/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DremioRefreshAPI
extends ActionHandlerEJB {
    E12GenericUtility genericUtility = new E12GenericUtility();
    public static String token = "";
    public static String loginLink = "";
    public static String CatalogLink = "";
    public static HttpURLConnection connGet;
    public static String USER_NAME;
    public static String PASSWORD;
    public static String transDB;
    public static String source;
    public static String table;

    static {
        USER_NAME = "";
        PASSWORD = "";
        transDB = "";
        source = "";
        table = "";
    }

    public DremioRefreshAPI() {
        System.out.println("##  Default constructor .. ");
    }

    public void confirm(String table, String xtraParams) {
        String trandDB = "";
        System.out.println("dremio refresh .. table   [" + table + "]    xtraParams[" + xtraParams + "]");
        ArrayList<String> tableList = null;
        try {
            if (!"".equalsIgnoreCase(table)) {
                String[] tableArray = table.split(",");
                tableList = new ArrayList<String>(Arrays.asList(tableArray));
            }
            System.out.println("  tableList  [ " + tableList + " ] ");
            String loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            String objName = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName");
            String userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            System.out.println("loginEmpCode : [" + loginEmpCode + "]\n objName[" + objName + "]\n userId [" + userId + "]");
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
            transDB = userInfo.getTransDB();
            BaseLogger.log("3", null, null, "DremioRefreshUtil :: userInfo" + userInfo);
            String url = userInfo.getInMemUrl();
            USER_NAME = userInfo.getInMemUserName();
            PASSWORD = userInfo.getInMemPassword();
            System.out.println("dremio url[" + url + "]   USER_NAME[" + USER_NAME + "]  PASSWORD[" + PASSWORD + "]");
            loginLink = String.valueOf(url) + "/apiv2/login";
            CatalogLink = String.valueOf(url) + "/api/v3/catalog";
            int counter = 0;
            while (counter < tableList.size()) {
                System.out.println((String)tableList.get(counter));
                String tableToRefresh = (String)tableList.get(counter);
                if (!"".equalsIgnoreCase(loginLink) && !"".equalsIgnoreCase(CatalogLink)) {
                    DremioRefreshAPI.authenticateDremio(transDB, transDB, tableToRefresh.toUpperCase());
                }
                ++counter;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in dremio confirm   " + e.getMessage());
        }
    }

    public DremioRefreshAPI(String dremioLink, String dremioParam, String xtraParams) {
        System.out.println("PARAM constructor .. ");
        String transDB = "";
        String source = "";
        String table = "";
        String loginEmpCode = "";
        String objName = "";
        String userId = "";
        String tableToRefresh = "";
        int formNo = 1;
        JSONParser parser = new JSONParser();
        try {
            JSONObject loginData = (JSONObject)parser.parse(dremioLink.toString());
            int i = 0;
            while (i < loginData.size()) {
                loginLink = (String)loginData.get((Object)"loginLink");
                CatalogLink = (String)loginData.get((Object)"CatalogLink");
                USER_NAME = (String)loginData.get((Object)"USER_NAME");
                PASSWORD = (String)loginData.get((Object)"PASS");
                ++i;
            }
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            objName = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName");
            userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            System.out.println("loginEmpCode : [" + loginEmpCode + "]\n objName[" + objName + "]\n userId [" + userId + "]");
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
            transDB = userInfo.getTransDB();
            String metaDataFileName = String.valueOf(objName) + "2" + formNo;
            DWFactory dws = new DWFactory(userInfo);
            DWObject dwObject = dws.getDataWindow(metaDataFileName);
            tableToRefresh = dwObject.getTableToBeUpdated();
            System.out.println("Link [" + loginLink + "]\n CatalogLink[" + CatalogLink + "]\n USER_NAME[" + USER_NAME + "]\n PASSWORD[" + PASSWORD + "]\n xtraParams[" + xtraParams + "]\n tableToRefresh[" + tableToRefresh + "]");
        }
        catch (Exception e) {
            System.out.println("Exception in DremioRefreshAPI Constructor ..  " + e.getMessage());
        }
        try {
            JSONObject dremioParamObj = (JSONObject)parser.parse(dremioParam.toString());
            int i = 0;
            while (i < dremioParamObj.size()) {
                source = (String)dremioParamObj.get((Object)"source");
                ++i;
            }
            System.out.println("transDB [" + transDB + "] source[" + source + "] table[" + table + "]");
        }
        catch (Exception e) {
            System.out.println("Exception in DremioRefreshAPI Constructor ..01 " + e.getMessage());
        }
        if (!"".equalsIgnoreCase(loginLink) && !"".equalsIgnoreCase(CatalogLink)) {
            DremioRefreshAPI.authenticateDremio(transDB, source, tableToRefresh);
        }
    }

    public static void authenticateDremio(String transDB, String source, String table) {
        System.out.println("authenticateDremio transDB [" + transDB + "] source [ " + source + " ] table[" + table + "]");
        try {
            String output;
            Random random = new Random();
            URL url = new URL(loginLink);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            connGet = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
            JSONObject dremioAuthObj = new JSONObject();
            dremioAuthObj.put((Object)"userName", (Object)USER_NAME);
            dremioAuthObj.put((Object)"password", (Object)PASSWORD);
            System.out.println(dremioAuthObj.toString());
            osw.write(String.format(dremioAuthObj.toString(), random.nextInt(30), random.nextInt(20)));
            osw.flush();
            osw.close();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder opt = new StringBuilder();
            System.out.println("Output from Server authentication \n");
            while ((output = br.readLine()) != null) {
                opt.append(output);
            }
            System.out.println("Result: " + opt.toString());
            JSONParser parser = new JSONParser();
            JSONObject loginData = (JSONObject)parser.parse(opt.toString());
            System.out.println("loginData: " + loginData);
            token = "_dremio" + (String)loginData.get((Object)"token");
            System.out.println("login token :" + token);
            conn.disconnect();
            if (!("".equalsIgnoreCase(source) || "".equalsIgnoreCase(transDB) || "".equalsIgnoreCase(table))) {
                String sourceId = DremioRefreshAPI.catalog("", "source", source);
                if (!"".equalsIgnoreCase(sourceId)) {
                    String tranDBId = DremioRefreshAPI.catalog(sourceId, "tranDB", transDB);
                    if (!"".equalsIgnoreCase(tranDBId)) {
                        String tableId = DremioRefreshAPI.catalog(tranDBId, "table", table);
                        if (!"".equalsIgnoreCase(tableId)) {
                            DremioRefreshAPI.catalog(tableId, "refresh", "");
                        } else {
                            System.out.println("tableId not found .. ");
                        }
                    } else {
                        System.out.println("tranDBId not found .. ");
                    }
                } else {
                    System.out.println("SourceId not found .. ");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception In While Authenticate Dremio  " + e.getMessage());
        }
    }

    public static String catalog(String id, String type, String dataStr) {
        URL urlGet = null;
        String returnStr = "";
        try {
            String output;
            if ("".equalsIgnoreCase(id)) {
                urlGet = new URL(CatalogLink);
            } else if (!"".equalsIgnoreCase(id) && !"refresh".equalsIgnoreCase(type)) {
                urlGet = new URL(String.valueOf(CatalogLink) + "/" + id);
            } else if ("refresh".equalsIgnoreCase(type)) {
                urlGet = new URL(String.valueOf(CatalogLink) + "/" + id + "/refresh");
                System.out.println("refresh .. ");
            }
            System.out.println(urlGet);
            connGet = (HttpURLConnection)urlGet.openConnection();
            if ("refresh".equalsIgnoreCase(type)) {
                connGet.setRequestMethod("POST");
            } else {
                connGet.setRequestMethod("GET");
            }
            connGet.setDoOutput(true);
            connGet.setRequestProperty("Content-Type", "application/json;");
            connGet.setRequestProperty("Authorization", token);
            connGet.setRequestProperty("cache-control", "no-cache");
            if (connGet.getResponseCode() != 200) {
                if (connGet.getResponseCode() == 204) {
                    System.out.println("204 No Content \n");
                } else if (connGet.getResponseCode() == 403) {
                    System.out.println("403 - User does not have permission to access the catalog entity. \n");
                } else if (connGet.getResponseCode() == 404) {
                    System.out.println("404 - A catalog entity with the specified ID could not be found. \n");
                }
            }
            BufferedReader br1 = new BufferedReader(new InputStreamReader(connGet.getInputStream()));
            StringBuilder dataSetsResultStr = new StringBuilder();
            System.out.println("Output from Server Dataset \n");
            while ((output = br1.readLine()) != null) {
                dataSetsResultStr.append(output);
            }
            if ("source".equalsIgnoreCase(type)) {
                returnStr = DremioRefreshAPI.getSourceId(dataSetsResultStr.toString(), dataStr);
            } else if ("tranDB".equalsIgnoreCase(type)) {
                returnStr = DremioRefreshAPI.getTransDBId(dataSetsResultStr.toString(), dataStr);
            } else if ("table".equalsIgnoreCase(type)) {
                returnStr = DremioRefreshAPI.getTableId(dataSetsResultStr.toString(), dataStr);
            }
            connGet.disconnect();
        }
        catch (Exception e) {
            System.out.println("Exception in catalog :: " + e.getMessage());
        }
        return returnStr;
    }

    public static String getSourceId(String dataSetString, String dataSource) {
        String sourceId = "";
        try {
            if (dataSetString.toString() != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject finalObject = (JSONObject)jsonParser.parse(dataSetString.toString());
                JSONArray array = (JSONArray)finalObject.get((Object)"data");
                int i = 0;
                while (i < array.size()) {
                    JSONObject jsonObject = (JSONObject)array.get(i);
                    JSONArray arraystr = (JSONArray)jsonObject.get((Object)"path");
                    int j = 0;
                    while (j < arraystr.size()) {
                        if (arraystr.get(j).equals(dataSource)) {
                            System.out.println("source id for transdb  :  " + jsonObject.get((Object)"id").toString());
                            sourceId = jsonObject.get((Object)"id").toString();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getDataSourceId" + e.getMessage());
            return "";
        }
        return sourceId;
    }

    public static String getTransDBId(String dataSetString, String transDB) {
        String transDBId = "";
        try {
            if (dataSetString.toString() != null && dataSetString.toString() != null) {
                System.out.println(dataSetString.toString());
                JSONParser jsonParser = new JSONParser();
                JSONObject finalObject = (JSONObject)jsonParser.parse(dataSetString.toString());
                JSONArray array = (JSONArray)finalObject.get((Object)"children");
                int i = 0;
                while (i < array.size()) {
                    JSONObject jsonObject = (JSONObject)array.get(i);
                    JSONArray arraystr = (JSONArray)jsonObject.get((Object)"path");
                    int j = 0;
                    while (j < arraystr.size()) {
                        if (transDB.equals(arraystr.get(j))) {
                            System.out.println("TransDBId Found " + arraystr.get(j));
                            System.out.println(jsonObject.get((Object)"id"));
                            transDBId = jsonObject.get((Object)"id").toString();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getTransDBId " + e.getMessage());
            return "";
        }
        return transDBId;
    }

    public static String getTableId(String dataSetString, String tableName) {
        System.out.println("Inside getTableId method ..   ");
        String tableId = "";
        try {
            if (dataSetString.toString() != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject finalObject = (JSONObject)jsonParser.parse(dataSetString.toString());
                JSONArray array = (JSONArray)finalObject.get((Object)"children");
                System.out.println("Size :: " + array.size());
                int i = 0;
                while (i < array.size()) {
                    JSONObject jsonObject = (JSONObject)array.get(i);
                    JSONArray arraystr = (JSONArray)jsonObject.get((Object)"path");
                    int j = 0;
                    while (j < arraystr.size()) {
                        if (arraystr.get(j).equals(tableName)) {
                            System.out.println("Table Id Found : " + jsonObject.get((Object)"id"));
                            tableId = jsonObject.get((Object)"id").toString();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return tableId;
        }
        catch (Exception e) {
            System.out.println("Exception in getTableId :: " + e.getMessage());
            return "";
        }
    }
}

