/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseLogger;
import java.io.PrintStream;

public class BaseLoggerSop
extends PrintStream {
    private static final PrintStream originalSystemOut = System.out;
    private static BaseLoggerSop systemOutToLogger;
    private String packageOrClassToLog;

    public static void enableForClass(Class clazz) {
        systemOutToLogger = new BaseLoggerSop(originalSystemOut, clazz.getName());
        System.setOut(systemOutToLogger);
    }

    public static void enableForPackage(String packageToLog) {
        systemOutToLogger = new BaseLoggerSop(originalSystemOut, packageToLog);
        System.setOut(systemOutToLogger);
    }

    public static void disable() {
        System.setOut(originalSystemOut);
        systemOutToLogger = null;
    }

    private BaseLoggerSop(PrintStream original, String packageOrClassToLog) {
        super(original);
        this.packageOrClassToLog = packageOrClassToLog;
    }

    @Override
    public void println(String line) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement caller = this.findCallerToLog(stack);
        if (caller == null) {
            super.println(line);
            return;
        }
        BaseLogger.infoLogger.info((Object)("Code Line No.: " + stack[2].getLineNumber() + ", Class Name: " + caller.getClassName() + ", Text: " + line));
    }

    public StackTraceElement findCallerToLog(StackTraceElement[] stack) {
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (element.getClassName().startsWith(this.packageOrClassToLog)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

