/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication;

import ibase.communication.EmailComm;
import ibase.communication.SMSComm;
import ibase.communication.TelegramComm;
import ibase.communication.WhatsAppComm;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterDataEJB;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.w3c.dom.Document;

public class Communication {
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String communicate1(String commType, String dataXMLString, UserInfoBean userInfo, String objName, String tranId, String formatCode) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)(" Telegram Communication Type :: sendNotification() : " + commType));
        BaseLogger.log((String)"3", null, null, (Object)(" Telegram Communication Type :: userINFO() : " + userInfo));
        BaseLogger.log((String)"3", null, null, (Object)("XMLString: " + dataXMLString));
        String commXml = this.buildCommunicationXML(dataXMLString, formatCode, userInfo, tranId, objName);
        String returnStr = "";
        if ("Email".equalsIgnoreCase(commType)) {
            EmailComm email = new EmailComm();
            returnStr = email.sendMail(commXml, "ITM", userInfo);
        } else if ("Telegram".equalsIgnoreCase(commType)) {
            TelegramComm telegram = new TelegramComm();
            returnStr = telegram.sendTelegramMessage(userInfo, dataXMLString, commXml, formatCode);
            BaseLogger.log((String)"3", null, null, (Object)" Telegram XMLString :: sendNotification() : ");
        } else if ("Whatsapp".equalsIgnoreCase(commType)) {
            WhatsAppComm whatsapp = new WhatsAppComm();
            whatsapp.sendWhatsApp(commXml, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)(" Whatsapp XMLString :: sendNotification() : " + commXml));
        } else if ("SMS".equalsIgnoreCase(commType)) {
            SMSComm sms = new SMSComm();
            String userId = userInfo.getLoginCode();
            String xtraParams = "loginCode=" + userId + "~~loginEmpCode" + userId;
            String result = sms.sendSMS(commXml, formatCode, xtraParams, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)(" Telegram XMLString :: sendNotification() : " + commXml));
        } else {
            BaseLogger.log((String)"3", null, null, (Object)"Unknown Communication Request Request!!");
        }
        return returnStr;
    }

    private boolean verifyLimit(String appId, String tranDB) {
        BaseLogger.log((String)"3", null, null, (Object)"Communication :verifyLimit(): - Verify Limit executed");
        BaseLogger.log((String)"3", null, null, (Object)("Communication :verifyLimit(): -appId: " + appId));
        BaseLogger.log((String)"3", null, null, (Object)("Communication :verifyLimit(): tranDB: " + tranDB));
        boolean isAvailable = true;
        CommonDBAccessEJB genUtility = new CommonDBAccessEJB();
        try {
            int maxLimit = Integer.parseInt(E12GenericUtility.checkNull((String)genUtility.getDBColumnValue("", "Count(maxDayLimit)", "", tranDB)));
            int sentMessageCount = Integer.parseInt(E12GenericUtility.checkNull((String)genUtility.getDBColumnValue("", "Count(maxDayLimit)", "", tranDB)));
            if (maxLimit <= sentMessageCount) {
                isAvailable = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAvailable;
    }

    private String buildCommunicationXML(String dataXMLString, String formatCode, UserInfoBean userInfo, String tranId, String objName) {
        String commXML = "";
        Statement pstmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        String result = "";
        try {
            try {
                String transDB = userInfo.getTransDB();
                String toAddr = "";
                String ccAddr = "";
                String bccAddr = "";
                String subject = "";
                String body = "";
                String templateCode = "";
                String templateName = "";
                String attachmentText = "";
                String attachmentType = "";
                String attachmentObject = "";
                String editFlag = "E";
                String saveFlag = "false";
                if (dataXMLString == null || dataXMLString != null && dataXMLString.length() == 0) {
                    dataXMLString = this.buildDataXML(tranId, userInfo, objName);
                }
                String tranPKValues = tranId;
                String sql = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, FORMAT_CODE, MAIL_DESCR, ATTACH_OBJECT, ATTACH_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE='" + formatCode + "'";
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(transDB);
                pstmt = connection.prepareStatement(sql);
                resultSet = pstmt.executeQuery();
                while (resultSet.next()) {
                    toAddr = E12GenericUtility.checkNull((String)resultSet.getString("SEND_TO"));
                    ccAddr = E12GenericUtility.checkNull((String)resultSet.getString("COPY_TO"));
                    bccAddr = E12GenericUtility.checkNull((String)resultSet.getString("BLIND_COPY"));
                    subject = E12GenericUtility.checkNull((String)resultSet.getString("SUBJECT"));
                    body = E12GenericUtility.checkNull((String)resultSet.getString("BODY_TEXT"));
                    templateCode = E12GenericUtility.checkNull((String)resultSet.getString("FORMAT_CODE"));
                    templateName = E12GenericUtility.checkNull((String)resultSet.getString("MAIL_DESCR"));
                    attachmentText = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_TEXT"));
                    attachmentType = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_TYPE"));
                    attachmentObject = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_OBJECT"));
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return commXML;
    }

    String buildDataXML(String tranId, UserInfoBean userInfo, String objName) {
        String tranDataXML = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranDataXML = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", tranId, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tranDataXML;
    }

    private String getNodeValue(Document dom, String colName) {
        String retValue = "";
        try {
            if (dom.getElementsByTagName(colName).item(0) != null && dom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                retValue = dom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }
}

