/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.E12DataModelComponent;
import ibase.webitm.utility.ITMException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/data_model")
public class DataModelService {
    private UserInfoBean userInfo = null;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    @GET
    @Path(value="/{dataModelName}")
    @Produces(value={"application/json"})
    public Response getData(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModel: [" + dataModelName + "]"));
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        String jsonString = "";
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, null, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    @GET
    @Path(value="/{dataModelName}/{fieldValue}")
    @Produces(value={"application/json"})
    public Response getDataByParam(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName, @PathParam(value="fieldValue") String fieldValue) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModelName: [" + dataModelName + "] fieldValue[" + fieldValue + "]"));
        String jsonString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, fieldValue, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    public String callDMDataJson(String dataModelName, String fieldValue, String userInfo) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)"proteus-> getDMDataJson 2835");
        Class<?> classObj = null;
        String returnValue = null;
        Class[] paramSpec = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
        Object[] params = new Object[]{dataModelName, fieldValue, userInfo};
        if (userInfo != null) {
            try {
                classObj = Class.forName("ibase.webitm.ejb.dis.DataModelComponent");
                E12DataModelComponent e12DmCom = (E12DataModelComponent)classObj.newInstance();
                Method metObj = classObj.getMethod("getDMDataJson", paramSpec);
                metObj.setAccessible(true);
                Object retVal = metObj.invoke((Object)e12DmCom, params);
                returnValue = retVal.toString();
                BaseLogger.log((String)"2", null, null, (Object)("returnValue [" + returnValue + "]"));
                e12DmCom = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :EventManagerEJB :callJB :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnValue;
    }

    @GET
    @Path(value="/datamodels")
    @Produces(value={"application/json"})
    public Response getDataModels(@QueryParam(value="format") String format, @Context HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            String userInfoStr = "";
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                String dataModelValue;
                UserInfoBean userInfo = new UserInfoBean(userInfoStr);
                E12DataModelComponent e12DataModelComponent = new E12DataModelComponent();
                String applName = "FIP";
                boolean isMobile = false;
                String dataModelName = "WORKFLOW_DATA_MODEL";
                String scopeParameters = "";
                String responseFormat = format;
                String dataModelToDownload = "";
                if (format.equals("JSON")) {
                    BaseLogger.log((String)"3", null, null, (Object)"calling prepareDataModelDetailsJSON for getting data models==>");
                    dataModelValue = e12DataModelComponent.prepareDataModelDetailsJSON(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                } else {
                    dataModelValue = e12DataModelComponent.prepareDataModeldetails(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                }
                BaseLogger.log((String)"0", null, null, (Object)("Session Attribute signJSONData:==> " + dataModelValue));
                return Response.status((int)200).entity((Object)dataModelValue).build();
            }
            return Response.status((int)200).entity((Object)"Error:Unauthorized Access").build();
        }
        catch (Exception e) {
            return Response.status((int)200).entity((Object)("Error:" + e.getMessage())).build();
        }
    }
}

