/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.CollaborateNotificationEJBLocal;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.WorkflowLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class CollaborateNotificationEJB
implements CollaborateNotificationEJBLocal {
    @Override
    public String sendMail(String objName, String xmlString, String refSer, String refId, String entityCode, String formatCode, String post_status) {
        String retStr = new String();
        WorkflowLogger.info("[CollaborateNotificationEJB]Sending mail to all MRS for \n objName :[" + objName + "]\n refSer :[" + refSer + "]\n refId :[" + refId + "]\n formatCode :[" + formatCode + "]\n entityCode :[" + entityCode + "]\n xmlString :[" + xmlString + "]\n" + "post_status[" + post_status + "]");
        try {
            if (formatCode != null) {
                if ("NA".equalsIgnoreCase(post_status)) {
                    this.updatePost(xmlString, "A");
                    retStr = this.notifyToAllMembers(objName, refSer, refId, formatCode, entityCode, xmlString);
                } else if ("A".equalsIgnoreCase(post_status)) {
                    BaseLogger.log("3", null, null, "[CollaborateNotificationEJB] POST ACCEPTED");
                    this.updatePost(xmlString, "A");
                    retStr = this.notifyToPoster(objName, refSer, refId, formatCode, entityCode, xmlString);
                } else if ("R".equalsIgnoreCase(post_status)) {
                    BaseLogger.log("3", null, null, "[CollaborateNotificationEJB] POST REJECTED");
                    this.updatePost(xmlString, "R");
                    retStr = this.notifyToPoster(objName, refSer, refId, formatCode, entityCode, xmlString);
                }
                BaseLogger.log("9", null, null, "retStr [" + retStr + "]");
                retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + retStr + "]]></RESULT></ROOT>";
            } else {
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ FORMATCODE is Null ]]></RESULT></ROOT>";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Mail Sending failed");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Mail Sending failed ]]></RESULT></ROOT>";
        }
        return retStr;
    }

    private void updatePost(String xmlString, String approvalStatus) throws ITMException {
        boolean isError = false;
        E12GenericUtility genUtility = new E12GenericUtility();
        Document dom = null;
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement updatePrepStmt = null;
        try {
            try {
                dom = genUtility.parseString(xmlString);
                String postId = genUtility.getColumnValue("post_id", dom);
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                String collabSQL = " UPDATE COLLAB_POSTS SET IS_APPROVED = ? WHERE POST_ID = ? ";
                updatePrepStmt = conn.prepareStatement(collabSQL);
                updatePrepStmt.setString(1, approvalStatus);
                updatePrepStmt.setString(2, postId);
                int row = updatePrepStmt.executeUpdate();
                BaseLogger.log("3", null, null, " UPDATE COLLAB_POST ROWS " + row);
                updatePrepStmt.close();
                updatePrepStmt = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.err.println("Exception :CollaborateNotificationEJB :updatePost :\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
            catch (ITMException e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        if (isError) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        if (updatePrepStmt != null) {
                            updatePrepStmt.close();
                            updatePrepStmt = null;
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e2.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        if (isError) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        if (updatePrepStmt != null) {
                            updatePrepStmt.close();
                            updatePrepStmt = null;
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e3) {
                    System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e3.getMessage());
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (isError) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                    if (updatePrepStmt != null) {
                        updatePrepStmt.close();
                        updatePrepStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e.getMessage());
            }
        }
    }

    private String notifyToPoster(String objName, String refSer, String refId, String formatCode, String entityCode, String xmlString) {
        String returnStr = null;
        String lineNo = "1";
        String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER>" + refSer + "</REF_SER><REF_ID>" + refId + "</REF_ID>" + "<LINE_NO>" + lineNo + "</LINE_NO><XSL_FILE_NAME></XSL_FILE_NAME></TRANS_INFO>" + "<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>" + entityCode + "</ENTITY_CODE>" + "<ENTITY_TYPE>E</ENTITY_TYPE><FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" + "</MAIL><XML_DATA>" + xmlString + "</XML_DATA></ROOT>";
        EMail email = new EMail();
        try {
            email.sendMail(mailDomStr, "ITM");
            returnStr = "S";
        }
        catch (Exception e) {
            e.printStackTrace();
            returnStr = e.toString();
        }
        return returnStr;
    }

    private String notifyToAllMembers(String objName, String refSer, String refId, String formatCode, String entityCode, String xmlString) {
        String returnStr = null;
        String lineNo = "1";
        String toAddr = this.getMembersEmailIDs(xmlString);
        String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER>" + refSer + "</REF_SER><REF_ID>" + refId + "</REF_ID>" + "<LINE_NO>" + lineNo + "</LINE_NO><XSL_FILE_NAME></XSL_FILE_NAME></TRANS_INFO>" + "<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>" + entityCode + "</ENTITY_CODE>" + "<ENTITY_TYPE></ENTITY_TYPE><FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" + toAddr + "</MAIL><XML_DATA>" + xmlString + "</XML_DATA></ROOT>";
        EMail email = new EMail();
        try {
            email.sendMail(mailDomStr, "ITM");
            returnStr = "S";
        }
        catch (Exception e) {
            e.printStackTrace();
            returnStr = e.toString();
        }
        return returnStr;
    }

    private String getMembersEmailIDs(String xmlString) {
        HashSet<String> userEmailIDSet;
        block31: {
            E12GenericUtility genUtility = new E12GenericUtility();
            userEmailIDSet = new HashSet<String>();
            Document dom = null;
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement collabStmt = null;
            ResultSet collabRs = null;
            Statement emailStmt = null;
            ResultSet emailRs = null;
            try {
                try {
                    dom = genUtility.parseString(xmlString);
                    String groupId = genUtility.getColumnValue("group_id__collab", dom);
                    mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB("Driver");
                    String collabSQL = " SELECT ENTITY_TYPE, ENTITY_CODE, LINE_NO FROM COLLAB_ENTITY WHERE GROUP_ID = '" + groupId + "'";
                    String emailSQL = "";
                    collabStmt = mConnection.createStatement();
                    collabRs = collabStmt.executeQuery(collabSQL);
                    while (collabRs.next()) {
                        String entityType = collabRs.getString("ENTITY_TYPE");
                        String entityCode = collabRs.getString("ENTITY_CODE");
                        if ("E".equalsIgnoreCase(entityType)) {
                            emailSQL = "SELECT EMAIL_ID_OFF AS EMAIL_ID FROM EMPLOYEE WHERE EMP_CODE = '" + entityCode + "'";
                        } else if ("P".equalsIgnoreCase(entityType)) {
                            emailSQL = "SELECT EMAIL_ADDR AS EMAIL_ID FROM SALES_PERS WHERE SALES_PERS = '" + entityCode + "'";
                        } else if ("U".equalsIgnoreCase(entityType)) {
                            emailSQL = "SELECT EMAIL_ID AS EMAIL_ID FROM USERS WHERE CODE = '" + entityCode + "'";
                        } else if ("D".equalsIgnoreCase(entityType)) {
                            emailSQL = "SELECT EMAIL_ID_OFF AS EMAIL_ID FROM EMPLOYEE WHERE DEPT_CODE = '" + entityCode + "'";
                        } else if ("F".equalsIgnoreCase(entityType)) {
                            emailSQL = "SELECT EMAIL_ID AS EMAIL_ID FROM USERS WHERE PROFILE_ID = '" + entityCode + "'";
                        }
                        BaseLogger.log("3", null, null, "emailSQL : " + emailSQL);
                        emailStmt = mConnection.createStatement();
                        emailRs = emailStmt.executeQuery(emailSQL);
                        while (emailRs.next()) {
                            String emailID = emailRs.getString("EMAIL_ID");
                            if (emailID == null) continue;
                            userEmailIDSet.add(emailID);
                            BaseLogger.log("3", null, null, "EMAIL ID found for " + entityCode + ":[" + emailID + "]");
                        }
                        emailRs.close();
                        emailRs = null;
                        emailStmt.close();
                        emailStmt = null;
                    }
                    collabRs.close();
                    collabRs = null;
                    collabStmt.close();
                    collabStmt = null;
                }
                catch (Exception e) {
                    System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e.getMessage());
                    try {
                        if (mConnection != null) {
                            if (emailStmt != null) {
                                emailStmt.close();
                                emailStmt = null;
                            }
                            if (collabStmt != null) {
                                collabStmt.close();
                                collabStmt = null;
                            }
                            mConnection.close();
                            mConnection = null;
                        }
                        break block31;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e2.getMessage());
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (mConnection != null) {
                        if (emailStmt != null) {
                            emailStmt.close();
                            emailStmt = null;
                        }
                        if (collabStmt != null) {
                            collabStmt.close();
                            collabStmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (mConnection != null) {
                    if (emailStmt != null) {
                        emailStmt.close();
                        emailStmt = null;
                    }
                    if (collabStmt != null) {
                        collabStmt.close();
                        collabStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :CollaborateNotificationEJB :getMembersEmailIDs :\n" + e.getMessage());
            }
        }
        String emailIDs = this.getEmailIDList(userEmailIDSet);
        return emailIDs;
    }

    private String getEmailIDList(HashSet<String> userEmailIDSet) {
        StringBuffer emailIDs = new StringBuffer();
        for (String emailID : userEmailIDSet) {
            emailIDs.append(emailID).append(", ");
        }
        String emailIDList = emailIDs.toString();
        if (!"".equalsIgnoreCase(emailIDList)) {
            emailIDList = emailIDList.substring(0, emailIDList.lastIndexOf(","));
            emailIDList = "<TO_ADD><![CDATA[" + emailIDList + "]]></TO_ADD>";
        }
        BaseLogger.log("2", null, null, "getEmailIDList : emailIDList [" + emailIDList + "]");
        return emailIDList;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

