/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.utility;

import ibase.planner.utility.ITMException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXMLInput
implements Serializable {
    public static void main(String[] args) throws Exception {
        ValidateXMLInput v = new ValidateXMLInput();
    }

    public String validate(String xslType, String xmlType, String fileNamePrefix, String fileNameSuffix) throws ITMException {
        BaseLogger.log("2", null, null, "%%%%%%%%%%%%%%%%%%Validate XML input%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        String retString = null;
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer t = null;
            DOMSource sourceDom = null;
            String transformedFileName = "";
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(false);
            Handler handler = new Handler();
            if (xslType.endsWith(".xsl")) {
                xslType = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "planner" + File.separator + "xsl" + File.separator + xslType;
                t = tfactory.newTransformer(new StreamSource(xslType));
            } else {
                t = tfactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslType.getBytes())));
            }
            Document dom = null;
            if (xmlType.endsWith(".xml")) {
                BaseLogger.log("3", null, null, "xmlType--[" + xmlType + "]");
                dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlType);
                sourceDom = new DOMSource(dom);
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setIgnoringComments(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlType.getBytes());
                dom = db.parse(bais);
                sourceDom = new DOMSource(dom);
            }
            String prefix = String.valueOf(fileNamePrefix) + Math.random();
            File tempDirectory = new File(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "temp");
            File tempFile = File.createTempFile(prefix, fileNameSuffix, tempDirectory);
            transformedFileName = tempFile.getAbsolutePath();
            retString = tempFile.getName();
            FileOutputStream fos = new FileOutputStream(transformedFileName);
            t.transform(sourceDom, new StreamResult(fos));
            fos.flush();
            fos.close();
            return transformedFileName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            BaseLogger.log("2", null, null, "SAXParseException warning: " + spe.getMessage());
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            BaseLogger.log("2", null, null, "SAXParseException error: " + spe.getMessage());
        }
    }
}

