/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import bsh.Interpreter;
import bsh.InterpreterError;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TaxCalculation {
    double totalTax = 0.0;
    double netAmt = 0.0;
    Connection conn = null;
    Node dataNode = null;
    double totTax = 0.0;
    HashMap instVarMap = null;
    HashMap currTaxCodePercMap = null;
    HashMap currTaxCodeFormMap = null;
    String taxEnvStr = null;
    String taxClassStr = null;
    String taxChapStr = null;
    String objName = null;
    String refSerStr = null;
    String tranIdStr = null;
    String dataLineStr = null;
    String selDataObjCtx = "";
    String selDataDomId = "";
    String taxDateStr = null;
    String lotSl = null;
    String currCodeTranStr = null;
    String loginSiteStr = null;
    String tranDateColumnName = null;
    Document taxDom = null;
    Document detailDom = null;
    Document dataDom = null;
    Document updatedTaxDom = null;
    ArrayList taxCodeList = null;
    ArrayList taxCodeSeqArrList = null;
    ArrayList taxCodeForTaxAmtList = null;
    ArrayList taxAmtFromMethodType = null;
    ArrayList taxArrLst = null;
    Document lineNoTaxDom = null;
    Node workingTaxNode = null;
    Node cloneTaxNode = null;
    Date taxDate = null;
    int noOfTaxCodes = 0;
    double clgRate = 0.0;
    double rateFld = 0.0;
    double applyPerc = 0.0;
    double disc = 0.0;
    double qty = 0.0;
    double noOfArticle = 0.0;
    Interpreter interpreter = null;
    ArrayList globalVarsList = null;
    StringBuffer taxChangeStrBuff = new StringBuffer();
    String transRateCol = null;
    String transQtyCol = null;
    boolean isLocalConn = false;
    private UserInfoBean userInfo = null;

    public TaxCalculation(String objName, Connection conn, UserInfoBean userInfo) {
        try {
            this.userInfo = userInfo;
            this.conn = conn;
            this.objName = objName;
            this.globalVarsList = new ArrayList();
            this.globalVarsList.add("objectName");
            this.globalVarsList.add("transactionSeries");
            this.setTranDateColumnName(this.conn, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TaxCalculation(String objName, UserInfoBean userInfo) {
        try {
            this.userInfo = userInfo;
            this.objName = objName;
            this.globalVarsList = new ArrayList();
            this.globalVarsList.add("objectName");
            this.globalVarsList.add("transactionSeries");
            this.setTranDateColumnName(this.conn, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TaxCalculation() {
        try {
            this.objName = null;
            this.globalVarsList = new ArrayList();
            this.globalVarsList.add("objectName");
            this.globalVarsList.add("transactionSeries");
            this.setTranDateColumnName(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTaxDom(Node detailNode) throws Exception {
        try {
            String detailString = this.serializeDom(detailNode);
            BaseLogger.log("2", null, null, "Setting Taxdom : [" + detailString + "]");
            this.detailDom = this.parseString(detailString);
            this.setTaxArrLst(detailNode, "Tax");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation : setTaxTranDom() : \n" + e);
            throw e;
        }
    }

    public void setUpdatedTaxDom(Node detailNode) throws Exception {
        try {
            this.currTaxCodePercMap = new HashMap();
            this.currTaxCodeFormMap = new HashMap();
            String taxCode = "";
            String taxPerc = "";
            String taxForm = "";
            if (detailNode != null) {
                String detailString = this.serializeDom(detailNode);
                this.updatedTaxDom = this.parseString(detailString);
                if (this.updatedTaxDom != null) {
                    NodeList childList = this.updatedTaxDom.getChildNodes().item(0).getChildNodes();
                    int childListLength = childList.getLength();
                    int j = 0;
                    while (j < childListLength) {
                        Node curChildNode = childList.item(j);
                        if (curChildNode.getNodeName().equalsIgnoreCase("Tax")) {
                            boolean isUpdated = false;
                            NodeList childNodeList = curChildNode.getChildNodes();
                            int ctr = 0;
                            while (ctr < childNodeList.getLength()) {
                                Node elementNode = childNodeList.item(ctr);
                                if (elementNode.getNodeName().equalsIgnoreCase("tax_code")) {
                                    if (elementNode.getFirstChild() != null) {
                                        taxCode = elementNode.getFirstChild().getNodeValue();
                                    }
                                } else if (elementNode.getNodeName().equalsIgnoreCase("tax_perc")) {
                                    if (elementNode.getFirstChild() != null) {
                                        taxPerc = elementNode.getFirstChild().getNodeValue();
                                    }
                                } else if (elementNode.getNodeName().equalsIgnoreCase("tax_form")) {
                                    if (elementNode.getFirstChild() != null) {
                                        taxForm = elementNode.getFirstChild().getNodeValue();
                                    }
                                } else if (elementNode.getNodeName().equalsIgnoreCase("chg_stat") && elementNode.getFirstChild() != null && "F".equals(elementNode.getFirstChild().getNodeValue())) {
                                    isUpdated = true;
                                }
                                ++ctr;
                            }
                            BaseLogger.log("3", null, null, "Is tax updated by user :[" + isUpdated + "]");
                            if (isUpdated) {
                                this.currTaxCodePercMap.put(taxCode.trim(), taxPerc);
                                this.currTaxCodeFormMap.put(taxCode.trim(), taxForm);
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation : setTaxTranDom() : \n" + e);
            throw e;
        }
        BaseLogger.log("2", null, null, "Already set TaxCode,Perc Map size:[" + this.currTaxCodePercMap.size() + "]");
    }

    public void setDataNode(Node dataNode) throws ITMException {
        BaseLogger.log("2", null, null, "Setting DataNode with Node only . . . . . . . . . . . .");
        try {
            this.setDataNode(dataNode, "1", "1");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation : setDataNode() : \n" + e);
            throw new ITMException(e);
        }
    }

    public void setDataNode(Node dataNode, String selDataObjCtx, String selDataDomId) throws ITMException {
        BaseLogger.log("2", null, null, "Setting DataNode . . . . . . . . . . . .");
        try {
            BaseLogger.log("2", null, null, "Setting Current DataNode : [" + this.serializeDom(dataNode) + "]");
            this.dataNode = dataNode;
            this.selDataObjCtx = selDataObjCtx;
            this.selDataDomId = selDataDomId;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation : setDataNode() : \n" + e);
            throw new ITMException(e);
        }
    }

    private void setTaxArrLst(Node searchFrom, String tagName) throws ITMException {
        BaseLogger.log("2", null, null, "Setting TaxArrLst . . . . . . . . . . . . . .");
        try {
            NodeList childList = searchFrom.getChildNodes();
            this.taxArrLst = new ArrayList();
            int childListLength = childList.getLength();
            int iCtr = 0;
            while (iCtr < childListLength) {
                Node curChildNode = childList.item(iCtr);
                if (curChildNode.getNodeName().equalsIgnoreCase(tagName)) {
                    this.taxArrLst.add(curChildNode);
                }
                ++iCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation: setTaxArrLst :==>\n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "Setting TaxArrLst  completed....");
    }

    public String taxCalc(String refSer, String tranId, String taxDate, String defRateFld, String defQtyFld, String currCodeTranStr, String loginSite, String formNo, String exchRateTranStr) throws ITMException {
        String varRateValue = "";
        String varQtyValue = "";
        String retString = "";
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        boolean funcLocalConn = false;
        try {
            try {
                String tranSettingQry = "SELECT RATE_COL,QTY_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + this.objName + "'";
                if (this.conn == null) {
                    this.conn = this.getDBConnection(null);
                    funcLocalConn = true;
                }
                stmtLocal = this.conn.prepareStatement(tranSettingQry);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    varRateValue = rsLocal.getString(0);
                    varRateValue = varRateValue != null && varRateValue.trim().length() == 0 ? null : varRateValue;
                    varQtyValue = rsLocal.getString(1);
                    String string = varQtyValue = varQtyValue != null && varQtyValue.trim().length() == 0 ? null : varQtyValue;
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
                retString = this.taxCalc(refSer, tranId, taxDate, defRateFld, defQtyFld, varRateValue, varQtyValue, currCodeTranStr, loginSite, formNo, null, "", "", exchRateTranStr);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TaxCalculation: taxCalc :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
                if (funcLocalConn && this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    /*
     * Exception decompiling
     */
    public String taxCalc(String refSer, String tranId, String taxDate, String rateFldStr, String qtyFldStr, String transRateCol, String transQtyCol, String currCodeTranStr, String loginSite, String formNo, String transDB, String editorId, String actionMode, String exchRateTranStr) throws ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String setRoundInfo(String taxCodeStr) throws ITMException {
        String isNull = null;
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String queryForRoundTax = "SELECT ROUND, ROUND_TO, DESCR,EFFECT, ACCT_CODE, CCTR_CODE, PAY_TAX,  EDIT_OPTION, SERIES_EDIT,MAX_RATE,MIN_RATE FROM TAX WHERE TAX_CODE = '" + taxCodeStr + "'";
                stmtLocal = this.conn.prepareStatement(queryForRoundTax);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    isNull = "";
                    this.instVarMap.put("round", rsLocal.getString(1));
                    this.instVarMap.put("roundTo", new Double(rsLocal.getDouble(2)));
                    this.instVarMap.put("descr", rsLocal.getString(3));
                    this.instVarMap.put("effect", rsLocal.getString(4));
                    this.instVarMap.put("acctCodeRd", rsLocal.getString(5));
                    this.instVarMap.put("cctrCodeRd", rsLocal.getString(6));
                    this.instVarMap.put("payTax", rsLocal.getString(7));
                    this.instVarMap.put("editOption", rsLocal.getString(8));
                    this.instVarMap.put("seriesEdit", rsLocal.getString(9));
                    this.instVarMap.put("maxrate", new Double(rsLocal.getDouble(10)));
                    this.instVarMap.put("minrate", new Double(rsLocal.getDouble(11)));
                    BaseLogger.log("3", null, null, "this.instVarMap :[" + this.instVarMap + "]");
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation : setRoundInfo() : \n " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return isNull;
    }

    private void setTaxPercFromPreviousLine(String taxCodeStr) throws ITMException {
        block6: {
            BaseLogger.log("2", null, null, "Setting Tax Perc from previous line for taxCodeStr :[" + taxCodeStr + "]");
            boolean countRec = false;
            Object prevLineNoStr = null;
            try {
                String prevMaxDomId = this.getPrevMaxDomId();
                if (prevMaxDomId != "-1") {
                    Node curDetail = this.searchNode(this.dataNode.getOwnerDocument(), this.selDataObjCtx, prevMaxDomId);
                    NodeList currDetailChildList = curDetail.getChildNodes();
                    int childListLength = currDetailChildList.getLength();
                    Node taxesNode = null;
                    int i = 0;
                    while (i < childListLength) {
                        taxesNode = currDetailChildList.item(i);
                        if (taxesNode.getNodeName().equalsIgnoreCase("Taxes")) break;
                        ++i;
                    }
                    BaseLogger.log("3", null, null, "Found taxes node in prev transaction line....");
                    NodeList taxNodeList = taxesNode.getChildNodes();
                    int noOfTaxNodes = taxNodeList.getLength();
                    Node currTaxNode = null;
                    int taxCtr = 0;
                    while (taxCtr < noOfTaxNodes) {
                        currTaxNode = taxNodeList.item(taxCtr);
                        BaseLogger.log("3", null, null, "Checking for tax record with same tax code as current :[" + taxCodeStr + "]");
                        if (taxCodeStr.equals(this.getElementValueFromTaxNode(currTaxNode, "tax_code")) && "F".equals(this.getElementValueFromTaxNode(currTaxNode, "chg_stat"))) {
                            String taxPercStr = this.getElementValueFromTaxNode(currTaxNode, "tax_perc");
                            this.instVarMap.put("taxPerc", new Double(taxPercStr));
                            this.instVarMap.put("chgStat", "F");
                            this.setTaxNodeValue("chg_stat", "F");
                            this.currTaxCodePercMap.put(taxCodeStr, taxPercStr);
                            break block6;
                        }
                        ++taxCtr;
                    }
                    break block6;
                }
                BaseLogger.log("3", null, null, "WARNING : Previous Max Id is -1 ");
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : setTaxPercFromPreviousLine() " + e);
                throw new ITMException(e);
            }
        }
    }

    private String getChgState(String tranCode, String tranId, String lineNo) throws ITMException {
        String chgState = "";
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String queryTaxForm = "SELECT CHG_STAT FROM TAXTRAN WHERE TRAN_CODE = '" + tranCode + "' AND TRAN_ID = '" + tranId + "' AND LINE_NO = '" + lineNo + "' ";
                BaseLogger.log("3", null, null, queryTaxForm);
                stmtLocal = this.conn.prepareStatement(queryTaxForm);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    if (rsLocal.getString("CHG_STAT") == null) continue;
                    chgState = rsLocal.getString("CHG_STAT");
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
                BaseLogger.log("3", null, null, "CHG_STAT from getChgState() :" + chgState);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation: getChgState() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return chgState;
    }

    private String getTaxPerc(String taxCode) throws ITMException {
        String taxPerct = null;
        BaseLogger.log("2", null, null, "setting taxPerc from taxDom for taxCode :" + taxCode);
        String debugMsg = "";
        try {
            String string = taxCode = taxCode != null ? taxCode.trim() : taxCode;
            if (this.currTaxCodePercMap.containsKey(taxCode)) {
                debugMsg = "dom";
                taxPerct = (String)this.currTaxCodePercMap.get(taxCode);
                BaseLogger.log("3", null, null, "Setting chg status as 'F' for taxCode :[" + taxCode + "] taxPerct from Dom :[" + taxPerct + "]");
                this.instVarMap.put("chgStat", "F");
                this.instVarMap.put("taxPerc", new Double(taxPerct));
                this.setTaxNodeValue("chg_stat", "F");
            }
            if (taxPerct == null) {
                debugMsg = "TAXTRAN";
                BaseLogger.log("3", null, null, "Setting chg status as 'N' for taxCode :[" + taxCode + "] for perc not found in dom");
                this.setTaxNodeValue("chg_stat", "N");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getTaxPerc \n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "returning from " + debugMsg + " getTaxPerc  :" + taxPerct);
        return taxPerct;
    }

    private String getValueFromUpdTaxDom(String elementName) throws ITMException {
        String elementValue;
        block4: {
            elementValue = "";
            BaseLogger.log("2", null, null, "Setting taxPerc from taxDom");
            try {
                NodeList childList = this.updatedTaxDom.getChildNodes().item(0).getChildNodes();
                int childListLength = childList.getLength();
                Node curChildNode = childList.item(0);
                if (!curChildNode.getNodeName().equalsIgnoreCase("Tax")) break block4;
                NodeList childNodeList = curChildNode.getChildNodes();
                int ctr = 0;
                while (ctr < childNodeList.getLength()) {
                    Node elementNode = childNodeList.item(ctr);
                    if (elementNode.getNodeName().equalsIgnoreCase(elementName) && elementNode.getFirstChild() != null) {
                        elementValue = elementNode.getFirstChild().getNodeValue();
                        break;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : getValueFromUpdTaxDom \n" + e);
                throw new ITMException(e);
            }
        }
        return elementValue;
    }

    private double applyAmtFromExpr(String exprStr, String exprStrInput, String applyOperatorStr, double applyAmt) throws ITMException {
        BaseLogger.log("2", null, null, "***************************  NEW WORK BY DASH    ******************************** ");
        BaseLogger.log("2", null, null, "exprStr [" + exprStr + "] exprStrInput [" + exprStrInput + "] applyOperatorStr [" + applyOperatorStr + "] applyAmt [" + applyAmt + "]");
        double retVal = 0.0;
        this.interpreter = new Interpreter();
        try {
            if (exprStrInput != null && exprStrInput.length() > 0) {
                ArrayList exprStrInputList = this.getTokenList(exprStrInput, ",");
                BaseLogger.log("3", null, null, "ExprStrInputList :" + exprStrInputList);
                String firstToken = null;
                int ctr = 0;
                while (ctr < exprStrInputList.size()) {
                    String currVarName = null;
                    String currVarValue = null;
                    String varType = null;
                    String tempExprInpStr = (String)exprStrInputList.get(ctr);
                    BaseLogger.log("3", null, null, "Current Expr :[" + tempExprInpStr + "]");
                    ArrayList varDescTokenList = this.getTokenList(tempExprInpStr, ".");
                    if (varDescTokenList != null && varDescTokenList.size() > 0) {
                        currVarName = (String)varDescTokenList.get(varDescTokenList.size() - 1);
                        if (((String)varDescTokenList.get(0)).indexOf("[") != -1) {
                            firstToken = (String)varDescTokenList.get(0);
                            firstToken = firstToken.substring(1, firstToken.length() - 1);
                            BaseLogger.log("3", null, null, "TaxCalculation.applyAmtFromExpr() firstToken :[" + firstToken + "]");
                            if (firstToken.toLowerCase().endsWith("_perc")) {
                                String currTaxCode = firstToken.substring(0, firstToken.indexOf("_perc"));
                                currVarValue = this.getElementValueFromTaxesNode("tax_perc", currTaxCode);
                                BaseLogger.log("3", null, null, "TaxCalculation.applyAmtFromExpr() currVarValue in if :[" + currVarValue + "]");
                            } else {
                                currVarValue = this.getElementValueFromTaxesNode("tax_amt", firstToken);
                                BaseLogger.log("3", null, null, "TaxCalculation.applyAmtFromExpr() currVarValue else :[" + currVarValue + "]");
                            }
                            varType = "D";
                        } else {
                            firstToken = (String)varDescTokenList.get(0);
                            firstToken = firstToken.length() == 0 ? this.selDataObjCtx : firstToken;
                            Document detailDom = this.dataNode.getOwnerDocument();
                            String detailDomId = (String)varDescTokenList.get(1);
                            detailDomId = detailDomId.length() == 0 ? this.selDataDomId : detailDomId;
                            BaseLogger.log("3", null, null, "Form No. :[" + firstToken + "] Dom Id :[" + detailDomId + "]");
                            Node curDetail = this.searchNode(detailDom, firstToken, detailDomId);
                            currVarValue = this.getElementValueFromNode(currVarName, curDetail);
                            varType = (String)varDescTokenList.get(2);
                        }
                        BaseLogger.log("3", null, null, "Var Name :[" + currVarName + "] Var Type :[" + varType + "] Var Value :[" + currVarValue + "]");
                        Object varValue = null;
                        if (varType.equalsIgnoreCase("I")) {
                            varValue = Integer.valueOf(currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue);
                        } else if (varType.equalsIgnoreCase("N") || varType.equalsIgnoreCase("D")) {
                            varValue = Double.valueOf(currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue);
                        } else {
                            Object object = varValue = currVarValue == null ? "" : currVarValue;
                        }
                        if (varValue != null) {
                            BaseLogger.log("3", null, null, "********* Adding currVar [" + currVarName + "] with currVarValue [" + varValue.toString() + "] into interpreter ");
                            this.interpreter.set(currVarName, varValue);
                        }
                    }
                    ++ctr;
                }
            }
            String expVal = "";
            boolean flag = true;
            try {
                expVal = this.interpreter.eval(exprStr).toString();
                flag = true;
            }
            catch (InterpreterError inte) {
                BaseLogger.log("0", null, null, "******** Error occured during Evaluation--Interpreter Exception: ==>\n" + (Object)((Object)inte));
                expVal = inte.getMessage();
                flag = false;
            }
            if (flag) {
                retVal = Double.parseDouble(expVal == null || expVal.length() == 0 ? "0.0" : expVal);
                E12GenericUtility genericUtility = new E12GenericUtility();
                retVal = Double.parseDouble(genericUtility.formatDouble(retVal, 3));
                applyAmt = Double.parseDouble(genericUtility.formatDouble(applyAmt, 3));
                if (applyOperatorStr != null && applyOperatorStr.length() > 0) {
                    switch (applyOperatorStr.charAt(0)) {
                        case 'A': {
                            retVal = applyAmt + retVal;
                            break;
                        }
                        case 'S': {
                            retVal = applyAmt - retVal;
                            break;
                        }
                        case 'M': {
                            retVal = applyAmt * retVal;
                            break;
                        }
                        case 'D': {
                            retVal = applyAmt / retVal;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                BaseLogger.log("3", null, null, "taxJEP.getValueAsObject() is null ");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalulation : applyAmtFromFormula() \n");
            throw new ITMException(e);
        }
        return retVal;
    }

    private double applyAmtFromApplyFormula(int cntTaxCodes, String applyFormulaStr, String applyOperatorStr, double applyAmt) throws ITMException {
        double computeAmt = 0.0;
        String localApplyFormulaStr = null;
        String[] localApplyFormulaStrArr = new String[2];
        String taxCodeStr = null;
        String typeStr = null;
        String taxAmtStr = "0";
        localApplyFormulaStr = applyFormulaStr;
        applyFormulaStr = null;
        boolean index = false;
        try {
            while (localApplyFormulaStr.length() > 0) {
                localApplyFormulaStrArr = this.getToken(localApplyFormulaStr, "[");
                applyFormulaStr = String.valueOf(applyFormulaStr) + localApplyFormulaStrArr[0];
                localApplyFormulaStr = localApplyFormulaStrArr[1];
                localApplyFormulaStrArr = this.getToken(localApplyFormulaStr, "]");
                taxCodeStr = localApplyFormulaStrArr[0];
                localApplyFormulaStr = localApplyFormulaStrArr[1];
                if (taxCodeStr != null && taxCodeStr.length() > 0) {
                    typeStr = taxCodeStr.substring(1, 1);
                    if ((taxCodeStr = taxCodeStr.substring(2)) == null) {
                        taxCodeStr = "";
                    }
                    if (typeStr != null && (taxAmtStr = typeStr.charAt(0) == '%' ? this.getElementValue(cntTaxCodes, "tax_perc", "tax_code", taxCodeStr) : this.getElementValue(cntTaxCodes, "tax_amt", "tax_code", taxCodeStr)) == null) {
                        taxAmtStr = "0";
                    }
                }
                applyFormulaStr = String.valueOf(applyFormulaStr) + taxAmtStr.trim();
            }
            BaseLogger.log("3", null, null, "Apply Formula : " + applyFormulaStr);
            if (applyFormulaStr != null && applyFormulaStr.trim().length() > 0) {
                computeAmt = Double.parseDouble(applyFormulaStr.trim());
                switch (applyOperatorStr.charAt(0)) {
                    case 'A': {
                        applyAmt += computeAmt;
                    }
                    case 'S': {
                        applyAmt -= computeAmt;
                    }
                    case 'M': {
                        applyAmt *= computeAmt;
                    }
                    case 'D': {
                        applyAmt /= computeAmt;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalulation : applyAmtFromFormula() \n");
            throw new ITMException(e);
        }
        return applyAmt;
    }

    private double calcAppAmtForDiffTCodes(int cntTaxCodes, String taxCode) throws ITMException {
        String taxAmtStr = null;
        BaseLogger.log("2", null, null, "Tax Code from calcAppAmtForDiffTCodes : " + taxCode);
        BaseLogger.log("2", null, null, "cnt Tax Code from calcAppAmtForDiffTCodes : " + cntTaxCodes);
        double taxAmt = 0.0;
        try {
            if (taxCode == null) {
                taxCode = "";
            }
            taxAmtStr = this.getElementValue(cntTaxCodes, "tax_amt", "tax_code", taxCode);
            BaseLogger.log("3", null, null, "Tax Amount from getElementValue in calcTaxAmt is : " + taxAmtStr);
            if (taxAmtStr != null && taxAmtStr.trim().length() > 0) {
                taxAmt = Double.parseDouble(taxAmtStr);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : TaxCalc : calcAppAmtForDiffTCodes : " + e);
            throw new ITMException(e);
        }
        return taxAmt;
    }

    private int countTaxCodesFromTaxBase(String taxBase) throws ITMException {
        int taxCnt = 0;
        BaseLogger.log("2", null, null, "==========");
        BaseLogger.log("2", null, null, "  TAX_CODE");
        BaseLogger.log("2", null, null, "===========");
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                BaseLogger.log("3", null, null, "Tax Base \t :" + taxBase);
                String queryForTaxCode = "SELECT TAX_CODE FROM TBASSEQ WHERE TAX_BASE ='" + taxBase + "' ORDER BY SEQ_NO";
                BaseLogger.log("3", null, null, "queryForTaxCode : " + queryForTaxCode);
                stmtLocal = this.conn.prepareStatement(queryForTaxCode);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    ++taxCnt;
                    this.taxCodeSeqArrList.add(rsLocal.getString(1));
                    BaseLogger.log("9", null, null, "tax Code = " + rsLocal.getString(1));
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation : countTaxCodesFromTaxBase() \n ");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return taxCnt;
    }

    private void setTaxFormFromExcise(String tranCodeStr, String tranIdStr, String prevLineNoStr, String taxCodeStr) throws ITMException {
        BaseLogger.log("2", null, null, "=============================");
        BaseLogger.log("2", null, null, " TAX_FORM   TAX_FORM_DATE  ACCT_CODE ");
        BaseLogger.log("2", null, null, "================================\n");
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String queryTaxForm = "SELECT TAX_FORM, TAX_FORM_DATE FROM TAXTRAN WHERE TRAN_CODE = '" + tranCodeStr + "' AND TRAN_ID = '" + tranIdStr + "' AND LINE_NO = '" + prevLineNoStr + "' AND TAX_CODE = '" + taxCodeStr + "'";
                stmtLocal = this.conn.prepareStatement(queryTaxForm);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    this.instVarMap.put("taxForm", rsLocal.getString(1));
                    this.instVarMap.put("taxFormDate", rsLocal.getString(2));
                    BaseLogger.log("3", null, null, String.valueOf(rsLocal.getString(1)) + " \t " + rsLocal.getString(2));
                }
                this.setTaxNodeValue("tax_form", (String)this.instVarMap.get("taxForm"));
                this.setTaxNodeValue("tax_form_date", (String)this.instVarMap.get("taxFormDate"));
                BaseLogger.log("3", null, null, "Tax Method : " + (String)this.instVarMap.get("taxForm") + " taxFormDate : " + (String)this.instVarMap.get("taxFormDate"));
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation: setTaxFormFromExcise() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    private void setTaxFromAncestor(String tranCode, String tranId, String lineNo, String taxCode) throws ITMException {
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                lineNo = "   " + lineNo;
                if (lineNo.length() > 3) {
                    lineNo = lineNo.substring(lineNo.length() - 3, lineNo.length());
                }
                String queryTaxForm = "SELECT TAX_PERC, CHG_STAT, TAX_FORM, TAX_FORM_DATE FROM TAXTRAN WHERE TRAN_CODE IN (" + tranCode + ") AND TRAN_ID = '" + tranId + "' AND LINE_NO='" + lineNo + "' AND TAX_CODE='" + taxCode + "' AND CHG_STAT='F'";
                BaseLogger.log("3", null, null, queryTaxForm);
                double taxPercDbl = 0.0;
                boolean isAncFrozen = false;
                stmtLocal = this.conn.prepareStatement(queryTaxForm);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    isAncFrozen = true;
                    taxPercDbl = rsLocal.getDouble(1);
                    this.instVarMap.put("taxPerc", new Double(taxPercDbl));
                    this.instVarMap.put("chgStat", rsLocal.getString(2));
                    if (this.getElementValueFromTaxNode(null, "tax_form") != null) continue;
                    this.setTaxNodeValue("tax_form", rsLocal.getString(3));
                    this.setTaxNodeValue("tax_form_date", rsLocal.getString(4));
                }
                if (isAncFrozen) {
                    this.currTaxCodePercMap.put(taxCode.trim(), "" + taxPercDbl);
                    this.setTaxNodeValue("chg_stat", "F");
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
                BaseLogger.log("3", null, null, "Tax Percentage from setTaxFromAncestor() \n " + (Double)this.instVarMap.get("taxPerc"));
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation: setTaxFromAncestor() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    private String[] getToken(String source, String seperator) throws ITMException {
        String[] retSourceStr = new String[2];
        try {
            int p = source.indexOf(seperator);
            if (p == -1) {
                retSourceStr[0] = source;
                retSourceStr[1] = "";
            } else {
                retSourceStr[0] = source.substring(0, p);
                retSourceStr[1] = source.substring(p + 1);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalc() :getToken() " + e);
            throw new ITMException(e);
        }
        return retSourceStr;
    }

    private String getEnvDescription(String prdCode, String varName) throws ITMException {
        String varValue = null;
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String queryForVarValue = "SELECT VAR_VALUE FROM DISPARM WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME='" + varName + "'";
                stmtLocal = this.conn.prepareStatement(queryForVarValue);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    varValue = rsLocal.getString(1);
                }
                if (varValue == null || varValue != null && varValue.trim().length() == 0) {
                    varValue = "NULLFOUND";
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
                BaseLogger.log("3", null, null, "Retrieved Parameter value from DISPARM for varName [" + varName + "] for period [" + prdCode + "] :[" + varValue + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getEnvDescription() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return varValue;
    }

    private void taxAmtFromMethodType() throws ITMException {
        Statement pStmt = null;
        String tagValue = null;
        try {
            try {
                this.taxAmtFromMethodType = new ArrayList();
                String methodDetailStr = (String)this.instVarMap.get("methodDet");
                String methodInputStr = (String)this.instVarMap.get("methodInputAdv");
                boolean isInputAdv = true;
                if (methodInputStr == null || "".equals(methodInputStr)) {
                    isInputAdv = false;
                    methodInputStr = (String)this.instVarMap.get("methodInput");
                }
                BaseLogger.log("3", null, null, "Calculating tax amount for tax method type for methodDet :[" + methodDetailStr + "] methodInput :[" + (String)this.instVarMap.get("methodInput") + "] methodInputAdv :[" + (String)this.instVarMap.get("methodInputAdv") + "]");
                String[] inputs = new String[2];
                String input = null;
                StringTokenizer methodDetailStk = new StringTokenizer(methodDetailStr, "?");
                pStmt = this.conn.prepareStatement(methodDetailStr);
                int noOfParams = methodDetailStk.countTokens() - 1;
                BaseLogger.log("3", null, null, "No. of params in Tax method SQL :[" + noOfParams + "]");
                int i = 1;
                while (i <= noOfParams) {
                    inputs = this.getToken(methodInputStr, ",");
                    input = inputs[0];
                    methodInputStr = inputs[1];
                    String dataType = "S";
                    Node curDetail = null;
                    ArrayList tokenList = null;
                    if (this.globalVarsList.contains(input)) {
                        BaseLogger.log("3", null, null, "Global var used as input :[" + input + "]....");
                        if (input.equals("objectName")) {
                            tagValue = this.objName;
                        } else if (input.equals("transactionSeries")) {
                            tagValue = this.refSerStr;
                        }
                    } else if (isInputAdv) {
                        BaseLogger.log("3", null, null, "Advance input used....");
                        tokenList = this.getTokenList(input, ".");
                        String formNo = (String)tokenList.get(0);
                        boolean isTaxElement = false;
                        if (formNo.toUpperCase().indexOf("T") != -1) {
                            isTaxElement = true;
                            formNo = formNo.substring(0, formNo.toUpperCase().indexOf("T"));
                        }
                        formNo = formNo.length() == 0 ? this.selDataObjCtx : formNo;
                        String recNo = (String)tokenList.get(1);
                        recNo = recNo.length() == 0 ? this.selDataDomId : recNo;
                        String tempDataType = (String)tokenList.get(2);
                        if (tempDataType != null && tempDataType.length() > 0) {
                            dataType = tempDataType;
                        }
                        input = (String)tokenList.get(3);
                        BaseLogger.log("3", null, null, "Form No. :[" + formNo + "] Dom Id :[" + recNo + "] input field name :[" + input + "] isTaxElement :[" + isTaxElement + "]");
                        if (!isTaxElement) {
                            curDetail = this.searchNode(this.dataNode.getOwnerDocument(), formNo, recNo);
                            if (curDetail != null) {
                                tagValue = this.getElementValueFromNode(input.trim(), curDetail);
                            }
                        } else if (this.isNodeFoundInTaxDom(input) && this.getElementValueFromTaxNode(null, input.trim()) != null) {
                            tagValue = this.getElementValueFromTaxNode(null, input.trim());
                        }
                    } else if (this.isNodeFoundInTaxDom(input)) {
                        if (this.getElementValueFromTaxNode(null, input.trim()) != null) {
                            tagValue = this.getElementValueFromTaxNode(null, input.trim());
                        }
                    } else if (this.isNodeFound(input) && this.getNodeValue(input.trim()) != null) {
                        tagValue = this.getNodeValue(input.trim());
                    }
                    BaseLogger.log("3", null, null, "Setting param [" + i + "] for datatype :[" + dataType + "] value :[" + tagValue + "]");
                    if (dataType.toUpperCase().equals("I") || dataType.toUpperCase().equals("N")) {
                        pStmt.setInt(i, Integer.parseInt(tagValue));
                    } else if (dataType.toUpperCase().equals("D") || dataType.toUpperCase().equals("F")) {
                        pStmt.setDouble(i, Double.parseDouble(tagValue));
                    } else if (dataType.toUpperCase().equals("S")) {
                        pStmt.setString(i, tagValue);
                    } else if (dataType.toUpperCase().equals("T")) {
                        if (tagValue != null && tagValue.length() > 0) {
                            E12GenericUtility genericUtility = new E12GenericUtility();
                            tagValue = genericUtility.getValidDateTimeString(tagValue, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                            pStmt.setTimestamp(i, Timestamp.valueOf(tagValue));
                        } else {
                            pStmt.setNull(i, 0);
                        }
                    }
                    ++i;
                }
                ResultSet rsLocal = pStmt.executeQuery();
                while (rsLocal.next()) {
                    BaseLogger.log("3", null, null, "Records found for Tax Method query....");
                    this.taxAmtFromMethodType.add(rsLocal.getString(1));
                }
                BaseLogger.log("3", null, null, "taxAmtFromMethodType :" + this.taxAmtFromMethodType);
                rsLocal.close();
                rsLocal = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation : taxAmtFromMethodType() \n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    private String getTaxMethod() throws ITMException {
        String taxMethodStr = null;
        BaseLogger.log("2", null, null, "=============");
        BaseLogger.log("2", null, null, "TAX_METHOD");
        BaseLogger.log("2", null, null, "=============\n");
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String taxCode = (String)this.instVarMap.get("taxCode");
                String queryForTaxMethod = "SELECT TAX_METHOD FROM TAX WHERE TAX_CODE ='" + taxCode + "'";
                stmtLocal = this.conn.prepareStatement(queryForTaxMethod);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    taxMethodStr = rsLocal.getString(1);
                }
                BaseLogger.log("3", null, null, "Tax Method is : " + taxMethodStr);
                this.instVarMap.put("taxMethod", taxMethodStr);
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getTaxMethod() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return taxMethodStr;
    }

    private String getTaxMethodType() throws ITMException {
        String taxMethodTypeStr = null;
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String taxMethodStr = this.getTaxMethod();
                BaseLogger.log("2", null, null, "=============");
                BaseLogger.log("2", null, null, "METHOD TYPE");
                BaseLogger.log("2", null, null, "=============\n");
                if (taxMethodStr != null) {
                    String queryForTaxMethodType = "SELECT METHOD_TYPE, METHOD_DET, METHOD_INPUT,METHOD_INPUT_ADV FROM TAXMETHOD\tWHERE TAX_METHOD = '" + taxMethodStr + "'";
                    boolean isTaxMethodDefn = false;
                    stmtLocal = this.conn.prepareStatement(queryForTaxMethodType);
                    rsLocal = stmtLocal.executeQuery();
                    while (rsLocal.next()) {
                        isTaxMethodDefn = true;
                        taxMethodTypeStr = rsLocal.getString(1);
                        this.instVarMap.put("methodType", taxMethodTypeStr);
                        this.instVarMap.put("methodDet", rsLocal.getString(2));
                        this.instVarMap.put("methodInput", rsLocal.getString(3));
                        this.instVarMap.put("methodInputAdv", rsLocal.getString(4));
                    }
                    rsLocal.close();
                    rsLocal = null;
                    stmtLocal.close();
                    stmtLocal = null;
                    if (!isTaxMethodDefn) {
                        throw new Exception("Tax Method not defined for Tax Method :[" + taxMethodStr + "]");
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getTaxMethodType() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return taxMethodTypeStr;
    }

    private String getTaxRate(double slabAmt) throws ITMException {
        String errStr = null;
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        BaseLogger.log("2", null, null, "===============================");
        BaseLogger.log("2", null, null, "TYPE       RATE           MIN_AMT");
        BaseLogger.log("2", null, null, "================================\n");
        try {
            try {
                String taxSet = this.getElementValueFromTaxNode(null, "tax_set");
                if (taxSet != null) {
                    String queryForTaxRate = "SELECT TYPE, RATE, MIN_AMT FROM TAXRATE WHERE TAX_SET = '" + taxSet + "'AND MIN_SLAB <= " + slabAmt + " AND MAX_SLAB >= " + slabAmt;
                    BaseLogger.log("3", null, null, "queryForTaxRate :" + queryForTaxRate);
                    stmtLocal = this.conn.prepareStatement(queryForTaxRate);
                    rsLocal = stmtLocal.executeQuery();
                    if (rsLocal == null) {
                        errStr = null;
                    }
                    while (rsLocal.next()) {
                        errStr = "NOERROR";
                        this.instVarMap.put("type", rsLocal.getString(1));
                        this.instVarMap.put("rate", new Double(rsLocal.getDouble(2)));
                        this.instVarMap.put("minAmt", new Double(rsLocal.getDouble(3)));
                        BaseLogger.log("3", null, null, String.valueOf(rsLocal.getString(1)) + " \t " + rsLocal.getString(2) + " \t " + rsLocal.getString(3));
                    }
                    rsLocal.close();
                    rsLocal = null;
                    stmtLocal.close();
                    stmtLocal = null;
                    if (errStr == null) {
                        throw new Exception("Tax Rate not found Tax Set :[" + taxSet + "]");
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getTaxRate() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return errStr;
    }

    private double getSlabBaseAmt(double disc, String qtyFldStr, String rateFldStr) throws ITMException {
        double qtyFld = 0.0;
        double rateFld = 0.0;
        double slabAmt = 0.0;
        try {
            String slabBaseStr = (String)this.instVarMap.get("slabBase");
            if (slabBaseStr != null) {
                String rateFldValueStr;
                String qtyFldValueStr;
                int slabBase = slabBaseStr.charAt(0);
                if (qtyFldStr != null && (qtyFldValueStr = this.getNodeValue(qtyFldStr)) != null && qtyFldValueStr.trim().length() > 0) {
                    qtyFld = Double.parseDouble(qtyFldValueStr.trim());
                }
                if (rateFldStr != null && (rateFldValueStr = this.getNodeValue(rateFldStr)) != null && rateFldValueStr.trim().length() > 0) {
                    rateFld = Double.parseDouble(rateFldValueStr.trim());
                }
                if (slabBase == 78 && !this.isNodeFound(qtyFldStr) && !this.isNodeFound("discount")) {
                    slabBase = 71;
                }
                switch (slabBase) {
                    case 71: {
                        if (qtyFldStr == null || qtyFldStr.trim().length() == 0) {
                            slabAmt = rateFld;
                            break;
                        }
                        slabAmt = rateFld * qtyFld;
                        break;
                    }
                    case 78: {
                        slabAmt = rateFld * qtyFld;
                        slabAmt -= slabAmt * disc / 100.0;
                        break;
                    }
                    case 82: {
                        slabAmt = rateFld;
                        break;
                    }
                    case 81: {
                        slabAmt = qtyFld;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : Taxcalculation :  () " + e);
            throw new ITMException(e);
        }
        return slabAmt;
    }

    private char getApplyOn() throws ITMException {
        String applyOnStr = null;
        char applyOnChar = ' ';
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        BaseLogger.log("2", null, null, "======================================");
        BaseLogger.log("2", null, null, "apply_on  apply_perc apply_operator  apply_formula");
        BaseLogger.log("2", null, null, "======================================\n");
        try {
            try {
                String taxBaseStr = (String)this.instVarMap.get("taxBase");
                if (taxBaseStr != null) {
                    String queryForApplyOn = "SELECT APPLY_ON, APPLY_PERC, APPLY_OPERATOR, APPLY_FORMULA, TAX_EXPR, TAX_EXPR_INP FROM TAXBASE WHERE TAX_BASE ='" + taxBaseStr + "'";
                    BaseLogger.log("3", null, null, " query for apply on : " + queryForApplyOn);
                    boolean isTaxBaseExists = false;
                    stmtLocal = this.conn.prepareStatement(queryForApplyOn);
                    rsLocal = stmtLocal.executeQuery();
                    while (rsLocal.next()) {
                        isTaxBaseExists = true;
                        this.instVarMap.put("applyOn", rsLocal.getString(1));
                        this.instVarMap.put("applyPerc", new Double(rsLocal.getDouble(2)));
                        this.instVarMap.put("applyOperator", rsLocal.getString(3));
                        this.instVarMap.put("applyFormula", rsLocal.getString(4));
                        this.instVarMap.put("exprStr", rsLocal.getString(5));
                        this.instVarMap.put("exprStrInput", rsLocal.getString(6));
                    }
                    if (!isTaxBaseExists) {
                        throw new Exception("Invalid Tax Base, setting not found in TAXBASE for Tax Base :[" + taxBaseStr + "]");
                    }
                    applyOnStr = (String)this.instVarMap.get("applyOn");
                    applyOnChar = applyOnStr.charAt(0);
                    rsLocal.close();
                    rsLocal = null;
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getApplyOn() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "this.instVarMap :[" + this.instVarMap + "]");
        return applyOnChar;
    }

    private double getApplyAmt(double rate, double qty, double noOfArticle, double clgRate, double disc, String qtyFldStr, String rateFldStr, String tempTaxPerc) throws ITMException {
        double qtyFld = 0.0;
        double rateFld = 0.0;
        double applyAmt = 0.0;
        boolean isCustomColSet = false;
        try {
            if (this.transRateCol != null && this.transQtyCol != null) {
                rateFldStr = this.transRateCol;
                qtyFldStr = this.transQtyCol;
                isCustomColSet = true;
            }
            char applyOn = this.getApplyOn();
            BaseLogger.log("3", null, null, "Before qtyFldStr :[" + qtyFldStr + "] rateFldStr :[" + rateFldStr + "]");
            boolean isQtyFieldExists = this.isNodeFound(qtyFldStr);
            boolean isRateFieldExists = this.isNodeFound(rateFldStr);
            boolean isDiscountFieldExists = this.isNodeFound("discount");
            String qtyFldValueStr = null;
            String rateFldValueStr = null;
            if (!isQtyFieldExists && !isCustomColSet) {
                qtyFldValueStr = this.getNodeValue("quantity");
                rateFldValueStr = this.getNodeValue("rate");
            } else {
                qtyFldValueStr = this.getNodeValue(qtyFldStr);
                rateFldValueStr = this.getNodeValue(rateFldStr);
                if (rateFldValueStr == null && isCustomColSet) {
                    try {
                        rateFldValueStr = "" + Double.parseDouble(rateFldStr);
                    }
                    catch (NumberFormatException nfe) {
                        BaseLogger.log("0", null, null, "Rate field set in Transetup is not a number");
                        rateFldValueStr = null;
                    }
                }
            }
            if (qtyFldValueStr != null && qtyFldValueStr.trim().length() > 0) {
                isQtyFieldExists = true;
                qtyFld = Double.parseDouble(qtyFldValueStr.trim());
            }
            if (rateFldValueStr != null && rateFldValueStr.trim().length() > 0) {
                isRateFieldExists = true;
                rateFld = Double.parseDouble(rateFldValueStr.trim());
            }
            BaseLogger.log("3", null, null, "After qtyFldStr :[" + qtyFldStr + "] rateFldStr :[" + rateFldStr + "] qtyFld :[" + qtyFld + "] rateFld :[" + rateFld + "]");
            if (applyOn == 'N' && !isDiscountFieldExists) {
                applyOn = 'G';
            }
            if (applyOn == 'T' && !isDiscountFieldExists) {
                applyOn = 'E';
            }
            if (applyOn == 'E' && !this.isNodeFound("rate__Clg")) {
                applyOn = 'G';
            }
            BaseLogger.log("3", null, null, "Final applyOn :[" + applyOn + "]");
            switch (applyOn) {
                case 'G': {
                    String amtFldValueStr;
                    if (!isQtyFieldExists) {
                        amtFldValueStr = this.getNodeValue("amount");
                        if (amtFldValueStr != null && amtFldValueStr.trim().length() > 0) {
                            applyAmt = Double.parseDouble(amtFldValueStr.trim());
                            break;
                        }
                        if (!isRateFieldExists) break;
                        applyAmt = rateFld;
                        break;
                    }
                    applyAmt = qtyFld * rateFld;
                    break;
                }
                case 'N': {
                    String amtFldValueStr;
                    if (!isQtyFieldExists) {
                        amtFldValueStr = this.getNodeValue("amount");
                        if (amtFldValueStr != null && amtFldValueStr.trim().length() > 0) {
                            applyAmt = Double.parseDouble(amtFldValueStr.trim());
                        }
                    } else {
                        applyAmt = qtyFld * rateFld;
                    }
                    applyAmt -= applyAmt * (disc / 100.0);
                    break;
                }
                case 'R': {
                    applyAmt = rateFld;
                    break;
                }
                case 'Q': {
                    applyAmt = qtyFld;
                    break;
                }
                case 'A': {
                    applyAmt = noOfArticle;
                    break;
                }
                case 'E': {
                    if (!isQtyFieldExists) {
                        applyAmt = clgRate;
                        break;
                    }
                    applyAmt = qtyFld * clgRate;
                    break;
                }
                case 'T': {
                    BaseLogger.log("3", null, null, "777777777777777 applyAmt:[" + applyAmt + "] isQtyFieldExists :[" + isQtyFieldExists + "] clgRate :[" + clgRate + "]");
                    applyAmt = !isQtyFieldExists ? clgRate : qtyFld * clgRate;
                    applyAmt -= applyAmt * (disc / 100.0);
                }
            }
            Double applyPercDbl = (Double)this.instVarMap.get("applyPerc");
            double applyPerc = applyPercDbl;
            BaseLogger.log("3", null, null, "Penukltimate applyAmt :[" + applyAmt + "] applyPerc :[" + applyPerc + "]");
            applyAmt = applyAmt * applyPerc / 100.0;
            BaseLogger.log("3", null, null, "Final applyAmt :[" + applyAmt + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : Taxcalculation : getApplyAmt() " + e);
            throw new ITMException(e);
        }
        return applyAmt;
    }

    private String getTaxBase(String taxCodeStr, String taxClassStr, String taxChapStr, String taxDate) throws ITMException {
        BaseLogger.log("2", null, null, "TaxCalculation.getTaxBase() taxCodeStr:[" + taxCodeStr + "]");
        BaseLogger.log("2", null, null, "TaxCalculation.getTaxBase() taxClassStr:[" + taxClassStr + "]");
        BaseLogger.log("2", null, null, "TaxCalculation.getTaxBase() taxChapStr:[" + taxChapStr + "]");
        BaseLogger.log("2", null, null, "TaxCalculation.getTaxBase() taxDate:[" + taxDate + "]");
        String taxBaseStr = null;
        String taxSetStr = null;
        String[] queryForTaxSlab = new String[4];
        Statement pstmt = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        ResultSet rsLocal = null;
        try {
            try {
                String taxTable = (String)this.instVarMap.get("taxTable");
                queryForTaxSlab[0] = "SELECT TAX_SET, TAX_BASE, SLAB_BASE, ACCT_CODE, CCTR_CODE, RECO_PERC, ACCT_CODE__RECO, CCTR_CODE__RECO FROM TAXSET WHERE TAX_CODE = '" + taxCodeStr.trim() + "' AND TAX_CLASS = '" + taxClassStr + "' AND TAX_CHAP = '" + taxChapStr + "' AND TAX_TABLE = '" + taxTable + "' AND EFF_FROM <= ? AND ( VALID_UPTO >= ? OR VALID_UPTO is null )";
                queryForTaxSlab[1] = "SELECT TAX_SET, TAX_BASE, SLAB_BASE, ACCT_CODE, CCTR_CODE, RECO_PERC, ACCT_CODE__RECO, CCTR_CODE__RECO FROM TAXSET WHERE TAX_CODE = '" + taxCodeStr.trim() + "' AND TAX_CLASS = '" + taxClassStr + "' AND TAX_CHAP = '          ' AND TAX_TABLE = '" + taxTable + "' AND EFF_FROM <= ? AND ( VALID_UPTO >= ? OR VALID_UPTO is null )";
                queryForTaxSlab[2] = "SELECT TAX_SET, TAX_BASE, SLAB_BASE, ACCT_CODE, CCTR_CODE, RECO_PERC, ACCT_CODE__RECO, CCTR_CODE__RECO FROM TAXSET WHERE TAX_CODE = '" + taxCodeStr.trim() + "' AND TAX_CLASS = '     '  AND TAX_CHAP = '" + taxChapStr + "' AND TAX_TABLE = '" + taxTable.trim() + "' AND EFF_FROM <= ? AND ( VALID_UPTO >= ? OR VALID_UPTO is null )";
                queryForTaxSlab[3] = "SELECT TAX_SET, TAX_BASE, SLAB_BASE, ACCT_CODE, CCTR_CODE, RECO_PERC, ACCT_CODE__RECO, CCTR_CODE__RECO FROM TAXSET WHERE TAX_CODE = '" + taxCodeStr.trim() + "' AND TAX_CLASS = '     ' AND TAX_CHAP = '          ' \tAND TAX_TABLE = '" + taxTable.trim() + "' AND EFF_FROM <= ? AND ( VALID_UPTO >= ? OR VALID_UPTO is null )";
                int queryCount = 0;
                while (queryCount < 4) {
                    if (taxBaseStr != null) break;
                    BaseLogger.log("3", null, null, "executing query : " + queryForTaxSlab[queryCount]);
                    pstmt = this.conn.prepareStatement(queryForTaxSlab[queryCount]);
                    pstmt.setTimestamp(1, Timestamp.valueOf(genericUtility.getValidDateTimeString(taxDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    pstmt.setTimestamp(2, Timestamp.valueOf(genericUtility.getValidDateTimeString(taxDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    rsLocal = pstmt.executeQuery();
                    while (rsLocal.next()) {
                        taxBaseStr = rsLocal.getString(2);
                        taxSetStr = rsLocal.getString(1);
                        this.instVarMap.put("taxSet", taxSetStr);
                        this.instVarMap.put("taxBase", taxBaseStr);
                        this.instVarMap.put("slabBase", rsLocal.getString(3));
                        this.instVarMap.put("taxBaseAcctCode", rsLocal.getString(4));
                        this.instVarMap.put("taxBaseCctrCode", rsLocal.getString(5));
                        this.instVarMap.put("recoPerc", new Double(rsLocal.getDouble(6)));
                        this.instVarMap.put("acctCodeReco", rsLocal.getString(7));
                        this.instVarMap.put("cctrCodeReco", rsLocal.getString(8));
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    ++queryCount;
                }
                BaseLogger.log("3", null, null, " record set from get TaxBase : \n" + taxBaseStr);
                if (taxBaseStr != null) {
                    this.setTaxNodeValue("tax_set", (String)this.instVarMap.get("taxSet"));
                    this.setTaxNodeValue("tax_base", taxBaseStr.trim());
                    BaseLogger.log("3", null, null, "TaxSet   : " + (String)this.instVarMap.get("taxSet"));
                    BaseLogger.log("3", null, null, "TaxBase  : " + taxBaseStr);
                    BaseLogger.log("3", null, null, "InstVarMap  : " + this.instVarMap);
                } else {
                    if (taxBaseStr == null) {
                        throw new Exception("Tax Base not found for Tax Code :[" + taxCodeStr + "] Tax Class :[" + taxClassStr + "] Tax Chapter :[" + taxChapStr + "] Tax Table :[" + taxTable + "] for the given date :[" + taxDate + "]");
                    }
                    if (taxSetStr == null) {
                        throw new Exception("Tax Set not found for Tax Code :[" + taxCodeStr + "] Tax Class :[" + taxClassStr + "] Tax Chapter :[" + taxChapStr + "] Tax Table :[" + taxTable + "] for the given date :[" + taxDate + "]");
                    }
                }
                rsLocal.close();
                rsLocal = null;
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : getTaxBase() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return taxBaseStr;
    }

    private void setTaxCodeStatus(String taxCodeStr) throws ITMException {
        String edOptStr = null;
        String currCodeTaxStr = null;
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String queryForTaxStatusStr = "SELECT CASE WHEN EDIT_OPTION IS NULL THEN 'N' ELSE EDIT_OPTION END, CURR_CODE FROM TAX WHERE TAX_CODE = '" + taxCodeStr + "'";
                BaseLogger.log("3", null, null, "TaxCalculation : setTaxCodeStatus : queryForTaxStatusStr :" + queryForTaxStatusStr + "\n");
                BaseLogger.log("3", null, null, "======================");
                BaseLogger.log("3", null, null, "EDIT_OPTION CURR_CODE");
                BaseLogger.log("3", null, null, "======================\n");
                stmtLocal = this.conn.prepareStatement(queryForTaxStatusStr);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    edOptStr = rsLocal.getString(1);
                    currCodeTaxStr = rsLocal.getString(2);
                }
                char edOptChar = edOptStr.charAt(0);
                if (edOptChar == 'A' || edOptChar == 'R') {
                    this.setTaxNodeValue("cc_editopt", "Y");
                } else {
                    this.setTaxNodeValue("cc_editopt", "N");
                }
                this.instVarMap.put("currCode", currCodeTaxStr);
                this.instVarMap.put("editOpt", edOptStr);
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : setTaxCodeStatus() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }

    private String getRefSer(String taxEnvStr, String modIdStr) throws ITMException {
        int countRec = 0;
        String refSerStr = modIdStr;
        String queryForCountTaxCodes = "SELECT COUNT(1) FROM TENVSEQ WHERE TAX_ENV='" + taxEnvStr + "' AND REF_SER='" + modIdStr + "'";
        BaseLogger.log("2", null, null, "TaxCalculation : getRefSer : queryForCountTaxCodes :" + queryForCountTaxCodes + "\n");
        PreparedStatement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                stmtLocal = this.conn.prepareStatement(queryForCountTaxCodes);
                rsLocal = stmtLocal.executeQuery();
                BaseLogger.log("3", null, null, "refrence Series for which we are searching  no. of records in tenvseq table  : " + refSerStr);
                while (rsLocal.next()) {
                    countRec = rsLocal.getInt(1);
                }
                if (countRec == 0) {
                    refSerStr = "      ";
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
                BaseLogger.log("3", null, null, "NO. of Records for current tax Environment and refrence Series are : " + countRec);
                BaseLogger.log("3", null, null, "refrence Series returns on the basis of  searching  no. of records in tenvseq table  : " + refSerStr);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalc : countTaxCodes : \n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return refSerStr;
    }

    private void getTaxCodes(String taxEnvStr, String refSerStr) throws ITMException {
        BaseLogger.log("2", null, null, "=========================================================");
        BaseLogger.log("2", null, null, "tax_code\ttaxtable    taxtablemark    usemarking    acctcode    cctrcode ");
        BaseLogger.log("2", null, null, "=========================================================");
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String modIdStr = this.getRefSer(taxEnvStr, refSerStr);
                this.taxCodeList = new ArrayList();
                String queryForTaxCodes = "SELECT TAX_CODE, TAX_TABLE, TAX_TABLE__MARK, USE_MARKING, ACCT_CODE, CCTR_CODE FROM TENVSEQ WHERE TAX_ENV ='" + taxEnvStr + "' AND REF_SER ='" + modIdStr + "' ORDER BY SEQ_NO";
                stmtLocal = this.conn.prepareStatement(queryForTaxCodes);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    ++this.noOfTaxCodes;
                    this.taxCodeList.add(rsLocal.getString(1));
                    this.taxCodeList.add(rsLocal.getString(2));
                    this.taxCodeList.add(rsLocal.getString(3));
                    this.taxCodeList.add(rsLocal.getString(4));
                    this.taxCodeList.add(rsLocal.getString(5));
                    this.taxCodeList.add(rsLocal.getString(6));
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation : getTaxCodes : \n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "this.taxCodeList :" + this.taxCodeList);
    }

    private double getExchangeRate(String currCodeTranStr, String currCodeStr, String loginSiteStr, String taxCalcDate, String asType) throws ITMException {
        double lc_exch_rate;
        block52: {
            E12GenericUtility genericUtility;
            Timestamp tranDate;
            ResultSet rs1;
            ResultSet rs;
            Statement pstmt1;
            Statement pstmt;
            Statement stmtInner;
            String sql;
            String ls_curr_code__to;
            String ls_fin_entity;
            block50: {
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() currCodeTranStr : [" + currCodeTranStr + "]");
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() currCodeStr : [" + currCodeStr + "]");
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() loginSiteStr : [" + loginSiteStr + "]");
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() taxCalcDate : [" + taxCalcDate + "]");
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() asType : [" + asType + "]");
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() refSerStr : [" + this.refSerStr + "]");
                ls_fin_entity = "";
                ls_curr_code__to = "";
                String var_value = "";
                String type = "";
                lc_exch_rate = 0.0;
                sql = "";
                stmtInner = null;
                pstmt = null;
                pstmt1 = null;
                rs = null;
                rs1 = null;
                tranDate = null;
                genericUtility = new E12GenericUtility();
                if (!currCodeTranStr.trim().equalsIgnoreCase(currCodeStr.trim())) break block50;
                return 1.0;
            }
            try {
                if (taxCalcDate != null && taxCalcDate.length() > 0) {
                    taxCalcDate = genericUtility.getValidDateString(taxCalcDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                    tranDate = Timestamp.valueOf(String.valueOf(taxCalcDate) + " 00:00:00");
                } else {
                    Date todayDate = new Date(System.currentTimeMillis());
                    taxCalcDate = genericUtility.getValidDateString(todayDate.toString(), "yyyy-MM-dd", genericUtility.getDBDateFormat());
                    tranDate = Timestamp.valueOf(String.valueOf(taxCalcDate) + " 00:00:00");
                }
                if (currCodeStr.equals("")) {
                    try {
                        sql = "SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE ='" + loginSiteStr.trim() + "'";
                        PreparedStatement stmt = this.conn.prepareStatement(sql);
                        rs = stmt.executeQuery();
                        if (rs.next() && (rs = (stmtInner = this.conn.prepareStatement(sql = "SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = '" + (ls_fin_entity = rs.getString(1)).trim() + "'")).executeQuery()).next()) {
                            ls_curr_code__to = rs.getString(1);
                        }
                        stmt.close();
                        stmt = null;
                        rs.close();
                        rs = null;
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception :: [][getDailyExchRateSellBuy] ::" + e);
                    }
                } else {
                    ls_curr_code__to = currCodeStr;
                }
                String exchRateColName = "";
                if (this.refSerStr != null && this.refSerStr.length() > 0) {
                    exchRateColName = this.refSerStr.trim().equalsIgnoreCase("VOUCH") || this.refSerStr.trim().equalsIgnoreCase("DRNPAY") || this.refSerStr.trim().equalsIgnoreCase("P-ORD") || this.refSerStr.trim().equalsIgnoreCase("P-RCP") || this.refSerStr.trim().equalsIgnoreCase("P-RET") || this.refSerStr.trim().equalsIgnoreCase("P-CON") || this.refSerStr.trim().equalsIgnoreCase("D-RCP") || this.refSerStr.trim().equalsIgnoreCase("P-ADV") || this.refSerStr.trim().equalsIgnoreCase("P-AMD") || this.refSerStr.trim().equalsIgnoreCase("P-RET") || this.refSerStr.trim().equalsIgnoreCase("M-VOUC") ? "EXCH_RATE__BUY" : (this.refSerStr.trim().equalsIgnoreCase("S-DSP") || this.refSerStr.trim().equalsIgnoreCase("S-INV") || this.refSerStr.trim().equalsIgnoreCase("S-ORD") || this.refSerStr.trim().equalsIgnoreCase("S-AMD") || this.refSerStr.trim().equalsIgnoreCase("D-ORD") || this.refSerStr.trim().equalsIgnoreCase("D-ISS") || this.refSerStr.trim().equalsIgnoreCase("MDRCRC") || this.refSerStr.trim().equalsIgnoreCase("MDRCRD") || this.refSerStr.trim().equalsIgnoreCase("RCP") ? "EXCH_RATE__SELL" : "EXCH_RATE");
                }
                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() exchRateColName : [" + exchRateColName + "]");
                try {
                    try {
                        sql = "SELECT " + exchRateColName + " FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + currCodeTranStr.trim() + "' AND CURR_CODE__TO = '" + ls_curr_code__to.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                        pstmt = this.conn.prepareStatement(sql);
                        pstmt.setTimestamp(1, tranDate);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            lc_exch_rate = rs.getDouble(1);
                            BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 3967 : [" + lc_exch_rate + "]");
                        }
                        if (lc_exch_rate == 0.0) {
                            sql = "SELECT " + exchRateColName + " FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + ls_curr_code__to.trim() + "' AND CURR_CODE__TO = '" + currCodeTranStr.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                            pstmt1 = this.conn.prepareStatement(sql);
                            pstmt1.setTimestamp(1, tranDate);
                            rs1 = pstmt1.executeQuery();
                            if (rs1.next()) {
                                lc_exch_rate = rs1.getDouble(1);
                                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 3979  : [" + lc_exch_rate + "]");
                                if (lc_exch_rate != 0.0) {
                                    lc_exch_rate = 1.0 / lc_exch_rate;
                                    BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 3983 : [" + lc_exch_rate + "]");
                                }
                            }
                            rs1.close();
                            rs1 = null;
                            pstmt1.close();
                            pstmt1 = null;
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e) {
                        BaseLogger.log("0", null, null, "Exception :: [][getDailyExchRateSellBuy]" + sql + e);
                        e.printStackTrace();
                        throw new ITMException(e);
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", null, null, "Exception []::" + ex.getMessage());
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt1 != null) {
                            pstmt1.close();
                            pstmt1 = null;
                        }
                        if (rs1 != null) {
                            rs1.close();
                            rs1 = null;
                        }
                        if (stmtInner != null) {
                            stmtInner.close();
                            stmtInner = null;
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception []" + e.getMessage() + ":");
                    }
                }
                if (lc_exch_rate != 0.0) break block52;
                try {
                    try {
                        sql = "SELECT EXCH_RATE FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + currCodeTranStr.trim() + "' AND CURR_CODE__TO = '" + ls_curr_code__to.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                        pstmt = this.conn.prepareStatement(sql);
                        pstmt.setTimestamp(1, tranDate);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            lc_exch_rate = rs.getDouble(1);
                            BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 4045 : [" + lc_exch_rate + "]");
                        }
                        if (lc_exch_rate == 0.0) {
                            sql = "SELECT EXCH_RATE FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + ls_curr_code__to.trim() + "' AND CURR_CODE__TO = '" + currCodeTranStr.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                            pstmt1 = this.conn.prepareStatement(sql);
                            pstmt1.setTimestamp(1, tranDate);
                            rs1 = pstmt1.executeQuery();
                            if (rs1.next()) {
                                lc_exch_rate = rs1.getDouble(1);
                                BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 4056 : [" + lc_exch_rate + "]");
                                if (lc_exch_rate != 0.0) {
                                    lc_exch_rate = 1.0 / lc_exch_rate;
                                    BaseLogger.log("2", this.userInfo, null, "TaxCalculation.getExchangeRate() lc_exch_rate 4060 : [" + lc_exch_rate + "]");
                                }
                            }
                            rs1.close();
                            rs1 = null;
                            pstmt1.close();
                            pstmt1 = null;
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e) {
                        BaseLogger.log("0", null, null, "Exception ::[][getDailyExchRateSellBuy]" + sql + e);
                        e.printStackTrace();
                        throw new ITMException(e);
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", null, null, "Exception []::" + ex.getMessage());
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt1 != null) {
                            pstmt1.close();
                            pstmt1 = null;
                        }
                        if (rs1 != null) {
                            rs1.close();
                            rs1 = null;
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception []" + e.getMessage() + ":");
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "TaxCalculation:getExchangeRate:Exception []::" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return lc_exch_rate;
    }

    private String getTaxForm(String tranCode, String tranId, String dataLineStr, String lineNoTax, String taxCodeStr) throws ITMException {
        BaseLogger.log("2", null, null, "start taxform taxPerc :[" + this.instVarMap.get("taxPerc") + "]");
        String taxFormStr = null;
        BaseLogger.log("2", null, null, "=============================");
        BaseLogger.log("2", null, null, "tax_perc, chg_stat, tax_form, tax_form_date");
        BaseLogger.log("2", null, null, "================================\n");
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                if (tranCode != null && tranId != null && dataLineStr != null && lineNoTax != null) {
                    String queryTaxForm = "SELECT TAX_PERC, CHG_STAT, TAX_FORM, TAX_FORM_DATE FROM TAXTRAN WHERE TRAN_CODE = '" + tranCode + "' AND TRAN_ID = '" + tranId + "' AND LINE_NO = '" + dataLineStr + "' AND LINE_NO__TAX = '" + lineNoTax + "' AND TAX_CODE = '" + taxCodeStr + "'";
                    BaseLogger.log("3", null, null, "queryTaxForm :[" + queryTaxForm + "]");
                    stmtLocal = this.conn.prepareStatement(queryTaxForm);
                    rsLocal = stmtLocal.executeQuery();
                    while (rsLocal.next()) {
                        this.instVarMap.put("taxPerc", new Double(rsLocal.getDouble(1)));
                        this.instVarMap.put("chgStat", rsLocal.getString(2));
                        taxFormStr = rsLocal.getString(3);
                        this.setTaxNodeValue("tax_form", taxFormStr);
                        this.setTaxNodeValue("tax_form_date", rsLocal.getString(4));
                    }
                    rsLocal.close();
                    rsLocal = null;
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : TaxCalculation: getTaxForm() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "end taxform taxPerc :[" + this.instVarMap.get("taxPerc") + "]");
        return taxFormStr;
    }

    private double rndAmt(double amt, String round, double roundTo, String transDB) throws ITMException {
        double rndAmt = 0.0;
        double multiplier = 1.0;
        BaseLogger.log("2", null, null, "amount(rndAmt):" + amt);
        try {
            if (amt < 0.0) {
                multiplier = -1.0;
                amt = Math.abs(amt);
            } else {
                if (amt == 0.0) {
                    return amt;
                }
                if (round.equals("N")) {
                    return amt;
                }
                if (roundTo == 0.0) {
                    return amt;
                }
            }
            double modVal = this.getMod(amt, roundTo, transDB);
            String roundStr = round;
            char rnd = roundStr.charAt(0);
            switch (rnd) {
                case 'X': {
                    if (modVal > 0.0) {
                        rndAmt = amt - modVal + roundTo;
                        break;
                    }
                    rndAmt = amt;
                    break;
                }
                case 'P': {
                    rndAmt = amt - modVal;
                    break;
                }
                case 'R': {
                    if (modVal < roundTo / 2.0) {
                        rndAmt = amt - modVal;
                        break;
                    }
                    rndAmt = amt - modVal + roundTo;
                    break;
                }
                default: {
                    rndAmt = amt;
                }
            }
            BaseLogger.log("3", null, null, "rountTo amount(rndAmt):" + (rndAmt *= multiplier));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalcualtion : rndAmt() \n");
            throw new ITMException(e);
        }
        return rndAmt;
    }

    private char getVoucherTypeA(String taxCodeStr) throws ITMException {
        String vTypeStr = null;
        String voucherTypeQuery = "SELECT CASE WHEN TAX_TYPE IS NULL THEN 'A' ELSE TAX_TYPE END FROM TAX WHERE TAX_CODE = '" + taxCodeStr + "'";
        PreparedStatement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                stmtLocal = this.conn.prepareStatement(voucherTypeQuery);
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    vTypeStr = rsLocal.getString(1);
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : Taxcalculation : vouchertypeA() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return vTypeStr.charAt(0);
    }

    private Node getParentNode(int cntTaxCodes, String elementName, String elementValue) throws ITMException {
        Node parentNode = null;
        boolean count = false;
        try {
            int cntForTaxArrLst = 0;
            while (cntForTaxArrLst < this.taxArrLst.size()) {
                Node taxNode = (Node)this.taxArrLst.get(cntForTaxArrLst);
                NodeList taxNodeList = taxNode.getChildNodes();
                int taxNodeListLen = taxNodeList.getLength();
                int cntForNodeList = 0;
                while (cntForNodeList < taxNodeListLen) {
                    String elementNodeValue;
                    Node elementNode = taxNodeList.item(cntForNodeList);
                    if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(elementName) && elementNode.getFirstChild() != null && (elementNodeValue = elementNode.getFirstChild().getNodeValue()).trim().equals(elementValue.trim())) {
                        parentNode = elementNode.getParentNode();
                        break;
                    }
                    ++cntForNodeList;
                }
                ++cntForTaxArrLst;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : Taxcalc : getParentNode() : " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return parentNode;
    }

    private String getElementValue(int cntTaxCodes, String elementNodeName, String tagName, String tagValue) throws ITMException {
        String elementValueStr;
        block4: {
            Node ParentNode = null;
            elementValueStr = null;
            try {
                ParentNode = this.getParentNode(cntTaxCodes, tagName, tagValue);
                if (ParentNode == null) break block4;
                NodeList childNodeList = ParentNode.getChildNodes();
                int i = 0;
                while (i < childNodeList.getLength()) {
                    Node elementNode = childNodeList.item(i);
                    if (elementNode.getNodeName().equals(elementNodeName) && elementNode.getFirstChild() != null) {
                        elementValueStr = elementNode.getFirstChild().getNodeValue();
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : taxCalc : getElementValue : " + e);
                throw new ITMException(e);
            }
        }
        return elementValueStr;
    }

    private boolean isNodeFound(String nodeName) throws ITMException {
        boolean isFound = false;
        try {
            if (this.searchNode(this.dataNode, nodeName) != null) {
                isFound = true;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : isNodeFound() \n" + e);
            throw new ITMException(e);
        }
        return isFound;
    }

    private String getNodeValue(String NodeName) throws ITMException {
        String tagValueStr = null;
        try {
            NodeList taxElements = this.dataNode.getChildNodes();
            int j = 0;
            while (j < taxElements.getLength()) {
                Node taxElement = taxElements.item(j);
                if (taxElement.getNodeType() == 1 && taxElement.getNodeName().equalsIgnoreCase(NodeName) && taxElement.getFirstChild() != null) {
                    tagValueStr = taxElement.getFirstChild().getNodeValue();
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getNodeValue() \n" + e);
            throw new ITMException(e);
        }
        return tagValueStr;
    }

    private boolean isNodeFoundInTaxDom(String nodeName) throws ITMException {
        boolean isFound = false;
        try {
            BaseLogger.log("3", null, null, "Searching for node in :[" + nodeName + "] in curr tax node...");
            NodeList childNodeList = this.workingTaxNode.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(nodeName)) {
                    isFound = true;
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : isNodeFoundInTaxDom() \n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "is node found in tax dom :[" + isFound + "]");
        return isFound;
    }

    private String getElementValueFromTaxNode(Node currTaxNode, String elementName) throws ITMException {
        BaseLogger.log("2", null, null, "getElementValueFromTaxNode start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        String elementValue = null;
        try {
            currTaxNode = currTaxNode == null ? this.workingTaxNode : currTaxNode;
            NodeList childNodeList = currTaxNode.getChildNodes();
            int noOfTaxChildren = childNodeList.getLength();
            int j = 0;
            while (j < noOfTaxChildren) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(elementName.trim()) && elementNode.getFirstChild() != null) {
                    elementValue = elementNode.getFirstChild().getNodeValue();
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getElementValueFromTaxNode() \n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getElementValueFromTaxNode end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        return elementValue;
    }

    private void setTaxNodeValue(String nodeName, String nodeValue) throws ITMException {
        BaseLogger.log("2", null, null, "setTaxNodeValue : nodeName :" + nodeName + ": nodeValue :" + nodeValue + ":");
        Document dom = this.workingTaxNode.getOwnerDocument();
        try {
            if (nodeValue == null) {
                nodeValue = "";
            }
            NodeList childNodeList = this.workingTaxNode.getChildNodes();
            boolean toProtect = false;
            if (nodeName.equalsIgnoreCase("tax_perc") && !this.isTaxPercEditable()) {
                toProtect = true;
            }
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(nodeName)) {
                    if (elementNode.getFirstChild() == null) {
                        if (nodeValue != null) {
                            Element sourceElement = dom.createElement(nodeName);
                            if (toProtect) {
                                sourceElement.setAttribute("protect", "1");
                                this.setTaxNodeValue("cc_editopt", "N");
                            }
                            Text sourceText = dom.createTextNode(nodeValue);
                            sourceElement.appendChild(sourceText);
                            Node updatedNode = dom.importNode(sourceElement, true);
                            this.workingTaxNode.replaceChild(updatedNode, elementNode);
                            break;
                        }
                    } else {
                        elementNode.getFirstChild().setNodeValue(nodeValue);
                        if (toProtect) {
                            ((Element)elementNode).setAttribute("protect", "1");
                            this.setTaxNodeValue("cc_editopt", "N");
                        }
                        break;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : TaxCalc : setNodeValue() \n " + e);
            throw new ITMException(e);
        }
    }

    private void setDataNodeValue(String nodeName, String nodeValue) throws ITMException {
        BaseLogger.log("2", null, null, "setDataNodeValue : nodeName :" + nodeName + ": nodeValue :" + nodeValue + ":");
        Document dom = this.dataNode.getOwnerDocument();
        try {
            if (nodeValue == null) {
                nodeValue = "";
            }
            NodeList childNodeList = this.dataNode.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(nodeName)) {
                    if (elementNode.getFirstChild() == null) {
                        if (nodeValue != null) {
                            Element sourceElement = dom.createElement(nodeName);
                            Text sourceText = dom.createTextNode(nodeValue);
                            sourceElement.appendChild(sourceText);
                            Node updatedNode = dom.importNode(sourceElement, true);
                            this.dataNode.replaceChild(updatedNode, elementNode);
                        }
                    } else {
                        elementNode.getFirstChild().setNodeValue(nodeValue);
                    }
                    this.taxChangeStrBuff.append("<").append(nodeName).append(">").append(nodeValue).append("</").append(nodeName).append(">");
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : TaxCalc : setNodeValue() \n " + e);
            throw new ITMException(e);
        }
    }

    private Node searchNode(Node searchFrom, String tagName) throws ITMException {
        Node currNode = null;
        try {
            NodeList childNodeList = searchFrom.getChildNodes();
            int childListLength = childNodeList.getLength();
            int iCtr = 0;
            while (iCtr < childListLength) {
                Node curChild = childNodeList.item(iCtr);
                if (curChild.getNodeName().equalsIgnoreCase(tagName)) {
                    currNode = curChild;
                    break;
                }
                ++iCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation:searchNode :==>\n" + e);
            throw new ITMException(e);
        }
        return currNode;
    }

    private void appendTaxNodeInDetail() throws ITMException {
        BaseLogger.log("2", null, null, "appending Tax Node in Detail . . . . . . . . . . . . . .");
        try {
            NodeList dataNodeChildList = this.dataNode.getChildNodes();
            int dataNodeChildListLen = dataNodeChildList.getLength();
            int i = 0;
            while (i < dataNodeChildListLen) {
                if (dataNodeChildList.item(i) != null && dataNodeChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                    int noOfTaxRecords = dataNodeChildList.item(i).getChildNodes().getLength();
                    this.workingTaxNode.getAttributes().getNamedItem("domID").setNodeValue("" + (noOfTaxRecords + 1));
                    dataNodeChildList.item(i).appendChild(this.workingTaxNode);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation: appendTaxNodeInDetail :==>\n" + e);
            throw new ITMException(e);
        }
    }

    private void removeTaxNodeInDetail() throws ITMException {
        BaseLogger.log("2", null, null, "TaxCalculation : Removing TaxNodes from Detail");
        try {
            NodeList dataNodeChildList = this.dataNode.getChildNodes();
            int dataNodeChildListLen = dataNodeChildList.getLength();
            int i = 0;
            while (i < dataNodeChildListLen) {
                if (dataNodeChildList.item(i) != null && dataNodeChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                    this.dataNode.replaceChild(this.dataNode.getOwnerDocument().importNode(this.parseString("<Taxes status='N'></Taxes>").getFirstChild(), false), dataNodeChildList.item(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation: removeTaxNodeInDetail :==>\n" + e);
            throw new ITMException(e);
        }
    }

    private Connection getDBConnection(String transDB) throws ITMException {
        Connection newConn = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            newConn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation : getDBConnection() : \n" + e);
            throw new ITMException(e);
        }
        return newConn;
    }

    private String serializeDom(Node dom) throws ITMException {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            retString = out.toString(CommonConstants.ENCODING);
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            retString = null;
            BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :serializeDom :==>\n" + e);
            throw new ITMException(e);
        }
        return retString;
    }

    private Document parseString(String xmlString) throws ITMException {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(baos);
        }
        catch (Exception e) {
            dom = null;
            BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :parseString :==>\n" + e);
            throw new ITMException(e);
        }
        return dom;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && !"".equals(tokenString.trim())) {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    private Node searchNode(Document dom, String objContext, String nodeID) throws ITMException {
        Node detailNode = null;
        try {
            objContext = objContext == null || objContext.length() == 0 ? "1" : objContext;
            nodeID = nodeID == null || nodeID.length() == 0 ? "1" : nodeID;
            NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID)) {
                    BaseLogger.log("3", null, null, "Found node...");
                    detailNode = curDetail;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : searchNode :" + e);
            throw new ITMException(e);
        }
        return detailNode;
    }

    private NodeList searchNodes(Document dom, String objContext) throws ITMException {
        NodeList detailList = null;
        try {
            objContext = objContext == null ? "1" : objContext;
            detailList = dom.getElementsByTagName("Detail" + objContext);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : searchNodes :" + e);
            throw new ITMException(e);
        }
        return detailList;
    }

    private String getElementValueFromTaxesNode(String elementName, String taxCode) throws ITMException {
        BaseLogger.log("2", null, null, "getElementValueFromTaxesNode start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        String elementVal = "";
        try {
            BaseLogger.log("9", null, null, "this.detailDom::::::::" + this.detailDom);
            BaseLogger.log("3", null, null, "Searching for node with Tax code :[" + taxCode + "]");
            Node taxNode = this.getParentNode(0, "tax_code", taxCode);
            elementVal = this.getElementValueFromNode(elementName, taxNode);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : searchNode :" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getElementValueFromTaxesNode end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        return elementVal;
    }

    private String getElementValueFromNode(String elementName, Node curNode) throws ITMException {
        BaseLogger.log("2", null, null, "getElementValueFromNode start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        BaseLogger.log("2", null, null, "********* getElementValueFromNode elementName [" + elementName + "]");
        String elementVal = "";
        try {
            NodeList curNodeList = curNode.getChildNodes();
            int curNodeListLength = curNodeList.getLength();
            int ctr = 0;
            while (ctr < curNodeListLength) {
                Node curChildNode = curNodeList.item(ctr);
                if (curChildNode.getNodeName().equalsIgnoreCase(elementName) && curChildNode.getFirstChild() != null) {
                    elementVal = curChildNode.getFirstChild().getNodeValue();
                    BaseLogger.log("3", null, null, "********* getElementValueFromNode elementVal [" + elementVal + "]");
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : getElementValueFromNode :" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getElementValueFromNode end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        return elementVal;
    }

    private boolean isTaxPercEditable() throws ITMException {
        BaseLogger.log("2", null, null, "isTaxPercEditable start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        boolean isEditable = false;
        try {
            String refSer;
            String editOption = (String)this.instVarMap.get("editOption");
            String seriesEdit = (String)this.instVarMap.get("seriesEdit");
            ArrayList seriesEditList = this.getTokenList(seriesEdit, ",");
            String string = refSer = this.refSerStr != null ? this.refSerStr.trim() : this.refSerStr;
            if (seriesEdit != null && seriesEdit.trim().length() > 0) {
                if ("A".equalsIgnoreCase(editOption) && seriesEdit != null) {
                    isEditable = seriesEditList.contains(refSer);
                } else if ("R".equalsIgnoreCase(editOption)) {
                    isEditable = !seriesEditList.contains(refSer);
                } else {
                    "N".equalsIgnoreCase(editOption);
                }
            } else if ("A".equalsIgnoreCase(editOption)) {
                isEditable = true;
            } else if ("R".equalsIgnoreCase(editOption)) {
                isEditable = false;
            } else {
                "N".equalsIgnoreCase(editOption);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "Returning isTaxPercEditable :[" + isEditable + "]");
        BaseLogger.log("2", null, null, "isTaxPercEditable end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        return isEditable;
    }

    private String getPrevMaxDomId() throws ITMException {
        BaseLogger.log("2", null, null, "getPrevMaxDomId start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        BaseLogger.log("2", null, null, "Getting previous max dom id with tax for setting from ancestor");
        String maxDomId = "-1";
        try {
            NodeList detailList = this.searchNodes(this.dataNode.getOwnerDocument(), this.selDataObjCtx);
            int detailListLength = detailList.getLength();
            int maxLineNo = 0;
            int currLineNo = -1;
            Node currDetailNode = null;
            NodeList currDetailChildNodeList = null;
            BaseLogger.log("3", null, null, "detailListLength [" + detailListLength + "]");
            int detailCtr = 0;
            while (detailCtr < detailListLength) {
                currDetailNode = detailList.item(detailCtr);
                currDetailChildNodeList = currDetailNode.getChildNodes();
                int noOfDetailChildren = currDetailChildNodeList.getLength();
                int detailChildCtr = 0;
                while (detailChildCtr < noOfDetailChildren) {
                    Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
                    if (detailChildNode.getNodeName().equalsIgnoreCase("LINE_NO") && detailChildNode.getFirstChild() != null) {
                        String currLineNoStr = detailChildNode.getFirstChild().getNodeValue();
                        if (currLineNoStr != null) {
                            currLineNo = Integer.parseInt(currLineNoStr.trim());
                        }
                        if (currLineNo < Integer.parseInt(this.selDataDomId) && currLineNo > maxLineNo) {
                            maxLineNo = currLineNo;
                            maxDomId = currDetailNode.getAttributes().getNamedItem("domID").getNodeValue();
                            break;
                        }
                    }
                    ++detailChildCtr;
                }
                ++detailCtr;
            }
            BaseLogger.log("3", null, null, "Rerturning maxDomId :[" + maxDomId + "] maxLineNo :[" + maxLineNo + "]");
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getPrevMaxDomId end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        return maxDomId;
    }

    private void setTranDateColumnName(Connection connPassed, UserInfoBean userInfo) throws ITMException {
        block22: {
            BaseLogger.log("2", userInfo, null, "setTranDateColumnName start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
            Statement stmt = null;
            ResultSet rs = null;
            String sql = "";
            boolean isFuncLocalConn = false;
            try {
                try {
                    String winName;
                    if (connPassed == null) {
                        connPassed = this.getDBConnection(userInfo.getTransDB());
                        isFuncLocalConn = true;
                    }
                    if (this.objName != null && (rs = (stmt = connPassed.prepareStatement(sql = "SELECT TRAN_DATE_COL FROM TRANSETUP WHERE TRAN_WINDOW ='" + (winName = this.objName.startsWith("w_") ? this.objName : "w_" + this.objName) + "'")).executeQuery()).next()) {
                        this.tranDateColumnName = rs.getString("TRAN_DATE_COL");
                        BaseLogger.log("2", null, null, "TaxCalculation.setTranDateColumnName() tranDateColumnName:[" + this.tranDateColumnName + "]");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (isFuncLocalConn && connPassed != null) {
                            connPassed.close();
                            connPassed = null;
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (isFuncLocalConn && connPassed != null) {
                        connPassed.close();
                        connPassed = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (isFuncLocalConn && connPassed != null) {
                    connPassed.close();
                    connPassed = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "setTranDateColumnName end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
    }

    private void setRateNQtyCol(String formNo) throws Exception {
        BaseLogger.log("2", null, null, "setRateNQtyCol start " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        try {
            try {
                String varRateColName = "";
                String varQtyColName = "";
                String qryStr = "SELECT RATE_COL, QTY_COL FROM OBJ_FORMS WHERE WIN_NAME='w_" + this.objName + "' AND FORM_NO ='" + formNo + "' ";
                stmtLocal = this.conn.prepareStatement(qryStr);
                BaseLogger.log("3", null, null, "qryStr [" + qryStr + "]");
                rsLocal = stmtLocal.executeQuery();
                while (rsLocal.next()) {
                    varRateColName = rsLocal.getString("RATE_COL");
                    varQtyColName = rsLocal.getString("QTY_COL");
                    if (varRateColName != null && varRateColName.trim().length() > 0) {
                        this.transRateCol = varRateColName;
                    }
                    if (varQtyColName != null && varQtyColName.trim().length() > 0) {
                        this.transQtyCol = varQtyColName;
                    }
                    BaseLogger.log("3", null, null, "Setting RATE_COL QTY_COL FROM OBJ_FORMS for " + this.objName);
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TaxCalculation: taxCalc :==>\n" + e);
                throw e;
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "setRateNQtyCol end " + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13));
    }

    private double getMod(double val1, double val2, String transDB) throws Exception {
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        Connection conn = null;
        double modVal = -1.0;
        try {
            try {
                String qryStr = "SELECT MOD(" + val1 + ", " + val2 + ") FROM DUAL";
                if ("MSSQL".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    qryStr = "SELECT " + val1 + "%" + val2 + " ";
                }
                conn = this.getDBConnection(transDB);
                stmtLocal = conn.createStatement();
                BaseLogger.log("3", null, null, "qryStr [" + qryStr + "]");
                rsLocal = stmtLocal.executeQuery(qryStr);
                while (rsLocal.next()) {
                    modVal = rsLocal.getDouble(1);
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TaxCalculation: getMod :==>\n" + e);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return modVal;
    }
}

