/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DataProviderComp;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.NodeList;

public class DataProviderActionServlet
extends HttpServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    String XTRA_PARAMS_SEPARATOR = "~~";

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        BaseLogger.log("2", null, null, "DataProviderActionServlet Called");
        try {
            String responseStr = "";
            try {
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                String objName = E12GenericUtility.checkNull(request.getParameter("obj_name"));
                String action = E12GenericUtility.checkNull(request.getParameter("action"));
                if ("GET_DATA".equalsIgnoreCase(action)) {
                    String dataProviderType = E12GenericUtility.checkNull(request.getParameter("provider_type"));
                    String mapXmlData = this.createRequestParamXml(objName, request);
                    String xtraParams = this.getXtraParams(userInfo);
                    BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getMapData : objName[" + objName + "] dataProviderType[" + dataProviderType + "] \n xtraParams[" + xtraParams + "] \n mapXmlData[" + mapXmlData + "]");
                    responseStr = this.getData(objName, dataProviderType, mapXmlData, xtraParams, userInfo);
                    BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getMapData : responseStr[" + responseStr + "]");
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                } else if ("GET_MAP_XSL".equalsIgnoreCase(action)) {
                    BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getMapXsl : objName[" + objName + "]");
                    responseStr = this.getXSL(objName);
                    BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getMapXsl : responseStr[" + responseStr + "]");
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            response.getWriter().write(responseStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            try {
                response.getWriter().write(e.getLocalizedMessage());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String getData(String objName, String dataProviderType, String xmlData, String xtraParams, UserInfoBean userInfo) throws Exception {
        String responseStr = "";
        AppConnectParm appConnect = new AppConnectParm();
        InitialContext ctx = new InitialContext(appConnect.getProperty());
        DataProviderComp dataProviderComp = new DataProviderComp();
        if ("MAP".equalsIgnoreCase(dataProviderType)) {
            responseStr = dataProviderComp.valData(objName, "val_mapdata", xmlData, xtraParams, userInfo);
            if (!this.isError(responseStr)) {
                responseStr = dataProviderComp.getData(objName, "get_mapdata", xmlData, xtraParams, userInfo);
            }
            BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getMapData : responseStr[" + responseStr + "]");
        } else if ("CALENDAR".equalsIgnoreCase(dataProviderType)) {
            responseStr = dataProviderComp.getData(objName, "get_caldata", xmlData, xtraParams, userInfo);
            BaseLogger.log("3", userInfo, null, " DataProviderActionServlet :: getCalData : responseStr[" + responseStr + "]");
        }
        return responseStr;
    }

    private String createRequestParamXml(String objName, HttpServletRequest request) {
        StringBuffer transXml = new StringBuffer();
        try {
            Enumeration enum1 = request.getParameterNames();
            transXml.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
            transXml.append("<Root>");
            transXml.append("<Detail1 objContext=\"1\" objName=\"" + objName + "\" domID=\"1\" dbID=\"\" selected=\"N\" >");
            transXml.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
            while (enum1.hasMoreElements()) {
                Object e = enum1.nextElement();
                String paramName = (String)e;
                if (paramName.indexOf(".") == -1) continue;
                String paramValue = request.getParameter(paramName);
                String fieldName = paramName.substring(paramName.lastIndexOf(".") + 1);
                String currElement = "<" + fieldName + "><![CDATA[" + paramValue + "]]></" + fieldName + ">";
                transXml.append(currElement);
            }
            transXml.append("</Detail1>");
            transXml.append("</Root>");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "DataProviderActionServlet createRequestParamXml Exception::-->:" + e.getMessage());
        }
        return transXml.toString();
    }

    private String getXtraParams(UserInfoBean userInfo) throws Exception {
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfo.getEmpCode());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfo.getSiteCode());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfo.getEntityCode());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfo.getProfileId());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("userType=" + userInfo.getUserType());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("runMode=I");
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfo.getUserLanguage());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfo.getUserCountry());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfo.getCharEnc());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("termId=" + userInfo.getRemoteHost());
        String chgTerm = userInfo.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = userInfo.getRemoteHost();
        }
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("currentGeoPos=" + userInfo.getCurrentGeoPOS());
        BaseLogger.log("3", userInfo, null, "[DataProviderActionServlet]XTRA_PARAMS currentGeoPos :" + userInfo.getCurrentGeoPOS());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("currentGeoPosName=" + userInfo.getCurrentGeoPOSName());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("geoPosAccuracy=" + userInfo.getGeoPosAccuracy());
        xtraParamsBuff.append(this.XTRA_PARAMS_SEPARATOR).append("transDB=" + userInfo.getTransDB());
        BaseLogger.log("3", userInfo, null, "xtraParamsBuff [" + xtraParamsBuff + "]");
        return xtraParamsBuff.toString();
    }

    private String getXSL(String objName) throws ITMException {
        String xslFileContents = "";
        try {
            File xslFile;
            String fileName = String.valueOf(objName) + "_iw.xsl";
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            if (!new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + "map").exists()) {
                new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + "map").mkdir();
            }
            if ((xslFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + "map", fileName)).exists()) {
                StringBuffer fileContent = new StringBuffer("");
                BufferedReader bf = new BufferedReader(new FileReader(xslFile));
                String outTempStr = null;
                while ((outTempStr = bf.readLine()) != null) {
                    if (outTempStr == null || outTempStr.trim().length() <= 0) continue;
                    fileContent.append(outTempStr);
                    outTempStr = null;
                }
                if (bf != null) {
                    bf.close();
                }
                xslFileContents = fileContent.toString();
            } else {
                BaseLogger.log("3", null, null, "Default file not found @ " + xslFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            xslFileContents = "";
            throw new ITMException(e);
        }
        return xslFileContents;
    }

    private boolean isError(String returnString) throws ITMException {
        boolean isError = false;
        if (E12GenericUtility.checkNull(returnString).length() > 0 && returnString.indexOf("<Errors>") != -1) {
            isError = returnString.indexOf("<Errors></Errors>") == -1 && this.isErrorNodeFound(returnString);
        }
        BaseLogger.log("2", null, null, String.valueOf(isError) + " checkError :: returnStr " + returnString);
        return isError;
    }

    private boolean isErrorNodeFound(String errXmlString) throws ITMException {
        boolean isErrorNodeFound;
        block4: {
            isErrorNodeFound = false;
            try {
                if (errXmlString.indexOf("<Errors>") == -1) break block4;
                NodeList errorNodeList = new E12GenericUtility().parseString(errXmlString).getElementsByTagName("error");
                int errorNodeListLen = errorNodeList.getLength();
                int i = 0;
                while (i < errorNodeListLen) {
                    String errorType = errorNodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                    BaseLogger.log("3", null, null, "errorType :[" + errorType + "]");
                    if ("E".equals(errorType) || "W".equals(errorType) || "P".equals(errorType) || "F".equals(errorType) || "X".equals(errorType)) {
                        isErrorNodeFound = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return isErrorNodeFound;
    }
}

