/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.servlet;

import ibase.scheduler.bean.SchedulerExecutionDetailBean;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SchedulerExecutionDetailServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatcher = request.getRequestDispatcher("/scheduler/jsp/SchedulerExecutionDetail.jsp");
        try {
            Connection conn = new ConnDriver().getConnectDB("Driver");
            List schedulerNameList = this.getSchedulerNames(conn);
            request.setAttribute("schedulerNameList", (Object)schedulerNameList);
            if (request.getParameter("schedulerName") != null) {
                String schedulerName = request.getParameter("schedulerName");
                List schedulerlist = this.getScheduler(conn, schedulerName);
                request.setAttribute("schedulerlist", (Object)schedulerlist);
                String count = this.getSchedulerCount(conn, schedulerName);
                request.setAttribute("count", (Object)count);
                List schedulerDetailsList = this.getSchedulerDetails(conn, schedulerName);
                request.setAttribute("schedulerDetailsList", (Object)schedulerDetailsList);
            }
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SchedulerServlet : doPost() Threw sqlException@@@@@@@@@@@@" + e);
            e.printStackTrace();
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "SchedulerServlet :doPost() threw an Exception>>>>>>>>>>>>" + ex);
            ex.printStackTrace();
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List getSchedulerNames(Connection conn) throws Exception {
        ArrayList<String> schedulerNames = new ArrayList<String>();
        try {
            String schedulerNameSQL = "SELECT  DISTINCT (shedlog.SCH_NAME) FROM SCHEDULE_LOG shedlog INNER JOIN SCHEDULES shed ON shedlog.SCH_ID = shed.SCHEDULE_ID WHERE shedlog.START_DATE >= ADD_MONTHS(SYSDATE,-1)";
            PreparedStatement pstmt = conn.prepareStatement(schedulerNameSQL);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String result = rs.getString(1);
                schedulerNames.add(result);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerNames() threw a sqlException@@@@@@@@@@@@" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerNames() threw an Exception>>>>>>>>>>>>" + ex);
            ex.printStackTrace();
        }
        return schedulerNames;
    }

    public String getSchedulerCount(Connection conn, String schedulerName) throws SQLException, ITMException {
        String count = null;
        try {
            String schedularcountSQL = "SELECT COUNT(SCH_NAME) FROM SCHEDULE_LOG WHERE SCH_NAME = ? AND START_DATE >= ADD_MONTHS(SYSDATE,-1)";
            PreparedStatement prstmt = conn.prepareStatement(schedularcountSQL);
            prstmt.setString(1, schedulerName);
            ResultSet res = prstmt.executeQuery();
            while (res.next()) {
                int cnt = res.getInt(1);
                if (cnt <= 0) continue;
                count = Integer.toString(cnt);
            }
            if (res != null) {
                res.close();
                res = null;
            }
            if (prstmt != null) {
                prstmt.close();
                prstmt = null;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerCount() threw a sqlException@@@@@@@@@@@@" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerCount() threw an Exception>>>>>" + ex);
            ex.printStackTrace();
        }
        return count;
    }

    private List getScheduler(Connection conn, String schedulerName) throws Exception {
        ArrayList<SchedulerExecutionDetailBean> schedulerlist = new ArrayList<SchedulerExecutionDetailBean>();
        SchedulerExecutionDetailBean scheduler = null;
        try {
            E12GenericUtility genUtility = new E12GenericUtility();
            SimpleDateFormat sdformat = new SimpleDateFormat(genUtility.getApplDateTimeFormat());
            String schedularcountSQL = "SELECT shed.SCHEDULE_ID,shedlog.SCH_NAME, shed.SCHEDULE_TYPE,shed.REP_FREQ, shed.NEXT_DUE_DATE FROM SCHEDULE_LOG shedlog INNER JOIN SCHEDULES shed  ON shedlog.SCH_ID = shed.SCHEDULE_ID WHERE shedlog.SCH_NAME = ? AND shedlog.START_DATE >= ADD_MONTHS(SYSDATE,-1) ORDER BY shed.NEXT_DUE_DATE DESC";
            PreparedStatement pPrstmt = conn.prepareStatement(schedularcountSQL);
            pPrstmt.setString(1, schedulerName);
            ResultSet resultset = pPrstmt.executeQuery();
            if (resultset.next()) {
                scheduler = new SchedulerExecutionDetailBean();
                scheduler.setScheduleID(resultset.getString(1));
                scheduler.setSchedulerName(resultset.getString(2));
                String type = resultset.getString(3);
                if (type == null || type.equalsIgnoreCase("S")) {
                    scheduler.setSchType(type == null ? "" : "Start");
                } else if (type == null || type.equalsIgnoreCase("C")) {
                    scheduler.setSchType(type == null ? "" : "Canceled");
                }
                String refFrec = resultset.getString(4);
                if (refFrec == null || refFrec.equalsIgnoreCase("D")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "Daily");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("M")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "Monthly");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("W")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "Weekly");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("L")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "Last Day Of the Month");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("S")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "First Day Of Month");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("F")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "FortNight");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("H")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "Hourly");
                } else if (refFrec == null || refFrec.equalsIgnoreCase("O")) {
                    scheduler.setRepfrec(refFrec == null ? "" : "On Day of the Month");
                } else {
                    scheduler.setRepfrec(refFrec);
                }
                scheduler.setNextDueDate(resultset.getTimestamp(5) == null ? "" : sdformat.format(resultset.getTimestamp(5)));
                schedulerlist.add(scheduler);
            }
            if (resultset != null) {
                resultset.close();
                resultset = null;
            }
            if (pPrstmt != null) {
                pPrstmt.close();
                pPrstmt = null;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getScheduler() threw a sqlException@@@@@@@@@@@@" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getScheduler() threw an Exception>>>>>>> " + ex);
            ex.printStackTrace();
        }
        return schedulerlist;
    }

    private List getSchedulerDetails(Connection conn, String schedulerName) throws Exception {
        ArrayList<SchedulerExecutionDetailBean> schedulerDetailsList = new ArrayList<SchedulerExecutionDetailBean>();
        SchedulerExecutionDetailBean scheduler = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
            String schedulerNameSQL = "SELECT  TRAN_ID, SCH_TYPE, START_DATE, END_DATE, END_RESULT, ERR_INFO, EXEC_USER, EXEC_TERM   FROM SCHEDULE_LOG  WHERE SCH_NAME = ? AND START_DATE >= ADD_MONTHS(SYSDATE,-1) ORDER BY START_DATE DESC";
            PreparedStatement pstmt = conn.prepareStatement(schedulerNameSQL);
            pstmt.setString(1, schedulerName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                scheduler = new SchedulerExecutionDetailBean();
                scheduler.setTranId(rs.getString(1));
                scheduler.setSchType(rs.getString(2));
                scheduler.setStartDate(rs.getTimestamp(3) == null ? "" : sdf.format(rs.getTimestamp(3)));
                scheduler.setEndDate(rs.getTimestamp(4) == null ? "" : sdf.format(rs.getTimestamp(4)));
                scheduler.setEndResult(rs.getString(5));
                scheduler.setErrInfo(rs.getString(6));
                scheduler.setExecUser(rs.getString(7));
                scheduler.setExecTerm(rs.getString(8));
                schedulerDetailsList.add(scheduler);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerDetails() threw a sqlException@@@@@@@@@@@@" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "SchedulerServlet :getSchedulerDetails() threw an Exception  >>>>>" + ex);
            ex.printStackTrace();
        }
        return schedulerDetailsList;
    }
}

