/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.communication.Communication;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.utility.ITMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E12TelegramComp {
    private UserInfoBean userInfo;
    String XMLString;
    String message;
    Communication communication;

    public String sendTelegram() {
        return "";
    }

    public String sendTelegram(String subject, String message, UserInfoBean userInfo) {
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.message = message;
            this.communication = new Communication();
            this.XMLString = this.buildXMLString(this.userInfo, subject, message, "");
            resultStr = this.communication.communicate("Telegram", this.XMLString, "", userInfo, "");
            BaseLogger.log("3", userInfo, null, "ResultStr=[" + resultStr + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in sendTelegramMessage " + e.getMessage());
        }
        return resultStr;
    }

    public String sendTelegram(String filePath, UserInfoBean userInfo, boolean sendFile) {
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.XMLString = this.buildXMLString(this.userInfo, "", "", filePath);
            this.communication = new Communication();
            resultStr = this.communication.communicate("Telegram", this.XMLString, "", userInfo, "");
            BaseLogger.log("3", userInfo, null, "ResultStr=[" + resultStr + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in sendTelegramMessage " + e.getMessage());
        }
        return resultStr;
    }

    public String sendTelegram(String XMLString, UserInfoBean userInfo) {
        BaseLogger.log("3", userInfo, null, "E12TelegramComp XMLString=[" + XMLString + "]");
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.communication = new Communication();
            resultStr = this.communication.communicate("Telegram", XMLString, "", userInfo, "");
            BaseLogger.log("3", userInfo, null, "ResultStr=[" + resultStr + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in sendTelegramMessage " + e.getMessage());
        }
        return resultStr;
    }

    private String buildXMLString(UserInfoBean userInfo, String subject, String message, String filePath) {
        StringBuilder XMLString = new StringBuilder("<Root>");
        E12GenericUtility utility = new E12GenericUtility();
        String tblName = "USER_ACC_CHANNEL";
        String tokenId = "";
        String chatId = "";
        String file = E12GenericUtility.checkNull(filePath);
        String transDB = userInfo.getTransDB();
        transDB = "APPVIS";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            chatId = dbAccess.getDBColumnValue(tblName, "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            BaseLogger.log("3", userInfo, null, "sendTelegramMessage tokenId=[" + tokenId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Chat Id=[" + chatId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Message =[" + message + "]");
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            if (!E12GenericUtility.checkNull(filePath).equals("")) {
                BaseLogger.log("3", userInfo, null, "Sendin file to telegram");
                XMLString.append("<ATTACH_TEXT><![CDATA[" + file + "]]></ATTACH_TEXT>");
                XMLString.append("<BODY_TEXT><![CDATA[Please download]]></BODY_TEXT>");
                XMLString.append("<SUBJECT><![CDATA[Report File]]></SUBJECT>");
            } else {
                XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull(message) + "]]></BODY_TEXT>");
                XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull(subject) + "]]></SUBJECT>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in generateXMLStringForTelegram " + e.getMessage());
        }
        XMLString.append("</Root>");
        BaseLogger.log("3", userInfo, null, "XMLString from generateXMLStringForTelegram ==>" + XMLString.toString());
        return XMLString.toString();
    }

    public String buildXMLString(UserInfoBean userInfo, String transDom, String formatCode) {
        BaseLogger.log("3", userInfo, null, "in E12TelegramCom buildXMLString");
        StringBuilder XMLString = new StringBuilder("<Root>");
        E12GenericUtility utility = new E12GenericUtility();
        String tblName = "USER_ACC_CHANNEL";
        String tokenId = "";
        String chatId = "";
        String message = "";
        String subject = "";
        String attachText = "";
        Document currentDom = null;
        String transDB = userInfo.getTransDB();
        transDB = "APPVIS";
        try {
            currentDom = utility.parseString(transDom);
            BaseLogger.log("3", userInfo, null, "sendTelegramMessage currentDom=[" + currentDom + "]");
            DBAccessEJB dbAccess = new DBAccessEJB();
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            chatId = dbAccess.getDBColumnValue(tblName, "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            message = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "BODY_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            message = this.getFormatedMessageBody(message, currentDom);
            subject = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "subject", "COMM_FORMAT='" + formatCode + "'", transDB));
            attachText = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "ATTACH_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            BaseLogger.log("3", userInfo, null, "sendTelegramMessage tokenId=[" + tokenId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Chat Id=[" + chatId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Message =[" + message + "]");
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull(message) + "]]></BODY_TEXT>");
            XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull(subject) + "]]></SUBJECT>");
            if (attachText != "" && !attachText.equalsIgnoreCase("x")) {
                XMLString.append("<ATTACH_TEXT><![CDATA[" + attachText + "]]></ATTACH_TEXT>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in generateXMLStringForTelegram " + e.getMessage());
        }
        XMLString.append("</Root>");
        BaseLogger.log("3", userInfo, null, "XMLString from generateXMLStringForTelegram ==>" + XMLString.toString());
        return XMLString.toString();
    }

    public String buildXMLString(String objName, UserInfoBean userInfo, String tranDataStr, String tranPKNames, String tranPKValues, String formatCode) throws ITMException {
        StringBuilder XMLString = new StringBuilder("<Root>");
        try {
            String[] pkValues = tranPKValues.split(",");
            String tranId = "";
            Document currentPkTranDom = null;
            String mailData = "<root>";
            int pkCount = 0;
            while (pkCount < pkValues.length) {
                try {
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    currentPkTranDom = E12GenericUtility.checkNull(tranDataStr).length() > 0 ? e12GenericUtility.parseString(tranDataStr) : this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                catch (Exception e) {
                    System.out.println("TransactionEmailTempltEJB.sendMail() Exception tranDataStr : [" + tranDataStr + "]");
                    currentPkTranDom = this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                ++pkCount;
            }
            BaseLogger.log("3", userInfo, null, "in E12TelegramCom currentPkTranDom=[" + currentPkTranDom + "]");
            BaseLogger.log("3", userInfo, null, "in E12TelegramCom buildXMLString");
            E12GenericUtility utility = new E12GenericUtility();
            String tblName = "USER_ACC_CHANNEL";
            String tokenId = "";
            String chatId = "";
            String message = "";
            String subject = "";
            String attachText = "";
            String transDB = userInfo.getTransDB();
            transDB = "APPVIS";
            DBAccessEJB dbAccess = new DBAccessEJB();
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            chatId = dbAccess.getDBColumnValue(tblName, "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            message = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "BODY_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            message = this.getFormatedMessageBody(message, currentPkTranDom);
            subject = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "subject", "COMM_FORMAT='" + formatCode + "'", transDB));
            attachText = E12GenericUtility.checkNull(dbAccess.getDBColumnValue("COMM_FORMAT", "ATTACH_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            BaseLogger.log("3", userInfo, null, "sendTelegramMessage tokenId=[" + tokenId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Chat Id=[" + chatId + "]");
            BaseLogger.log("3", userInfo, null, "Got Telegram Message =[" + message + "]");
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull(message) + "]]></BODY_TEXT>");
            XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull(subject) + "]]></SUBJECT>");
            if (attachText != "" && !attachText.equalsIgnoreCase("x")) {
                XMLString.append("<ATTACH_TEXT><![CDATA[" + attachText + "]]></ATTACH_TEXT>");
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        BaseLogger.log("0", userInfo, null, "BuildXMLString() XMLString=[" + XMLString + "]");
        return XMLString.toString();
    }

    private String getFormatedMessageBody(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "&lt;Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log("3", null, null, nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf("&gt;") + 4);
                    BaseLogger.log("3", null, null, "Telegram Message colFullName:" + colFullName);
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf("&gt;"));
                    BaseLogger.log("3", null, null, "telegram Message colName:" + colName);
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log("3", null, null, "bodyTextData for Telegram message=" + bodyTextData);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getFormatedMessageBody()=" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "getFormatedMessageBody bodyTextData:" + bodyTextData);
        return bodyTextData;
    }

    private Document getCurrentTranDom(String pkValues, UserInfoBean userInfo, String objName) throws ITMException {
        String tranXml = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranXml = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", pkValues, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return genericUtility.parseString(tranXml);
    }
}

