/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.ejb.session.Argument;
import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.GenaralProp;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PdfToXsl {
    private Column[] columns;
    private ArrayList groupElements;
    private ArrayList columnElements;
    private ArrayList valueElements;
    private String baName;
    private ArrayList colNames;
    private ArrayList crossTabElements;
    GenaralProp genProp;
    ArrayList totals;
    String lsHeadingChild = "";
    String xslColumnText = "";
    String xslGroupText = "";
    int crossTabColSpan = 1;
    ArrayList crossTabValues = null;
    ArrayList alColumns = null;
    int noOfCrossTabCols = 0;
    int noOfGroupElements = 0;
    private ArrayList arCrossTab;
    private String xslGroupFileName = null;
    private String xslTableFileName = null;
    int scaleHtmlToPDF = 20;
    int itemCount;
    char listType;
    int columnCount;
    private HashMap whereCondition = new HashMap();
    private ArrayList argumentList;

    private void setCrossTabValues(ArrayList crossTabValues) throws Exception {
        this.crossTabValues = crossTabValues;
    }

    private ArrayList getCrossTabValues() throws Exception {
        return this.crossTabValues;
    }

    public void setWhereCondition(HashMap whereCondition) throws Exception {
        try {
            this.whereCondition = whereCondition;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setArgumentList(ArrayList argumentList) throws Exception {
        try {
            this.argumentList = argumentList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public PdfToXsl(Column[] columns, GenaralProp cProp) throws Exception {
        try {
            this.columns = columns;
            this.genProp = cProp;
            this.groupElements = new ArrayList();
            this.columnElements = new ArrayList();
            this.crossTabElements = new ArrayList();
            this.valueElements = new ArrayList();
            this.setFileNames();
            int ctr = 0;
            while (ctr < columns.length) {
                if (columns[ctr].getPlacement() == 1) {
                    this.groupElements.add(columns[ctr]);
                } else if (columns[ctr].getPlacement() == 2) {
                    this.columnElements.add(columns[ctr]);
                } else if (columns[ctr].getPlacement() == 3) {
                    this.crossTabElements.add(columns[ctr]);
                } else if (columns[ctr].getPlacement() == 4) {
                    this.valueElements.add(columns[ctr]);
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private ArrayList getCrossTabsValues(Document doc) throws Exception {
        ArrayList main = new ArrayList();
        this.arCrossTab = null;
        int ctCount = 0;
        while (ctCount < this.noOfCrossTabCols) {
            main.add(new ArrayList());
            ++ctCount;
        }
        NodeList colDefNodeList = doc.getElementsByTagName("coldef");
        int i = 0;
        while (i < colDefNodeList.getLength()) {
            Node colNodes = colDefNodeList.item(i);
            NodeList colNodeList = colNodes.getChildNodes();
            int j = 0;
            while (j < colNodeList.getLength()) {
                Node cols = colNodeList.item(j);
                NodeList colsChildList = cols.getChildNodes();
                int k = 0;
                while (k < colsChildList.getLength()) {
                    if (colsChildList.item(k).getNodeName().equalsIgnoreCase("heading")) {
                        String heading = colsChildList.item(k).getFirstChild().getNodeValue();
                        String crValue = "";
                        boolean addCT = false;
                        int colonCount = 0;
                        while (heading.indexOf("~") != -1) {
                            crValue = heading.substring(0, heading.indexOf("~"));
                            heading = heading.substring(heading.indexOf("~") + 1);
                            this.arCrossTab = (ArrayList)main.get(colonCount);
                            this.arCrossTab.add(crValue);
                            ++colonCount;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return main;
    }

    private ArrayList getColumns(Document doc) throws Exception {
        HashSet<String> hs = new HashSet<String>();
        ArrayList<Column> alColTemp = new ArrayList<Column>();
        boolean addColumn = false;
        NodeList colDefNodeList = doc.getElementsByTagName("coldef");
        int i = 0;
        while (i < colDefNodeList.getLength()) {
            Node colNodes = colDefNodeList.item(i);
            NodeList colNodeList = colNodes.getChildNodes();
            int j = 0;
            while (j < colNodeList.getLength()) {
                Node cols = colNodeList.item(j);
                NodeList colsChildList = cols.getChildNodes();
                Column col = new Column();
                int k = 0;
                while (k < colsChildList.getLength()) {
                    addColumn = false;
                    if (colsChildList.item(k).getNodeName().equalsIgnoreCase("heading")) {
                        String heading = colsChildList.item(k).getFirstChild().getNodeValue();
                        if ((heading = heading.replace('|', ' ')).indexOf("~") != -1) {
                            String crossTabValue = heading.substring(0, heading.indexOf("~"));
                            hs.add(crossTabValue);
                            heading = heading.substring(heading.lastIndexOf("~") + 1);
                        }
                        col.setDisplayName(heading);
                    }
                    if (colsChildList.item(k).getNodeName().equalsIgnoreCase("placement")) {
                        addColumn = true;
                        String placement = colsChildList.item(k).getFirstChild().getNodeValue().trim();
                        col.setPlacement(Integer.parseInt(placement));
                    }
                    if (colsChildList.item(k).getNodeName().equalsIgnoreCase("width")) {
                        String width = colsChildList.item(k).getFirstChild().getNodeValue().trim();
                        col.setWidth(width);
                    }
                    if (addColumn) {
                        alColTemp.add(col);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (!hs.isEmpty()) {
            ArrayList temp = new ArrayList(hs);
            this.setCrossTabValues(temp);
        }
        return alColTemp;
    }

    private ArrayList getCrossTabs(Document doc) throws Exception {
        ArrayList<String> alCrossTabs = new ArrayList<String>();
        boolean addColumn = false;
        NodeList crossTabsNodeList = doc.getElementsByTagName("crossTabTitles");
        String crossTab = crossTabsNodeList.item(0).getFirstChild().getNodeValue();
        while (crossTab.length() > 0) {
            if (crossTab.indexOf(",") != -1) {
                alCrossTabs.add(crossTab.substring(0, crossTab.indexOf(",")));
                crossTab = crossTab.substring(crossTab.indexOf(",") + 1);
                continue;
            }
            alCrossTabs.add(crossTab);
            crossTab = "";
        }
        return alCrossTabs;
    }

    public void setTableParseDom(String saxTransString) throws Exception {
        ArrayList crossTabs = new ArrayList();
        ArrayList crossTabValues = new ArrayList();
        this.alColumns = new ArrayList();
        int noOfFixedCols = 0;
        int noOfValueCols = 0;
        String grpValue = "";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(saxTransString);
            NodeList nlFixedColumns = doc.getElementsByTagName("NO_OF_FIXED_COLUMNS");
            String fixedColumnsString = nlFixedColumns.item(0).getFirstChild().getNodeValue().trim();
            noOfFixedCols = Integer.parseInt(fixedColumnsString);
            NodeList nlCrossTabColumns = doc.getElementsByTagName("NO_OF_CROSSTAB_COLUMNS");
            String CrossTabColumnsString = nlCrossTabColumns.item(0).getFirstChild().getNodeValue().trim();
            this.noOfCrossTabCols = Integer.parseInt(CrossTabColumnsString);
            NodeList nlValueColumns = doc.getElementsByTagName("NO_OF_VALUE_COLUMNS");
            String ValueColumnsString = nlValueColumns.item(0).getFirstChild().getNodeValue().trim();
            noOfValueCols = Integer.parseInt(ValueColumnsString);
            this.alColumns = this.getColumns(doc);
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:for-each select=\"//rows/coldef/column\">";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:variable name=\"columnwidth\"><xsl:value-of select=\"width\"/></xsl:variable>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:variable name=\"columnnumber\"><xsl:value-of select=\"position()\"/></xsl:variable>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:variable name=\"bkcolor\">\t<xsl:value-of select=\"bgcolor\"/></xsl:variable>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:variable name=\"bgcolor\">";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:choose>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:when test=\"$bkcolor = ''\"><xsl:value-of select=\"'#ffffff'\"/></xsl:when>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:when test=\"$bkcolor = '0'\"><xsl:value-of select=\"'#ffffff'\"/></xsl:when>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<xsl:otherwise><xsl:value-of select=\"$bkcolor\"/></xsl:otherwise>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</xsl:choose>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</xsl:variable>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-column column-number=\"{$columnnumber}\" column-width=\"{$columnwidth}pt\" background-color=\"{$ bgcolor}\" />";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</xsl:for-each>";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-header background-color='darkblue' color='white' height='40mm'>\n";
            if (this.noOfCrossTabCols > 0) {
                ArrayList ctValues = this.getCrossTabsValues(doc);
                ArrayList crosstab = this.getCrossTabs(doc);
                boolean prevColSpan = true;
                BaseLogger.log("3", null, null, "a");
                int i = 0;
                while (i < crosstab.size()) {
                    BaseLogger.log("3", null, null, "b");
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-row>\n";
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + noOfFixedCols + "\">\n";
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:block text-align='center' font-size='15pt' line-height='25pt'>\n";
                    this.xslColumnText = String.valueOf(this.xslColumnText) + (String)crosstab.get(i) + "\n";
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:block>\n";
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-cell>\n";
                    ArrayList ct = (ArrayList)ctValues.get(i);
                    ArrayList ctArray = (ArrayList)ctValues.get(i);
                    HashMap hmVal = new HashMap();
                    HashMap hmCnt = new HashMap();
                    ArrayList<Integer> ctCount = new ArrayList<Integer>();
                    String ctTemp = "";
                    String ctNew = "";
                    int count = 0;
                    int j = 0;
                    while (j < ct.size()) {
                        ctNew = (String)ct.get(j);
                        count = !ctTemp.equalsIgnoreCase(ctNew) ? 1 : ++count;
                        ctTemp = (String)ct.get(j);
                        ctCount.add(new Integer(count));
                        ++j;
                    }
                    int k = 0;
                    while (k < ctArray.size()) {
                        ctNew = (String)ctArray.get(k);
                        if (ctTemp.equalsIgnoreCase(ctNew) && k > 0) {
                            ct.remove(k - 1);
                            ctCount.remove(k - 1);
                            --k;
                        }
                        ctTemp = (String)ctArray.get(k);
                        ++k;
                    }
                    k = 0;
                    while (k < ct.size()) {
                        String kStr = Integer.toString(k);
                        hmVal.put(kStr, ct.get(k));
                        hmCnt.put(kStr, ctCount.get(k));
                        ++k;
                    }
                    int m = 0;
                    while (m < ct.size()) {
                        String mStr = Integer.toString(m);
                        int colSpan = (Integer)hmCnt.get(mStr);
                        String hmValues = (String)hmVal.get(mStr);
                        this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + colSpan + "\"><fo:block text-align='center'  font-size='15pt' line-height='25pt'>\n";
                        this.xslColumnText = String.valueOf(this.xslColumnText) + hmValues + "\n";
                        this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:block></fo:table-cell>\n";
                        ++m;
                    }
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-row>\n";
                    ++i;
                }
            }
            if (doc.getElementsByTagName("COLHEADING") != null) {
                ArrayList commonColumnList = this.getCommonColumnList(doc);
                BaseLogger.log("3", null, null, "\n\n\nuserHeading" + commonColumnList);
                if (commonColumnList != null && commonColumnList.size() > 0) {
                    boolean flag = true;
                    int colIndex = 0;
                    int colSpan = 0;
                    String colData = "";
                    int tempCount = 0;
                    int commonColumnListSize = commonColumnList.size();
                    StringBuffer commonColBuffer = new StringBuffer();
                    ArrayList tempCommonColumnList = null;
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-row>\n";
                    int i = 0;
                    while (i < commonColumnListSize) {
                        tempCommonColumnList = (ArrayList)commonColumnList.get(i);
                        colIndex = Integer.parseInt((String)tempCommonColumnList.get(0));
                        colSpan = Integer.parseInt((String)tempCommonColumnList.get(1));
                        colData = (String)tempCommonColumnList.get(2);
                        if (flag) {
                            if (colIndex != 0) {
                                this.xslColumnText = this.columnCount == noOfFixedCols || this.columnCount == 0 ? String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + colIndex + "\"></fo:table-cell>\n" : String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + noOfFixedCols + "\"></fo:table-cell>\n";
                            }
                            if (colIndex > noOfFixedCols) {
                                this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + (colIndex - noOfFixedCols) + "\"></fo:table-cell>\n";
                            }
                            flag = false;
                        } else if (colIndex - tempCount > 0) {
                            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + (colIndex - tempCount) + "\"></fo:table-cell>\n";
                        }
                        this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + colSpan + "\"><fo:block text-align='center'  font-size='15pt' line-height='25pt'>\n";
                        this.xslColumnText = String.valueOf(this.xslColumnText) + colData + "\n";
                        this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:block></fo:table-cell>\n";
                        tempCount = colIndex + colSpan;
                        ++i;
                    }
                    tempCommonColumnList = null;
                    commonColumnList = null;
                    if (this.columnCount - tempCount > 0) {
                        this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell display-align='center' border-width='0.1mm' border-color='#c0c0c0' border-style='solid' number-columns-spanned=\"" + (this.columnCount - tempCount) + "\"></fo:table-cell>\n";
                    }
                    this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-row>\n";
                }
            }
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-row>\n";
            int i = 0;
            while (i < this.alColumns.size()) {
                this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-cell border-width='0.1mm' border-color='#c0c0c0' border-style='solid' display-align='center' height='0.5cm'><fo:block text-align='center' font-size='15pt' line-height='25pt'>\n";
                String name = ((Column)this.alColumns.get(i)).getDisplayName();
                this.xslColumnText = String.valueOf(this.xslColumnText) + name + "\n";
                this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:block></fo:table-cell>\n";
                ++i;
            }
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-row>\n";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-header>\n";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-footer background-color='#7EBEBE' height='20mm' color='white'>\n";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "<fo:table-row height='7mm'>\n";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-row>\n";
            this.xslColumnText = String.valueOf(this.xslColumnText) + "</fo:table-footer>\n";
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String getHTMLFormat() throws Exception {
        StringBuffer foTextToBeAdded = new StringBuffer();
        StringBuffer initialCondition = new StringBuffer();
        String conditionForQry = "";
        int defaultWidth = 1080;
        int totalWidth = 0;
        String titleStr = "";
        foTextToBeAdded.append("<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0' xmlns:js='javascript:code'>\n");
        if (this.genProp.getSelectedGroup().equalsIgnoreCase("A")) {
            foTextToBeAdded.append("<xsl:template match='AllRows'>\n");
        } else {
            foTextToBeAdded.append("<xsl:template match='rows'>\n");
        }
        foTextToBeAdded.append("<fo:root xmlns:fo='http://www.w3.org/1999/XSL/Format'>\n");
        foTextToBeAdded.append("<!-- defines the layout master -->\n");
        foTextToBeAdded.append("<fo:layout-master-set>\n");
        foTextToBeAdded.append("<fo:simple-page-master master-name='first'\n");
        foTextToBeAdded.append("page-height='" + (this.genProp.getPageHeight() > 0.0f ? this.genProp.getPageHeight() : 29.0f) + "in'\n");
        int i = 0;
        while (i < this.alColumns.size()) {
            int width = Integer.parseInt(((Column)this.alColumns.get(i)).getWidth());
            BaseLogger.log("3", null, null, String.valueOf(i) + "column :" + width);
            totalWidth += width;
            ++i;
        }
        if ((totalWidth += 30) > defaultWidth) {
            defaultWidth = totalWidth;
        }
        if (this.genProp.getPageWidth() > 0.0f) {
            foTextToBeAdded.append("page-width='" + this.genProp.getPageWidth() + "in'\n");
        } else {
            foTextToBeAdded.append("page-width='" + defaultWidth + "pt'\n");
        }
        foTextToBeAdded.append("margin-top='" + this.genProp.getMarginTop() + "in'\n");
        foTextToBeAdded.append("margin-bottom='" + this.genProp.getMarginBottom() + "in'\n");
        foTextToBeAdded.append("margin-left='" + this.genProp.getMarginLeft() + "in'\n");
        foTextToBeAdded.append("margin-right='" + this.genProp.getMarginRight() + "in'>\n");
        foTextToBeAdded.append("<fo:region-body />\n");
        foTextToBeAdded.append("</fo:simple-page-master>\n");
        foTextToBeAdded.append("</fo:layout-master-set>\n");
        foTextToBeAdded.append("<!-- Start a page layout -->\n");
        foTextToBeAdded.append("<fo:page-sequence master-reference='first'>\n");
        foTextToBeAdded.append("<fo:flow flow-name='xsl-region-body'>\n");
        foTextToBeAdded.append("<!-- this defines a title level 1-->\n");
        titleStr = String.valueOf(titleStr) + "<html>";
        String tempTitle = this.genProp.getTitle();
        if (this.whereCondition != null) {
            Iterator itr = this.whereCondition.keySet().iterator();
            int size = this.whereCondition.size();
            String[] condiNameArray = new String[size];
            String[] condiValueArray = new String[size];
            int j = 0;
            String imagePath = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/FCKEditor/editor/dialog/images/button.about.gif";
            String rOpervalue = null;
            while (itr.hasNext()) {
                String label = (String)itr.next();
                String labelValue = (String)this.whereCondition.get(label);
                if (labelValue.indexOf("&&") != -1) {
                    StringTokenizer labelValueTokens = new StringTokenizer(labelValue = labelValue.substring(labelValue.indexOf("&&"), labelValue.lastIndexOf("&&") + 2), "&&");
                    rOpervalue = labelValueTokens.nextToken();
                    if (rOpervalue.indexOf(".") != -1) {
                        rOpervalue = rOpervalue.substring(0, rOpervalue.indexOf("."));
                    }
                    ArrayList argValueList = null;
                    String argValue = null;
                    int i2 = 0;
                    while (i2 < this.argumentList.size()) {
                        Argument argObj = (Argument)this.argumentList.get(i2);
                        if (argObj.getArgOrder().equals(rOpervalue)) {
                            argValueList = argObj.getArgValue();
                            StringBuffer argValueBuff = new StringBuffer();
                            int argValueCount = 0;
                            while (argValueCount < argValueList.size()) {
                                String tempArgValue = (String)argValueList.get(argValueCount);
                                argValueBuff.append(String.valueOf(tempArgValue) + ",");
                                ++argValueCount;
                            }
                            labelValue = argValue = argValueBuff.deleteCharAt(argValueBuff.length() - 1).toString();
                            if (labelValueTokens.countTokens() <= 1) break;
                            Argument argObjAnd = (Argument)this.argumentList.get(i2 + 1);
                            argValueList = argObjAnd.getArgValue();
                            argValueBuff = new StringBuffer();
                            int argValueCount2 = 0;
                            while (argValueCount2 < argValueList.size()) {
                                String tempArgValue = (String)argValueList.get(argValueCount2);
                                argValueBuff.append(String.valueOf(tempArgValue) + ",");
                                ++argValueCount2;
                            }
                            argValue = argValueBuff.deleteCharAt(argValueBuff.length() - 1).toString();
                            labelValue = String.valueOf(labelValue) + " And " + argValue;
                            break;
                        }
                        ++i2;
                    }
                }
                condiNameArray[j] = "~<img alt=\"" + label + "\" src=\"" + imagePath + "\"/>~";
                if (labelValue.equals("%")) {
                    labelValue = "All";
                }
                condiValueArray[j] = labelValue;
                ++j;
            }
            int k = 0;
            while (k < condiNameArray.length) {
                String bufferTitle = "";
                int index = tempTitle.indexOf(condiNameArray[k]);
                if (index != -1) {
                    String subStr = tempTitle.substring(index + condiNameArray[k].length(), tempTitle.length());
                    int tildIndex = subStr.indexOf("~~");
                    bufferTitle = String.valueOf(tempTitle.substring(0, index)) + condiValueArray[k] + tempTitle.substring(index + (tildIndex + 2) + condiNameArray[k].length());
                    tempTitle = new String(bufferTitle);
                }
                ++k;
            }
        }
        titleStr = String.valueOf(titleStr) + tempTitle;
        titleStr = String.valueOf(titleStr) + "</html>";
        StringBuffer tempStrBuf = new StringBuffer(titleStr);
        int index = 0;
        while ((index = tempStrBuf.toString().indexOf("&nbsp;")) != -1) {
            tempStrBuf.replace(index, index + 6, " ");
        }
        titleStr = tempStrBuf.toString();
        titleStr = this.getHtmlToFo(titleStr);
        foTextToBeAdded.append(titleStr);
        return foTextToBeAdded.toString();
    }

    private String getFoForGroups(String fileName) throws Exception {
        String foStr = "";
        File fName = new File(fileName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(fName);
        NodeList groupsList = dom.getElementsByTagName("group");
        foStr = "<fo:block>";
        int i = 0;
        while (i < groupsList.getLength()) {
            Node groupNode = groupsList.item(i);
            NamedNodeMap groupAtrib = groupNode.getAttributes();
            int j = 0;
            while (j < groupAtrib.getLength()) {
                Node groupAtribNode = groupAtrib.item(j);
                if (groupAtribNode.getNodeName().equalsIgnoreCase("disName")) {
                    foStr = String.valueOf(foStr) + "<fo:inline font-weight='bold' font-size='15pt'>" + groupAtribNode.getNodeValue() + " : </fo:inline>";
                    break;
                }
                ++j;
            }
            boolean valueFound = false;
            NodeList groupList = groupNode.getChildNodes();
            int j2 = 0;
            while (j2 < groupList.getLength()) {
                Node valueNode = groupList.item(j2);
                if (valueNode.getNodeName().equalsIgnoreCase("value")) {
                    NamedNodeMap valueAtrib = valueNode.getAttributes();
                    int k = 0;
                    while (k < valueAtrib.getLength()) {
                        Node valueAtribNode = valueAtrib.item(k);
                        if (valueAtribNode.getNodeName().equalsIgnoreCase("selected") && valueAtribNode.getNodeValue().equalsIgnoreCase("1")) {
                            foStr = String.valueOf(foStr) + "<fo:inline font-size='15pt'>" + valueNode.getFirstChild().getNodeValue() + " </fo:inline>";
                            valueFound = true;
                            break;
                        }
                        ++k;
                    }
                    if (valueFound) break;
                }
                ++j2;
            }
            if (!valueFound) {
                foStr = String.valueOf(foStr) + "<fo:inline font-size='15pt'> All </fo:inline>";
            }
            ++i;
        }
        foStr = String.valueOf(foStr) + "</fo:block><fo:block></fo:block>";
        return foStr;
    }

    private String getFoForGroups(ArrayList grpNameList, ArrayList grpValList) throws Exception {
        String foStr = "";
        foStr = "<fo:block>";
        int i = 0;
        while (i < grpNameList.size()) {
            foStr = String.valueOf(foStr) + "<fo:inline font-weight='bold' font-size='15pt'>" + grpNameList.get(i).toString() + " : </fo:inline>";
            foStr = String.valueOf(foStr) + "<fo:inline font-size='15pt'>" + grpValList.get(i).toString() + " </fo:inline>";
            ++i;
        }
        foStr = String.valueOf(foStr) + "</fo:block>";
        return foStr;
    }

    private String getHtmlToFo(String titleStr) {
        String foStr = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = parser.parse(new ByteArrayInputStream(titleStr.getBytes()));
            foStr = "<fo:block>";
            NodeList htmlList = dom.getElementsByTagName("html");
            int i = 0;
            while (i < htmlList.getLength()) {
                NodeList tagList = htmlList.item(i).getChildNodes();
                foStr = String.valueOf(foStr) + this.parseHtmlToFo(tagList);
                ++i;
            }
            foStr = String.valueOf(foStr) + "</fo:block>";
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error: In getHTMLToFO :" + e);
            e.printStackTrace();
        }
        return foStr;
    }

    private String parseHtmlToFo(NodeList tagList) {
        String foTagStr = "";
        try {
            int i = 0;
            while (i < tagList.getLength()) {
                Node tagNode = tagList.item(i);
                if (tagNode.getNodeType() == 3) {
                    foTagStr = String.valueOf(foTagStr) + tagNode.getNodeValue();
                } else if (tagNode.getNodeType() == 1) {
                    String alignType;
                    Node tagAtribNode;
                    int j;
                    String endTag = "</fo:inline>";
                    if (tagNode.getNodeName().equalsIgnoreCase("b") || tagNode.getNodeName().equalsIgnoreCase("strong")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline font-weight='bold'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("u")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline text-decoration='underline'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("i") || tagNode.getNodeName().equalsIgnoreCase("em")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline font-style='italic'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("strike")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline text-decoration='line-through'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("h1")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline font-size='" + (this.scaleHtmlToPDF + 6) + "pt' font-weight='bold' ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("align")) {
                                alignType = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "text-align='" + alignType + "' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + ">";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("h2")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline font-size='" + (this.scaleHtmlToPDF + 5) + "pt' font-weight='bold' ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("align")) {
                                alignType = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "text-align='" + alignType + "' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + ">";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("p") || tagNode.getNodeName().equalsIgnoreCase("div")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:block line-height='40pt' ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("align")) {
                                alignType = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "text-align='" + alignType + "' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + ">";
                        endTag = "</fo:block>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("font")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            String styleVal;
                            int index;
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("size")) {
                                String size = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "font-size='" + (this.scaleHtmlToPDF + Integer.parseInt(size)) + "pt' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("color")) {
                                String color = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "color='" + color + "' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("face")) {
                                String fontFace = tagAtribNode.getNodeValue();
                                String fontFamily = null;
                                fontFamily = fontFace.equalsIgnoreCase("Times New Roman") ? "Times" : (fontFace.equalsIgnoreCase("Arial") || fontFace.equalsIgnoreCase("Verdana") ? "Helvetica" : (fontFace.equalsIgnoreCase("Courier New") ? "Courier" : fontFace));
                                foTagStr = String.valueOf(foTagStr) + "font-family='" + fontFamily + "' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("style") && (index = (styleVal = tagAtribNode.getNodeValue()).indexOf("BACKGROUND-COLOR:")) != -1) {
                                foTagStr = String.valueOf(foTagStr) + "background-color='" + styleVal.substring(index + 18) + "' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + ">";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("img")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:external-graphic top='2pt' ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("src")) {
                                String source = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "src='" + source + "' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("width")) {
                                String width = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "width='" + width + "pt' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("height")) {
                                String height = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "height='" + height + "pt' ";
                            } else if (tagAtribNode.getNodeName().equalsIgnoreCase("border")) {
                                String borderVal = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "border-bottom-color='#000000' border-bottom-style='solid' border-bottom-width='" + borderVal + "pt' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + "/>";
                        endTag = null;
                    } else if (tagNode.getNodeName().equalsIgnoreCase("sub")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline vertical-align='sub'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("sup")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:inline vertical-align='super'>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("hr")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:block><fo:leader leader-pattern='rule'/></fo:block>";
                        endTag = null;
                    } else if (tagNode.getNodeName().equalsIgnoreCase("a")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:basic-link color='blue' ";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        j = 0;
                        while (j < tagAtrib.getLength()) {
                            tagAtribNode = tagAtrib.item(j);
                            if (tagAtribNode.getNodeName().equalsIgnoreCase("href")) {
                                String ref = tagAtribNode.getNodeValue();
                                foTagStr = String.valueOf(foTagStr) + "external-destination='" + ref + "' ";
                            }
                            ++j;
                        }
                        foTagStr = String.valueOf(foTagStr) + ">";
                        endTag = "</fo:basic-link>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("ol")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:list-block provisional-distance-between-starts='0.75cm' provisional-label-separation='0.5cm' space-after='12pt' start-indent='1cm' >";
                        this.itemCount = 1;
                        this.listType = (char)111;
                        endTag = "</fo:list-block>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("ul")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:list-block provisional-distance-between-starts='0.75cm' provisional-label-separation='0.5cm' space-after='12pt' start-indent='1cm' >";
                        this.itemCount = 1;
                        this.listType = (char)117;
                        endTag = "</fo:list-block>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("li")) {
                        if (this.listType == 'o') {
                            foTagStr = String.valueOf(foTagStr) + "  <fo:list-item><fo:list-item-label end-indent='label-end()'><fo:block>" + this.itemCount++ + ". </fo:block></fo:list-item-label><fo:list-item-body start-indent='body-start()'><fo:block>";
                        } else if (this.listType == 'u') {
                            foTagStr = String.valueOf(foTagStr) + "  <fo:list-item><fo:list-item-label end-indent='label-end()'><fo:block>&#x2022;</fo:block></fo:list-item-label><fo:list-item-body start-indent='body-start()'><fo:block>";
                        }
                        endTag = "</fo:block></fo:list-item-body></fo:list-item>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("table")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:table table-layout='fixed'  border-separation='10pt'>";
                        endTag = "</fo:table>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("tbody")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:table-body";
                        foTagStr = String.valueOf(foTagStr) + ">";
                        endTag = "</fo:table-body>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("tr")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:table-row";
                        NamedNodeMap tagAtrib = tagNode.getAttributes();
                        this.columnCount = 0;
                        foTagStr = String.valueOf(foTagStr) + ">";
                        endTag = "</fo:table-row>";
                    } else if (tagNode.getNodeName().equalsIgnoreCase("td")) {
                        foTagStr = String.valueOf(foTagStr) + "<fo:table-cell border-width='0.1pt' border-style='solid' border-color='#c0c0c0' display-align='center' padding-start='2pt' padding-end='2pt'>";
                        foTagStr = String.valueOf(foTagStr) + "<fo:block line-height='20pt'>";
                        ++this.columnCount;
                        endTag = "</fo:block></fo:table-cell>";
                    }
                    if (tagNode.hasChildNodes()) {
                        foTagStr = String.valueOf(foTagStr) + this.parseHtmlToFo(tagNode.getChildNodes());
                    }
                    if (endTag != null) {
                        if (endTag.equalsIgnoreCase("</fo:table>")) {
                            int j2 = 0;
                            while (j2 < this.columnCount) {
                                foTagStr = String.valueOf(foTagStr) + "<fo:table-column column-width='100pt'/>";
                                ++j2;
                            }
                            foTagStr = String.valueOf(foTagStr) + endTag;
                        } else {
                            foTagStr = String.valueOf(foTagStr) + endTag;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: In parseHTMLToFO :" + e);
        }
        return foTagStr;
    }

    private String getEndElements(String xslCondition) throws Exception {
        StringBuffer endElementsString = new StringBuffer();
        endElementsString.append("</fo:flow>\n");
        endElementsString.append("</fo:page-sequence>\n");
        endElementsString.append("</fo:root>\n");
        endElementsString.append("</xsl:template>\n");
        endElementsString.append("</xsl:stylesheet>\n");
        return endElementsString.toString();
    }

    private String getHTMLValues(int rowsIndex) throws Exception {
        StringBuffer foText = new StringBuffer();
        StringBuffer commonContent = new StringBuffer();
        int noOfColumnElements = this.columnElements.size();
        int noOfValueElements = this.valueElements.size();
        int noOfCrossElements = 0;
        int scaleFont = 4;
        if (this.arCrossTab != null) {
            noOfCrossElements = this.arCrossTab.size();
        }
        int totElements = noOfColumnElements + noOfCrossElements;
        BaseLogger.log("3", null, null, totElements);
        foText.append("<fo:table-body>\n");
        if (this.genProp.getSelectedGroup().equalsIgnoreCase("A")) {
            foText.append("<xsl:for-each select=\"/AllRows/rows\" >");
            foText.append("<xsl:if test=\"position() = " + rowsIndex + "\">");
            foText.append("<xsl:for-each select=\"row\">");
        } else {
            foText.append("<xsl:for-each select=\"/rows/row\" >\n");
        }
        foText.append("<fo:table-row>\n");
        foText.append("<xsl:for-each select='value'>\n");
        foText.append("<xsl:variable name=\"cellposition\">");
        foText.append("<xsl:value-of select=\"position()\"/>");
        foText.append("</xsl:variable>\t");
        foText.append("<xsl:variable name=\"celldata\">     ");
        foText.append("<xsl:choose>");
        foText.append("<xsl:when test=\"./@hide='1'\"><xsl:value-of select=\"translate('','&#x22;','')\"/></xsl:when>");
        foText.append("<xsl:otherwise><xsl:value-of select=\"translate(normalize-space(.),'&#x22;', '')\"/></xsl:otherwise>");
        foText.append("</xsl:choose>");
        foText.append("</xsl:variable>");
        foText.append("<fo:table-cell border-width='0.1pt' border-style='solid' border-color='#c0c0c0' display-align='center' padding-start='2pt' padding-end='2pt'>\n");
        foText.append("<xsl:for-each select=\"//rows/coldef/column\">");
        foText.append("<xsl:if test=\"position() = normalize-space($cellposition)\">");
        foText.append("<xsl:variable name=\"columnfont1\">");
        foText.append("\t<xsl:value-of select=\"fontfamily\"/>");
        foText.append("</xsl:variable>");
        foText.append("<xsl:variable name=\"columnfont\" select=\"translate($columnfont1,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')\">");
        foText.append("</xsl:variable>");
        foText.append("<xsl:variable name=\"colfont\">");
        foText.append("<xsl:choose>");
        foText.append("<xsl:when test=\"$columnfont = 'TIMES NEW ROMAN'\"><xsl:value-of select=\"'Times'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'HELVETICA'\"><xsl:value-of select=\"'Helvetica'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'ARIAL'\"><xsl:value-of select=\"'Helvetica'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'VERDANA'\"><xsl:value-of select=\"'Helvetica'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'COURIER'\"><xsl:value-of select=\"'Courier'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'WEBDINGS'\"><xsl:value-of select=\"'sans-serif'\"/></xsl:when>");
        foText.append("<xsl:when test=\"$columnfont = 'WINGDINGS'\"><xsl:value-of select=\"'sans-serif'\"/></xsl:when>");
        foText.append("<xsl:otherwise><xsl:value-of select=\"$columnfont\"/></xsl:otherwise>");
        foText.append("</xsl:choose>");
        foText.append("</xsl:variable>");
        foText.append("<xsl:variable name=\"colfontsize\">");
        foText.append("\t<xsl:value-of select=\"fontsize\"/>");
        foText.append("</xsl:variable>");
        commonContent.append("<xsl:variable name=\"underline\">\t<xsl:value-of select=\"underline\"/></xsl:variable>");
        commonContent.append("<xsl:variable name=\"undlvalue\">");
        commonContent.append("<xsl:choose>");
        commonContent.append("<xsl:when test=\"$underline = 0\"><xsl:value-of select=\"'none'\"/></xsl:when>");
        commonContent.append("<xsl:otherwise><xsl:value-of select=\"'underline'\"/></xsl:otherwise>");
        commonContent.append("</xsl:choose>");
        commonContent.append("</xsl:variable>");
        commonContent.append("<xsl:variable name=\"italics\">\t<xsl:value-of select=\"italic\"/></xsl:variable>");
        commonContent.append("<xsl:variable name=\"italicvalue\">");
        commonContent.append("<xsl:choose>");
        commonContent.append("<xsl:when test=\"$italics = 0\"><xsl:value-of select=\"'normal'\"/></xsl:when>");
        commonContent.append("<xsl:otherwise><xsl:value-of select=\"'italic'\"/></xsl:otherwise>");
        commonContent.append("</xsl:choose>");
        commonContent.append("</xsl:variable>");
        commonContent.append("<xsl:variable name=\"aligns\">\t<xsl:value-of select=\"align\"/></xsl:variable>");
        commonContent.append("<xsl:variable name=\"alignvalue\">");
        commonContent.append("<xsl:choose>");
        commonContent.append("<xsl:when test=\"$aligns = 1\"><xsl:value-of select=\"'left'\"/></xsl:when>");
        commonContent.append("<xsl:when test=\"$aligns = 2\"><xsl:value-of select=\"'right'\"/></xsl:when>");
        commonContent.append("<xsl:when test=\"$aligns = 3\"><xsl:value-of select=\"'center'\"/></xsl:when>");
        commonContent.append("<xsl:otherwise><xsl:value-of select=\"'justify'\"/></xsl:otherwise>");
        commonContent.append("</xsl:choose>");
        commonContent.append("</xsl:variable>");
        commonContent.append("<xsl:variable name=\"bold\">\t<xsl:value-of select=\"bold\"/></xsl:variable>");
        commonContent.append("<xsl:variable name=\"boldvalue\">");
        commonContent.append("<xsl:choose>");
        commonContent.append("<xsl:when test=\"$bold = 0\"><xsl:value-of select=\"'normal'\"/></xsl:when> ");
        commonContent.append("<xsl:otherwise><xsl:value-of select=\"'bold'\"/></xsl:otherwise>");
        commonContent.append("</xsl:choose>");
        commonContent.append("</xsl:variable>");
        foText.append("<xsl:variable name=\"fcolor\">\t<xsl:value-of select=\"fgcolor\"/></xsl:variable>");
        foText.append("<xsl:variable name=\"fontcolor\">");
        foText.append("<xsl:choose>");
        foText.append("<xsl:when test=\"$fcolor = ''\"><xsl:value-of select=\"'#000000'\"/></xsl:when>");
        foText.append("<xsl:otherwise><xsl:value-of select=\"$fcolor\"/></xsl:otherwise>");
        foText.append("</xsl:choose>");
        foText.append("</xsl:variable>");
        foText.append(commonContent.toString());
        foText.append("<fo:block line-height=\"{$colfontsize+1}pt\" font-size=\"{$colfontsize}pt\" font-family=\"{$colfont}\" font-style=\"{$ italicvalue}\" text-align=\"{$ alignvalue}\" text-decoration=\"{$ undlvalue}\" font-weight=\"{$ boldvalue}\" color=\"{$ fontcolor}\" wrap-option='wrap'  padding-top='2pt' padding-bottom='2pt'> <xsl:value-of select=\"$celldata\"/>\n");
        foText.append("</fo:block>  </xsl:if>  </xsl:for-each>   </fo:table-cell>\n");
        foText.append("</xsl:for-each>\n");
        foText.append("</fo:table-row>\n");
        foText.append("</xsl:for-each>\n");
        if (this.genProp.getSelectedGroup().equalsIgnoreCase("A")) {
            foText.append("</xsl:if>\n");
            foText.append("</xsl:for-each>\n");
        }
        foText.append("</fo:table-body>\n");
        return foText.toString();
    }

    public void getPDFTable(String filteredGroupfName) throws Exception {
        try {
            StringBuffer foTextTableAdded = new StringBuffer();
            foTextTableAdded.append(this.getHTMLFormat());
            foTextTableAdded.append("<!-- this defines a title level 2-->\n");
            foTextTableAdded.append("<fo:block font-size='16pt'\n");
            foTextTableAdded.append("font-family='sans-serif'\n");
            foTextTableAdded.append("space-after.optimum='25pt'\n");
            foTextTableAdded.append("text-align='left'>\n");
            if (filteredGroupfName != null && filteredGroupfName.length() > 0) {
                foTextTableAdded.append(this.getFoForGroups(filteredGroupfName));
            }
            foTextTableAdded.append("</fo:block>\n");
            foTextTableAdded.append("<fo:table table-layout='fixed' border-separation='10pt'>\n");
            foTextTableAdded.append(this.xslColumnText);
            foTextTableAdded.append(this.getHTMLValues(-1));
            foTextTableAdded.append("</fo:table>\n");
            foTextTableAdded.append("</fo:flow>\n");
            foTextTableAdded.append("</fo:page-sequence>\n");
            foTextTableAdded.append("</fo:root>\n");
            foTextTableAdded.append("</xsl:template>\n");
            foTextTableAdded.append("</xsl:stylesheet>\n");
            this.writeToFileTable(foTextTableAdded.toString());
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void getPDFTable(ArrayList uniqueValList) throws Exception {
        try {
            StringBuffer foTextTableAdded = new StringBuffer();
            foTextTableAdded.append(this.getHTMLFormat());
            BaseLogger.log("3", null, null, "uniqueValList >>" + uniqueValList);
            int i = 0;
            while (i < uniqueValList.size()) {
                String uniqueValStr = (String)uniqueValList.get(i);
                BaseLogger.log("3", null, null, "uniqueValStr >>" + uniqueValStr);
                ArrayList<String> grpNameList = new ArrayList<String>();
                ArrayList<String> grpValList = new ArrayList<String>();
                foTextTableAdded.append("<!-- this defines a title level 2-->\n");
                foTextTableAdded.append("<fo:block font-size='16pt'\n");
                foTextTableAdded.append("font-family='sans-serif'\n");
                foTextTableAdded.append("space-after.optimum='25pt'\n");
                foTextTableAdded.append("text-align='left'>\n");
                int cnt = 0;
                int index = -1;
                while ((index = uniqueValStr.indexOf("~")) != -1) {
                    grpNameList.add(((Column)this.groupElements.get(cnt)).getDisplayName());
                    grpValList.add(uniqueValStr.substring(0, index));
                    uniqueValStr = uniqueValStr.substring(index + 1);
                    ++cnt;
                }
                grpNameList.add(((Column)this.groupElements.get(cnt)).getDisplayName());
                grpValList.add(uniqueValStr);
                foTextTableAdded.append(this.getFoForGroups(grpNameList, grpValList));
                foTextTableAdded.append("</fo:block>\n");
                if (i == uniqueValList.size() - 1) {
                    foTextTableAdded.append("<fo:table table-layout='fixed' border-separation='10pt'>\n");
                } else {
                    foTextTableAdded.append("<fo:table table-layout='fixed' border-separation='10pt' break-after='page'>\n");
                }
                foTextTableAdded.append(this.xslColumnText);
                foTextTableAdded.append(this.getHTMLValues(i + 1));
                foTextTableAdded.append("</fo:table>\n");
                ++i;
            }
            foTextTableAdded.append("</fo:flow>\n");
            foTextTableAdded.append("</fo:page-sequence>\n");
            foTextTableAdded.append("</fo:root>\n");
            foTextTableAdded.append("</xsl:template>\n");
            foTextTableAdded.append("</xsl:stylesheet>\n");
            this.writeToFileTable(foTextTableAdded.toString());
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void writeToFileGroup(String fileContent) throws Exception {
        FileWriter fos = new FileWriter(this.getGroupFileName());
        fos.write(fileContent);
        fos.flush();
        fos.close();
    }

    private void writeToFileTable(String fileContent) throws Exception {
        FileWriter fos = new FileWriter(this.getTableFileName());
        fos.write(fileContent);
        fos.flush();
        fos.close();
    }

    private void setFileNames() throws Exception {
        String xslTableFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "TablesPdf" + Math.random() + ".xsl";
        this.setTableFileName(xslTableFileName);
    }

    private void setGroupFileName(String xslGroupFileName) throws Exception {
        this.xslGroupFileName = xslGroupFileName;
    }

    private void setTableFileName(String xslTableFileName) throws Exception {
        this.xslTableFileName = xslTableFileName;
    }

    private String getGroupFileName() throws Exception {
        return this.xslGroupFileName;
    }

    public String getTableFileName() throws Exception {
        try {
            BaseLogger.log("3", null, null, "The file name is" + this.xslTableFileName);
            return this.xslTableFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private ArrayList getCommonColumnList(Document doc) throws Exception {
        ArrayList commonColumnList = new ArrayList();
        ArrayList<String> tempCommonColumnList = null;
        NodeList colIndexList = doc.getElementsByTagName("COLINDEX");
        NodeList colSpanList = doc.getElementsByTagName("COLSPAN");
        NodeList colDataList = doc.getElementsByTagName("COLDATA");
        int i = 0;
        while (i < colIndexList.getLength()) {
            tempCommonColumnList = new ArrayList<String>();
            tempCommonColumnList.add(colIndexList.item(i).getFirstChild().getNodeValue());
            tempCommonColumnList.add(colSpanList.item(i).getFirstChild().getNodeValue());
            tempCommonColumnList.add(colDataList.item(i).getFirstChild().getNodeValue());
            commonColumnList.add(tempCommonColumnList);
            ++i;
        }
        return commonColumnList;
    }
}

