/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.LinkControllerEJB;
import ibase.webitm.ejb.XSLBuilderEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LinkControllerServlet
extends ITMAuthenticateServlet {
    protected InitialContext ctx = null;
    private static String ERR_MSG = "UNEXPECTEDERROR";
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    @Override
    public void init(ServletConfig servletConfig) {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        BaseLogger.log("2", null, null, "\nXXXXXX[LinkControllerServlet]Received request from user ......XXXXXX");
        Object outputStream = null;
        HttpSession sess = null;
        String responseStr = "";
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                String formNo;
                sess = request.getSession();
                BaseLogger.log("3", null, null, "\nsess.getId()............... :" + sess.getId());
                String action = request.getParameter("ACTION");
                this.debug(request);
                String objName = request.getParameter("OBJ_NAME") != null ? request.getParameter("OBJ_NAME") : "";
                String string = formNo = request.getParameter("OBJ_CTXT") != null ? request.getParameter("OBJ_CTXT") : "";
                if (action.equals("VIEW_DETAIL")) {
                    String contentType = request.getParameter("CONTENT") != null ? request.getParameter("CONTENT") : "";
                    String pageContext = request.getParameter("PAGE_CTX");
                    String objContext = request.getParameter("OBJ_CTX");
                    String editFlag = request.getParameter("EDIT_FLAG");
                    String qryParam = request.getParameter("QRY_PARAM");
                    String qryParamType = request.getParameter("QRY_PARAM_TYPE");
                    if (contentType.equalsIgnoreCase("HTML")) {
                        responseStr = this.getHTMLData(objName, objContext, pageContext, editFlag, qryParamType, qryParam, sess);
                        response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    } else {
                        responseStr = this.viewTransactionDetails(objName, objContext, pageContext, qryParamType, qryParam, sess);
                        response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                    }
                } else if (action.equals("SAVE_DETAIL")) {
                    BaseLogger.log("3", null, null, "SAVE_DETAIL");
                    String pageContext = request.getParameter("PAGE_CTX");
                    String chgStr = request.getParameter("CHG_STR");
                    responseStr = this.save2DB(chgStr, objName, pageContext, sess);
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                } else if (action.equals("GET_LINKS")) {
                    BaseLogger.log("3", null, null, "\n GET_LINKS formNo is [" + formNo + "] \n  GET_LINKS objName [" + objName + "]");
                    UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
                    if (userInfo != null) {
                        String transDB = userInfo.getTransDB();
                        responseStr = this.getLinkInfo(objName, formNo, userInfo.getLoginCode(), userInfo);
                    } else {
                        responseStr = Messages.getString("LinkControllerServlet_userInfoNotInSession");
                    }
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                }
                BaseLogger.log("3", null, null, "XXXXXX[LinkControllerServlet] responseStr from Server ........:XXXXXX\n" + responseStr);
                if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                    CommonConstants.setIBASEHOME();
                }
                BaseLogger.log("3", null, null, "CONTENT_ENCODING :" + CommonConstants.CONTENT_ENCODING);
                response.setBufferSize(1024);
                if (CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip")) {
                    response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzOutStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    gzOutStream.write(responseStr.getBytes());
                    gzOutStream.flush();
                    gzOutStream.close();
                } else {
                    response.setHeader("Content-Encoding", "");
                    ServletOutputStream outStream = response.getOutputStream();
                    outStream.write(responseStr.getBytes());
                    outStream.flush();
                    outStream.close();
                }
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException in doPost:==>" + e.getMessage());
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                String errMsg = "ERR_MSG :" + (String)sess.getAttribute("ERR_MSG") + "\n" + e.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                String errMsg = (String)sess.getAttribute("ERR_MSG");
                response.setContentLength(baos.toString().length());
                writer.println("ERR_MSG :" + errMsg + "\n" + baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String viewTransactionDetails(String objName, String objContext, String pageContext, String qryParamType, String qryParam, HttpSession sess) throws ITMException {
        String retXMLStr = "";
        try {
            UserInfoBean userInfo;
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            if ((userInfo = (UserInfoBean)sess.getAttribute("USER_INFO")) != null) {
                LinkControllerEJB linkCtrl = new LinkControllerEJB();
                retXMLStr = linkCtrl.viewTransactionDetails(objName, objContext, pageContext, qryParamType, qryParam, userInfo.toString());
                linkCtrl = null;
            } else {
                retXMLStr = Messages.getString("LinkControllerServlet_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"ERR_IN_ACTION_HANDLER");
            BaseLogger.log("0", null, null, "ITMException :LinkControllerServlet :viewTransactionDetails :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"ERR_IN_ACTION_HANDLER");
            BaseLogger.log("0", null, null, "Exception :LinkControllerServlet :viewTransactionDetails :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String save2DB(String chgStr, String objName, String pageContext, HttpSession sess) throws ITMException {
        String retXMLStr = "";
        try {
            UserInfoBean userInfo;
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            if ((userInfo = (UserInfoBean)sess.getAttribute("USER_INFO")) != null) {
                BaseLogger.log("3", userInfo, null, "USER INFO CALL");
                LinkControllerEJB linkController = new LinkControllerEJB();
                retXMLStr = linkController.save2DB(chgStr, objName, pageContext, userInfo.getLoginCode(), userInfo);
                linkController = null;
            } else {
                retXMLStr = Messages.getString("LinkControllerServlet_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"ERR_IN_ACTION_HANDLER");
            BaseLogger.log("0", null, null, "ITMException :LinkControllerServlet :save2DB :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"ERR_IN_ACTION_HANDLER");
            BaseLogger.log("0", null, null, "Exception :LinkControllerServlet :save2DB :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :LinkControllerServlet :getInitialContext :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :LinkControllerServlet :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }

    private void debug(HttpServletRequest request) {
        Enumeration enum1 = request.getParameterNames();
        while (enum1.hasMoreElements()) {
            String param = (String)enum1.nextElement();
            BaseLogger.log("3", null, null, "Parameter Name:" + param);
            BaseLogger.log("3", null, null, "Parameter Value:" + request.getParameter(param));
        }
    }

    private String getHTMLData(String objName, String objContext, String pageContext, String editFlag, String qryParamType, String qryParam, HttpSession sess) throws ITMException {
        String retHTMLStr = "";
        try {
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            String profileIdRes = userInfo.getProfileIdRes();
            String xslFileName = this.getXSLFileName(objName, objContext, editFlag, pageContext, "US", "en", profileIdRes, userInfo);
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            String xmlData = this.viewTransactionDetails(objName, objContext, pageContext, qryParamType, qryParam, sess);
            if (xmlData != null && xmlData.length() > 0) {
                retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    private String getXSLFileName(String objName, String objContext, String editFlag, String pgContext, String userCountry, String userLang, String profileIdRes, UserInfoBean userInfo) throws ITMException {
        String retFileName = null;
        try {
            if (Integer.parseInt(pgContext) == 1) {
                editFlag = "V";
            }
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            String fileName = String.valueOf(objName) + pgContext + objContext + "_" + userLang + "_" + userCountry + "_" + editFlag + ".xsl";
            String customXSLFilePath = String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + "Custom" + File.separator + fileName;
            if (new File(customXSLFilePath).exists()) {
                File xslCustomFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + "Custom", fileName);
                retFileName = xslCustomFile.getAbsolutePath();
            } else {
                File xslFile;
                if (!new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                    BaseLogger.log("3", userInfo, null, "LinkControllerServlet ::creating  theme folder");
                    new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
                }
                if ((xslFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME, fileName)).exists()) {
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                    XSLBuilderEJB xslBuilderEJB = new XSLBuilderEJB();
                    String xslString = xslBuilderEJB.buildXSLString(objName, objContext, userLang, userCountry, pgContext, editFlag, CommonConstants.APPLICATION_CONTEXT, profileIdRes, userInfo);
                    if (!xslString.endsWith(".xsl")) {
                        byte[] buffer = xslString.getBytes();
                        int bytes = buffer.length;
                        FileOutputStream fos = new FileOutputStream(xslFile);
                        fos.write(buffer, 0, bytes);
                        fos.flush();
                        fos.close();
                        fos = null;
                        retFileName = xslFile.getAbsolutePath();
                    } else {
                        retFileName = xslString;
                    }
                    xslBuilderEJB = null;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    private String getLinkInfo(String objName, String formNo, String loginCode, UserInfoBean userInfo) throws ITMException {
        String linkInfoStr = null;
        try {
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            LinkControllerEJB linkController = new LinkControllerEJB();
            linkInfoStr = linkController.getLinkInfo(objName, formNo, userInfo);
            linkController = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :LinkControllerServlet : getLinkInfo:==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :LinkControllerServlet :getLinkInfo :==>");
            throw new ITMException(e);
        }
        return linkInfoStr;
    }
}

