/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.bean;

import ibase.planner.ejb.CallDeletePlan;
import ibase.planner.ejb.DataProvider;
import ibase.planner.ejb.DeletePlan;
import ibase.planner.utility.ValidateXMLInput;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterDataEJB;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.naming.InitialContext;

public class TransDataProviderBean {
    public String getData(String objName, String fromDate, String toDate, UserInfoBean userInfo, String xslFileName) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : getData Called ...");
        String xmlString = "";
        try {
            xmlString = this.getData(objName, fromDate, toDate, userInfo, xslFileName, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    public String getData(String objName, String fromDate, String toDate, UserInfoBean userInfo, String xslFileName, String usrArgs) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : getData Called ..");
        String xmlString = "";
        String dataXMLStr = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String dbName = CommonConstants.DB_NAME;
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            String advQuery = usrArgs;
            String userCode = userInfo.getEmpCode();
            String argFieldTypes = "String:String:";
            if ("DB2".equalsIgnoreCase(dbName)) {
                argFieldTypes = "DATETIME:DATETIME:";
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
                fromDate = sdf1.format(sdf.parse(fromDate));
                toDate = sdf1.format(sdf.parse(toDate));
            }
            String argFieldValues = String.valueOf(fromDate) + ":" + toDate + ":";
            String url = "/ibase/";
            BaseLogger.log("3", userInfo, null, "objName=" + objName);
            BaseLogger.log("3", userInfo, null, "argFieldValues=" + argFieldValues);
            BaseLogger.log("3", userInfo, null, "advQuery=" + advQuery);
            dataXMLStr = masterDataEJB.getXMLFromDBForBrow(objName, "1", "1", argFieldValues, argFieldTypes, advQuery, userInfo, false);
            BaseLogger.log("3", userInfo, null, "\n\ndataXMLStr from db [" + dataXMLStr + "]");
            ValidateXMLInput vxi = new ValidateXMLInput();
            BaseLogger.log("3", userInfo, null, "Transforming Data......" + xslFileName);
            String outputFileName = vxi.validate(String.valueOf(xslFileName) + ".xsl", dataXMLStr, "Output", ".html");
            FileInputStream fis = new FileInputStream(outputFileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = -1;
            while ((i = fis.read()) != -1) {
                baos.write(i);
            }
            xmlString = baos.toString();
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    public String saveData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String startDateCol, String updStartDate, String endDateCol, String updEndDate, String startTimeCol, String updStartTime, String endTimeCol, String updEndTime, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : saveData Called ...");
        String saveDataStr = "";
        try {
            String loginCode = userInfo.getLoginCode();
            String remoteHost = userInfo.getRemoteHost();
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            DataProvider dataProviderRem = new DataProvider();
            saveDataStr = dataProviderRem.saveData(objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName, startDateCol, updStartDate, endDateCol, updEndDate, startTimeCol, updStartTime, endTimeCol, updEndTime, loginCode, remoteHost, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return saveDataStr;
    }

    public String deleteData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String compName) {
        BaseLogger.log("2", null, null, "TransDataProviderBean : delData Called ...");
        String deletDataStr = "";
        try {
            BaseLogger.log("3", null, null, "TransDataPtroviderBean:deleteData:compName[" + compName + "]");
            CallDeletePlan DeletePlanComp = new CallDeletePlan();
            deletDataStr = DeletePlanComp.calldeleteData(compName, objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletDataStr;
    }

    public String valData(String objName, String usrArgs, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : valData Called ...");
        String xmlString = "false";
        String loginEmpCode = "";
        Statement pStmt = null;
        String sql = "";
        Connection conn = null;
        ResultSet rs = null;
        String fieldName = "";
        String fieldValue = "";
        String transDB = "";
        try {
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            transDB = userInfo.getTransDB();
            conn = connDriver.getConnectDB(transDB);
            loginEmpCode = userInfo.getEmpCode();
            BaseLogger.log("3", userInfo, null, "\n \n \n getData usrArgs [" + usrArgs + "]loginEmpCode[" + loginEmpCode + "]usrArgs.length()[" + usrArgs.length() + "]");
            int position = usrArgs.indexOf("'");
            int lastPosition = usrArgs.lastIndexOf("'");
            if (usrArgs.indexOf("in") != -1) {
                fieldValue = loginEmpCode;
            } else {
                fieldName = usrArgs.substring(0, usrArgs.indexOf("="));
                fieldValue = usrArgs.substring(position + 1, lastPosition);
            }
            BaseLogger.log("3", userInfo, null, "fieldName [" + fieldName + "]fieldValue[" + fieldValue + "]");
            if (fieldValue.trim() == null) {
                String string = xmlString = "false";
                return string;
            }
            if (!loginEmpCode.trim().equals(fieldValue.trim())) {
                pStmt = conn.createStatement();
                sql = "SELECT A.EMP_CODE FROM EMPLOYEE A, GRADE B WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = '" + loginEmpCode + "' CONNECT BY PRIOR EMP_CODE = REPORT_TO) AND A.GRADE = B.GRADE_CODE  ORDER BY B.GRADE_CODE, A.EMP_CODE ";
                BaseLogger.log("9", null, null, "sql [" + sql + "]");
                rs = pStmt.executeQuery(sql);
                while (rs.next()) {
                    String empCode = rs.getString("EMP_CODE");
                    BaseLogger.log("3", userInfo, null, "salesPers [" + empCode + "]");
                    if (!empCode.trim().equals(fieldValue.trim())) continue;
                    String string = xmlString = "true";
                    return string;
                }
            } else {
                String string = xmlString = "true";
                return string;
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xmlString;
    }

    public String getDeafultAllowDate(String sprsCodeFor, UserInfoBean userInfo) {
        Statement pStmt = null;
        String sql = "";
        Connection conn = null;
        ResultSet rs = null;
        String allowPlanBefore = "";
        String prvDate = null;
        String transDB = "";
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                SimpleDateFormat sdfFormat = new SimpleDateFormat("dd/MM/yyyy");
                BaseLogger.log("3", userInfo, null, "\n \n \n TransDataProviderBean:getDeafultAllowDate(): sprsCodeFor [" + sprsCodeFor + "]");
                sql = "SELECT ALLOW_PLAN_BEF FROM SALES_PERS WHERE SALES_PERS= '" + sprsCodeFor + "' ";
                BaseLogger.log("3", userInfo, null, "sql [" + sql + "]");
                pStmt = conn.createStatement();
                rs = pStmt.executeQuery(sql);
                if (rs.next()) {
                    allowPlanBefore = rs.getString("ALLOW_PLAN_BEF");
                    if (allowPlanBefore != null) {
                        BaseLogger.log("3", userInfo, null, "TransDataProviderBean:getDeafultAllowDate():salesPers [" + allowPlanBefore + "]");
                        Calendar preCalc = Calendar.getInstance();
                        preCalc.setTime(new Date());
                        preCalc.add(5, -Integer.parseInt(allowPlanBefore));
                        prvDate = sdfFormat.format(preCalc.getTime());
                        BaseLogger.log("3", userInfo, null, "plandate after adding allow plan before days[" + prvDate + "]");
                    } else {
                        prvDate = sdfFormat.format(new Date());
                        BaseLogger.log("3", userInfo, null, "TransDataProviderBean:getDeafultAllowDate():prvDate IN ELSE CONDITION[" + prvDate + "]");
                    }
                }
                pStmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return prvDate;
    }

    public String deleteTranData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String compName) {
        BaseLogger.log("2", null, null, "TransDataProviderBean : deleteTranData Called ...");
        String deletDataStr = "";
        try {
            BaseLogger.log("3", null, null, "TransDataPtroviderBean:deleteTranData:compName[" + compName + "]");
            DeletePlan DeletePlanComp = new DeletePlan();
            deletDataStr = DeletePlanComp.deleteTranData(objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletDataStr;
    }

    public String deleteTranData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String compName, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : deleteTranData with Userinfo Called ...");
        String deletDataStr = "";
        try {
            BaseLogger.log("3", userInfo, null, "TransDataPtroviderBean:deleteTranData:compName[" + compName + "]");
            DeletePlan DeletePlanComp = new DeletePlan();
            deletDataStr = DeletePlanComp.deleteTranData(objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletDataStr;
    }

    public String deleteTranPlanData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String compName, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : deleteTranData Called ...");
        String deletDataStr = "";
        try {
            BaseLogger.log("3", userInfo, null, "deleteTranPlanData::[" + compName + "] userInfo is:[" + userInfo + "]");
            DeletePlan DeletePlanComp = new DeletePlan();
            deletDataStr = DeletePlanComp.deleteTranPlanData(objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName, compName, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletDataStr;
    }

    public String deleteTranActivityData(String objName, String primaryKeyCol, String primaryKeyType, String pkFldValue, String tableName, String compName, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, "TransDataProviderBean : deleteTranData Called ...");
        String deletDataStr = "";
        try {
            BaseLogger.log("3", userInfo, null, "deleteTranActivityData::[" + compName + "]");
            DeletePlan DeletePlanComp = new DeletePlan();
            deletDataStr = DeletePlanComp.deleteTranActivityData(objName, primaryKeyCol, primaryKeyType, pkFldValue, tableName, compName, userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletDataStr;
    }
}

