/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.planner.utility.ITMException;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticDashboardServlet
extends ITMAuthenticateServlet {
    private static final long serialVersionUID = -1175043784605943340L;
    private StringBuilder sb = null;
    private StringBuilder dashboardBuff = null;
    private boolean duplicateTab = false;
    private HashMap<String, String> dashboardMap = new HashMap();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            BaseLogger.log("3", null, null, "XXXXXX StaticDashboardServlet XXXXXX Starts");
            this.authenticate(request);
            UserInfoBean userInfoBean = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            BaseLogger.log("3", null, null, "userId [" + userInfoBean.getLoginCode() + "]");
            this.dashboardBuff = new StringBuilder();
            this.dashboardBuff.append("<DASHBOARD_PAGES>");
            String userId = userInfoBean.getLoginCode();
            boolean isDashBrdDef = this.checkDashBoardInfo(userId, "U", userInfoBean.getTransDB(), userInfoBean);
            if (!(isDashBrdDef || (isDashBrdDef = this.checkDashBoardInfo(userId, "R", userInfoBean.getTransDB(), userInfoBean)) || (isDashBrdDef = this.checkDashBoardInfo(userId, "F", userInfoBean.getTransDB(), userInfoBean)))) {
                isDashBrdDef = this.checkDashBoardInfo(userId, "", userInfoBean.getTransDB(), userInfoBean);
            }
            this.dashboardBuff.append("</DASHBOARD_PAGES>");
            String returnStr = this.dashboardBuff.toString();
            BaseLogger.log("3", null, null, " Dashboard info returnStr[" + returnStr + "]");
            response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(returnStr);
            BaseLogger.log("3", null, null, "XXXXXX StaticDashboardServlet XXXXXX Ends");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            e.printStackTrace(response.getWriter());
            BaseLogger.log("0", null, null, "Exception in staticdashboardservlet:" + e.getMessage());
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private boolean checkDashBoardInfo(String userId, String entityType, String transDB, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "In checkDashboardInfo");
        boolean returnValue = false;
        ResultSet resultSet = null;
        String sql = "";
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        try {
            try {
                String profileID = userInfo.getProfileId();
                BaseLogger.log("3", userInfo, null, "profileID:[" + profileID + "]");
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB(transDB);
                if ("R".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = ? AND ENTITY_CODE IN (SELECT ROLE_CODE FROM WF_ROLE_USERS WHERE USERID = ?) ORDER BY PAGE_ID ";
                } else if ("F".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = '" + entityType + "' AND ENTITY_CODE IN " + E12GenericUtility.getFormattedProfileId(profileID) + " ORDER BY PAGE_ID";
                } else if ("U".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? ORDER BY PAGE_ID ";
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_CODE = '99999' ORDER BY PAGE_ID ";
                }
                pstmtDescr = connectionObject.prepareStatement(sql);
                if ("R".equals(entityType) || "U".equals(entityType)) {
                    pstmtDescr.setString(1, entityType);
                    pstmtDescr.setString(2, userId);
                }
                this.dashboardMap = new HashMap();
                resultSet = pstmtDescr.executeQuery();
                int order = 1;
                while (resultSet.next()) {
                    this.sb = new StringBuilder();
                    returnValue = true;
                    String pageId = resultSet.getString("PAGE_ID");
                    String title = resultSet.getString("TITLE");
                    String uri = resultSet.getString("URI");
                    String pageType = resultSet.getString("PAGE_TYPE");
                    String compType = resultSet.getString("COMP_TYPE");
                    String entityCode = resultSet.getString("ENTITY_CODE");
                    this.sb.append("<DASHBOARD_PAGE order='" + order + "'>");
                    this.sb.append("<PAGE_ID><![CDATA[" + pageId + "]]></PAGE_ID>");
                    this.sb.append("<TITLE><![CDATA[" + title + "]]></TITLE>");
                    this.sb.append("<URI><![CDATA[" + uri + "]]></URI>");
                    this.sb.append("<PAGE_TYPE><![CDATA[" + pageType + "]]></PAGE_TYPE>");
                    this.sb.append("<COMP_TYPE><![CDATA[" + compType + "]]></COMP_TYPE>");
                    this.getDashBrdCompInfo(pageId, userId, entityType, transDB, userInfo, entityCode);
                    this.sb.append("</DASHBOARD_PAGE>");
                    ++order;
                    BaseLogger.log("3", userInfo, null, "duplicateTab for " + resultSet.getString("TITLE") + " :[" + this.duplicateTab + "]");
                    if (this.duplicateTab) continue;
                    this.dashboardBuff.append(this.sb.toString());
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                    pstmtDescr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in checkDashboardInfo of StaticDashboardServlet  == >" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ProfileServiceEJB :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnValue;
    }

    private void getDashBrdCompInfo(String tabId, String userId, String entityType, String transDB, UserInfoBean userInfo, String entityCode) throws Exception, ITMException {
        ResultSet dashCompRs = null;
        String sql = "";
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB(transDB);
                if ("R".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE IN (SELECT ROLE_CODE FROM WF_ROLE_USERS WHERE USERID = ?) ORDER BY COMP_ID ";
                } else if ("F".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE = ? ";
                } else if ("U".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE = ? ORDER BY COMP_ID";
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_CODE = '99999' ORDER BY COMP_ID ";
                }
                pstmtDescr = connectionObject.prepareStatement(sql);
                if ("R".equals(entityType) || "U".equals(entityType)) {
                    pstmtDescr.setString(1, tabId);
                    pstmtDescr.setString(2, entityType);
                    pstmtDescr.setString(3, userId);
                } else if ("F".equals(entityType)) {
                    pstmtDescr.setString(1, tabId);
                    pstmtDescr.setString(2, entityType);
                    pstmtDescr.setString(3, entityCode);
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    pstmtDescr.setString(1, tabId);
                }
                dashCompRs = pstmtDescr.executeQuery();
                this.sb.append("<DASHBOARD_COMPS>");
                while (dashCompRs.next()) {
                    String compId = dashCompRs.getString("COMP_ID");
                    String compTitle = dashCompRs.getString("TITLE");
                    String compUri = dashCompRs.getString("URI");
                    String compType = dashCompRs.getString("COMP_TYPE");
                    String compName = dashCompRs.getString("COMP_NAME");
                    String dbrResource = E12GenericUtility.checkNull(dashCompRs.getString("DBR_RESOURCE"));
                    String defaultValue = null;
                    if (dbrResource != null) {
                        try {
                            String metadataPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "dashboard" + File.separator + "metadataxml" + File.separator + dbrResource + ".xml";
                            File metadataFile = new File(metadataPath);
                            if (metadataFile.exists() && metadataFile.length() > 0L) {
                                Document document = new E12GenericUtility().parseFile(metadataFile);
                                NodeList parentList = document.getElementsByTagName("component");
                                int i = 0;
                                while (i < parentList.getLength()) {
                                    Node parentNode = parentList.item(i);
                                    NodeList childList = parentNode.getChildNodes();
                                    int j = 0;
                                    while (j < childList.getLength()) {
                                        Node childNode = childList.item(j);
                                        if (childNode.getNodeName().equals("default_appl")) {
                                            defaultValue = childNode.getFirstChild().getNodeValue();
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", userInfo, null, "Exception in settin defaultApplication" + e);
                            e.printStackTrace();
                        }
                    }
                    BaseLogger.log("3", userInfo, null, "B4Encoding >> " + compUri);
                    if (compUri != null) {
                        compUri = compUri.replaceAll("&", "&amp;");
                    }
                    BaseLogger.log("3", userInfo, null, "After Encoding >> " + compUri);
                    this.sb.append("<DASHBOARD_COMP compId ='" + compId + "' title = '" + compTitle + "' uri = '" + compUri + "' compType = '" + compType + "' compName = '" + compName + "' dbrResource = '" + dbrResource + "' default_appl = '" + defaultValue + "' >");
                    this.sb.append("<COMP_TYPE><![CDATA[" + this.checkNull(compType) + "]]></COMP_TYPE>");
                    this.sb.append("<COMP_NAME><![CDATA[" + this.checkNull(compName) + "]]></COMP_NAME>");
                    this.sb.append("</DASHBOARD_COMP>");
                    BaseLogger.log("3", null, null, "dbrResource:[" + dbrResource + "]");
                    if (this.dashboardMap.containsKey(dbrResource) && dbrResource != null && dbrResource.trim().length() > 0) {
                        this.duplicateTab = true;
                        BaseLogger.log("3", userInfo, null, "in if duplicateTab:[" + this.duplicateTab + "]");
                    } else {
                        this.duplicateTab = false;
                        this.dashboardMap.put(dbrResource, this.sb.toString());
                        BaseLogger.log("3", userInfo, null, "in else duplicateTab:[" + this.duplicateTab + "]");
                    }
                    BaseLogger.log("3", userInfo, null, "dashboardMap Size:" + this.dashboardMap.size());
                }
                this.sb.append("</DASHBOARD_COMPS>");
                if (dashCompRs != null) {
                    dashCompRs.close();
                    dashCompRs = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in ProfileServiceEJB  getScreens== >");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ProfileServiceEJB getScreens:==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }
}

