/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.ApplicationInvoker;
import ibase.utility.ApplicationParams;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataStatefulEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowEngineLocal;
import ibase.wrkflw.WorkflowEngineRemote;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.metadata.Activity;
import ibase.wrkflw.metadata.ActualParameters;
import ibase.wrkflw.metadata.Application;
import ibase.wrkflw.metadata.BasicType;
import ibase.wrkflw.metadata.BlockActivity;
import ibase.wrkflw.metadata.Condition;
import ibase.wrkflw.metadata.DataType;
import ibase.wrkflw.metadata.ExtendedAttribute;
import ibase.wrkflw.metadata.ExtendedAttributes;
import ibase.wrkflw.metadata.ExtendedAttributesType;
import ibase.wrkflw.metadata.FormalParameter;
import ibase.wrkflw.metadata.FormalParameters;
import ibase.wrkflw.metadata.Implementation;
import ibase.wrkflw.metadata.Participant;
import ibase.wrkflw.metadata.ParticipantType1;
import ibase.wrkflw.metadata.Participants;
import ibase.wrkflw.metadata.Route;
import ibase.wrkflw.metadata.Tool;
import ibase.wrkflw.metadata.Transition;
import ibase.wrkflw.metadata.WorkflowProcess;
import ibase.wrkflw.metadata.WorkflowProcessType;
import ibase.wrkflw.schedule.WorkflowShedule;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowMetaDataManager;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.nfunk.jep.JEP;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Stateless
public class WorkflowEngineEJB
implements WorkflowEngineLocal,
WorkflowEngineRemote {
    SessionContext cSessionContext;
    UserInfoBean userInfo = new UserInfoBean();
    WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = null;
    WorkflowProcessDataMangerEJB workflowProcessDataManger = null;
    String DEFAULT_EXEC_MODE = "SYNC";

    public WorkflowEngineEJB() {
        try {
            this.workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            this.workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
        }
        catch (Exception e) {
            e.printStackTrace();
            WorkflowLogger.info("Exception :WorkflowEngineEJB :ejbCreate :==>" + e);
        }
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            this.workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            this.workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
        }
        catch (Exception e) {
            e.printStackTrace();
            WorkflowLogger.info("Exception :WorkflowEngineEJB :ejbCreate :==>" + e);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext mSessionContext) {
    }

    @Override
    public String createActivity(String processInstanceId, String activityId, boolean isReverted) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.createActivity.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusMsg = "";
        try {
            String newProcessInstanceId;
            statusMsg = newProcessInstanceId = this.workflowProcessInstanceMonitor.createActivityInstance(processInstanceId, activityId, isReverted);
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return statusMsg;
    }

    @Override
    public String createActivity(String processInstanceId, String activityId, boolean isReverted, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.createActivity in connection.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusMsg = "";
        try {
            String newProcessInstanceId;
            statusMsg = newProcessInstanceId = this.workflowProcessInstanceMonitor.createActivityInstance(processInstanceId, activityId, isReverted, con);
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return statusMsg;
    }

    @Override
    public String performActivity(String processInstanceId, Connection conn, String userInfoStr) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.performActivity.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        StringBuffer statusMsgStrBuff = new StringBuffer();
        HashMap paramMap = null;
        boolean isActivityDefn = false;
        Statement pstmtWfPrcSTatus = null;
        ResultSet wfPrclLockRs = null;
        ResultSet prcStatusResultSet = null;
        String workFlowlLockSql = "";
        int processStatus = 0;
        try {
            try {
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                String processStatusSql = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ?";
                pstmtWfPrcSTatus = conn.prepareStatement(processStatusSql);
                pstmtWfPrcSTatus.setString(1, processId);
                pstmtWfPrcSTatus.setString(2, instanceId);
                pstmtWfPrcSTatus.setString(3, activityId);
                pstmtWfPrcSTatus.setString(4, seqId);
                prcStatusResultSet = pstmtWfPrcSTatus.executeQuery();
                if (prcStatusResultSet.next()) {
                    processStatus = prcStatusResultSet.getInt("PROCESS_STATUS");
                }
                prcStatusResultSet.close();
                prcStatusResultSet = null;
                pstmtWfPrcSTatus.close();
                pstmtWfPrcSTatus = null;
                String dbName = CommonConstants.DB_NAME;
                if (dbName.equalsIgnoreCase("db2")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS, OBJ_NAME FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ? FOR UPDATE WITH RS";
                } else if (dbName.equalsIgnoreCase("mssql")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS, OBJ_NAME FROM WF_PRC_STATUS (UPDLOCK) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?";
                } else if (dbName.equalsIgnoreCase("oracle")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS, OBJ_NAME FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?  FOR UPDATE NOWAIT";
                }
                try {
                    Throwable throwable = null;
                    Object var19_33 = null;
                    try (PreparedStatement pstmtLock = conn.prepareStatement(workFlowlLockSql);){
                        pstmtLock.setString(1, processId);
                        pstmtLock.setString(2, instanceId);
                        pstmtLock.setString(3, activityId);
                        pstmtLock.setString(4, seqId);
                        pstmtLock.setInt(5, processStatus);
                        wfPrclLockRs = pstmtLock.executeQuery();
                        if (wfPrclLockRs.next()) {
                            String objName = wfPrclLockRs.getString("OBJ_NAME") == null ? "" : wfPrclLockRs.getString("OBJ_NAME").trim();
                            BaseLogger.log("3", null, null, "performActivity >> objName =[" + objName + "]");
                            this.updateTransOnNullExp(processId, instanceId, activityId, objName, conn, userInfoStr);
                            paramMap = this.workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), conn);
                            paramMap.put("$PRC_ID", processInstanceId);
                            WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
                            Activity activity = WorkflowMetaDataManager.getInstance().getActivity(workflowProcess, activityId);
                            String performer = this.getPerformer((WorkflowProcessType)workflowProcess, activity.getPerformer(), paramMap, conn);
                            paramMap.put("$PRFMR_CODE", performer);
                            Implementation implementation = (Implementation)activity.getImplementation();
                            Route route = (Route)activity.getRoute();
                            BlockActivity blockActivity = (BlockActivity)activity.getBlockActivity();
                            StringBuffer flowInfoBuff = new StringBuffer("");
                            if (implementation != null) {
                                flowInfoBuff.append("implementaion found ");
                                List toolList = implementation.getTool();
                                if (toolList != null) {
                                    flowInfoBuff.append(", Toollist size [" + toolList.size() + "]");
                                    int noOfTool = toolList.size();
                                    int toolCtr = 0;
                                    while (toolCtr < noOfTool) {
                                        isActivityDefn = true;
                                        Tool tool = (Tool)toolList.get(toolCtr);
                                        paramMap.put("$USER_INFO", userInfoStr);
                                        String[] invokeStatusArr = this.invokeApplication(workflowProcess, tool, paramMap, processInstanceId, conn, userInfoStr);
                                        String statusStr = "";
                                        String invocationStatus = (String)this.getValueOfField(invokeStatusArr[2], "STATUS", "S");
                                        statusStr = "0".equalsIgnoreCase(invocationStatus) || "SYNC".equals(invokeStatusArr[1]) ? "2" : "1";
                                        statusMsgStrBuff.append(invokeStatusArr[2]);
                                        WorkflowLogger.info("111111111111111111Calling workflowProcessInstanceMonitor.updateActivityStatus with " + statusStr + " from performActivity ::::: [" + processInstanceId + "]");
                                        if (!this.checkActivityStatus(processInstanceId, statusStr, conn)) {
                                            BaseLogger.log("3", null, null, "performer++++:::" + performer);
                                            String performers = performer == null ? "" : performer.split(",")[0];
                                            this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, statusStr, (String)paramMap.get("$PRFMR_ROLE_CODE"), performers, null, null, null, invokeStatusArr[2], conn);
                                        }
                                        ++toolCtr;
                                    }
                                }
                            } else if (route == null) {
                                // empty if block
                            }
                            WorkflowLogger.info("isActivityDefn :[" + isActivityDefn + "]");
                            if (!isActivityDefn) {
                                BaseLogger.log("3", null, null, "flowInfoBuff [" + flowInfoBuff.toString() + "]");
                                WorkflowLogger.info("flowInfoBuff [" + flowInfoBuff.toString() + "]");
                                WorkflowLogger.info("111111111111111111Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from performActivity ");
                                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[No Activity Defined. ]]></RESULT></ROOT>";
                                String performers = performer == null ? "" : performer.split(",")[0];
                                this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", (String)paramMap.get("$PRFMR_ROLE_CODE"), performers, null, null, null, resultXmlStr, conn);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException(e);
                }
            }
            catch (SQLException sqe) {
                try {
                    conn.rollback();
                    String errMSg = sqe.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        String performer = paramMap != null ? (String)paramMap.get("$PRFMR_ROLE_CODE") : "system";
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", performer, null, null, null, errMSg, conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "", conn);
                    }
                }
                catch (Exception errMSg) {
                    // empty catch block
                }
                sqe.printStackTrace();
                throw new BaseException(sqe);
            }
            catch (BaseException be) {
                try {
                    conn.rollback();
                    String errMSg = be.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        String performer = paramMap != null ? (String)paramMap.get("$PRFMR_ROLE_CODE") : "system";
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", performer, null, null, null, be.getMessage(), conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "", conn);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                    String errMSg = e.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        String performer = paramMap != null ? (String)paramMap.get("$PRFMR_ROLE_CODE") : "system";
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", performer, null, null, null, e.getMessage(), conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "", conn);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (prcStatusResultSet != null) {
                    prcStatusResultSet.close();
                    prcStatusResultSet = null;
                }
                if (wfPrclLockRs != null) {
                    wfPrclLockRs.close();
                    wfPrclLockRs = null;
                }
                if (pstmtWfPrcSTatus != null) {
                    pstmtWfPrcSTatus.close();
                    pstmtWfPrcSTatus = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return statusMsgStrBuff.toString();
    }

    @Override
    public String checkForEscalation(String processInstanceId, Connection conn) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.checkForEscalation.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusMsg = "";
        Statement pstmtWfPrcSTatus = null;
        Statement pstmtLock = null;
        ResultSet wfPrclLockRs = null;
        ResultSet prcStatusResultSet = null;
        String workFlowlLockSql = "";
        int processStatus = 0;
        try {
            try {
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                String processStatusSql = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ?";
                pstmtWfPrcSTatus = conn.prepareStatement(processStatusSql);
                pstmtWfPrcSTatus.setString(1, processId);
                pstmtWfPrcSTatus.setString(2, instanceId);
                pstmtWfPrcSTatus.setString(3, activityId);
                pstmtWfPrcSTatus.setString(4, seqId);
                prcStatusResultSet = pstmtWfPrcSTatus.executeQuery();
                if (prcStatusResultSet.next()) {
                    processStatus = prcStatusResultSet.getInt("PROCESS_STATUS");
                }
                prcStatusResultSet.close();
                prcStatusResultSet = null;
                pstmtWfPrcSTatus.close();
                pstmtWfPrcSTatus = null;
                String dbName = CommonConstants.DB_NAME;
                if (dbName.equalsIgnoreCase("db2")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ? FOR UPDATE WITH RS";
                } else if (dbName.equalsIgnoreCase("mssql")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS (UPDLOCK) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?";
                } else if (dbName.equalsIgnoreCase("oracle")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?  FOR UPDATE NOWAIT";
                }
                pstmtLock = conn.prepareStatement(workFlowlLockSql);
                pstmtLock.setString(1, processId);
                pstmtLock.setString(2, instanceId);
                pstmtLock.setString(3, activityId);
                pstmtLock.setString(4, seqId);
                pstmtLock.setInt(5, processStatus);
                wfPrclLockRs = pstmtLock.executeQuery();
                if (wfPrclLockRs.next()) {
                    List toolList;
                    WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
                    Activity activity = WorkflowMetaDataManager.getInstance().getActivity(workflowProcess, activityId);
                    Implementation implementation = (Implementation)activity.getImplementation();
                    if (implementation != null && (toolList = implementation.getTool()) != null) {
                        int noOfTool = toolList.size();
                        int toolCtr = 0;
                        while (toolCtr < noOfTool) {
                            ExtendedAttributesType extAttrType;
                            Tool tool = (Tool)toolList.get(toolCtr);
                            if (tool != null && (extAttrType = tool.getExtendedAttributes()) != null) {
                                List extendedAttributeList = extAttrType.getExtendedAttribute();
                                int noOfExtendedAttribute = extendedAttributeList.size();
                                WorkflowLogger.info("noOfExtendedAttribute [" + noOfExtendedAttribute + "]");
                                int extAttrCtr = 0;
                                while (extAttrCtr < noOfExtendedAttribute) {
                                    ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                                    WorkflowLogger.info("extendedAttribute.getName() [" + extendedAttribute.getName() + "]");
                                    if ("ESCALATE".equalsIgnoreCase(extendedAttribute.getName())) {
                                        this.doEscalate(processInstanceId, processId, instanceId, activityId, extendedAttribute.getValue(), conn);
                                    }
                                    ++extAttrCtr;
                                }
                            }
                            ++toolCtr;
                        }
                    }
                }
            }
            catch (SQLException sqe) {
                try {
                    conn.rollback();
                    String errMSg = sqe.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, sqe.getMessage(), conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "");
                    }
                }
                catch (Exception errMSg) {
                    // empty catch block
                }
                sqe.printStackTrace();
                throw new BaseException(sqe);
            }
            catch (BaseException be) {
                try {
                    conn.rollback();
                    String errMSg = be.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, be.getMessage(), conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                    String errMSg = e.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, e.getMessage(), conn);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "");
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (prcStatusResultSet != null) {
                    prcStatusResultSet.close();
                    prcStatusResultSet = null;
                }
                if (wfPrclLockRs != null) {
                    wfPrclLockRs.close();
                    wfPrclLockRs = null;
                }
                if (pstmtWfPrcSTatus != null) {
                    pstmtWfPrcSTatus.close();
                    pstmtWfPrcSTatus = null;
                }
                if (pstmtLock != null) {
                    pstmtLock.close();
                    pstmtLock = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return statusMsg;
    }

    private void doEscalate(String processInstanceId, String processId, String instanceId, String activityId, String transitionIds, Connection conn) throws BaseException, Exception {
        WorkflowLogger.info("WorkflowEngineEJB.doEscalate.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusMsg = "";
        Transition transition = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("$PRC_ID", processId);
            paramMap.put("$INST_ID", instanceId);
            paramMap.put("$ACT_ID", activityId);
            String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
            ArrayList spanList = this.getActivitySpan(processId, instanceId, activityId, seqId, conn);
            paramMap.put("$HR_SPAN", (String)spanList.get(0));
            paramMap.put("$DAY_SPAN", (String)spanList.get(1));
            HashMap dataMap = this.workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), conn);
            paramMap.putAll(dataMap);
            StringTokenizer transitionIdBuff = new StringTokenizer(transitionIds, ",");
            ArrayList<String> activityIdList = new ArrayList<String>();
            boolean isTransitionEvaluated = false;
            while (transitionIdBuff.hasMoreTokens()) {
                String currentTransition = transitionIdBuff.nextToken();
                WorkflowLogger.info("WorkflowEngineEJB:doEscalate:currentTransition [" + currentTransition + "]");
                transition = WorkflowMetaDataManager.getInstance().getTransition(processId, currentTransition);
                WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
                if (!this.evaluateTransitionCondition((WorkflowProcessType)workflowProcess, transition, paramMap)) continue;
                activityIdList.add(transition.getTo());
                isTransitionEvaluated = true;
            }
            int noOfActivities = activityIdList.size();
            WorkflowLogger.info("WorkflowEngineEJB:doEscalate:activityIdList :" + activityIdList);
            StringBuffer statusMsgBuffer = new StringBuffer(" Invoked :");
            int activityCtr = 0;
            while (activityCtr < noOfActivities) {
                statusMsgBuffer.append(this.createActivity(processInstanceId, (String)activityIdList.get(activityCtr), false, conn)).append(",");
                ++activityCtr;
            }
            this.updateEvaluationDetails(processId, Integer.parseInt(instanceId), activityId, isTransitionEvaluated, transition, Integer.parseInt(seqId), activityIdList, conn);
            statusMsg = statusMsgBuffer.toString();
            if (statusMsg.endsWith(",")) {
                statusMsg = statusMsg.substring(0, statusMsg.length() - 1);
            }
            if (isTransitionEvaluated) {
                WorkflowLogger.info("Creating ESC_ACTIVITY . . . . for ProcessInstance [" + processInstanceId + "]");
                this.createActivity(processInstanceId, "ESC_ACTIVITY", false, conn);
                WorkflowLogger.info("Closing Escalated Activity updating Status as '5'");
                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + statusMsg + "]]></RESULT></ROOT>";
                this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "5", null, null, null, null, null, resultXmlStr, conn);
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "");
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "");
            throw new BaseException(e);
        }
    }

    @Override
    public String completeActivity(String processInstanceId, String resultXmlStr) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.completeActivity.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("WorkflowEngineEJB.completeActivity.resultXmlStr length :[" + resultXmlStr.length() + "]");
        String statusMsg = "";
        Transition transition = null;
        boolean isTransitionEvaluated = false;
        try {
            String statusStr;
            StringBuffer statusMsgBuffer = new StringBuffer("Completing :" + processInstanceId);
            String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
            String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
            String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
            String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            ArrayList spanList = this.getActivitySpan(processId, instanceId, activityId, seqId);
            paramMap.put("$HR_SPAN", spanList.get(0));
            paramMap.put("$DAY_SPAN", spanList.get(1));
            paramMap.put("$PRC_ID", processInstanceId);
            paramMap.put("$INST_ID", processInstanceId);
            paramMap.put("$ACT_ID", processInstanceId);
            if (resultXmlStr != null && resultXmlStr.length() > 0) {
                paramMap.put("$APP_STATUS", (String)this.getValueOfField(resultXmlStr, "STATUS", ""));
                paramMap.put("$APP_RESULT", (String)this.getValueOfField(resultXmlStr, "RESULT", ""));
            }
            HashMap dataMap = this.workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
            paramMap.putAll(dataMap);
            WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
            ArrayList allActivitiesList = WorkflowMetaDataManager.getInstance().getAllActivities(workflowProcess);
            if (allActivitiesList != null && allActivitiesList.size() > 0) {
                HashMap activitiesStatusMap = this.workflowProcessInstanceMonitor.getActivitiesStatusMap(processId, Integer.parseInt(instanceId), allActivitiesList);
                WorkflowLogger.info("activitiesStatusMap [" + activitiesStatusMap + "]");
                paramMap.putAll(activitiesStatusMap);
            }
            String previousActivity = this.workflowProcessInstanceMonitor.getPreviousActivity(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
            boolean isReverted = false;
            String appResult = (String)this.getValueOfField(resultXmlStr, "RESULT", "");
            ArrayList<String> activityIdList = new ArrayList<String>();
            boolean isNextActFound = false;
            Activity activity = WorkflowMetaDataManager.getInstance().getActivity(workflowProcess, activityId);
            List transitionList = WorkflowMetaDataManager.getInstance().getTransitionsFromActivity(workflowProcess, activityId);
            BaseLogger.log("3", null, null, "transitionList :[" + transitionList + "]");
            if (transitionList != null) {
                int noOfTransition = transitionList.size();
                int transitionCtr = 0;
                while (transitionCtr < noOfTransition) {
                    transition = (Transition)transitionList.get(transitionCtr);
                    if (this.evaluateTransitionCondition((WorkflowProcessType)workflowProcess, transition, paramMap)) {
                        activityIdList.add(transition.getTo());
                        isNextActFound = true;
                    }
                    ++transitionCtr;
                }
            }
            if (!isNextActFound && appResult != null && "V".equalsIgnoreCase(appResult) || previousActivity.startsWith("R-")) {
                BaseLogger.log("3", null, null, "Reverting to previous Activity [" + previousActivity + "]");
                statusMsgBuffer.append(" Reverted and Invoked :");
                if (previousActivity.startsWith("R-")) {
                    if ("V".equalsIgnoreCase(appResult)) {
                        BaseLogger.log("3", null, null, "\n ******** \n WARNING : Cannot Revert to a reverted Activity.\n");
                        previousActivity = null;
                    } else {
                        previousActivity = previousActivity.substring(2);
                    }
                } else {
                    isReverted = true;
                }
                if (previousActivity != null && previousActivity.length() > 0) {
                    BaseLogger.log("3", null, null, "Reverting to previous Activity [" + previousActivity + "]");
                    activityIdList.add(previousActivity);
                }
            }
            int noOfActivities = activityIdList.size();
            WorkflowLogger.info("activityIdList :" + activityIdList);
            statusMsgBuffer.append(" Invoked :");
            int activityCtr = 0;
            while (activityCtr < noOfActivities) {
                statusMsgBuffer.append(this.createActivity(processInstanceId, (String)activityIdList.get(activityCtr), isReverted)).append(",");
                ++activityCtr;
            }
            this.updateEvaluationDetails(processId, Integer.parseInt(instanceId), activityId, isTransitionEvaluated, transition, Integer.parseInt(seqId), activityIdList, null);
            statusMsg = statusMsgBuffer.toString();
            if (statusMsg.endsWith(",")) {
                statusMsg = statusMsg.substring(0, statusMsg.length() - 1);
            }
            if ((statusStr = (String)this.getValueOfField(resultXmlStr, "STATUS", "S")) == null && (resultXmlStr.indexOf("error") != -1 || resultXmlStr.indexOf("Error") != -1)) {
                statusStr = "1";
            }
            resultXmlStr = "<ROOT><STATUS><![CDATA[" + statusStr + "]]></STATUS><RESULT><![CDATA[" + statusMsg + "]]></RESULT></ROOT>";
            if (appResult != null && "V".equalsIgnoreCase(appResult)) {
                this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "4", null, null, null, null, null, resultXmlStr);
            } else {
                this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "3", null, null, null, null, null, resultXmlStr);
            }
            this.updateTransWfStatus(processId, instanceId, "Completed Activity:[ " + activityId + " ]", null, activityId);
        }
        catch (BaseException be) {
            this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, statusMsg);
            be.printStackTrace();
        }
        catch (Exception e) {
            this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, statusMsg);
            e.printStackTrace();
        }
        return statusMsg;
    }

    @Override
    public String completeActivity(String processInstanceId, String resultXmlStr, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.completeActivity.with connection.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("WorkflowEngineEJB.completeActivity.resultXmlStr length :[" + resultXmlStr.length() + "]");
        String statusMsg = "";
        boolean isNotupdateactivity = false;
        Transition transition = null;
        boolean isTransitionEvaluated = false;
        Statement pstmtWfPrcSTatus = null;
        Statement pstmtLock = null;
        ResultSet wfPrclLockRs = null;
        ResultSet prcStatusResultSet = null;
        String workFlowlLockSql = "";
        int processStatus = 0;
        try {
            try {
                StringBuffer statusMsgBuffer = new StringBuffer("Completing :" + processInstanceId);
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                String processStatusSql = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ?";
                pstmtWfPrcSTatus = con.prepareStatement(processStatusSql);
                pstmtWfPrcSTatus.setString(1, processId);
                pstmtWfPrcSTatus.setString(2, instanceId);
                pstmtWfPrcSTatus.setString(3, activityId);
                pstmtWfPrcSTatus.setString(4, seqId);
                prcStatusResultSet = pstmtWfPrcSTatus.executeQuery();
                if (prcStatusResultSet.next()) {
                    processStatus = prcStatusResultSet.getInt("PROCESS_STATUS");
                }
                prcStatusResultSet.close();
                prcStatusResultSet = null;
                pstmtWfPrcSTatus.close();
                pstmtWfPrcSTatus = null;
                String dbName = CommonConstants.DB_NAME;
                if (dbName.equalsIgnoreCase("db2")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ? FOR UPDATE WITH RS";
                } else if (dbName.equalsIgnoreCase("mssql")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS (UPDLOCK) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?";
                } else if (dbName.equalsIgnoreCase("oracle")) {
                    workFlowlLockSql = "SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID, PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? AND PROCESS_STATUS = ?  FOR UPDATE NOWAIT";
                }
                pstmtLock = con.prepareStatement(workFlowlLockSql);
                pstmtLock.setString(1, processId);
                pstmtLock.setString(2, instanceId);
                pstmtLock.setString(3, activityId);
                pstmtLock.setString(4, seqId);
                pstmtLock.setInt(5, processStatus);
                wfPrclLockRs = pstmtLock.executeQuery();
                if (wfPrclLockRs.next()) {
                    String statusStr;
                    ArrayList spanList = this.getActivitySpan(processId, instanceId, activityId, seqId, con);
                    paramMap.put("$HR_SPAN", spanList.get(0));
                    paramMap.put("$DAY_SPAN", spanList.get(1));
                    paramMap.put("$PRC_ID", processInstanceId);
                    paramMap.put("$INST_ID", processInstanceId);
                    paramMap.put("$ACT_ID", processInstanceId);
                    if (resultXmlStr != null && resultXmlStr.length() > 0) {
                        paramMap.put("$APP_STATUS", (String)this.getValueOfField(resultXmlStr, "STATUS", ""));
                        paramMap.put("$APP_RESULT", (String)this.getValueOfField(resultXmlStr, "RESULT", ""));
                    }
                    HashMap dataMap = this.workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), con);
                    paramMap.putAll(dataMap);
                    WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
                    ArrayList allActivitiesList = WorkflowMetaDataManager.getInstance().getAllActivities(workflowProcess);
                    if (allActivitiesList != null && allActivitiesList.size() > 0) {
                        HashMap activitiesStatusMap = this.workflowProcessInstanceMonitor.getActivitiesStatusMap(processId, Integer.parseInt(instanceId), allActivitiesList, con);
                        WorkflowLogger.info("activitiesStatusMap [" + activitiesStatusMap + "]");
                        paramMap.putAll(activitiesStatusMap);
                    }
                    String previousActivity = this.workflowProcessInstanceMonitor.getPreviousActivity(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), con);
                    boolean isReverted = false;
                    String appResult = (String)this.getValueOfField(resultXmlStr, "RESULT", "");
                    ArrayList<String> activityIdList = new ArrayList<String>();
                    boolean isNextActFound = false;
                    Activity activity = WorkflowMetaDataManager.getInstance().getActivity(workflowProcess, activityId);
                    List transitionList = WorkflowMetaDataManager.getInstance().getTransitionsFromActivity(workflowProcess, activityId);
                    BaseLogger.log("3", null, null, "transitionList :[" + transitionList + "]");
                    if (transitionList != null) {
                        int noOfTransition = transitionList.size();
                        int transitionCtr = 0;
                        while (transitionCtr < noOfTransition) {
                            transition = (Transition)transitionList.get(transitionCtr);
                            if (this.evaluateTransitionCondition((WorkflowProcessType)workflowProcess, transition, paramMap)) {
                                activityIdList.add(transition.getTo());
                                isNextActFound = true;
                            }
                            ++transitionCtr;
                        }
                    }
                    if (!isNextActFound && appResult != null && "V".equalsIgnoreCase(appResult) || previousActivity.startsWith("R-")) {
                        BaseLogger.log("3", null, null, "Reverting to previous Activity [" + previousActivity + "]");
                        statusMsgBuffer.append(" Reverted and Invoked :");
                        if (previousActivity.startsWith("R-")) {
                            if ("V".equalsIgnoreCase(appResult)) {
                                BaseLogger.log("3", null, null, "\n ******** \n WARNING : Cannot Revert to a reverted Activity.\n");
                                previousActivity = null;
                            } else {
                                previousActivity = previousActivity.substring(2);
                            }
                        } else {
                            isReverted = true;
                        }
                        if (previousActivity != null && previousActivity.length() > 0) {
                            BaseLogger.log("3", null, null, "Reverting to previous Activity [" + previousActivity + "]");
                            activityIdList.add(previousActivity);
                        }
                    }
                    int noOfActivities = activityIdList.size();
                    WorkflowLogger.info("activityIdList in connection:" + activityIdList);
                    statusMsgBuffer.append(" Invoked :");
                    int activityCtr = 0;
                    while (activityCtr < noOfActivities) {
                        statusMsgBuffer.append(this.createActivity(processInstanceId, (String)activityIdList.get(activityCtr), isReverted, con)).append(",");
                        ++activityCtr;
                    }
                    this.updateEvaluationDetails(processId, Integer.parseInt(instanceId), activityId, isTransitionEvaluated, transition, Integer.parseInt(seqId), activityIdList, con);
                    statusMsg = statusMsgBuffer.toString();
                    if (statusMsg.endsWith(",")) {
                        statusMsg = statusMsg.substring(0, statusMsg.length() - 1);
                    }
                    if ((statusStr = (String)this.getValueOfField(resultXmlStr, "STATUS", "S")) == null && (resultXmlStr.indexOf("error") != -1 || resultXmlStr.indexOf("Error") != -1)) {
                        statusStr = "1";
                    }
                    resultXmlStr = "<ROOT><STATUS><![CDATA[" + statusStr + "]]></STATUS><RESULT><![CDATA[" + statusMsg + "]]></RESULT></ROOT>";
                    WorkflowLogger.info("resultXmlStr[" + resultXmlStr + "]");
                    isNotupdateactivity = appResult != null && "V".equalsIgnoreCase(appResult) ? this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "4", null, null, null, null, null, resultXmlStr, con) : this.workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "3", null, null, null, null, null, resultXmlStr, con);
                    if (isNotupdateactivity) {
                        statusMsg = "Error";
                    } else {
                        this.updateTransWfStatus(processId, instanceId, "Completed Activity:[ " + activityId + " ]", con, activityId);
                    }
                }
            }
            catch (SQLException sqe) {
                try {
                    con.rollback();
                    String errMSg = sqe.getMessage();
                    if (!(errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054"))) {
                        this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, sqe.getMessage(), con);
                        this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, statusMsg, con);
                        statusMsg = "Error";
                    }
                }
                catch (Exception errMSg) {
                    // empty catch block
                }
                sqe.printStackTrace();
                throw new BaseException(sqe);
            }
            catch (BaseException be) {
                try {
                    con.rollback();
                    this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, be.getMessage(), con);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, statusMsg, con);
                statusMsg = "Error";
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                try {
                    con.rollback();
                    this.workflowProcessInstanceMonitor.updateActivityErrorStatus(processInstanceId, "2", "Exception", "", null, null, null, e.getMessage(), con);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, statusMsg, con);
                statusMsg = "Error";
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (prcStatusResultSet != null) {
                    prcStatusResultSet.close();
                    prcStatusResultSet = null;
                }
                if (wfPrclLockRs != null) {
                    wfPrclLockRs.close();
                    wfPrclLockRs = null;
                }
                if (pstmtWfPrcSTatus != null) {
                    pstmtWfPrcSTatus.close();
                    pstmtWfPrcSTatus = null;
                }
                if (pstmtLock != null) {
                    pstmtLock.close();
                    pstmtLock = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return statusMsg;
    }

    private String getPerformer(WorkflowProcessType wrkflwProcess, String performerId, HashMap paramMap, Connection con) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.getPerformer.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("Performer Id :[" + performerId + "]");
        String performerCode = null;
        Participant participant = null;
        Statement roleExprPStmt = null;
        try {
            try {
                if (performerId != null) {
                    Participants participants = (Participants)wrkflwProcess.getParticipants();
                    List participantList = participants.getParticipant();
                    int noOfParticipants = participantList.size();
                    HashMap<String, String> attrNameValueMap = new HashMap<String, String>();
                    boolean performerCodeFound = false;
                    int participantCtr = 0;
                    while (participantCtr < noOfParticipants) {
                        participant = (Participant)participantList.get(participantCtr);
                        if (performerId.equals(participant.getId())) {
                            performerCodeFound = true;
                            break;
                        }
                        ++participantCtr;
                    }
                    if (performerCodeFound) {
                        ParticipantType1 paticipantType1 = (ParticipantType1)participant.getParticipantType1();
                        String paticipantTypeStr = paticipantType1.getType();
                        ExtendedAttributesType extAttrType = participant.getExtendedAttributes();
                        List extendedAttributeList = extAttrType.getExtendedAttribute();
                        int noOfExtendedAttribute = extendedAttributeList.size();
                        int extAttrCtr = 0;
                        while (extAttrCtr < noOfExtendedAttribute) {
                            ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                            attrNameValueMap.put(extendedAttribute.getName(), extendedAttribute.getValue());
                            paramMap.put("$" + extendedAttribute.getName(), extendedAttribute.getValue());
                            ++extAttrCtr;
                        }
                        String roleType = "S";
                        String roleEntity = "E";
                        String roleEntitySql = "";
                        String userId = "";
                        String perfRoleCode = (String)paramMap.get("$PRFMR_ROLE_CODE");
                        WorkflowLogger.info("Performer Role Code :[" + perfRoleCode + "]");
                        if (perfRoleCode != null) {
                            DBAccessEJB dbAccessEJB = new DBAccessEJB();
                            ArrayList roleInfoList = dbAccessEJB.getRoleInfoList(con, perfRoleCode);
                            dbAccessEJB = null;
                            if (roleInfoList != null && roleInfoList.size() >= 4) {
                                roleType = (String)roleInfoList.get(0);
                                roleEntity = (String)roleInfoList.get(1);
                                roleEntitySql = (String)roleInfoList.get(2);
                                userId = (String)roleInfoList.get(3);
                            }
                        }
                        WorkflowLogger.info("Performer Type :[" + paticipantTypeStr + "]");
                        if (paticipantTypeStr.equals("ROLE") && "D".equalsIgnoreCase(roleType)) {
                            String currRoleExpr = (String)paramMap.get("$PRFMR_ROLE_EXPR");
                            String currRoleExprType = (String)paramMap.get("$PRFMR_ROLE_EXPR_TYPE");
                            if (currRoleExpr != null) {
                                int indexOfSep = -1;
                                StringBuilder roleEntityQueryBuilder = new StringBuilder(roleEntitySql);
                                Object currValue = null;
                                while ((indexOfSep = currRoleExpr.indexOf(":")) != -1) {
                                    currValue = null;
                                    String currField = currRoleExpr.substring(0, indexOfSep);
                                    String currType = currRoleExprType.substring(0, currRoleExprType.indexOf(":"));
                                    WorkflowLogger.info("Role Code Param :[" + currField + "] type :[" + currType + "]");
                                    currValue = this.getValueOfField((String)paramMap.get("$XML_DATA_ALL"), currField, currType);
                                    WorkflowLogger.info("Role Code Param Value :[" + currValue + "]");
                                    if (currValue == null) {
                                        currValue = "";
                                    }
                                    this.setParameter(roleEntityQueryBuilder, currValue);
                                    currRoleExpr = currRoleExpr.substring(indexOfSep + 1);
                                    currRoleExprType = currRoleExprType.substring(currRoleExprType.indexOf(":") + 1);
                                }
                                roleEntitySql = roleEntityQueryBuilder.toString();
                                System.out.printf("WorkflowEngineEJB :: getPerformer() : roleEntitySql [%s]\n", roleEntitySql);
                                roleExprPStmt = con.prepareStatement(roleEntitySql);
                                ResultSet roleExprRS = roleExprPStmt.executeQuery();
                                performerCode = "";
                                while (roleExprRS.next()) {
                                    String code = roleExprRS.getString(1);
                                    WorkflowLogger.info("In WorkflowengineEJB getPerformer() Code before split:[" + code + "]");
                                    if (code != null && code.contains(",")) {
                                        String[] entityDetailArr = code.split(",");
                                        code = entityDetailArr[1];
                                    }
                                    WorkflowLogger.info("In WorkflowengineEJB getPerformer() Code after split:[" + code + "]");
                                    performerCode = String.valueOf(performerCode) + (performerCode.trim().length() > 0 ? "," : "") + code;
                                }
                                roleExprRS.close();
                                roleExprRS = null;
                                if (roleExprPStmt != null) {
                                    roleExprPStmt.close();
                                    roleExprPStmt = null;
                                }
                            }
                        }
                        if (("S".equalsIgnoreCase(roleType) || "HUMAN".equals(paticipantTypeStr)) && userId != null && userId.length() > 0) {
                            performerCode = userId;
                        }
                    } else {
                        throw new Exception("Performer Code undefined");
                    }
                }
                WorkflowLogger.info("Evaluated Performer Code :[" + performerCode + "]");
            }
            catch (BaseException be) {
                be.printStackTrace();
                throw be;
            }
            catch (NullPointerException ne) {
                ne.printStackTrace();
                throw new BaseException(ne);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (roleExprPStmt != null) {
                    roleExprPStmt.close();
                    roleExprPStmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        return performerCode;
    }

    private void setParameter(StringBuilder sql, Object value) {
        boolean hasINOperator;
        int index = sql.indexOf("?");
        String substring = sql.substring(index - 5, index);
        boolean bl = hasINOperator = substring.toUpperCase().indexOf(" IN ") != -1;
        if (hasINOperator) {
            String newValue = this.formatParameterForINOperator((String)value);
            sql.replace(index, index + 1, newValue);
        } else if (value instanceof String) {
            sql.replace(index, index + 1, "'" + value + "'");
        } else if (value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Long) {
            sql.replace(index, index + 1, String.valueOf(value));
        }
    }

    private String formatParameterForINOperator(String parameter) {
        String formattedParameter = "";
        String[] splitedParameters = parameter.split(",");
        int length = splitedParameters.length;
        int i = 0;
        while (i < length) {
            String paramPart = splitedParameters[i];
            formattedParameter = String.valueOf(formattedParameter) + String.format("'%s',", paramPart);
            ++i;
        }
        if (formattedParameter.length() > 0) {
            formattedParameter = formattedParameter.substring(0, formattedParameter.length() - 1);
        }
        return formattedParameter;
    }

    private boolean evaluateTransitionCondition(WorkflowProcessType wrkflwProcess, Transition transition, HashMap paramMap) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.evaluateTransitionCondition.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        boolean isEvaluation = false;
        try {
            Condition condition = (Condition)transition.getCondition();
            if (condition != null) {
                List exprToEvalList = condition.getContent();
                String exprToEval = (String)exprToEvalList.get(0);
                WorkflowLogger.info("Expr To Eval :[" + exprToEval + "]");
                JEP jep = new JEP();
                HashMap<String, String> attrNameValueMap = new HashMap<String, String>();
                ExtendedAttributes extendedAttributes = (ExtendedAttributes)transition.getExtendedAttributes();
                if (extendedAttributes != null) {
                    List extendedAttributeList = extendedAttributes.getExtendedAttribute();
                    int noOfExtendedAttribute = extendedAttributeList.size();
                    int extAttrCtr = 0;
                    while (extAttrCtr < noOfExtendedAttribute) {
                        ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                        attrNameValueMap.put(extendedAttribute.getName(), extendedAttribute.getValue());
                        ++extAttrCtr;
                    }
                }
                String varNamesString = (String)attrNameValueMap.get("VAR_NAMES");
                StringTokenizer expStringToken = null;
                if (varNamesString != null && varNamesString.length() > 0) {
                    expStringToken = new StringTokenizer(varNamesString, ",");
                    Object currFieldValue = null;
                    String curFieldName = null;
                    while (expStringToken.hasMoreTokens()) {
                        String currField = expStringToken.nextToken();
                        WorkflowLogger.info("currField [" + currField + "]");
                        if (currField.startsWith("$")) {
                            currFieldValue = "$HR_SPAN".equals(currField) || "$DAY_SPAN".equals(currField) ? new Double((String)paramMap.get(currField)) : (String)paramMap.get(currField);
                            WorkflowLogger.info("Value of " + currField + " [" + (String)paramMap.get(currField) + "]");
                            if (currFieldValue == null) continue;
                            jep.addVariableAsObject(currField, currFieldValue);
                            continue;
                        }
                        String currDataType = currField.substring(currField.lastIndexOf(".") + 1);
                        curFieldName = currField.substring(0, currField.lastIndexOf("."));
                        currFieldValue = this.getValueOfField((String)paramMap.get("$XML_DATA_ALL"), curFieldName, currDataType);
                        WorkflowLogger.info("Retrieved value of expr for Transition for :[" + curFieldName + "=" + currFieldValue + "]");
                        if (currFieldValue != null) {
                            if (curFieldName.indexOf(".") != -1) {
                                curFieldName = curFieldName.substring(curFieldName.indexOf(".") + 1);
                            }
                            if (currFieldValue == null) continue;
                            jep.addVariableAsObject(curFieldName, currFieldValue);
                            continue;
                        }
                        jep.addVariableAsObject(curFieldName, (Object)"");
                    }
                }
                StringBuffer expr = new StringBuffer(exprToEval);
                if (exprToEval.toUpperCase().indexOf(" AND ") > 0) {
                    expr.replace(exprToEval.toUpperCase().indexOf(" AND "), exprToEval.toUpperCase().indexOf(" AND ") + " AND ".length(), " && ");
                }
                if (exprToEval.toUpperCase().indexOf(" OR ") > 0) {
                    expr.replace(exprToEval.toUpperCase().indexOf(" OR "), exprToEval.toUpperCase().indexOf(" OR ") + " OR ".length(), " || ");
                }
                exprToEval = new String(expr);
                jep.parseExpression(exprToEval);
                Object resultObj = null;
                String errorString = jep.getErrorInfo();
                if (errorString != null) {
                    resultObj = errorString;
                } else {
                    resultObj = jep.getValueAsObject();
                    if (resultObj.equals(Double.valueOf("1"))) {
                        isEvaluation = true;
                    }
                }
            } else {
                isEvaluation = true;
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        WorkflowLogger.info("Result of evaluation of expression :[" + isEvaluation + "]");
        return isEvaluation;
    }

    private String[] invokeApplication(WorkflowProcess workflowProcess, Tool tool, HashMap paramMap, String processInstanceId, Connection conn, String userInfoStr) throws BaseException {
        String[] returnArr;
        block15: {
            WorkflowLogger.info("WorkflowEngineEJB.invokeApplication.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
            Object statusStr = null;
            returnArr = null;
            Application application = null;
            try {
                String applicationId = tool.getId();
                returnArr = new String[3];
                returnArr[0] = applicationId;
                String applnType = tool.getType();
                WorkflowLogger.info("Invoking Application Id :[" + applicationId + "] Appl Type :[" + applnType + "]");
                application = WorkflowMetaDataManager.getInstance().getApplication(workflowProcess, applicationId);
                ApplicationParams appParams = new ApplicationParams();
                appParams.setApplnName(application.getName());
                HashMap<String, String> attrNameValueMap = new HashMap<String, String>();
                attrNameValueMap.put("EXEC_MODE", this.DEFAULT_EXEC_MODE);
                ExtendedAttributes extAttr = (ExtendedAttributes)application.getExtendedAttributes();
                List extendedAttributeList = extAttr.getExtendedAttribute();
                int noOfExtendedAttribute = extendedAttributeList.size();
                int extAttrCtr = 0;
                while (extAttrCtr < noOfExtendedAttribute) {
                    ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                    attrNameValueMap.put(extendedAttribute.getName(), extendedAttribute.getValue());
                    ++extAttrCtr;
                }
                ExtendedAttributes tooExtAttr = (ExtendedAttributes)tool.getExtendedAttributes();
                if (tooExtAttr != null) {
                    List toolExtAttributeList = tooExtAttr.getExtendedAttribute();
                    noOfExtendedAttribute = toolExtAttributeList.size();
                    int extAttrCtr2 = 0;
                    while (extAttrCtr2 < noOfExtendedAttribute) {
                        ExtendedAttribute extendedAttribute = (ExtendedAttribute)toolExtAttributeList.get(extAttrCtr2);
                        attrNameValueMap.put(extendedAttribute.getName(), extendedAttribute.getValue());
                        ++extAttrCtr2;
                    }
                }
                returnArr[1] = (String)attrNameValueMap.get("EXEC_MODE");
                WorkflowLogger.info("EXEC_MODE [" + returnArr[1] + "]");
                paramMap.putAll(attrNameValueMap);
                if ((String)attrNameValueMap.get("COMP_NAME") != null) {
                    appParams.setCompName((String)attrNameValueMap.get("COMP_NAME"));
                }
                appParams.setApplnType((String)attrNameValueMap.get("APPLN_TYPE"));
                appParams.setMethodName((String)attrNameValueMap.get("METHOD_NAME"));
                FormalParameters formalParameters = (FormalParameters)application.getFormalParameters();
                ActualParameters actualParameters = (ActualParameters)tool.getActualParameters();
                int noOfFormalParam = 0;
                int noOfActualParam = 0;
                List formalParameterList = null;
                List actualParameterList = null;
                if (formalParameters != null) {
                    formalParameterList = formalParameters.getFormalParameter();
                    noOfFormalParam = formalParameterList.size();
                }
                if (actualParameters != null) {
                    actualParameterList = actualParameters.getActualParameter();
                    noOfActualParam = actualParameterList.size();
                }
                if (noOfFormalParam == noOfActualParam) {
                    this.setAppParamsByRef(appParams, paramMap, formalParameterList, actualParameterList, userInfoStr);
                    returnArr[2] = new ApplicationInvoker(appParams).invokeApplication(conn);
                    WorkflowLogger.info("WorkflowEngineEJB.invokeApplication.returnArr [" + returnArr[2] + "]");
                    if (returnArr[2] == null || returnArr[2].length() == 0) {
                        returnArr[2] = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Nothing returned from component, so considering success]]></RESULT></ROOT>";
                        WorkflowLogger.info("WorkflowEngineEJB.invokeApplication [ Nothing returned from component, so considering success ]");
                    } else if (returnArr[2].indexOf("<Errors>") != -1) {
                        String returnStr = returnArr[2];
                        boolean isError = this.isErrorTypeFound(returnStr);
                        returnStr = returnStr.indexOf("<Root>") != -1 ? (isError ? "<ROOT><STATUS><![CDATA[0]]></STATUS>" + returnStr.substring(returnStr.indexOf("<Root>") + 6, returnStr.indexOf("</Root>")) + "</ROOT>" : "<ROOT><STATUS><![CDATA[1]]></STATUS>" + returnStr.substring(returnStr.indexOf("<Root>") + 6, returnStr.indexOf("</Root>")) + "</ROOT>") : (isError ? "<ROOT><STATUS><![CDATA[0]]></STATUS>" + returnStr + "</ROOT>" : "<ROOT><STATUS><![CDATA[1]]></STATUS>" + returnStr + "</ROOT>");
                        returnArr[2] = returnStr;
                    } else if (returnArr[2].indexOf("<ROOT><STATUS>") == -1) {
                        returnArr[2] = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + returnArr[2] + "]]></RESULT></ROOT>";
                        WorkflowLogger.info("WorkflowEngineEJB.invokeApplication [ Not returned in proper format ] returnArr[2] [" + returnArr[2] + "]");
                    }
                    break block15;
                }
                throw new Exception("Parameter mismatch");
            }
            catch (BaseException be) {
                be.printStackTrace();
                String wrkflowErrFolder = this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "", conn);
                returnArr[2] = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Error occured detailed can be found at " + wrkflowErrFolder + " folder ]]></RESULT></ROOT>";
            }
            catch (Exception e) {
                e.printStackTrace();
                String wrkflowErrFolder = this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, "", conn);
                returnArr[2] = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Error occured detailed can be found at " + wrkflowErrFolder + " folder ]]></RESULT></ROOT>";
            }
        }
        WorkflowLogger.info("WorkflowEngineEJB.invokeApplication.returnArr [" + returnArr + "]");
        return returnArr;
    }

    private void setAppParamsByRef(ApplicationParams appParams, HashMap paramMap, List formalParameterList, List actualParameterList, String userInfoStr) throws BaseException, Exception {
        WorkflowLogger.info("WorkflowEngineEJB.setAppParamsByRef.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        try {
            int noOfFormalParam = formalParameterList.size();
            int paramCtr = 0;
            while (paramCtr < noOfFormalParam) {
                FormalParameter formalParameter = (FormalParameter)formalParameterList.get(paramCtr);
                String actualParamValue = (String)actualParameterList.get(paramCtr);
                WorkflowLogger.info("setAppParamsByRef:actualParamValue[" + actualParamValue + "]");
                StringBuffer actualParamValueBffr = new StringBuffer(actualParamValue);
                DataType dataType = (DataType)formalParameter.getDataType();
                BasicType basicType = (BasicType)dataType.getBasicType();
                String paramDataType = basicType.getType();
                String paramId = formalParameter.getId();
                BaseLogger.log("3", null, null, "@@@@ actualParamValueBffr : [ " + actualParamValueBffr.toString() + " ]");
                BaseLogger.log("3", null, null, "@@@@ paramMap : [ " + paramMap.toString() + " ] ");
                if (actualParamValue.indexOf("$") != -1) {
                    for (String key : paramMap.keySet()) {
                        int indexOfKey = actualParamValue.indexOf(key);
                        WorkflowLogger.info("setAppParamsByRef:actualParamValue:key[" + key + "]");
                        WorkflowLogger.info("setAppParamsByRef:actualParamValue:indexOfKey[" + indexOfKey + "]");
                        while (indexOfKey != -1) {
                            if ("$PRFMR_CODE".equalsIgnoreCase(key) && ((String)paramMap.get(key) == null || paramMap.get(key).toString().length() == 0)) {
                                BaseLogger.log("3", null, null, "$PRFMR_CODE is found null");
                                actualParamValueBffr = actualParamValueBffr.replace(indexOfKey, indexOfKey + key.length(), "");
                                actualParamValue = null;
                                actualParamValue = actualParamValueBffr.toString();
                                WorkflowLogger.info(" $PRFMR_CODE setAppParamsByRef:actualParamValue:After if exist indexOfKey[" + actualParamValue + "]");
                                indexOfKey = actualParamValue.indexOf(key, indexOfKey);
                                BaseLogger.log("3", null, null, "@@@@ indexOfKey :[ " + indexOfKey + " ]");
                                continue;
                            }
                            if ("$USER_INFO".equalsIgnoreCase(actualParamValue) && "$USER_INFO".equalsIgnoreCase(key)) {
                                BaseLogger.log("3", null, null, "$USER_INFO is found:[" + userInfoStr + "]");
                                actualParamValue = null;
                                actualParamValue = userInfoStr;
                                indexOfKey = actualParamValue.indexOf(key, indexOfKey);
                                continue;
                            }
                            actualParamValueBffr = actualParamValueBffr.replace(indexOfKey, indexOfKey + key.length(), (String)paramMap.get(key));
                            actualParamValue = null;
                            actualParamValue = actualParamValueBffr.toString();
                            WorkflowLogger.info("setAppParamsByRef:actualParamValue:After if exist indexOfKey[" + actualParamValue + "]");
                            indexOfKey = actualParamValue.indexOf(key, indexOfKey);
                        }
                    }
                } else if (actualParamValue.indexOf("<Detail") != -1) {
                    WorkflowLogger.info("actualParamValue B4 [" + actualParamValue + "] ");
                    actualParamValue = this.customizeDataStr(actualParamValue, (String)paramMap.get("$XML_DATA_ALL"));
                    WorkflowLogger.info("actualParamValue After [" + actualParamValue + "] ");
                }
                int n = appParams.addParam(paramId, paramDataType, Integer.parseInt(formalParameter.getIndex()), formalParameter.getMode(), actualParamValue, "");
                ++paramCtr;
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
    }

    private ArrayList getActivitySpan(String processId, String instanceId, String activityId, String seqId) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.getActivitySpan.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        ArrayList<String> spanList = new ArrayList<String>();
        Connection con = null;
        Statement roleExprPStmt = null;
        try {
            try {
                Timestamp statusDate = null;
                Timestamp currDate = new Timestamp(System.currentTimeMillis());
                String query = "SELECT STATUS_DATE FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? AND SEQ_ID = ? ";
                con = new ConnDriver().getConnectDB(CommonConstants.WRKFLW_DB);
                roleExprPStmt = con.prepareStatement(query);
                roleExprPStmt.setString(1, processId);
                if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    roleExprPStmt.setInt(2, Integer.parseInt(instanceId));
                } else {
                    roleExprPStmt.setString(2, instanceId);
                }
                roleExprPStmt.setString(3, activityId);
                roleExprPStmt.setInt(4, Integer.parseInt(seqId));
                ResultSet statusDateRS = roleExprPStmt.executeQuery();
                if (statusDateRS.next()) {
                    statusDate = statusDateRS.getTimestamp(1);
                }
                if (statusDate != null) {
                    long diff = currDate.getTime() - statusDate.getTime();
                    float hrs = (float)diff / 3600000.0f;
                    float days = (float)diff / 8.64E7f;
                    WorkflowLogger.info("hrs Delay [" + hrs + "]");
                    WorkflowLogger.info("days Delay [" + days + "]");
                    spanList.add(new Float(hrs).toString());
                    spanList.add(new Float(days).toString());
                }
                statusDateRS.close();
                statusDateRS = null;
                roleExprPStmt.close();
                roleExprPStmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (roleExprPStmt != null) {
                    roleExprPStmt.close();
                    roleExprPStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        return spanList;
    }

    private ArrayList getActivitySpan(String processId, String instanceId, String activityId, String seqId, Connection con) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.getActivitySpan.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        ArrayList<String> spanList = new ArrayList<String>();
        Statement roleExprPStmt = null;
        try {
            try {
                Timestamp statusDate = null;
                Timestamp currDate = new Timestamp(System.currentTimeMillis());
                String query = "SELECT STATUS_DATE FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? AND SEQ_ID = ?";
                roleExprPStmt = con.prepareStatement(query);
                roleExprPStmt.setString(1, processId);
                if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    roleExprPStmt.setInt(2, Integer.parseInt(instanceId));
                } else {
                    roleExprPStmt.setString(2, instanceId);
                }
                roleExprPStmt.setString(3, activityId);
                roleExprPStmt.setInt(4, Integer.parseInt(seqId));
                ResultSet statusDateRS = roleExprPStmt.executeQuery();
                if (statusDateRS.next()) {
                    statusDate = statusDateRS.getTimestamp(1);
                }
                if (statusDate != null) {
                    long diff = currDate.getTime() - statusDate.getTime();
                    float hrs = (float)diff / 3600000.0f;
                    float days = (float)diff / 8.64E7f;
                    WorkflowLogger.info("hrs Delay [" + hrs + "]");
                    WorkflowLogger.info("days Delay [" + days + "]");
                    spanList.add(new Float(hrs).toString());
                    spanList.add(new Float(days).toString());
                }
                statusDateRS.close();
                statusDateRS = null;
                roleExprPStmt.close();
                roleExprPStmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (roleExprPStmt != null) {
                    roleExprPStmt.close();
                    roleExprPStmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        return spanList;
    }

    private String isEscalable(Activity activity) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.isEscalable.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String isEscalable = "false";
        try {
            Implementation implementation = (Implementation)activity.getImplementation();
            if (implementation != null) {
                List toolList = implementation.getTool();
                if (toolList != null) {
                    int noOfTool = toolList.size();
                    int toolCtr = 0;
                    while (toolCtr < noOfTool) {
                        ExtendedAttributesType extAttrType;
                        Tool tool = (Tool)toolList.get(toolCtr);
                        if (tool != null && (extAttrType = tool.getExtendedAttributes()) != null) {
                            List extendedAttributeList = extAttrType.getExtendedAttribute();
                            int noOfExtendedAttribute = extendedAttributeList.size();
                            WorkflowLogger.info("noOfExtendedAttribute [" + noOfExtendedAttribute + "]");
                            int extAttrCtr = 0;
                            while (extAttrCtr < noOfExtendedAttribute) {
                                ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                                WorkflowLogger.info("extendedAttribute.getName() [" + extendedAttribute.getName() + "]");
                                WorkflowLogger.info("extendedAttribute.getValue() [" + extendedAttribute.getValue() + "]");
                                if ("ESCALATE".equalsIgnoreCase(extendedAttribute.getName())) {
                                    isEscalable = extendedAttribute.getValue();
                                    WorkflowLogger.info("isEscalable [" + isEscalable + "]");
                                    break;
                                }
                                ++extAttrCtr;
                            }
                        }
                        ++toolCtr;
                    }
                } else {
                    WorkflowLogger.info("No ToolList defined.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        WorkflowLogger.info("returning isEscalable [" + isEscalable + "]");
        return isEscalable;
    }

    private Object getValueOfField(String dataString, String currFieldName, String currFieldType) throws BaseException {
        WorkflowLogger.info("WorkflowEngineEJB.Getting value of :[" + currFieldName + "] from dataString LENGTH :[" + dataString.length() + "]");
        Object fieldValue = null;
        Node currField = null;
        Document dom = null;
        boolean parseRetry = false;
        try {
            try {
                dom = this.parseString(dataString);
            }
            catch (SAXParseException saxe) {
                saxe.printStackTrace();
                WorkflowLogger.info("Exception :getValueOfField :parsingXMLString :==>\n" + saxe.getMessage());
                parseRetry = true;
            }
            if (parseRetry) {
                dom = this.parsingFile(dataString);
            }
            String currFieldValue = null;
            if (currFieldName.indexOf(".") != -1) {
                String detailName = currFieldName.substring(0, currFieldName.indexOf("."));
                String fieldName = currFieldName.substring(currFieldName.indexOf(".") + 1);
                NodeList detailNodeList = dom.getElementsByTagName(detailName).item(0).getChildNodes();
                int ctr = 0;
                while (ctr < detailNodeList.getLength()) {
                    Node currChild = detailNodeList.item(ctr);
                    if (currChild.getNodeName().equals(fieldName) && currChild.getFirstChild() != null) {
                        currField = currChild;
                    }
                    ++ctr;
                }
            } else {
                currField = dom.getElementsByTagName(currFieldName).item(0);
            }
            if (currField != null) {
                if (currField.getFirstChild() != null) {
                    currFieldValue = currField.getFirstChild().getNodeValue();
                }
                if (currFieldValue != null) {
                    fieldValue = currFieldType.equalsIgnoreCase("I") ? Integer.valueOf(currFieldValue.toString()) : (currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") ? Double.valueOf(currFieldValue.toString()) : currFieldValue);
                }
            }
        }
        catch (SAXParseException saxe) {
            WorkflowLogger.info("WorkflowEngineEJB[" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "] :Overlooking SAXParseException on getting value of :[" + currFieldName + "].....");
            saxe.printStackTrace();
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        WorkflowLogger.info("Returning value for field name :[" + currFieldName + "] value :[" + fieldValue + "]");
        return fieldValue;
    }

    private String customizeDataStr(String msgStr, String domString) throws Exception {
        String fieldValue = "";
        String replacedFieldValue = "";
        StringBuffer msgBuff = new StringBuffer();
        try {
            if (msgStr.indexOf("<") != -1) {
                StringTokenizer msgToken = new StringTokenizer(msgStr, ">");
                while (msgToken.hasMoreTokens()) {
                    String currMsgstr = msgToken.nextToken();
                    if (currMsgstr.indexOf("<") == -1) continue;
                    int startBracket = currMsgstr.indexOf("<");
                    msgBuff.append(currMsgstr.substring(0, startBracket));
                    fieldValue = currMsgstr.substring(startBracket + 1, currMsgstr.length());
                    replacedFieldValue = this.getValueOfFieldFromDom(domString, fieldValue);
                    msgBuff.append(replacedFieldValue);
                }
                if (!msgStr.endsWith(">")) {
                    String tempStr = msgStr.substring(msgStr.lastIndexOf(">") + 1, msgStr.length());
                    msgBuff.append(tempStr);
                }
            } else {
                msgBuff.append(msgStr);
            }
            WorkflowLogger.info(" msgBuff [" + msgBuff.toString() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgBuff.toString();
    }

    private String getValueOfFieldFromDom(String domStr, String fieldRequired) throws Exception {
        Object parentNode = null;
        Document dom = null;
        String childNodeName = null;
        Object childNodeName1 = null;
        String fieldValue = null;
        String fromNode = null;
        ArrayList taskList = new ArrayList();
        boolean parseRetry = false;
        try {
            try {
                dom = this.parseString(domStr);
            }
            catch (SAXParseException saxe) {
                saxe.printStackTrace();
                WorkflowLogger.info("Exception :getValueOfFieldFromDom :parsingXMLString :==>\n" + saxe.getMessage());
                parseRetry = true;
            }
            if (parseRetry) {
                dom = this.parsingFile(domStr);
            }
            if (fieldRequired.indexOf(".") != -1) {
                fromNode = fieldRequired.substring(0, fieldRequired.indexOf("."));
                fieldRequired = fieldRequired.substring(fieldRequired.indexOf(".") + 1, fieldRequired.length());
            } else {
                fromNode = fromNode == null ? "Detail1" : fromNode;
            }
            NodeList detailList = dom.getElementsByTagName(fromNode);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node currDetailNode = detailList.item(ctr);
                NodeList childList = currDetailNode.getChildNodes();
                int childCtr = childList.getLength();
                int chCnt = 0;
                while (chCnt < childCtr) {
                    Node childNode = childList.item(chCnt);
                    childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null) {
                        fieldValue = childNode.getFirstChild().getNodeValue().trim();
                        WorkflowLogger.info("fieldRequired [" + fieldRequired + "] fieldValue  [" + fieldValue + "]");
                    }
                    ++chCnt;
                }
                ++ctr;
            }
            fieldValue = fieldValue == null ? "" : fieldValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return fieldValue;
    }

    private Document parseString(String xmlString) throws Exception {
        Document dom = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            dom = genericUtility.parseString(xmlString);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return dom;
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        return ctx;
    }

    private boolean updateTransOnNullExp(String processId, String instanceId, String activityId, String objName, Connection con, String userInfoStr) throws Exception {
        BaseLogger.log("2", null, null, "updateTransOnNullExp is called...........");
        BufferedWriter logFileWriter = null;
        Statement pstmt = null;
        Statement pstmtTransetup = null;
        Statement pStmtDataInsQuery = null;
        String tranWindowName = "";
        String queryTransetup = "";
        ResultSet rsTransetup = null;
        Object oConnection = null;
        Document processInputParamDom = null;
        boolean isSuccess = false;
        try {
            if (userInfoStr != null && userInfoStr.length() > 0) {
                this.userInfo = new UserInfoBean(userInfoStr);
            }
            WorkflowLogger.info(" SELECT COUNT IN WF_PRC_DATA for Current Process_id [" + processId + "] instance Id [" + instanceId + "]");
            String query = "SELECT COUNT(1) AS CNT FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? ";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, processId);
            pstmt.setString(2, instanceId);
            ResultSet rs = pstmt.executeQuery();
            int cnt = -1;
            while (rs.next()) {
                cnt = rs.getInt("CNT");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            if (cnt == 2) {
                return true;
            }
            String delQuery = "DELETE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? ";
            pstmt = con.prepareStatement(delQuery);
            pstmt.setString(1, processId);
            pstmt.setString(2, instanceId);
            pstmt.executeUpdate();
            con.commit();
            WorkflowLogger.info("DELETED FROM WF_PRC_DATA ");
            pstmt.close();
            pstmt = null;
            delQuery = null;
            WorkflowLogger.info(" SELECT REF_SER, REF_ID FROM WF_PRC_STATUS STARTS");
            query = "SELECT REF_SER, REF_ID FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? ";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, processId);
            pstmt.setString(2, instanceId);
            pstmt.setString(3, activityId);
            rs = pstmt.executeQuery();
            String refSer = "";
            String refId = "";
            if (rs.next()) {
                refSer = rs.getString("REF_SER");
                refId = rs.getString("REF_ID");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            WorkflowLogger.info("REF_SER [" + refSer + "]");
            WorkflowLogger.info("REF_ID [" + refId + "]");
            String updtQuery = "";
            if (objName == null || objName.trim().length() == 0) {
                WorkflowLogger.info("Getting objname from the ref_ser if objName is null...");
                queryTransetup = "SELECT TRAN_WINDOW FROM TRANSETUP WHERE REF_SER=?";
                pstmtTransetup = con.prepareStatement(queryTransetup);
                pstmtTransetup.setString(1, refSer);
                rsTransetup = pstmtTransetup.executeQuery();
                if (rsTransetup.next()) {
                    tranWindowName = rsTransetup.getString("TRAN_WINDOW") == null ? "" : rsTransetup.getString("TRAN_WINDOW").trim();
                }
                rsTransetup.close();
                rsTransetup = null;
                pstmtTransetup.close();
                pstmtTransetup = null;
                objName = tranWindowName.substring(tranWindowName.indexOf("w_") + 2);
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName, this.userInfo);
            int noOfForms = objFormsDetailList.size();
            dbAccess = null;
            String metaDataFileName = String.valueOf(objName) + "21";
            DWFactory dws = new DWFactory(this.userInfo);
            DWObject dwObj = dws.getDataWindow(metaDataFileName);
            ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
            ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
            StringBuffer headerPKFieldNamesBuff = new StringBuffer();
            StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
            int i = 0;
            while (i < primaryKeyLogNameList.size()) {
                headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(":");
                headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":");
                ++i;
            }
            if (headerPKFieldNamesBuff.length() > 0) {
                headerPKFieldNamesBuff.deleteCharAt(headerPKFieldNamesBuff.length() - 1);
            }
            String headerPKFieldNames = headerPKFieldNamesBuff.toString();
            String headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();
            BaseLogger.log("3", null, null, "[WorkflowEngineEJB] Header primary key field names :[ " + headerPKFieldDataTypes + " ] noOfForms :[ " + noOfForms + " ]");
            BaseLogger.log("3", null, null, "[WorkflowEngineEJB] refId:[ " + refId + " ] objName:[ " + objName + " ] userInfo:[" + this.userInfo + "] refSer:[ " + refSer + " ] ");
            String tempDetailXMLStr = "";
            MasterDataStatefulEJB masterDataStateful = new MasterDataStatefulEJB();
            tempDetailXMLStr = masterDataStateful.getTransactionXMLForEdit(objName, "2", noOfForms, refId, headerPKFieldDataTypes, null, null, refSer, null);
            BaseLogger.log("3", null, null, "@@@@ tempDetailXMLStr[WorkflowEngine] before:[ " + tempDetailXMLStr + " ]");
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document dataDom = genericUtility.parseString(tempDetailXMLStr);
            Element docElement = null;
            Document xmlDataDom = dataDom;
            if (xmlDataDom != null) {
                docElement = xmlDataDom.getDocumentElement();
            }
            String inputParamXML = "<ProcessParam><XML_DATA_ALL>" + genericUtility.serializeDom(docElement, true) + "</XML_DATA_ALL>" + "<EDIT_FLAG>E</EDIT_FLAG>" + "</ProcessParam>";
            processInputParamDom = this.parseString(inputParamXML);
            NodeList processParamNodeList = processInputParamDom.getElementsByTagName("ProcessParam").item(0).getChildNodes();
            int noOfParams = processParamNodeList.getLength();
            String statusString = "";
            int statusCnt = 0;
            int processParamCtr = 0;
            while (processParamCtr < noOfParams) {
                String prcDataInsQuery;
                Node currParam = processParamNodeList.item(processParamCtr);
                String argumentValue = genericUtility.serializeDom(currParam.getFirstChild());
                String argumentId = currParam.getNodeName();
                argumentId = "$" + argumentId;
                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    WorkflowLogger.info("Using mssql with binary stream");
                    prcDataInsQuery = "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE) VALUES(?,?,?,?)";
                    pStmtDataInsQuery = con.prepareStatement(prcDataInsQuery);
                    pStmtDataInsQuery.setString(1, processId);
                    pStmtDataInsQuery.setString(2, instanceId);
                    pStmtDataInsQuery.setString(3, argumentId);
                    byte[] encoded = argumentValue.getBytes();
                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                    pStmtDataInsQuery.setBinaryStream(4, byteArrayIn, byteArrayIn.available());
                    int noOfRows = pStmtDataInsQuery.executeUpdate();
                    BaseLogger.log("3", null, null, "noOfRows[" + noOfRows + "]");
                    statusString = noOfRows > 0 ? "true" : "false";
                    pStmtDataInsQuery.close();
                    pStmtDataInsQuery = null;
                } else {
                    BaseLogger.log("3", null, null, "@@@@ argumentValue :[ " + argumentValue + " ]");
                    prcDataInsQuery = "";
                    if (argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                        prcDataInsQuery = "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE,ARGUMENT_VALUE_XML) VALUES(?,?,?,EMPTY_BLOB(),XMLType(?))";
                    } else if (argumentId.equalsIgnoreCase("$EDIT_FLAG")) {
                        prcDataInsQuery = "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE) VALUES(?,?,?,EMPTY_BLOB())";
                    }
                    pStmtDataInsQuery = con.prepareStatement(prcDataInsQuery);
                    pStmtDataInsQuery.setString(1, processId);
                    pStmtDataInsQuery.setString(2, instanceId);
                    pStmtDataInsQuery.setString(3, argumentId);
                    if (argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                        CLOB xmlData = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                        xmlData.putString(1L, argumentValue);
                        pStmtDataInsQuery.setClob(4, (Clob)xmlData);
                    }
                    int noOfRows = pStmtDataInsQuery.executeUpdate();
                    BaseLogger.log("3", null, null, "noOfRows[" + noOfRows + "]");
                    statusString = noOfRows > 0 ? "true" : "false";
                    pStmtDataInsQuery.close();
                    pStmtDataInsQuery = null;
                }
                if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME) && argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                    query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID=? FOR UPDATE NOWAIT";
                    ArrayList<String> bindVarValues = new ArrayList<String>();
                    bindVarValues.add(processId);
                    bindVarValues.add(instanceId);
                    bindVarValues.add(argumentId);
                    ArrayList<String> bindVarTypes = new ArrayList<String>();
                    bindVarTypes.add("String");
                    bindVarTypes.add("String");
                    bindVarTypes.add("String");
                    WorkflowLogger.info("Updating Workflow data for Process Id :[" + processId + "] Instance Id :[" + instanceId + "]");
                    WorkflowLogger.info("Argument Id :[" + argumentId + "] Argument Value :[" + argumentValue + "]");
                    boolean updStatus = this.updateBlob(con, query, argumentValue, bindVarValues, bindVarTypes);
                    WorkflowLogger.info("saveProcessInputData:updStatus[" + updStatus + "]");
                    String string = statusString = updStatus ? "true" : "false";
                }
                if ("true".equalsIgnoreCase(statusString)) {
                    ++statusCnt;
                }
                ++processParamCtr;
            }
            if (statusCnt == noOfParams) {
                return true;
            }
            WorkflowLogger.info(" UPDATE QUERY STARTS");
            if ("P-ORD".equalsIgnoreCase(refSer)) {
                updtQuery = " UPDATE PORDER SET STATUS='O' WHERE PURC_ORDER = ? ";
            } else if ("S-ORD".equalsIgnoreCase(refSer)) {
                updtQuery = " UPDATE SORDER SET WORKFLOW_STATUS='O' WHERE SALE_ORDER = ? ";
            } else if ("P-AMD".equalsIgnoreCase(refSer)) {
                updtQuery = " UPDATE POAMD_HDR SET STATUS= '0' WHERE AMD_NO = ? ";
            } else if ("S-AMD".equalsIgnoreCase(refSer)) {
                updtQuery = " UPDATE SORDAMD SET ORDER_STATUS='0' WHERE AMD_NO = ? ";
            }
            if (updtQuery == null || updtQuery.length() == 0) {
                return true;
            }
            try {
                pstmt = con.prepareStatement(updtQuery);
                pstmt.setString(1, refId);
                pstmt.executeUpdate();
                con.commit();
                WorkflowLogger.info(" UPDATED [" + updtQuery + "]");
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmtTransetup != null) {
                    pstmtTransetup.close();
                    pstmtTransetup = null;
                }
                if (pStmtDataInsQuery != null) {
                    pStmtDataInsQuery.close();
                    pStmtDataInsQuery = null;
                }
                if (oConnection != null) {
                    oConnection.close();
                    oConnection = null;
                }
                if (logFileWriter != null) {
                    logFileWriter.flush();
                    logFileWriter.close();
                    logFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logFileWriter = null;
            }
        }
        return isSuccess;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws BaseException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    } else {
                        dataByteArray = dataStr.getBytes();
                    }
                    WorkflowLogger.info("blobOutputStream :[" + blobOutputStream + "]");
                    WorkflowLogger.info("dataByteArray :[" + dataByteArray + "]");
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :WorkflowProcessDataManger :updateBlob :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return updStatus;
    }

    private boolean checkActivityStatus(String processInstanceId, String processStatus, Connection con) throws BaseException {
        Statement stmt = null;
        boolean isComplete = false;
        try {
            try {
                stmt = con.createStatement();
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                String prcStatusSelQry = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS  WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + Integer.parseInt(instanceId) + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID=" + Integer.parseInt(seqId) + " ";
                WorkflowLogger.info("checkActivityStatus:prcStatusSelQry[" + prcStatusSelQry + "]");
                ResultSet rs = stmt.executeQuery(prcStatusSelQry);
                if (rs.next()) {
                    int prcStatus = rs.getInt(1);
                    if (prcStatus == 3 && processStatus.equals("2")) {
                        isComplete = true;
                    }
                    rs.close();
                    rs = null;
                    stmt.close();
                    stmt = null;
                }
            }
            catch (BaseException be) {
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning Process Exists Status :[" + isComplete + "]");
        return isComplete;
    }

    private Document parsingFile(String writeFileString) throws BaseException {
        BufferedWriter parseFileWriter = null;
        Document dom = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                double randomNo = Math.random();
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").createNewFile();
                }
                String parseFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml";
                WorkflowLogger.info("writeParsingFile:parseFileName[" + parseFileName + "]");
                parseFileWriter = new BufferedWriter(new FileWriter(parseFileName));
                parseFileWriter.write(writeFileString);
                parseFileWriter.flush();
                parseFileWriter.close();
                parseFileWriter = null;
                dom = genericUtility.parseFile(parseFileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                dom = null;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (parseFileWriter != null) {
                    parseFileWriter.flush();
                    parseFileWriter.close();
                    parseFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parseFileWriter = null;
            }
        }
        return dom;
    }

    private Document parseXMLFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        try {
            File file = null;
            file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            dom = parser.parse(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            dom = null;
            WorkflowLogger.info("Exception :WorkflowEngineEJB :parseFile :\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    private void updateEvaluationDetails(String processId, int instanceId, String activityId, boolean isEvaluate, Transition transition, int seqId, ArrayList activityIdList, Connection con) {
        Statement pstmt = null;
        boolean isLocalConnection = false;
        try {
            try {
                String exprToEval = null;
                String evaluationDetail = "";
                if (transition != null) {
                    Condition condition = (Condition)transition.getCondition();
                    if (condition != null) {
                        List exprToEvalList = condition.getContent();
                        exprToEval = (String)exprToEvalList.get(0);
                    }
                    WorkflowLogger.info("WorkflowEngineEJB:updateEvaluationDetails:exprToEval[" + exprToEval + "]");
                    evaluationDetail = "Expression To Evaluate = " + exprToEval + " Evaluation Result = " + isEvaluate + "Next Activity = " + activityIdList;
                    if (evaluationDetail != null && evaluationDetail.length() > 1000) {
                        evaluationDetail = evaluationDetail.substring(0, 999);
                    }
                } else {
                    evaluationDetail = "Transition is null";
                }
                String updateEvalDetail = "UPDATE WF_PRC_STATUS SET EVAL_DETAIL=? WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? AND SEQ_ID=?";
                pstmt = con.prepareStatement(updateEvalDetail);
                pstmt.setString(1, evaluationDetail);
                pstmt.setString(2, processId);
                pstmt.setInt(3, instanceId);
                pstmt.setString(4, activityId);
                pstmt.setInt(5, seqId);
                pstmt.executeUpdate();
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateTransWfStatus(String processId, String instanceId, String statusMsgStr, Connection conn) throws BaseException {
        this.updateTransWfStatus(processId, instanceId, statusMsgStr, conn, "");
    }

    public void updateTransWfStatus(String processId, String instanceId, String statusMsgStr, Connection conn, String compActivityId) throws BaseException {
        Statement pStmtWfPrcStatus = null;
        Statement pstmtTransetup = null;
        Statement pStmtTrasactionUpd = null;
        ResultSet rsTransetup = null;
        ResultSet rsWfPrcStatus = null;
        String wfStatus = "";
        String tableName = "";
        String tranIdCol = "";
        String objName = "";
        String refId = "";
        Date startTime = new Date();
        try {
            try {
                BaseLogger.log("3", null, null, "CommonConstants.WRKFLW_DB:[" + CommonConstants.WRKFLW_DB + "]");
                if (conn == null) {
                    throw new ITMException(new Exception("Connection is null in updateTransWfStatus method of WorkflowEngineEJB."));
                }
                String sqlWfPrcStatus = "SELECT OBJ_NAME , REF_ID FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID =? ";
                pStmtWfPrcStatus = conn.prepareStatement(sqlWfPrcStatus);
                pStmtWfPrcStatus.setString(1, processId);
                pStmtWfPrcStatus.setInt(2, Integer.parseInt(instanceId));
                rsWfPrcStatus = pStmtWfPrcStatus.executeQuery();
                if (rsWfPrcStatus.next()) {
                    objName = rsWfPrcStatus.getString("OBJ_NAME");
                    refId = rsWfPrcStatus.getString("REF_ID");
                }
                pStmtWfPrcStatus.close();
                pStmtWfPrcStatus = null;
                rsWfPrcStatus.close();
                rsWfPrcStatus = null;
                String sqlTransetup = "SELECT TABLE_NAME , WF_STATUS , TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_" + objName + "'";
                pstmtTransetup = conn.prepareStatement(sqlTransetup);
                rsTransetup = pstmtTransetup.executeQuery();
                if (rsTransetup.next()) {
                    tableName = rsTransetup.getString("TABLE_NAME") != null ? rsTransetup.getString("TABLE_NAME") : "";
                    wfStatus = rsTransetup.getString("WF_STATUS") != null ? rsTransetup.getString("WF_STATUS") : "";
                    tranIdCol = rsTransetup.getString("TRAN_ID_COL") != null ? rsTransetup.getString("TRAN_ID_COL") : "";
                }
                pstmtTransetup.close();
                pstmtTransetup = null;
                rsTransetup.close();
                rsTransetup = null;
                BaseLogger.log("3", null, null, "wfStatus:[" + wfStatus + "]");
                BaseLogger.log("3", null, null, "tableName:[" + tableName + "]");
                BaseLogger.log("3", null, null, "tranIdCol:[" + tranIdCol + "]");
                BaseLogger.log("3", null, null, "statusMsgStr:[" + statusMsgStr + "]");
                if (tableName.trim().length() > 0 && wfStatus.trim().length() > 0 && tranIdCol.trim().length() > 0) {
                    String sqlTrasactionUpd = "UPDATE " + tableName + " SET " + wfStatus + "= '" + statusMsgStr + "' WHERE " + tranIdCol + "= '" + refId + "'";
                    pStmtTrasactionUpd = conn.prepareStatement(sqlTrasactionUpd);
                    int updateCnt = pStmtTrasactionUpd.executeUpdate();
                    BaseLogger.log("3", null, null, "updateCnt:[" + updateCnt + "]");
                    if (updateCnt > 0) {
                        BaseLogger.log("3", null, null, "Updated obj_name : [ " + objName + " ] and transaction id : [ " + refId + " ] with workflow status :[ " + statusMsgStr + " ]");
                    } else {
                        BaseLogger.log("3", null, null, "Update failed obj_name : [ " + objName + " ] and transaction id : [ " + refId + " ] with workflow status :[ " + statusMsgStr + " ]");
                    }
                    if (pStmtTrasactionUpd != null) {
                        pStmtTrasactionUpd.close();
                        pStmtTrasactionUpd = null;
                    }
                } else {
                    BaseLogger.log("3", null, null, "Update failed obj_name : [ " + objName + " ] and transaction id : [ " + refId + " ] with workflow status :[ " + statusMsgStr + " ]");
                }
                String userCode = "SYSTEM";
                String sessionId = "NA";
                if (this.userInfo != null) {
                    userCode = this.userInfo.getLoginCode();
                    sessionId = this.userInfo.getSesstionId();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmtTrasactionUpd != null) {
                    pStmtTrasactionUpd.close();
                    pStmtTrasactionUpd = null;
                }
                if (pstmtTransetup != null) {
                    pstmtTransetup.close();
                    pstmtTransetup = null;
                }
                if (pStmtWfPrcStatus != null) {
                    pStmtWfPrcStatus.close();
                    pStmtWfPrcStatus = null;
                }
                if (rsWfPrcStatus != null) {
                    rsWfPrcStatus.close();
                    rsWfPrcStatus = null;
                }
                if (rsTransetup != null) {
                    rsTransetup.close();
                    rsTransetup = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :WorkflowEngineEJB :updateTransWfStatus :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
    }

    public boolean isErrorTypeFound(String errorXmlString) throws BaseException {
        Document dom = null;
        ArrayList msgTypeList = new ArrayList();
        boolean isError = false;
        try {
            dom = this.parseString(errorXmlString);
            NodeList parentList = dom.getElementsByTagName("error");
            int parentNodeListLength = parentList.getLength();
            BaseLogger.log("3", null, null, "parentNodeListLength[" + parentNodeListLength + "]");
            int prntCtr = 0;
            while (prntCtr < parentNodeListLength) {
                String attributeValue = "";
                Node parentNode = parentList.item(prntCtr);
                if (parentNode != null && parentNode.getAttributes().getNamedItem("type") != null) {
                    attributeValue = parentNode.getAttributes().getNamedItem("type").getNodeValue();
                }
                if (attributeValue != null && "E".equalsIgnoreCase(attributeValue)) {
                    isError = true;
                    break;
                }
                ++prntCtr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
        WorkflowLogger.info("returning from [isErrorFound] isError [" + isError + "]");
        return isError;
    }
}

