/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.w3c.dom.Document;

public class InternalLogger {
    public static Logger internalSysLogger = null;
    public static String logSeparator = "~";
    public static String JBOSSHOME = "";

    static {
        System.out.println("In InternalLogger Static Block..................");
        try {
            String filename = "/IBASEHOME" + File.separator + "ibase.xml";
            File fileObj = new File(filename);
            if (!fileObj.exists()) {
                if (!fileObj.getParentFile().exists()) {
                    fileObj.getParentFile().mkdirs();
                }
                CommonConstants.createDefIBASEHOME(fileObj);
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(filename);
            JBOSSHOME = document.getElementsByTagName("JBOSSHOME").item(0).getFirstChild().getNodeValue();
            System.out.println("In InternalLogger Static Block JBOSSHOME:[" + JBOSSHOME + "]");
        }
        catch (Exception e) {
            System.out.println("Exception:[" + e + "]");
        }
        try {
            internalSysLogger = Logger.getLogger((String)"InternalLogger");
            internalSysLogger.setLevel(Level.DEBUG);
            InternalLogger.initializeLogger(internalSysLogger, "internalSysLogger", "internalSys");
        }
        catch (Exception e) {
            System.out.println("Exception in InternalLogger static block:[" + e.getMessage() + "]");
        }
    }

    public static void initializeLogger(Logger logger, String loggerPropFileName, String loggerOutputFileName) {
        try {
            String propFileDir = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "configuration" + File.separator + loggerPropFileName + ".properties";
            System.out.println("propFileDir:[" + propFileDir + "]");
            File propFile = new File(propFileDir);
            if (propFile.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(propFile));
                System.out.println(String.valueOf(loggerPropFileName) + " properties:[" + properties.toString() + "]");
                String layout = properties.getProperty("layout").trim();
                String appender = properties.getProperty("appender").trim();
                String ConversionPattern = properties.getProperty("ConversionPattern");
                String level = properties.getProperty("level");
                logSeparator = properties.getProperty("logSeparator");
                LevelRangeFilter logFilter = new LevelRangeFilter();
                logFilter.setLevelMin(Level.toLevel((String)level));
                logFilter.setLevelMax(Level.toLevel((String)level));
                logFilter.setAcceptOnMatch(true);
                if (layout.equalsIgnoreCase("HTMLLayout")) {
                    HTMLLayout htmlLayout = new HTMLLayout();
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".html";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)htmlLayout, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)htmlLayout, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)htmlLayout, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                } else if (layout.equalsIgnoreCase("PatternLayout")) {
                    PatternLayout pattern = new PatternLayout(ConversionPattern);
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".log";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)pattern, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)pattern, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)pattern, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                } else if (layout.equalsIgnoreCase("JSONLayout")) {
                    PatternLayout pattern = new PatternLayout(ConversionPattern);
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".json";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)pattern, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)pattern, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)pattern, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in initializeLogger :[" + e.getMessage() + "]");
        }
    }

    public static void log(String debugLevel, UserInfoBean userInfo, String componentId, Object msg) {
        debugLevel = "".equals(debugLevel = E12GenericUtility.checkNull(debugLevel)) ? "0" : debugLevel;
        int debugLev = Integer.parseInt(debugLevel);
        String ibaseDebugLevel = E12GenericUtility.checkNull(CommonConstants.DEBUG_LEVEL);
        ibaseDebugLevel = "".equals(ibaseDebugLevel) ? "0" : ibaseDebugLevel;
        int ibaseDebugLev = Integer.parseInt(ibaseDebugLevel);
        String userId = "NA";
        if (userInfo != null) {
            userId = userInfo.getLoginCode();
        }
        String editorId = "NA";
        if (!"".equals(E12GenericUtility.checkNull(componentId))) {
            editorId = componentId;
        }
        if (debugLev <= ibaseDebugLev || ibaseDebugLev == -1) {
            String className = "";
            String methodName = "";
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
            }
            String msgInfo = String.valueOf(userId) + logSeparator + editorId + logSeparator + className + logSeparator + methodName + logSeparator + msg;
            internalSysLogger.debug((Object)msgInfo);
            if (ibaseDebugLev == -1) {
                System.out.println(msgInfo);
            }
        }
    }
}

