/*
 * Decompiled with CFR 0.152.
 */
package ibase.ai.entityid;

import ibase.ai.entityid.ItemUOM;
import ibase.bis.utility.BISDictionary;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ItemLookUp {
    public JSONObject itemCodeLookUp(JSONObject extractedObj, String[] procMethods, UserInfoBean userInfo) throws ITMException {
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        Statement pstmtCnt = null;
        ResultSet rsCnt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, ArrayList<String>> itemTypeHM = new HashMap<String, ArrayList<String>>();
        ItemUOM itemUOM = new ItemUOM();
        try {
            try {
                BaseLogger.log("3", null, null, "ItemLookUp START [" + System.currentTimeMillis() + "]");
                JSONObject prodIdentificationObj = new JSONObject();
                BISDictionary bis = new BISDictionary();
                prodIdentificationObj = bis.getProductIdentificationAlias(userInfo);
                BaseLogger.log("3", null, null, "ItemLookUp prodIdentificationObj[" + prodIdentificationObj + "]");
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                JSONArray linesArray = extractedObj.optJSONArray("lines");
                int i = 0;
                while (i < linesArray.length()) {
                    boolean permutation = false;
                    JSONObject lineObj = linesArray.optJSONObject(i);
                    if (lineObj != null && lineObj.length() > 0) {
                        String phyAttr4;
                        String phyAttr3;
                        String phyAttr2;
                        boolean permutationPending = true;
                        String itemType = "ZFPK";
                        lineObj.put("item_code", (Object)"");
                        lineObj.put("phy_attrib_1", (Object)"");
                        lineObj.put("phy_attrib_2", (Object)"");
                        lineObj.put("phy_attrib_3", (Object)"");
                        lineObj.put("phy_attrib_4", (Object)"");
                        lineObj.put("stan_qty", (Object)"");
                        lineObj.put("unit", (Object)"");
                        String phyAttr1 = this.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_1"), "phy_attrib_1", lineObj.optString("extract_phy_attrib_1"));
                        if ("".equals(phyAttr1)) {
                            phyAttr1 = this.checkNull(lineObj.optString("extract_phy_attrib_1"));
                        }
                        if ("".equals(phyAttr2 = this.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_2"), "phy_attrib_2", lineObj.optString("extract_phy_attrib_1")))) {
                            phyAttr2 = this.checkNull(lineObj.optString("extract_phy_attrib_2"));
                        }
                        if ("".equals(phyAttr3 = this.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_3"), "phy_attrib_3", lineObj.optString("extract_phy_attrib_1")))) {
                            phyAttr3 = this.checkNull(lineObj.optString("extract_phy_attrib_3"));
                        }
                        if ("".equals(phyAttr4 = this.checkNull(lineObj.optString("extract_phy_attrib_4"))) || "0".equalsIgnoreCase(phyAttr4) || "NA".equalsIgnoreCase(phyAttr4)) {
                            phyAttr4 = this.getValueForAlias(prodIdentificationObj, lineObj.optString("packing"), "phy_attrib_4", lineObj.optString("extract_phy_attrib_1"));
                            if ("".equals(phyAttr4)) {
                                phyAttr4 = this.checkNull(lineObj.optString("packing"));
                            }
                        } else {
                            phyAttr4 = this.getValueForAlias(prodIdentificationObj, lineObj.optString("extract_phy_attrib_4"), "phy_attrib_4", lineObj.optString("extract_phy_attrib_1"));
                            if ("".equals(phyAttr4)) {
                                phyAttr4 = this.checkNull(lineObj.optString("extract_phy_attrib_4"));
                            }
                        }
                        int permutationCnt = 6;
                        int count = 0;
                        while (permutationPending) {
                            if (permutationCnt == 0) {
                                permutationPending = false;
                            }
                            StringBuffer condition = new StringBuffer();
                            condition.append("PHY_ATTRIB_1=? ");
                            if (permutationCnt >= 3) {
                                condition.append("AND PHY_ATTRIB_2=? ");
                            }
                            if (permutationCnt == 5 || permutationCnt == 6 || permutationCnt == 1) {
                                condition.append("AND PHY_ATTRIB_3=? ");
                            }
                            if (permutationCnt == 6 || permutationCnt == 4 || permutationCnt == 2) {
                                condition.append("AND PHY_ATTRIB_4=?");
                            }
                            condition.append("AND ACTIVE=? ");
                            String cntSQL = "SELECT COUNT(*) AS COUNT FROM ITEM WHERE " + condition.toString();
                            pstmtCnt = conn.prepareStatement(cntSQL);
                            int indexCnt = 1;
                            pstmtCnt.setString(indexCnt, phyAttr1);
                            if (permutationCnt >= 3) {
                                pstmtCnt.setString(++indexCnt, phyAttr2);
                            }
                            if (permutationCnt == 5 || permutationCnt == 6 || permutationCnt == 1) {
                                pstmtCnt.setString(++indexCnt, phyAttr3);
                            }
                            if (permutationCnt == 6 || permutationCnt == 4 || permutationCnt == 2) {
                                pstmtCnt.setString(++indexCnt, phyAttr4);
                            }
                            pstmtCnt.setString(++indexCnt, "Y");
                            rsCnt = pstmtCnt.executeQuery();
                            if (rsCnt.next()) {
                                count = rsCnt.getInt("COUNT");
                                BaseLogger.log("3", null, null, "ItemLookUp count [" + count + "] permutationCnt [" + permutationCnt + "]");
                                if (count > 1) {
                                    condition.append("AND PHY_ATTRIB_5 IS NOT NULL ");
                                }
                                if (count >= 1) {
                                    String sql = "SELECT ITEM_CODE, DESCR, ITEM_TYPE, PHY_ATTRIB_1, PHY_ATTRIB_2, PHY_ATTRIB_3, PHY_ATTRIB_4, UNIT, PHY_ATTRIB_5 FROM ITEM WHERE " + condition.toString() + "ORDER BY PHY_ATTRIB_5";
                                    pstmt = conn.prepareStatement(sql);
                                    int index = 1;
                                    pstmt.setString(index, phyAttr1);
                                    if (permutationCnt >= 3) {
                                        pstmt.setString(++index, phyAttr2);
                                    }
                                    if (permutationCnt == 5 || permutationCnt == 6 || permutationCnt == 1) {
                                        pstmt.setString(++index, phyAttr3);
                                    }
                                    if (permutationCnt == 6 || permutationCnt == 4 || permutationCnt == 2) {
                                        pstmt.setString(++index, phyAttr4);
                                    }
                                    pstmt.setString(++index, "Y");
                                    rs = pstmt.executeQuery();
                                    if (rs.next()) {
                                        permutationPending = false;
                                        lineObj.put("system_item_code", (Object)this.checkNull(rs.getString("ITEM_CODE")));
                                        lineObj.put("system_item_descr", (Object)this.checkNull(rs.getString("DESCR")));
                                        if ("".equalsIgnoreCase(this.checkNull(lineObj.optString("descr")))) {
                                            lineObj.put("descr", (Object)this.checkNull(rs.getString("DESCR")));
                                        }
                                        itemType = this.checkNull(rs.getString("ITEM_TYPE"));
                                        lineObj.put("phy_attrib_1", (Object)this.checkNull(rs.getString("PHY_ATTRIB_1")));
                                        lineObj.put("phy_attrib_2", (Object)this.checkNull(rs.getString("PHY_ATTRIB_2")));
                                        lineObj.put("phy_attrib_3", (Object)this.checkNull(rs.getString("PHY_ATTRIB_3")));
                                        lineObj.put("phy_attrib_4", (Object)this.checkNull(rs.getString("PHY_ATTRIB_4")));
                                        lineObj.put("unit", (Object)this.checkNull(rs.getString("UNIT")));
                                    }
                                    if (pstmt != null) {
                                        pstmt.close();
                                        pstmt = null;
                                    }
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                }
                            }
                            if (pstmtCnt != null) {
                                pstmtCnt.close();
                                pstmtCnt = null;
                            }
                            if (rsCnt != null) {
                                rsCnt.close();
                                rsCnt = null;
                            }
                            --permutationCnt;
                        }
                        if (!"".equalsIgnoreCase(this.checkNull(lineObj.optString("vector_item_code")))) {
                            lineObj.put("item_code", (Object)this.checkNull(lineObj.optString("vector_item_code")));
                            lineObj.put("item_code__ord", (Object)this.checkNull(lineObj.optString("vector_item_code")));
                            String unit = this.getItemUnit(lineObj.optString("vector_item_code"), conn);
                            lineObj.put("unit", (Object)unit);
                            String descr = "";
                            if (!lineObj.optString("vector_item_code").equalsIgnoreCase(lineObj.optString("system_item_code"))) {
                                descr = this.getItemDescr(lineObj.optString("vector_item_code"), conn);
                            }
                            lineObj.put("descr", (Object)descr);
                        } else {
                            lineObj.put("item_code", (Object)this.checkNull(lineObj.optString("system_item_code")));
                            lineObj.put("item_code__ord", (Object)this.checkNull(lineObj.optString("system_item_code")));
                        }
                        int quantity = lineObj.optInt("quantity");
                        int standardQty = 0;
                        if (lineObj.has("packing") && "UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                            String unitFR = this.getValueForAlias(prodIdentificationObj, lineObj.optString("packing"), "", lineObj.optString("extract_phy_attrib_1"));
                            if ("".equals(unitFR)) {
                                unitFR = lineObj.optString("packing");
                            }
                            String itemCode = !"".equalsIgnoreCase(this.checkNull(lineObj.optString("vector_item_code"))) ? this.checkNull(lineObj.optString("vector_item_code")) : this.checkNull(lineObj.optString("item_code"));
                            standardQty = itemUOM.getStandardQuantity(quantity, itemCode, unitFR, conn);
                        }
                        lineObj.put("stan_qty", standardQty);
                        if (!"".equalsIgnoreCase(this.checkNull(itemType)) && !itemTypeHM.containsKey(itemType)) {
                            ArrayList<String> itemTypeList = this.setPhyAttributeLbl(itemType, conn);
                            itemTypeHM.put(itemType, itemTypeList);
                        }
                        if (itemTypeHM.containsKey(itemType)) {
                            ArrayList itemTypeList = (ArrayList)itemTypeHM.get(itemType);
                            int lblCnt = 0;
                            for (String label : itemTypeList) {
                                lineObj.put("phy_attr_lbl_" + (lblCnt + 1), itemTypeList.get(lblCnt));
                                ++lblCnt;
                            }
                        }
                        if ("".equalsIgnoreCase(this.checkNull(lineObj.optString("stan_qty"))) || "0".equalsIgnoreCase(this.checkNull(lineObj.optString("stan_qty")))) {
                            lineObj.put("stan_qty", (Object)this.checkNull(lineObj.optString("quantity")));
                        }
                        if ("".equalsIgnoreCase(this.checkNull(lineObj.optString("descr")))) {
                            lineObj.put("descr", (Object)this.checkNull(lineObj.optString("extract_descr")));
                        }
                    }
                    ++i;
                }
                BaseLogger.log("3", null, null, "ItemLookUp END [" + System.currentTimeMillis() + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ItemLookUp ::itemCodeLookUp:::catch==>" + e);
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmtCnt != null) {
                        pstmtCnt.close();
                        pstmtCnt = null;
                    }
                    if (rsCnt != null) {
                        rsCnt.close();
                        rsCnt = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :ItemLookUp ::itemCodeLookUp:::finally==>" + e2);
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtCnt != null) {
                    pstmtCnt.close();
                    pstmtCnt = null;
                }
                if (rsCnt != null) {
                    rsCnt.close();
                    rsCnt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ItemLookUp ::itemCodeLookUp:::finally==>" + e);
            }
        }
        return extractedObj;
    }

    public ArrayList<String> setPhyAttributeLbl(String itemType, Connection conn) {
        ArrayList<String> itemTypeList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "SELECT PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4 FROM ITEM_TYPE WHERE ITEM_TYPE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, itemType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    itemTypeList.add(this.checkNull(rs.getString("PHY_ATTRIB_1")));
                    itemTypeList.add(this.checkNull(rs.getString("PHY_ATTRIB_2")));
                    itemTypeList.add(this.checkNull(rs.getString("PHY_ATTRIB_3")));
                    itemTypeList.add(this.checkNull(rs.getString("PHY_ATTRIB_4")));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ItemLookUp ::setPhyAttributes:::==>" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :ItemLookUp ::setPhyAttributes:::finally==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ItemLookUp ::setPhyAttributes:::finally==>" + e);
            }
        }
        return itemTypeList;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public int updateItemCode(UserInfoBean userInfo, JSONObject jsonObj) throws ITMException {
        Statement pst = null;
        ResultSet rset = null;
        Connection con = null;
        int insertCount = 0;
        int count = 0;
        String chgUser = "";
        String chgTerm = "";
        String itemUsage = "C";
        String itemSer = "EN";
        ConnDriver connDriver = new ConnDriver();
        chgUser = userInfo.getLoginCode();
        chgTerm = userInfo.getRemoteHostName();
        try {
            try {
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                con = connDriver.getConnectDB(userInfo.getTransDB());
                Iterator iterator = jsonObj.keys();
                String key = null;
                String value = "";
                while (iterator.hasNext()) {
                    key = (String)iterator.next();
                    value = jsonObj.getString(key);
                    JSONObject object = new JSONObject(value);
                    String itemCode = object.optString("item_code");
                    String descr = object.optString("descr");
                    String itemType = object.optString("packing");
                    String phyAttr1 = object.optString("phy_attrib_1");
                    String phyAttr2 = object.optString("phy_attrib_2");
                    String phyAttr3 = object.optString("phy_attrib_3");
                    String phyAttr4 = object.optString("phy_attrib_4");
                    String sql = "SELECT COUNT(*) AS COUNT FROM ITEM WHERE ITEM_CODE=?";
                    pst = con.prepareStatement(sql);
                    pst.setString(1, itemCode);
                    rset = pst.executeQuery();
                    if (rset.next()) {
                        count = rset.getInt("COUNT");
                    }
                    rset.close();
                    rset = null;
                    pst.close();
                    pst = null;
                    BaseLogger.log("3", userInfo, null, " Inside updateOrInsertUOM....count[" + count + "]");
                    if (count > 0) continue;
                    String insertSql = "Insert into ITEM (ITEM_CODE,DESCR,ITEM_SER,CHG_DATE,CHG_USER,CHG_TERM,ITEM_USAGE,PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4,ITEM_TYPE)values (?,?,?,?,?,?,?,?,?,?,?,?)";
                    BaseLogger.log("3", userInfo, null, " Inside updateOrInsertUOM....insertSql[" + insertSql + "]");
                    pst = con.prepareStatement(insertSql);
                    pst.setString(1, itemCode);
                    pst.setString(2, descr);
                    pst.setString(3, itemSer);
                    pst.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    pst.setString(5, chgUser);
                    pst.setString(6, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pst.setString(7, itemUsage);
                    pst.setString(8, phyAttr1);
                    pst.setString(9, phyAttr2);
                    pst.setString(10, phyAttr3);
                    pst.setString(11, phyAttr4);
                    pst.setString(12, itemType);
                    insertCount = pst.executeUpdate();
                    if (insertCount > 0) {
                        con.commit();
                    }
                    if (pst == null) continue;
                    pst.close();
                    pst = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("2", userInfo, null, "ItemLookUp updateItemCode Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
                if (rset != null) {
                    rset.close();
                    rset = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("2", userInfo, null, "ItemLookUp updateItemCode finally Exception : [" + E12GenericUtility.getStackTrace(e2) + "]");
                throw new ITMException(e2);
            }
        }
        return insertCount;
    }

    public String getValueForAlias(JSONObject prodIdentificationObj, String phrase, String bisEntityID, String applScope) {
        String value = "";
        if (prodIdentificationObj.has(String.valueOf(phrase) + "_" + bisEntityID + "_" + applScope)) {
            value = this.checkNull(prodIdentificationObj.optString(String.valueOf(phrase) + "_" + bisEntityID + "_" + applScope));
        } else if (prodIdentificationObj.has(String.valueOf(phrase) + "_" + bisEntityID)) {
            value = this.checkNull(prodIdentificationObj.optString(String.valueOf(phrase) + "_" + bisEntityID));
        } else if (prodIdentificationObj.has(String.valueOf(phrase) + "_" + applScope)) {
            value = this.checkNull(prodIdentificationObj.optString(String.valueOf(phrase) + "_" + applScope));
        } else if (prodIdentificationObj.has(phrase)) {
            value = this.checkNull(prodIdentificationObj.optString(phrase));
        }
        return value;
    }

    private String getItemUnit(String itemCode, Connection conn) {
        String unit = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "SELECT UNIT FROM ITEM WHERE ITEM_CODE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, itemCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    unit = this.checkNull(rs.getString("UNIT"));
                }
                pstmt.close();
                rs.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "ItemLookUp getItemUnit Exception :CATCH: [" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "ItemLookUp getItemUnit Exception :FINALLY: [" + e2.getMessage() + "]");
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", null, null, "ItemLookUp getItemUnit Exception :FINALLY: [" + e2.getMessage() + "]");
            }
        }
        return unit;
    }

    private String getItemDescr(String extitemCode, Connection conn) {
        String descr = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "SELECT DESCR FROM ITEM WHERE ITEM_CODE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, extitemCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    descr = this.checkNull(rs.getString("DESCR"));
                }
                pstmt.close();
                rs.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "ItemLookUp getItemDescr Exception :CATCH: [" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "ItemLookUp getItemDESCR Exception :FINALLY: [" + e2.getMessage() + "]");
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", null, null, "ItemLookUp getItemDESCR Exception :FINALLY: [" + e2.getMessage() + "]");
            }
        }
        return descr;
    }
}

