/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import ibase.system.config.resource.NoSQLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;

public class MongoDBHandler {
    private MongoDatabase mongoDB = null;
    private MongoCollection<Document> mongoCollection = null;
    private final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");

    public MongoDBHandler(NoSQLConnection connection) throws SQLException {
        this.mongoDB = (MongoDatabase)connection.getDatabase();
    }

    public MongoDBHandler(NoSQLConnection connection, String collection) throws SQLException {
        this(connection);
        this.setMongoCollection(collection);
    }

    public MongoDatabase getDB() throws SQLException {
        if (this.mongoDB == null) {
            throw new SQLException("Database does not exist");
        }
        return this.mongoDB;
    }

    public MongoCollection<Document> getCollection() throws SQLException {
        if (this.mongoCollection == null) {
            throw new SQLException("Collection does not exist");
        }
        return this.mongoCollection;
    }

    public void setMongoCollection(String collection) throws SQLException {
        if (!this.isCollectionExist(collection)) {
            this.getDB().createCollection(collection);
        }
        this.mongoCollection = this.getDB().getCollection(collection);
    }

    private boolean isCollectionExist(String collection) throws SQLException {
        return ((ArrayList)this.getDB().listCollectionNames().into(new ArrayList())).contains(collection);
    }

    public Document getDocumentById(ObjectId id) throws SQLException {
        BasicDBObject queryObj = new BasicDBObject("_id", (Object)id);
        FindIterable cursor = this.getCollection().find((Bson)queryObj);
        MongoCursor it = cursor.iterator();
        if (it.hasNext()) {
            return (Document)it.next();
        }
        return null;
    }

    public ObjectId insert(Document bsonDocument) throws SQLException {
        this.getCollection().insertOne((Object)bsonDocument);
        return (ObjectId)bsonDocument.get((Object)"_id");
    }

    public ObjectId insert(Map input) throws SQLException {
        Document bsonDocument = this.toBsonDocument(input);
        return this.insert(bsonDocument);
    }

    public ObjectId insert(String input) throws SQLException {
        Document bsonDocument = this.toBsonDocument(input);
        return this.insert(bsonDocument);
    }

    public JSONObject retrieve(ObjectId id) throws SQLException, JSONException {
        Document document = this.getDocumentById(id);
        if (document != null) {
            return new JSONObject(document.toJson());
        }
        return null;
    }

    public void update(String key, String value, String param, Object paramValue) throws SQLException {
        this.getCollection().updateOne((Bson)new BasicDBObject(key, (Object)new ObjectId(value)), (Bson)new BasicDBObject("$set", (Object)new BasicDBObject(param, paramValue)));
    }

    public void deleteDoc(String fieldName, String fieldValue) throws SQLException {
        this.getCollection().deleteOne(Filters.eq((String)fieldName, (Object)fieldValue));
    }

    public void collectionDrop() throws SQLException {
        this.getCollection().drop();
    }

    public Bson toBson(Object obj) {
        if (obj instanceof Map) {
            return new BasicDBObject(this.doMapConversions((Map)obj));
        }
        String json = new Gson().toJson(obj);
        return obj != null ? BasicDBObject.parse((String)json) : null;
    }

    public Map doMapConversions(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                this.doMapConversions((Map)value);
            }
            if (value instanceof Map && this.canConvertMapToArray((Map)value)) {
                map.put(key, this.convertMapToArray((Map)value));
            }
            if (!"_id".equals(key) || !(value instanceof String) || !this.HEXADECIMAL_PATTERN.matcher((String)value).matches()) continue;
            map.put("_id", new ObjectId((String)value));
        }
        return map;
    }

    private boolean canConvertMapToArray(Map map) {
        return map.isEmpty() && map.get("0") != null;
    }

    private List<Object> convertMapToArray(Map map) {
        Object obj;
        ArrayList<Object> array = new ArrayList<Object>();
        int i = 0;
        while ((obj = map.get("" + i)) != null) {
            array.add(obj);
            ++i;
        }
        return array;
    }

    public List toBsonList(Object source) {
        if (source instanceof Map && this.canConvertMapToArray((Map)source)) {
            Map sourceMap = (Map)source;
            ArrayList<Bson> array = new ArrayList<Bson>();
            int i = 0;
            while (i < sourceMap.size()) {
                array.add(this.toBson(sourceMap.get("" + i)));
                ++i;
            }
            return array;
        }
        if (source instanceof List) {
            ArrayList<Bson> ret = new ArrayList<Bson>();
            for (Object obj : (List)source) {
                ret.add(this.toBson(obj));
            }
            return ret;
        }
        return null;
    }

    private Document toBsonDocument(Object input) {
        if (input instanceof Map) {
            return new Document(this.doMapConversions((Map)input));
        }
        if (input instanceof String) {
            return Document.parse((String)((String)input));
        }
        return null;
    }
}

