/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ValidateXMLInput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;

public class ViewProcessAuditBean {
    public String objName;
    UserInfoBean userInfo = new UserInfoBean();

    public String getProcAuditHTMLData(String objName, int auditProcDispRec, HttpServletRequest request, UserInfoBean userInfo) throws Exception {
        String htmlData = "";
        String xmlData = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (auditProcDispRec == 0) {
                auditProcDispRec = dbAccess.getRecProcessAudit(userInfo.toString());
                request.getSession().setAttribute("AUDIT_PROC_DISP_REC", (Object)auditProcDispRec);
            }
            if ((xmlData = dbAccess.getProcessAuditDetail(objName, auditProcDispRec, userInfo.toString())) != null && xmlData.length() > 0) {
                htmlData = this.convertXmlToHtml(xmlData, objName);
            } else {
                BaseLogger.log("3", userInfo, null, "Data not found");
            }
            dbAccess = null;
            ctx.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in getHtmlData()" + e);
            e.printStackTrace();
        }
        return htmlData;
    }

    public String convertXmlToHtml(String xmlFromEJB, String objName) {
        String outputHtml = "";
        try {
            String user_lang = this.userInfo.getUserLanguage() == null ? "en" : this.userInfo.getUserLanguage();
            String user_country = this.userInfo.getUserCountry() == null ? "US" : this.userInfo.getUserCountry();
            String xslName = String.valueOf(objName) + "_proc_audit_" + user_lang + "_" + user_country + ".xsl";
            String xslFilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + xslName;
            File file = new File(xslFilePath);
            BaseLogger.log("3", this.userInfo, null, "xslFilePath = " + xslFilePath);
            if (!file.exists()) {
                xslName = String.valueOf(objName) + "_proc_audit" + ".xsl";
                xslFilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + xslName;
                file = new File(xslFilePath);
                if (file.exists()) {
                    ValidateXMLInput vxi = new ValidateXMLInput();
                    String outputFileName = vxi.validate(xslName, xmlFromEJB, "Process", ".html");
                    FileInputStream fis = new FileInputStream(outputFileName);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int i = -1;
                    while ((i = fis.read()) != -1) {
                        baos.write(i);
                    }
                    outputHtml = baos.toString();
                    fis = null;
                    if (fis != null) {
                        fis.close();
                    }
                    if ((baos = null) != null) {
                        baos.close();
                    }
                } else {
                    BaseLogger.log("3", this.userInfo, null, " xsl file not found");
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in convertXmlToHtml()" + e);
            e.printStackTrace();
        }
        return outputHtml;
    }
}

