/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.ejb.AdminLocal;
import ibase.ejb.AdminRemote;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class AdminEJB
implements AdminRemote,
AdminLocal {
    @Resource
    private SessionContext cSessionContext;

    public void ejbCreate() throws RemoteException, CreateException {
        BaseLogger.log("1", null, null, "AdminEJB Created...");
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    @Override
    public String setDBConnection(String dbParamString) throws RemoteException, Exception {
        return this.setDBConnectionAction(dbParamString);
    }

    @Override
    public String getDBConnection() throws RemoteException, Exception {
        return this.getDBConnectionAction();
    }

    private String getDBConnectionAction() {
        String driverFile = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "Driver.xml";
        String data = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamReader isr = new InputStreamReader(new FileInputStream(driverFile));
            int i = -1;
            while ((i = isr.read()) != -1) {
                baos.write(i);
            }
            data = baos.toString();
            baos.close();
            isr.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: AdminEJB: getDBSettings:" + e);
            e.printStackTrace();
        }
        return data;
    }

    private String setDBConnectionAction(String dbParamString) {
        String status = null;
        String success = "success";
        String action = "";
        String dbProvider = "";
        String dbDriver = "";
        String dbUserName = "";
        String dbPassword = "";
        String itmUserName = "";
        String itmPassword = "";
        String logInSite = "";
        String dbURL = "";
        Document dom = null;
        NodeList nodeList = null;
        Node node = null;
        try {
            dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(dbParamString.getBytes()));
            nodeList = dom.getElementsByTagName("CONNTECTIONPARAMS");
            node = nodeList.item(0);
            nodeList = node.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                if (node != null) {
                    if (node.getNodeName().equalsIgnoreCase("ACTION")) {
                        action = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("DATASOURCENAME")) {
                        dbProvider = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("DRIVERNAME")) {
                        dbDriver = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("DRIVERURL")) {
                        dbURL = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("LOGID")) {
                        dbUserName = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("LOGPASSWORD")) {
                        dbPassword = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("ITMUSERNAME")) {
                        itmUserName = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("ITMPASSWORD")) {
                        itmPassword = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equalsIgnoreCase("LOGINSITE")) {
                        logInSite = node.getFirstChild().getNodeValue();
                    }
                }
                ++i;
            }
            if (action.trim().equalsIgnoreCase("TEST")) {
                status = this.testConnection(dbDriver, dbURL, dbUserName, dbPassword, itmUserName, itmPassword, logInSite);
            } else if (action.trim().equalsIgnoreCase("TESTED")) {
                if (this.writeDBSettings(dbProvider, dbDriver, dbURL, dbUserName, dbPassword)) {
                    // empty if block
                }
                status = "success";
            } else {
                status = this.testConnection(dbDriver, dbURL, dbUserName, dbPassword, itmUserName, itmPassword, logInSite);
                if (status.equalsIgnoreCase("success")) {
                    if (this.writeDBSettings(dbProvider, dbDriver, dbURL, dbUserName, dbPassword)) {
                        // empty if block
                    }
                    status = "success";
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: AdminEJB: setDBConnectionAction: ");
            e.printStackTrace();
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private String testConnection(String dbDriver, String dbURL, String dbUserName, String dbPassword, String itmUserName, String itmPassword, String logInSite) throws ITMException {
        status = "Could not connect to Database!";
        conn = null;
        BaseLogger.log("2", null, null, ".........Testing Parameters.........");
        try {
            block28: {
                driver = DriverManager.getDriver(dbURL);
                BaseLogger.log("3", null, null, driver.getClass().getName());
                if (driver == null) break block28;
                if (!driver.getClass().getName().equals(dbDriver)) {
                    BaseLogger.log("3", null, null, "Invalid Driver or Connection Parameter!");
                    var12_15 = status;
                    return var12_15;
                }
                ** GOTO lbl17
            }
            try {
                Class.forName(dbDriver);
lbl17:
                // 2 sources

                if ((conn = DriverManager.getConnection(dbURL, dbUserName, dbPassword)) != null && this.authenticate(itmUserName, itmPassword, logInSite, conn)) {
                    status = "success";
                }
            }
            catch (ExceptionInInitializerError eie) {
                BaseLogger.log("0", null, null, eie.getMessage());
            }
            catch (LinkageError le) {
                BaseLogger.log("0", null, null, le.getMessage());
            }
            catch (ClassNotFoundException cfe) {
                BaseLogger.log("0", null, null, "Driver Not Found!: " + cfe.getMessage());
            }
            catch (SQLException se) {
                BaseLogger.log("0", null, null, se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in Finallay");
            }
        }
        return status;
    }

    private boolean writeDBSettings(String dbProvider, String dbDriver, String dbURL, String dbUserName, String dbPassword) {
        boolean rtnValue;
        block13: {
            rtnValue = false;
            String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting";
            OutputStreamWriter fw = null;
            BaseLogger.log("2", null, null, ".........Writing to Files.........");
            try {
                try {
                    File dirObj = new File(dirStr);
                    if (!dirObj.exists()) {
                        dirObj.mkdir();
                    }
                    StringBuffer dbSettings = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\" ?>");
                    dbSettings.append("\n<DBINITIALIZATION>");
                    dbSettings.append("\n\t<DATABASE isPool=\"false\">");
                    dbSettings.append("\n\t\t<DATASOURCENAME>").append(dbProvider).append("</DATASOURCENAME>");
                    dbSettings.append("\n\t\t<DRIVERNAME>").append(dbDriver).append("</DRIVERNAME>");
                    dbSettings.append("\n\t\t<DRIVERURL>").append(dbURL).append("</DRIVERURL>");
                    dbSettings.append("\n\t\t<LOGID>").append(dbUserName).append("</LOGID>");
                    dbSettings.append("\n\t\t<LOGPASSWORD>").append(dbPassword).append("</LOGPASSWORD>");
                    dbSettings.append("\n\t</DATABASE>");
                    dbSettings.append("\n</DBINITIALIZATION>");
                    fw = new FileWriter(String.valueOf(dirStr) + File.separator + "Driver.xml");
                    fw.write(dbSettings.toString(), 0, dbSettings.length());
                    fw.flush();
                    rtnValue = true;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception: AdminEJB: writeSettings: " + e);
                    if (fw == null) break block13;
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return rtnValue;
    }

    private boolean authenticate(String itmUserName, String itmPassword, String logInSite, Connection conn) {
        boolean rtnValue = true;
        Statement stmt = null;
        try {
            try {
                BaseLogger.log("3", null, null, "Authenticating....");
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT PASS_WD FROM USERS WHERE CODE='" + itmUserName + "'");
                String dbpwd = null;
                if (rs.next()) {
                    dbpwd = rs.getString("PASS_WD");
                }
                rs.close();
                rs = null;
                if (dbpwd != null && dbpwd.equals(itmPassword)) {
                    rs = stmt.executeQuery("SELECT ACCT_LOCK FROM USERS WHERE CODE = '" + itmUserName + "'");
                    if (rs.next()) {
                        String accLock = rs.getString("ACCT_LOCK");
                        if (accLock != null && "Y".equalsIgnoreCase(accLock.trim())) {
                            BaseLogger.log("3", null, null, "Authentication Failed ACCT_LOCK....");
                            rtnValue = false;
                        }
                    } else {
                        BaseLogger.log("3", null, null, "Authentication Failed Rs: ACCT_LOCK....");
                        rtnValue = false;
                    }
                } else {
                    BaseLogger.log("3", null, null, "Authentication Failed rs password....");
                    rtnValue = false;
                }
                stmt.close();
            }
            catch (Exception e) {
                rtnValue = false;
                BaseLogger.log("0", null, null, "Exception: AdminEJB: authenticate:" + e);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("2", null, null, "Exception finally : AdminEJB: authenticate :==>");
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("2", null, null, "Exception finally : AdminEJB: authenticate :==>");
            }
        }
        return rtnValue;
    }
}

