/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONManipulator {
    public static void main(String[] args) {
        try {
            String jsonString = "\n{\n  \"Root\": {\n    \"Detail1\": [\n      {\n        \"tran_id\": \"\",\n        \"tran_date\": \"13/06/23\",\n        \"tran_ser\": \"CRNRCP\",\n        \"tran_type\": \"RC\",\n        \"invoice_id\": \"O1IH000002\",        \n        \"cust_code\": \"\",\n        \"curr_code\": \"\",\n        \"site_code\": \"\",\n        \"fin_entity\": \"\",\n        \"anal_code\": \"\",\n        \"amount\": \"\",\n        \"exch_rate\": \"\",\n        \"amount__bc\": \"\",\n        \"acct_code\": \"\",\n        \"cctr_code\": \"\",\n        \"cr_term\": \"\",        \n        \"remarks\": \"\",\n        \"confirmed\": \"\",        \n        \"emp_code__aprv\": \"\",\n        \"drcr_flag\": \"C\",\n        \"tran_id__rcv\": \"\",        \n        \"add_user\": \"\",\n        \"add_term\": \"\",        \n        \"chg_user\": \"\",\n        \"chg_term\": \"\",\n        \"cust_name\": \"\",\n        \"accounts_descr\": \"\",\n        \"crterm_descr\": \"\",\n        \"item_ser\": \"\",\n        \"round_adj\": \"\",\n        \"adj_recv\": \"\",\n        \"gp_ser\": \"\",\n        \"gp_no\": \"\",        \n        \"sreturn_no\": \"\",\n        \"cust_ref_no\": \"\",        \n        \"cust_ref_amt\": \"\",\n        \"rnd_off\": \"\",\n        \"rnd_to\": \"\",\n        \"parent__tran_id\": \"\",\n        \"reas_code\": \"\"\n      }\n    ],\n    \"Detail2\": [\n      {\n        \"tran_id\": \"\",\n        \"line_no\": \"1\",\n        \"invoice_id\": \"\",\n        \"line_no__inv\": \"\",\n        \"item_code\": \"\",\n        \"sales_pers\": \"\",\n        \"tax_class\": \"\",\n        \"tax_chap\": \"\",\n        \"tax_env\": \"\",\n        \"drcr_amt\": \"\",\n        \"tax_amt\": \"\",\n        \"net_amt\": \"\",        \n        \"cost_rate\": \"\",\n        \"rate__std\": \"\",             \n        \"rate__clg\": \"\",\n        \"discount\": \"\",\n        \"line_no__sret\": \"\",\t\t  \n        \"line_no__invtrace\": \"1\",\n\t\t\"rate\": \"1\",\n\t\t\"quantity\": \"1\",\n\t\t\"reas_code\": \"R02\",\t\t  \n        \"lot_no\": \"\",\n        \"lot_sl\": \"\",\n        \"tran_id__rcp\": \"\",\n        \"sreturn_no\": \"\",\n        \"disc_amt\": \"\",\n        \"Taxes\": \"\"\t\t\n      }\n    ]\n  }\n}\n\n\n\n";
            JSONObject jsonObject = new JSONObject(jsonString);
            JSONManipulator.removePropertiesWithEmptyValues(jsonObject);
            System.out.println(jsonObject.toString());
            String result = JSONManipulator.jsonFomatter(jsonObject.toString());
            System.out.println("Final Json: [" + result + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removePropertiesWithEmptyValues(JSONObject jsonObject) throws JSONException {
        JSONArray keys = jsonObject.names();
        if (keys != null) {
            int i = 0;
            while (i < keys.length()) {
                String key = keys.getString(i);
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    JSONManipulator.removePropertiesWithEmptyValues((JSONObject)value);
                } else if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    int j = 0;
                    while (j < array.length()) {
                        if (array.get(j) instanceof JSONObject) {
                            JSONManipulator.removePropertiesWithEmptyValues(array.getJSONObject(j));
                        }
                        ++j;
                    }
                } else if (value instanceof String && ((String)value).isEmpty()) {
                    jsonObject.remove(key);
                }
                ++i;
            }
        }
    }

    public static String jsonFomatter(String jsonData) {
        String finalJson = "";
        try {
            JSONObject originalObject = new JSONObject(jsonData);
            JSONArray detail1Array = originalObject.getJSONObject("Root").getJSONArray("Detail1");
            JSONArray detail2Array = originalObject.getJSONObject("Root").getJSONArray("Detail2");
            String detail1String = "\"Detail1\": " + detail1Array.toString();
            String detail2String = "\"Detail2\": " + detail2Array.toString();
            finalJson = "{ \"Root\": {" + detail1String + "," + detail2String + "}}";
            System.out.println("Formated JSON gsb1 [" + finalJson + "]");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finalJson;
    }
}

