/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.webitm.utility.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class INIFile {
    private String _strDateFmt = "yyyy-MM-dd";
    private String _strTimeStampFmt = "yyyy-MM-dd HH:mm:ss";
    private String _strFile;
    private LinkedHashMap<String, INISection> _hmapSections;
    private Properties _propEnv;

    public INIFile(String pstrPathAndName) {
        this._propEnv = this.getEnvVars();
        this._hmapSections = new LinkedHashMap(4);
        this._strFile = pstrPathAndName;
        if (this.checkFile(pstrPathAndName)) {
            this.loadFile();
        }
    }

    public INIFile(String pstrPathAndName, InputStream is) {
        BufferedReader brdr = null;
        InputStreamReader isr = null;
        this._propEnv = this.getEnvVars();
        this._hmapSections = new LinkedHashMap(4);
        this._strFile = pstrPathAndName;
        try {
            isr = new InputStreamReader(is);
            brdr = new BufferedReader(isr);
            this.loadFile(brdr);
        }
        catch (Throwable throwable) {
            this.closeReader(brdr);
            this.closeReader(isr);
            brdr = null;
            isr = null;
            throw throwable;
        }
        this.closeReader(brdr);
        this.closeReader(isr);
        brdr = null;
        isr = null;
    }

    public INISection getSection(String strName) {
        return this._hmapSections.get(strName);
    }

    public String getFileName() {
        return this._strFile;
    }

    public String getStringProperty(String pstrSection, String pstrProp) {
        String strKey = null;
        String strRet = null;
        INIProperty objProp = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strRet = objProp.getPropValue();
                objProp = null;
            }
            objSec = null;
        }
        return strRet;
    }

    public Boolean getBooleanProperty(String pstrSection, String pstrProp) {
        boolean blnRet = false;
        String strKey = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strVal = objProp.getPropValue();
                if ("YES".equalsIgnoreCase(strVal) || "TRUE".equalsIgnoreCase(strVal) || "1".equalsIgnoreCase(strVal)) {
                    blnRet = true;
                }
                objProp = null;
            }
            objSec = null;
        }
        return blnRet;
    }

    public Integer getIntegerProperty(String pstrSection, String pstrProp) {
        String strKey = null;
        String strVal = null;
        Integer intRet = null;
        INIProperty objProp = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec != null) {
            block10: {
                objProp = objSec.getProperty(pstrProp);
                try {
                    try {
                        if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                            intRet = new Integer(strVal);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (objProp != null) {
                            objProp = null;
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    throw throwable;
                }
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return intRet;
    }

    public Long getLongProperty(String pstrSection, String pstrProp) {
        Long lngRet = null;
        String strKey = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec != null) {
            block10: {
                objProp = objSec.getProperty(pstrProp);
                try {
                    try {
                        if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                            lngRet = new Long(strVal);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (objProp != null) {
                            objProp = null;
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    throw throwable;
                }
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return lngRet;
    }

    public Double getDoubleProperty(String pstrSection, String pstrProp) {
        Double dblRet = null;
        String strKey = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec != null) {
            block10: {
                objProp = objSec.getProperty(pstrProp);
                try {
                    try {
                        if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                            dblRet = new Double(strVal);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (objProp != null) {
                            objProp = null;
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    throw throwable;
                }
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return dblRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDateProperty(String pstrSection, String pstrProp) {
        INISection objSec;
        Date dtRet;
        block12: {
            dtRet = null;
            String strKey = null;
            String strVal = null;
            SimpleDateFormat dtFmt = null;
            INIProperty objProp = null;
            objSec = null;
            strKey = pstrSection.toUpperCase();
            objSec = this._hmapSections.get(strKey);
            if (objSec == null) return dtRet;
            objProp = objSec.getProperty(pstrProp);
            try {
                try {
                    if (objProp != null) {
                        strVal = objProp.getPropValue();
                    }
                    if (strVal != null) {
                        dtFmt = new SimpleDateFormat(this._strDateFmt);
                        dtRet = dtFmt.parse(strVal);
                    }
                }
                catch (ParseException parseException) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    break block12;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (objProp != null) {
                    objProp = null;
                }
                throw throwable;
            }
            if (objProp != null) {
                objProp = null;
            }
        }
        objSec = null;
        return dtRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getTimestampProperty(String pstrSection, String pstrProp) {
        INISection objSec;
        Timestamp tsRet;
        block12: {
            Date dtTmp = null;
            String strVal = null;
            String strKey = null;
            tsRet = null;
            SimpleDateFormat dtFmt = null;
            INIProperty objProp = null;
            objSec = null;
            strKey = pstrSection.toUpperCase();
            objSec = this._hmapSections.get(strKey);
            if (objSec == null) return tsRet;
            objProp = objSec.getProperty(pstrProp);
            try {
                try {
                    if (objProp != null) {
                        strVal = objProp.getPropValue();
                    }
                    if (strVal != null) {
                        dtFmt = new SimpleDateFormat(this._strDateFmt);
                        dtTmp = dtFmt.parse(strVal);
                        tsRet = new Timestamp(dtTmp.getTime());
                    }
                }
                catch (ParseException parseException) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    break block12;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (objProp != null) {
                        objProp = null;
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (objProp != null) {
                    objProp = null;
                }
                throw throwable;
            }
            if (objProp != null) {
                objProp = null;
            }
        }
        objSec = null;
        return tsRet;
    }

    public void addSection(String pstrSection, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setSecComments(pstrComments);
        objSec = null;
    }

    public void setStringProperty(String pstrSection, String pstrProp, String pstrVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, pstrVal, pstrComments);
    }

    public void setBooleanProperty(String pstrSection, String pstrProp, boolean pblnVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        if (pblnVal) {
            objSec.setProperty(pstrProp, "TRUE", pstrComments);
        } else {
            objSec.setProperty(pstrProp, "FALSE", pstrComments);
        }
    }

    public void setIntegerProperty(String pstrSection, String pstrProp, int pintVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, Integer.toString(pintVal), pstrComments);
    }

    public void setLongProperty(String pstrSection, String pstrProp, long plngVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, Long.toString(plngVal), pstrComments);
    }

    public void setDoubleProperty(String pstrSection, String pstrProp, double pdblVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, Double.toString(pdblVal), pstrComments);
    }

    public void setDateProperty(String pstrSection, String pstrProp, Date pdtVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, this.utilDateToStr(pdtVal, this._strDateFmt), pstrComments);
    }

    public void setTimestampProperty(String pstrSection, String pstrProp, Timestamp ptsVal, String pstrComments) {
        String strKey = null;
        INISection objSec = null;
        strKey = pstrSection.toUpperCase();
        objSec = this._hmapSections.get(strKey);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this._hmapSections.put(strKey, objSec);
        }
        objSec.setProperty(pstrProp, this.timeToStr(ptsVal, this._strTimeStampFmt), pstrComments);
    }

    public void setDateFormat(String pstrDtFmt) throws IllegalArgumentException {
        if (!this.checkDateTimeFormat(pstrDtFmt)) {
            throw new IllegalArgumentException("The specified date pattern is invalid!");
        }
        this._strDateFmt = pstrDtFmt;
    }

    public void setTimeStampFormat(String pstrTSFmt) {
        if (!this.checkDateTimeFormat(pstrTSFmt)) {
            throw new IllegalArgumentException("The specified timestamp pattern is invalid!");
        }
        this._strTimeStampFmt = pstrTSFmt;
    }

    public int getTotalSections() {
        return this._hmapSections.size();
    }

    public String[] getAllSectionNames() {
        int cntr = 0;
        String[] arrRet = null;
        if (this._hmapSections.isEmpty()) {
            return new String[0];
        }
        arrRet = new String[this._hmapSections.size()];
        for (Map.Entry<String, INISection> entry : this._hmapSections.entrySet()) {
            arrRet[cntr] = entry.getValue().getSecName();
            ++cntr;
        }
        return arrRet;
    }

    public String[] getPropertyNames(String pstrSection) {
        String strKey = null;
        strKey = pstrSection.toUpperCase();
        if (this._hmapSections.containsKey(strKey)) {
            return this._hmapSections.get(strKey).getPropNames();
        }
        return new String[0];
    }

    public Map<String, INIProperty> getProperties(String pstrSection) {
        String strKey = null;
        strKey = pstrSection.toUpperCase();
        if (this._hmapSections.containsKey(strKey)) {
            return this._hmapSections.get(strKey).getProperties();
        }
        return null;
    }

    public void removeProperty(String pstrSection, String pstrProp) {
        String strKey = null;
        strKey = pstrSection.toUpperCase();
        if (this._hmapSections.containsKey(strKey)) {
            this._hmapSections.get(strKey).removeProperty(pstrProp);
        }
    }

    public void removeSection(String pstrSection) {
        String strKey = null;
        strKey = pstrSection.toUpperCase();
        if (this._hmapSections.containsKey(strKey)) {
            this._hmapSections.remove(strKey);
        }
    }

    /*
     * Loose catch block
     */
    public boolean save() {
        block8: {
            FileWriter objWriter;
            File objFile;
            block7: {
                objFile = null;
                objWriter = null;
                if (!this._hmapSections.isEmpty()) break block7;
                this.closeWriter(objWriter);
                objWriter = null;
                objFile = null;
                return false;
            }
            try {
                objFile = new File(this._strFile);
                if (objFile.exists()) {
                    objFile.delete();
                }
                objWriter = new FileWriter(objFile);
                for (Map.Entry<String, INISection> entry : this._hmapSections.entrySet()) {
                    objWriter.write(entry.getValue().toString());
                    objWriter.write("\r\n");
                }
                this.closeWriter(objWriter);
                objWriter = null;
                objFile = null;
                return true;
            }
            catch (IOException iOException) {
                this.closeWriter(objWriter);
                objWriter = null;
                objFile = null;
                break block8;
                catch (Throwable throwable) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                    objFile = null;
                    throw throwable;
                }
            }
        }
        return false;
    }

    private Properties getEnvVars() {
        Properties envVars = null;
        Map<String, String> env = null;
        try {
            try {
                env = System.getenv();
                envVars = new Properties();
                for (String envName : env.keySet()) {
                    envVars.setProperty(envName, env.get(envName));
                }
            }
            catch (SecurityException securityException) {
                env = null;
            }
            catch (ClassCastException classCastException) {
                env = null;
            }
            catch (NullPointerException nullPointerException) {
                env = null;
            }
        }
        finally {
            env = null;
        }
        return envVars;
    }

    private boolean checkDateTimeFormat(String pstrDtFmt) {
        SimpleDateFormat objFmt = null;
        try {
            objFmt = new SimpleDateFormat(pstrDtFmt);
            return true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (objFmt != null) {
                objFmt = null;
            }
        }
        return false;
    }

    private void loadFile() {
        block5: {
            FileReader objFRdr = null;
            BufferedReader objBRdr = null;
            try {
                try {
                    objFRdr = new FileReader(this._strFile);
                    objBRdr = new BufferedReader(objFRdr);
                    this.loadFile(objBRdr);
                }
                catch (FileNotFoundException ex) {
                    this._hmapSections.clear();
                    this.closeReader(objBRdr);
                    this.closeReader(objFRdr);
                    objBRdr = null;
                    objFRdr = null;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeReader(objBRdr);
                this.closeReader(objFRdr);
                objBRdr = null;
                objFRdr = null;
                throw throwable;
            }
            this.closeReader(objBRdr);
            this.closeReader(objFRdr);
            objBRdr = null;
            objFRdr = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFile(BufferedReader objBRdr) {
        int intLine = 0;
        int iPos = -1;
        String strLine = null;
        String strSection = null;
        String strRemarks = null;
        INISection objSec = null;
        try {
            try {
                strLine = "";
                while (true) {
                    if (!objBRdr.ready() || strLine == null) {
                        if (objSec == null) return;
                        this._hmapSections.put(strSection.trim().toUpperCase(), objSec);
                        return;
                    }
                    System.out.println(String.valueOf(++intLine) + " " + strLine);
                    iPos = -1;
                    strLine = objBRdr.readLine();
                    if (StringUtils.isBlank(strLine)) continue;
                    if (strLine.startsWith(";")) {
                        if (StringUtils.isEmpty(strRemarks)) {
                            strRemarks = strLine;
                            continue;
                        }
                        strRemarks = String.valueOf(strRemarks) + "\r\n" + strLine;
                        continue;
                    }
                    if (strLine.startsWith("[") && strLine.endsWith("]")) {
                        if (objSec != null) {
                            this._hmapSections.put(strSection.trim().toUpperCase(), objSec);
                        }
                        strSection = strLine.substring(1, strLine.length() - 1);
                        objSec = new INISection(strSection.trim(), strRemarks);
                        strRemarks = null;
                        continue;
                    }
                    iPos = strLine.indexOf("=");
                    if (iPos <= 0 || objSec == null) continue;
                    objSec.setProperty(strLine.substring(0, iPos).trim(), strLine.substring(iPos + 1).trim(), strRemarks);
                    strRemarks = null;
                }
            }
            catch (FileNotFoundException FNFExIgnore) {
                this._hmapSections.clear();
                objSec = null;
                strLine = null;
                strSection = null;
                strRemarks = null;
                return;
            }
            catch (IOException IOExIgnore) {
                this._hmapSections.clear();
                objSec = null;
                strLine = null;
                strSection = null;
                strRemarks = null;
                return;
            }
            catch (NullPointerException NPExIgnore) {
                this._hmapSections.clear();
                objSec = null;
                strLine = null;
                strSection = null;
                strRemarks = null;
                return;
            }
        }
        finally {
            objSec = null;
            strLine = null;
            strSection = null;
            strRemarks = null;
        }
    }

    private void closeReader(Reader pobjRdr) {
        if (pobjRdr == null) {
            return;
        }
        try {
            pobjRdr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeWriter(Writer pobjWriter) {
        if (pobjWriter == null) {
            return;
        }
        try {
            pobjWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean checkFile(String pstrFile) {
        boolean blnRet = false;
        File objFile = null;
        try {
            try {
                objFile = new File(pstrFile);
                blnRet = objFile.exists() && objFile.isFile();
            }
            catch (Exception e) {
                blnRet = false;
                if (objFile != null) {
                    objFile = null;
                }
            }
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
        return blnRet;
    }

    private String utilDateToStr(Date pdt, String pstrFmt) {
        String strRet = null;
        SimpleDateFormat dtFmt = null;
        try {
            try {
                dtFmt = new SimpleDateFormat(pstrFmt);
                strRet = dtFmt.format(pdt);
            }
            catch (Exception e) {
                strRet = null;
                if (dtFmt != null) {
                    dtFmt = null;
                }
            }
        }
        finally {
            if (dtFmt != null) {
                dtFmt = null;
            }
        }
        return strRet;
    }

    private String timeToStr(Timestamp pobjTS, String pstrFmt) {
        String strRet = null;
        SimpleDateFormat dtFmt = null;
        try {
            try {
                dtFmt = new SimpleDateFormat(pstrFmt);
                strRet = dtFmt.format(pobjTS);
            }
            catch (IllegalArgumentException iae) {
                strRet = "";
                if (dtFmt != null) {
                    dtFmt = null;
                }
            }
            catch (NullPointerException npe) {
                strRet = "";
                if (dtFmt != null) {
                    dtFmt = null;
                }
            }
        }
        finally {
            if (dtFmt != null) {
                dtFmt = null;
            }
        }
        return strRet;
    }

    public static void main(String[] pstrArgs) {
        INIFile objINI = null;
        String strFile = null;
        if (pstrArgs.length == 0) {
            return;
        }
        strFile = pstrArgs[0];
        objINI = new INIFile(strFile);
        String[] stringArray = objINI.getAllSectionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sec = stringArray[n2];
            System.out.println(objINI.getSection(sec).toString());
            ++n2;
        }
        objINI = null;
    }

    public class INIProperty {
        private String _strName;
        private String _strValue;
        private String _strComments;

        INIProperty(String pstrName, String pstrValue) {
            this._strName = pstrName;
            this._strValue = pstrValue;
        }

        public INIProperty(String pstrName, String pstrValue, String pstrComments) {
            this._strName = pstrName;
            this._strValue = pstrValue;
            this._strComments = pstrComments;
        }

        public String getPropName() {
            return this._strName;
        }

        public String getPropValue() {
            int intStart = 0;
            int intEnd = 0;
            String strVal = null;
            String strVar = null;
            String strRet = null;
            strRet = this._strValue;
            intStart = strRet.indexOf("%");
            if (intStart >= 0) {
                intEnd = strRet.indexOf("%", intStart + 1);
                strVar = strRet.substring(intStart + 1, intEnd);
                strVal = INIFile.this._propEnv.getProperty(strVar);
                if (strVal != null) {
                    strRet = String.valueOf(strRet.substring(0, intStart)) + strVal + strRet.substring(intEnd + 1);
                }
            }
            return strRet;
        }

        public String getPropComments() {
            return this._strComments;
        }

        public void setPropName(String pstrName) {
            this._strName = pstrName;
        }

        public void setPropValue(String pstrValue) {
            this._strValue = pstrValue;
        }

        public void setPropComments(String pstrComments) {
            this._strComments = pstrComments;
        }

        public String toString() {
            StringBuilder sb = null;
            try {
                sb = new StringBuilder(128);
                if (this._strComments != null) {
                    if (!this._strComments.startsWith(";")) {
                        sb.append(";");
                    }
                    sb.append(this._strComments).append("\r\n");
                }
                sb.append(this._strName).append(" = ").append(this._strValue);
                String string = sb.toString();
                return string;
            }
            finally {
                sb = null;
            }
        }
    }

    public class INISection {
        private String _strComment;
        private String _strName;
        private LinkedHashMap<String, INIProperty> _hmapProps;

        INISection(String pstrSection) {
            this._strName = pstrSection;
            this._hmapProps = new LinkedHashMap(4);
        }

        public INISection(String pstrSection, String pstrComments) {
            this._strName = pstrSection;
            this._strComment = pstrComments;
            this._hmapProps = new LinkedHashMap(4);
        }

        public String getSecComments() {
            return this._strComment;
        }

        public String getSecName() {
            return this._strName;
        }

        public void setSecComments(String pstrComments) {
            this._strComment = pstrComments;
        }

        public void setSecName(String pstrName) {
            this._strName = pstrName;
        }

        public void removeProperty(String pstrProp) {
            String strKey = null;
            strKey = pstrProp.toUpperCase();
            if (this._hmapProps.containsKey(strKey)) {
                this._hmapProps.remove(strKey);
            }
        }

        public void setProperty(String pstrProp, String pstrValue, String pstrComments) {
            String strKey = null;
            strKey = pstrProp.toUpperCase();
            if (this._hmapProps.containsKey(strKey)) {
                this._hmapProps.get(strKey).setPropValue(pstrValue);
            } else {
                this._hmapProps.put(strKey, new INIProperty(pstrProp, pstrValue, pstrComments));
            }
        }

        public Map<String, INIProperty> getProperties() {
            return Collections.unmodifiableMap(this._hmapProps);
        }

        public String[] getPropNames() {
            int cntr = 0;
            String[] arrRet = null;
            if (this._hmapProps.isEmpty()) {
                return new String[0];
            }
            arrRet = new String[this._hmapProps.size()];
            for (Map.Entry<String, INIProperty> entry : this._hmapProps.entrySet()) {
                arrRet[cntr] = entry.getValue().getPropName();
                ++cntr;
            }
            return arrRet;
        }

        public INIProperty getProperty(String pstrProp) {
            String strKey = null;
            INIProperty objRet = null;
            strKey = pstrProp.toUpperCase();
            if (this._hmapProps.containsKey(strKey)) {
                objRet = this._hmapProps.get(strKey);
            }
            return objRet;
        }

        public String toString() {
            StringBuffer objBuf = null;
            try {
                objBuf = new StringBuffer(128);
                if (this._strComment != null) {
                    if (!this._strComment.startsWith(";")) {
                        objBuf.append(";");
                    }
                    objBuf.append(this._strComment).append("\r\n");
                }
                objBuf.append("[").append(this._strName).append("]\r\n");
                for (Map.Entry<String, INIProperty> entry : this._hmapProps.entrySet()) {
                    objBuf.append(entry.getValue().toString()).append("\r\n");
                }
                String string = objBuf.toString();
                return string;
            }
            finally {
                objBuf = null;
            }
        }
    }
}

