/*
 * Decompiled with CFR 0.152.
 */
package ibase.bis.utility;

import ibase.bis.utility.BISUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BISDictionary {
    private String bisDictId;
    private String userId;
    private String phrase;
    private String phraseScope;
    private String bisEntityId;
    private String resType;
    private String resValue;
    private String phraseValue;
    private UserInfoBean userInfo = null;

    public BISDictionary() {
    }

    public BISDictionary(JSONObject intentArgJson, UserInfoBean userInfo) throws JSONException {
        if (intentArgJson != null) {
            if (intentArgJson.has("USER_ID")) {
                this.userId = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("USER_ID"));
            }
            if (intentArgJson.has("PHRASE")) {
                this.phrase = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("PHRASE"));
            }
            if (intentArgJson.has("PHRASE_SCOPE")) {
                this.phraseScope = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("PHRASE_SCOPE"));
            }
            if (intentArgJson.has("BIS_ENTITY_ID")) {
                this.bisEntityId = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("BIS_ENTITY_ID"));
            }
            if (intentArgJson.has("RES_TYPE")) {
                this.resType = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("RES_TYPE"));
            }
            if (intentArgJson.has("RES_VALUE")) {
                this.resValue = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("RES_VALUE"));
            }
            if (intentArgJson.has("BIS_DICT_ID")) {
                this.bisDictId = E12GenericUtility.checkJsonObjectNull(intentArgJson.getString("BIS_DICT_ID"));
            }
        }
        this.userInfo = userInfo;
        BaseLogger.log("0", null, null, "BISDictionary  NOW userInfo[ " + userInfo + " ]");
        this.setDictionaryResValue();
    }

    private String setDictionaryResValue() {
        String argValue = "";
        this.resType = E12GenericUtility.checkNull(this.resType);
        this.resValue = E12GenericUtility.checkNull(this.resValue);
        try {
            argValue = this.resType.equalsIgnoreCase("S") ? this.getSqlResValue(this.resValue) : (this.resType.equalsIgnoreCase("F") ? this.getFunctionValue(this.resValue) : this.resValue);
            BaseLogger.log("0", null, null, "phraseValue : [" + argValue + "]");
            this.setPhraseValue(argValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "BISDICTIONARY setDictionaryResValue() catch (Exception e)  [ " + e.getMessage() + " ]");
        }
        return argValue;
    }

    private String getFunctionValue(String resValueString) {
        String resValue = "";
        String methodName = "";
        String methodParams = "";
        String componentName = "ibase.bis.utility.BISUtility";
        String argName = "";
        Class<?> classObj = null;
        if (resValueString.length() > 0) {
            try {
                JSONObject jsonResData = new JSONObject(resValueString);
                if (jsonResData.has("METHOD_NAME")) {
                    methodName = jsonResData.getString("METHOD_NAME");
                }
                if (jsonResData.has("PARAMETERS")) {
                    methodParams = jsonResData.getString("PARAMETERS");
                }
                String qryParam = methodParams.replaceAll(" ", "");
                String[] paramElements = qryParam.split(",");
                int noOfArgs = paramElements.length;
                BaseLogger.log("0", null, null, "noOfArgs : [" + noOfArgs + "]");
                Class[] paramSpec = new Class[noOfArgs];
                Object[] params = new Object[noOfArgs];
                int argCtr = 0;
                while (argCtr < noOfArgs) {
                    String testParam = paramElements[argCtr];
                    String argDataType = testParam.substring(0, testParam.indexOf(":"));
                    if (argDataType.length() == 0 || argDataType.indexOf("String") != -1) {
                        paramSpec[argCtr] = Class.forName("java.lang.String");
                    } else if (argDataType != null && argDataType.indexOf("Object") != -1 && "USER_INFO".equalsIgnoreCase(argName)) {
                        paramSpec[argCtr] = Class.forName("ibase.utility.UserInfoBean");
                    }
                    String argValue = testParam.substring(testParam.indexOf(":") + 1);
                    params[argCtr] = argValue;
                    ++argCtr;
                }
                BaseLogger.log("3", this.userInfo, null, "paramSpec length :[" + paramSpec.length + "] params length :[" + params.length + "]");
                classObj = Class.forName(componentName);
                BISUtility bisUtility = (BISUtility)classObj.newInstance();
                Method metObj = classObj.getMethod(methodName, paramSpec);
                resValue = (String)metObj.invoke((Object)bisUtility, params);
                BaseLogger.log("2", this.userInfo, null, "returning resValue = [ " + resValue + " ]");
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception BISDictionary.getFunctionValue() exception = [" + e.getMessage() + "]");
            }
        }
        return resValue;
    }

    private String getSqlResValue(String resValueString) {
        String resValue = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            try {
                if (resValueString.length() > 0) {
                    String sqlQuery = "";
                    String qryParam = "";
                    String paramValue = "";
                    ConnDriver connDriver = new ConnDriver();
                    con = connDriver.getConnectDB(this.userInfo.getTransDB());
                    connDriver = null;
                    JSONObject jsonResData = new JSONObject(resValueString);
                    if (jsonResData.has("SQL_STR")) {
                        sqlQuery = (String)jsonResData.get("SQL_STR");
                    }
                    if (jsonResData.has("SQL_INPUT")) {
                        qryParam = jsonResData.getString("SQL_INPUT");
                    }
                    pstmt = con.prepareStatement(sqlQuery);
                    if (qryParam != null && sqlQuery.indexOf("?") != -1) {
                        String[] paramElements;
                        int pCount = 1;
                        qryParam = qryParam.replaceAll(" ", "");
                        HashMap<String, String> userInfoMap = this.getUserInfoMap(this.userInfo);
                        String[] stringArray = paramElements = qryParam.split(",");
                        int n = paramElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String testParam = stringArray[n2];
                            paramValue = userInfoMap.containsKey(testParam) ? userInfoMap.get(testParam) : testParam;
                            pstmt.setString(pCount, paramValue);
                            ++pCount;
                            ++n2;
                        }
                    }
                    rs = pstmt.executeQuery();
                    BaseLogger.log("3", this.userInfo, null, "Executed Query!!");
                    while (rs.next()) {
                        resValue = rs.getString(1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "BISDictionary.getSqlResValue() exception = [" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resValue;
    }

    public HashMap<String, String> getUserInfoMap(UserInfoBean userInfo) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document dom = genericUtility.parseString(userInfo.toString());
            NodeList nodeList = dom.getElementsByTagName("UserInfo").item(0).getChildNodes();
            String fieldName = "";
            String fieldValue = "";
            int ctr = 0;
            while (ctr < nodeList.getLength()) {
                Node childNode = nodeList.item(ctr);
                if (childNode != null && childNode.getNodeType() == 1) {
                    fieldName = childNode.getNodeName();
                    fieldValue = "";
                    if (childNode.getFirstChild() != null) {
                        fieldValue = childNode.getFirstChild().getNodeValue();
                    }
                    userInfoMap.put(fieldName, fieldValue);
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userInfoMap;
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getBisDictId() {
        return this.bisDictId;
    }

    public void setBisDictId(String bisDictId) {
        this.bisDictId = bisDictId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public String getPhraseScope() {
        return this.phraseScope;
    }

    public void setPhraseScope(String phraseScope) {
        this.phraseScope = phraseScope;
    }

    public String getBisEntityId() {
        return this.bisEntityId;
    }

    public void setBisEntityId(String bisEntityId) {
        this.bisEntityId = bisEntityId;
    }

    public String getResType() {
        return this.resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public String getResValue() {
        return this.resValue;
    }

    public void setResValue(String resValue) {
        this.resValue = resValue;
    }

    public String getPhraseValue() {
        return this.phraseValue;
    }

    public void setPhraseValue(String phraseValue) {
        this.phraseValue = phraseValue;
    }

    public JSONObject getProductIdentificationAlias(UserInfoBean userInfoBean) throws ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String phrase = "";
        String resValue = "";
        String bisEntityId = "";
        String applScope = "";
        JSONObject prodIdentificationObj = new JSONObject();
        try {
            try {
                conn = connDriver.getConnectDB(userInfoBean.getTransDB());
                String sqlQry = "SELECT PHRASE,BIS_ENTITY_ID, RES_VALUE,APPL_SCOPE FROM BIS_DICTIONARY";
                pstmt = conn.prepareStatement(sqlQry);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    phrase = rs.getString("PHRASE");
                    resValue = rs.getString("RES_VALUE");
                    bisEntityId = rs.getString("BIS_ENTITY_ID");
                    applScope = rs.getString("APPL_SCOPE");
                    if (bisEntityId != null && bisEntityId.length() > 0 && applScope != null && applScope.length() > 0) {
                        prodIdentificationObj.put(String.valueOf(phrase) + "_" + bisEntityId + "_" + applScope, (Object)resValue);
                        continue;
                    }
                    if (bisEntityId != null && bisEntityId.length() > 0) {
                        prodIdentificationObj.put(String.valueOf(phrase) + "_" + bisEntityId, (Object)resValue);
                        continue;
                    }
                    if (applScope != null && applScope.length() > 0) {
                        prodIdentificationObj.put(String.valueOf(phrase) + "_" + applScope, (Object)resValue);
                        continue;
                    }
                    prodIdentificationObj.put(phrase, (Object)resValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "BISDictionary.getProductIdentificationAlias() exception = [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return prodIdentificationObj;
    }

    public int InsertOrUpdateBISDictionary(JSONObject bisObject, JSONObject prodIdentificationObj, UserInfoBean userInfo) throws ITMException {
        int insertCount = 0;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        Statement pstmt = null;
        ResultSet rs = null;
        String chgUser = userInfo.getLoginCode();
        String chgTerm = userInfo.getRemoteHostName();
        try {
            try {
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                if (prodIdentificationObj == null) {
                    prodIdentificationObj = this.getProductIdentificationAlias(userInfo);
                }
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                if (prodIdentificationObj.has(String.valueOf(bisObject.optString("PHRASE")) + "_" + bisObject.optString("BIS_ENTITY_ID") + "_" + bisObject.optString("APPL_SCOPE"))) {
                    String updateSQL = "UPDATE BIS_DICTIONARY SET RES_VALUE=? WHERE PHRASE=? AND USER_ID=? AND BIS_ENTITY_ID=? AND APPL_SCOPE=?";
                    pstmt = conn.prepareStatement(updateSQL);
                    pstmt.setString(1, bisObject.optString("RES_VALUE"));
                    pstmt.setString(2, bisObject.optString("PHRASE"));
                    pstmt.setString(3, bisObject.optString("USER_ID"));
                    pstmt.setString(4, bisObject.optString("BIS_ENTITY_ID"));
                    pstmt.setString(5, bisObject.optString("APPL_SCOPE"));
                    insertCount = pstmt.executeUpdate();
                    if (insertCount > 0) {
                        conn.commit();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                } else {
                    String bisDictID = this.getUpdatedMAXID(conn);
                    String insertSql = "Insert into BIS_DICTIONARY (BIS_DICT_ID,PHRASE,PHRASE_SCOPE,USER_ID,BIS_ENTITY_ID,RES_TYPE,RES_VALUE,CHG_USER,CHG_TERM,CHG_DATE,APPL_SCOPE) values (?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(insertSql);
                    pstmt.setString(1, bisDictID);
                    pstmt.setString(2, bisObject.optString("PHRASE"));
                    pstmt.setString(3, bisObject.optString("PHRASE_SCOPE"));
                    pstmt.setString(4, bisObject.optString("USER_ID"));
                    pstmt.setString(5, bisObject.optString("BIS_ENTITY_ID"));
                    pstmt.setString(6, bisObject.optString("RES_TYPE"));
                    pstmt.setString(7, bisObject.optString("RES_VALUE"));
                    pstmt.setString(8, chgUser);
                    pstmt.setString(9, chgTerm);
                    pstmt.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(11, bisObject.optString("APPL_SCOPE"));
                    insertCount = pstmt.executeUpdate();
                    if (insertCount > 0) {
                        conn.commit();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                BaseLogger.log("3", userInfo, null, "InsertOrUpdateBISDictionary insertCount [" + insertCount + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "InsertOrUpdateBISDictionary Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", userInfo, null, "InsertOrUpdateBISDictionary finally Exception : [" + E12GenericUtility.getStackTrace(e2) + "]");
                throw new ITMException(e2);
            }
        }
        return insertCount;
    }

    private String getUpdatedMAXID(Connection conn) throws ITMException {
        String bisDictID = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String bisSQL = "SELECT MAX(BIS_DICT_ID) AS BIS_DICT_ID FROM BIS_DICTIONARY";
                pstmt = conn.prepareStatement(bisSQL);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bisDictID = rs.getString("BIS_DICT_ID");
                    int i = Integer.parseInt(bisDictID) + 1;
                    bisDictID = String.format("%0" + bisDictID.length() + "d", i);
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("2", this.userInfo, null, "getMAXBisDictID Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("2", this.userInfo, null, "getMAXBisDictID In Finally Exception : [" + E12GenericUtility.getStackTrace(e2) + "]");
                throw new ITMException(e2);
            }
        }
        BaseLogger.log("2", this.userInfo, null, "Inside insertOrUpdate bisDictID: [" + bisDictID + "]");
        return bisDictID;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

