/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.HTMLTaggingStorageLocal;
import ibase.webitm.ejb.HTMLTaggingStorageRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.parser.ParseException;

@Stateless
public class HTMLTaggingStorageEJB
implements HTMLTaggingStorageRemote,
HTMLTaggingStorageLocal {
    @Override
    public String insertTag(String tagData, String userId, String tranDB) throws RemoteException, ITMException {
        String retStr;
        block6: {
            retStr = "{}";
            Connection conn = null;
            ConnDriver connDriver = null;
            TransIDGenerator idGenerator = null;
            try {
                try {
                    JSONObject jsonObject = new JSONObject(tagData);
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(tranDB);
                    idGenerator = new TransIDGenerator("<Root></Root>", userId, CommonConstants.DB_NAME);
                    String tagId = idGenerator.generateTranSeqID("CMMTID", "COMMENT_ID", "seq10", conn);
                    String objName = (String)jsonObject.remove("OBJ_NAME");
                    String refSer = (String)jsonObject.remove("REF_SER");
                    String refId = (String)jsonObject.remove("REF_ID");
                    String elementId = (String)jsonObject.remove("ELEMENT_ID");
                    jsonObject.put("id", (Object)tagId);
                    String prevTagData = this.getPreviousTagData(refSer, refId, elementId, conn);
                    int affectedRows = -1;
                    jsonObject.put("add_ts", System.currentTimeMillis());
                    affectedRows = prevTagData != null ? this.updataTagData(refSer, refId, elementId, prevTagData, jsonObject, conn) : this.addNewTagData(objName, refSer, refId, elementId, userId, jsonObject, conn);
                    if (affectedRows > 0) {
                        retStr = jsonObject.toString();
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "HTMLTaggingStorageEJB :: insertTag() : " + ex);
                    this.printStackTrace(ex);
                    this.closeObject(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeObject(conn);
                throw throwable;
            }
            this.closeObject(conn);
        }
        return retStr;
    }

    @Override
    public int updateTag(String refSer, String refId, String elementId, String tagData, String userId, String tranDB) throws RemoteException, ITMException {
        int affectedRows;
        block5: {
            affectedRows = 0;
            Connection conn = null;
            ConnDriver connDriver = null;
            try {
                try {
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(tranDB);
                    JSONObject tagObj = new JSONObject(tagData);
                    String prevData = this.getPreviousTagData(refSer, refId, elementId, conn);
                    tagObj.put("update_ts", System.currentTimeMillis());
                    affectedRows = this.updataTagData(refSer, refId, elementId, prevData, tagObj, conn);
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in HTMLTaggingStorageEJB :: updateTag() : " + ex);
                    this.printStackTrace(ex);
                    this.closeObject(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeObject(conn);
                throw throwable;
            }
            this.closeObject(conn);
        }
        return affectedRows;
    }

    @Override
    public int deleteTag(String refSer, String refId, String elementId, String tagId, String userId, String tranDB) throws RemoteException, ITMException {
        int affectedRows = 0;
        try {
            affectedRows = this.deleteTagData(refSer, refId, elementId, tagId, tranDB);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in HTMLTaggingStorageEJB :: deleteTag() : " + ex);
            this.printStackTrace(ex);
        }
        return affectedRows;
    }

    @Override
    public String searchTags(String refSer, String refId, String elementId, String userId, String tranDB) throws RemoteException, ITMException {
        String result;
        block7: {
            Connection conn = null;
            PreparedStatement pst = null;
            ResultSet rs = null;
            ConnDriver connDriver = null;
            result = "{}";
            try {
                try {
                    InputStream is;
                    Clob clob;
                    String sqlQuery = "SELECT TAG_DATA FROM HTML_TAGGING WHERE RTRIM(REF_SER)=? AND RTRIM(REF_ID)=? AND RTRIM(ELEMENT_ID)=?";
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(tranDB);
                    pst = conn.prepareStatement(sqlQuery);
                    pst.setString(1, refSer);
                    pst.setString(2, refId);
                    pst.setString(3, elementId);
                    rs = pst.executeQuery();
                    String tagData = "{}";
                    if (rs.next() && (clob = rs.getClob("TAG_DATA")) != null && (is = clob.getAsciiStream()) != null) {
                        tagData = E12GenericUtility.readStreamAsString(is);
                    }
                    JSONObject tagDataObj = new JSONObject(tagData);
                    JSONArray tagDataArray = new JSONArray();
                    Iterator iter = tagDataObj.keys();
                    while (iter.hasNext()) {
                        tagDataArray.put(tagDataObj.get((String)iter.next()));
                    }
                    JSONObject finalData = new JSONObject();
                    finalData.put("total", tagDataArray.length());
                    finalData.put("rows", (Object)tagDataArray);
                    result = finalData.toString();
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in HTMLTaggingStorageEJB :: searchTags() : " + ex);
                    this.printStackTrace(ex);
                    this.closeObject(rs);
                    this.closeObject(pst);
                    this.closeObject(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.closeObject(rs);
                this.closeObject(pst);
                this.closeObject(conn);
                throw throwable;
            }
            this.closeObject(rs);
            this.closeObject(pst);
            this.closeObject(conn);
        }
        return result;
    }

    private int deleteTagData(String refSer, String refId, String elementId, String id, String tranDB) throws SQLException, IOException, ParseException, JSONException, Exception {
        int affectedRows = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        ConnDriver connDriver = null;
        try {
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(tranDB);
            String data = this.getPreviousTagData(refSer, refId, elementId, conn);
            JSONObject prevData = new JSONObject(data);
            prevData.remove(id);
            String query = "UPDATE HTML_TAGGING SET TAG_DATA = ? WHERE RTRIM(REF_SER) = ? AND RTRIM(REF_ID) = ? AND ELEMENT_ID = ?";
            pst = conn.prepareStatement(query);
            pst.setString(1, prevData.toString());
            pst.setString(2, refSer);
            pst.setString(3, refId);
            pst.setString(4, elementId);
            affectedRows = pst.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            this.closeObject(pst);
            this.closeObject(conn);
            throw throwable;
        }
        this.closeObject(pst);
        this.closeObject(conn);
        return affectedRows;
    }

    private String getPreviousTagData(String refSer, String refId, String elementId, Connection conn) throws SQLException, IOException {
        String data = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            Clob clob;
            String query = "SELECT TAG_DATA FROM HTML_TAGGING WHERE RTRIM(REF_SER) = ? AND RTRIM(REF_ID) = ? AND ELEMENT_ID = ?";
            pst = conn.prepareStatement(query);
            pst.setString(1, refSer);
            pst.setString(2, refId);
            pst.setString(3, elementId);
            rs = pst.executeQuery();
            if (rs.next() && (clob = rs.getClob("TAG_DATA")) != null) {
                InputStream is = clob.getAsciiStream();
                data = E12GenericUtility.readStreamAsString(is);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        return data;
    }

    private int addNewTagData(String objName, String refSer, String refId, String elementId, String userId, JSONObject tag, Connection conn) throws SQLException, JSONException {
        int affectedRows = 0;
        try (PreparedStatement pst = null;){
            String query = "INSERT INTO HTML_TAGGING (OBJ_NAME, REF_SER, REF_ID, ELEMENT_ID, TAG_DATA, TAG_USER, TAG_DATE, TAG_TERM) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            pst = conn.prepareStatement(query);
            pst.setString(1, objName);
            pst.setString(2, refSer);
            pst.setString(3, refId);
            pst.setString(4, elementId);
            String id = (String)tag.get("id");
            JSONObject tagDataObj = new JSONObject();
            tagDataObj.put(id, (Object)tag);
            pst.setString(5, tagDataObj.toString());
            pst.setString(6, userId);
            pst.setDate(7, new Date(System.currentTimeMillis()));
            pst.setString(8, "");
            affectedRows = pst.executeUpdate();
            conn.commit();
        }
        return affectedRows;
    }

    private int updataTagData(String refSer, String refId, String elementId, String prevData, JSONObject annotation, Connection conn) throws SQLException, JSONException {
        int affectedRows = 0;
        PreparedStatement pst = null;
        try {
            String query = "UPDATE HTML_TAGGING SET TAG_DATA = ? WHERE RTRIM(REF_SER) = ? AND RTRIM(REF_ID) = ? AND ELEMENT_ID = ?";
            JSONObject prevDataObj = new JSONObject(prevData);
            String id = (String)annotation.get("id");
            prevDataObj.put(id, (Object)annotation);
            pst = conn.prepareStatement(query);
            pst.setString(1, prevDataObj.toString());
            pst.setString(2, refSer);
            pst.setString(3, refId);
            pst.setString(4, elementId);
            affectedRows = pst.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            this.closeObject(pst);
            throw throwable;
        }
        this.closeObject(pst);
        return affectedRows;
    }

    private void closeObject(AutoCloseable closeableObj) {
        try {
            if (closeableObj != null) {
                closeableObj.close();
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception while closing " + closeableObj.getClass().getSimpleName() + " : " + ex);
        }
    }

    private void printStackTrace(Exception ex) {
        StackTraceElement[] elements = ex.getStackTrace();
        BaseLogger.log("2", null, null, String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage());
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            BaseLogger.log("3", null, null, "\tat " + element.toString());
            ++n2;
        }
    }
}

