/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BaseException
extends Exception {
    private String msg = "";
    public String gException = "";

    public BaseException(Exception exp) {
        this("", exp);
    }

    public BaseException(String respFormat, Exception exp) {
        JSONObject responseJson;
        JSONObject detailJson;
        JSONObject resultJson;
        JSONObject errorDataJson;
        String trace = "";
        String msgNo = "xxxx";
        String msgType = "X";
        String msgDescr = "";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stackStream = new PrintStream(baos);
        exp.printStackTrace(stackStream);
        String expStr = baos.toString();
        String line1 = expStr.substring(0, expStr.indexOf("\n"));
        int i = line1.indexOf(":");
        String expClass = exp.getClass().toString().trim();
        BaseLogger.log("2", null, null, "Exception class is **[" + expClass + "]**");
        if (!expClass.equals("class ibase.webitm.utility.ITMException") && !expClass.equals("class ibase.utility.BaseException")) {
            String baosStr = baos.toString();
            if (i < 0) {
                String str = expClass.substring(0, expClass.indexOf(46));
                if (str.equalsIgnoreCase("java")) {
                    this.msg = "System Error";
                } else if (respFormat.contains("CUSTOM_MESSAGE")) {
                    this.msg = respFormat.substring(respFormat.indexOf(":") + 1);
                    msgDescr = exp.getMessage();
                    BaseLogger.log("0", null, null, "In if BaseException.BaseException() CUSTOM_MESSAGE:[" + this.msg + "]");
                }
                msgDescr = expClass;
            } else if ("SESSION_EXPIRED".equalsIgnoreCase(exp.getMessage())) {
                try {
                    ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
                    String errorString = itmDbAccess.getErrorString("", "SESSIONOUT", " ", "XML");
                    BaseLogger.log("3", null, null, "BaseExcepttion session timeout message:[" + errorString + "]");
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    Document errorDoc = e12GenericUtility.parseString(errorString);
                    Node errorsNode = errorDoc.getElementsByTagName("error").item(0);
                    this.msg = e12GenericUtility.getColumnValueFromNode("message", errorsNode);
                    msgDescr = e12GenericUtility.getColumnValueFromNode("description", errorsNode);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (ITMException e) {
                    e.printStackTrace();
                }
            } else if (respFormat.contains("CUSTOM_MESSAGE")) {
                this.msg = respFormat.substring(respFormat.indexOf(":"));
                msgDescr = exp.getMessage();
            } else {
                this.msg = "Data or Application Error";
                msgDescr = exp.getMessage();
            }
            trace = baosStr.substring(baosStr.indexOf("\n") + 1);
            if ("JSON".equals(respFormat)) {
                try {
                    errorDataJson = new JSONObject();
                    errorDataJson.put("@id", (Object)msgNo);
                    errorDataJson.put("@type", (Object)msgType);
                    errorDataJson.put("message", (Object)this.msg);
                    errorDataJson.put("description", (Object)msgDescr);
                    errorDataJson.put("type", (Object)msgType);
                    errorDataJson.put("trace", (Object)trace);
                    resultJson = new JSONObject();
                    resultJson.put("error", (Object)errorDataJson);
                    detailJson = new JSONObject();
                    detailJson.put("Errors", (Object)resultJson);
                    responseJson = new JSONObject();
                    responseJson.put("Root", (Object)detailJson);
                    this.gException = responseJson.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                this.gException = trace.indexOf(CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE) != -1 ? trace.substring(trace.indexOf("<Root>"), trace.indexOf("</Root>") + 7) : "<Errors><error id = \"" + msgNo + "\" type=\"" + msgType + "\"><message><![CDATA[" + this.msg + "]]></message>" + "<description><![CDATA[" + msgDescr + "]]></description><trace><![CDATA[" + trace + "]]></trace>" + "</error></Errors>";
            }
        } else {
            this.gException = ((BaseException)exp).gException;
        }
        String exceptionCode = CommonConstants.EXCEPTION_CLASS_CODES.getProperty(expClass.substring(expClass.indexOf("class ") + 6));
        if (E12GenericUtility.checkNull(exceptionCode).length() == 0) {
            exceptionCode = "99999";
        } else if (this.gException != null && (this.gException.indexOf("VTINVDNAME") != -1 || this.gException.indexOf("VTINVTDATA") != -1 || this.gException.indexOf("VTINVPDATA") != -1)) {
            exceptionCode = "00000";
        }
        if (this.gException != null && this.gException.indexOf("Session Expired") == -1 && this.gException.indexOf("Session timeout") == -1 && this.gException.indexOf("Contact system support.") == -1 && this.gException.indexOf(CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE) == -1 && this.gException.indexOf("TO_ADD is null") == -1) {
            Random random = new Random();
            int randomInt = random.nextInt();
            String randomNo = Integer.toString(randomInt);
            if (randomNo != null && randomNo.startsWith("-")) {
                randomNo = randomNo.substring(1);
            }
            this.writeExceptionLog(this.gException, "", "", exceptionCode, respFormat, randomNo);
            if (this.gException.toLowerCase().indexOf("connection refused") == -1 && this.gException.toLowerCase().indexOf("gateway timeout") == -1) {
                this.modifyException(respFormat, exceptionCode, randomNo);
            }
        } else if ("JSON".equals(respFormat)) {
            try {
                BaseLogger.log("3", null, null, "BaseExcepttion json format message : [" + this.gException + "]");
                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                Document errorDoc = e12GenericUtility.parseString(this.gException);
                Node errorsNode = errorDoc.getElementsByTagName("error").item(0);
                this.msg = e12GenericUtility.getColumnValueFromNode("message", errorsNode);
                msgDescr = e12GenericUtility.getColumnValueFromNode("description", errorsNode);
            }
            catch (ITMException e) {
                e.printStackTrace();
            }
            try {
                errorDataJson = new JSONObject();
                errorDataJson.put("@id", (Object)msgNo);
                errorDataJson.put("@type", (Object)msgType);
                errorDataJson.put("message", (Object)this.msg);
                errorDataJson.put("description", (Object)msgDescr);
                errorDataJson.put("type", (Object)msgType);
                resultJson = new JSONObject();
                resultJson.put("error", (Object)errorDataJson);
                detailJson = new JSONObject();
                detailJson.put("Errors", (Object)resultJson);
                responseJson = new JSONObject();
                responseJson.put("Root", (Object)detailJson);
                this.gException = responseJson.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public BaseException(Exception e, String reason) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        BaseLogger.log("2", null, null, "Exception=" + e);
        this.msg = baos.toString();
        this.msg = String.valueOf(this.msg) + " reason= " + reason;
    }

    @Override
    public String getMessage() {
        return this.gException;
    }

    private String writeExceptionLog(String trace, String folderPath, String fileName, String exceptionCode, String respFormat, String randomNo) {
        BaseLogger.log("0", null, null, "BaseException :: writeExceptionLog exceptionCode: [" + exceptionCode + "]");
        BaseLogger.log("0", null, null, "BaseException :: writeExceptionLog exception: [" + trace + "]");
        String exceptionLogFile = "";
        File logFile = null;
        try {
            String filePath = E12GenericUtility.checkNull(folderPath).length() > 0 ? folderPath : String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "ExceptionLog";
            File logDir = new File(filePath);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            Date date = new Date();
            String sysDate = formatter.format(date);
            if (sysDate != null && sysDate.indexOf("/") != -1) {
                sysDate = sysDate.replaceAll("/", "-");
            }
            exceptionLogFile = E12GenericUtility.checkNull(fileName).length() > 0 ? fileName : "SYSEXP_" + sysDate + "_" + exceptionCode + "_" + randomNo;
            BaseLogger.log("0", null, null, "BaseException :: writeExceptionLog exceptionLogFile name: [" + exceptionLogFile + "]");
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            logFile = new File(filePath, String.valueOf(exceptionLogFile) + ".txt");
            logFile.createNewFile();
            PrintWriter writer = new PrintWriter(logFile);
            writer.print(trace);
            writer.close();
        }
        catch (IOException er) {
            BaseLogger.log("0", null, null, "BaseException :: writeExceptionLog : " + E12GenericUtility.getStackTrace(er));
        }
        return exceptionLogFile;
    }

    private void modifyException(String respFormat, String exceptionCode, String randomNo) {
        String msgNo = "xxxx";
        String msgType = "X";
        String msg = "System Exception";
        String msgDescr = "A system exception of type " + exceptionCode + " has occurred of instance " + randomNo + ". Contact system support.";
        if ("JSON".equals(respFormat)) {
            try {
                JSONObject errorDataJson = new JSONObject();
                errorDataJson.put("@id", (Object)msgNo);
                errorDataJson.put("@type", (Object)msgType);
                errorDataJson.put("message", (Object)msg);
                errorDataJson.put("description", (Object)msgDescr);
                errorDataJson.put("type", (Object)msgType);
                JSONObject resultJson = new JSONObject();
                resultJson.put("error", (Object)errorDataJson);
                JSONObject detailJson = new JSONObject();
                detailJson.put("Errors", (Object)resultJson);
                JSONObject responseJson = new JSONObject();
                responseJson.put("Root", (Object)detailJson);
                this.gException = responseJson.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.gException = "<Errors><error id = \"" + msgNo + "\" type=\"" + msgType + "\"><message><![CDATA[" + msg + "]]></message>" + "<description><![CDATA[" + msgDescr + "]]></description>" + "</error></Errors>";
        }
    }
}

