/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class X12toXmlGenerator {
    InputSource inputSource;
    OutputStream generatedOutput;
    ContentHandler handler;
    String inputFileName = null;
    String outputFileName = null;

    public X12toXmlGenerator(String inputFileName, String outputFileName) {
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        BaseLogger.log("2", null, null, "X12toXmlGenerator :inputFileName [" + inputFileName + "] : outputFileName [" + outputFileName + "]");
        if (outputFileName != null) {
            try {
                this.generatedOutput = new BufferedOutputStream(new FileOutputStream(outputFileName));
                BaseLogger.log("3", null, null, "Output file " + outputFileName + " opened");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (inputFileName != null) {
            try {
                this.inputSource = new InputSource(new FileReader(inputFileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.x12ToXmlConv(this.inputFileName, this.outputFileName);
    }

    public void x12ToXmlConv(String inputFileName, String outputFileName) {
        try {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.berryworks.edireader.EDIParserFactory");
            SAXParserFactory sFactory = SAXParserFactory.newInstance();
            SAXParser sParser = sFactory.newSAXParser();
            XMLReader ediReader = sParser.getXMLReader();
            SAXSource source = new SAXSource(ediReader, this.inputSource);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            StreamResult result = new StreamResult(this.generatedOutput);
            transformer.transform(source, result);
            System.out.print("Transformation complete\n");
            System.clearProperty("javax.xml.parsers.SAXParserFactory");
        }
        catch (SAXException e) {
            BaseLogger.log("0", null, null, "\nUnable to create EDIReader: " + e);
        }
        catch (ParserConfigurationException e) {
            BaseLogger.log("0", null, null, "\nUnable to create EDIReader: " + e);
        }
        catch (TransformerConfigurationException e) {
            BaseLogger.log("0", null, null, "\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            BaseLogger.log("0", null, null, "\nFailure to transform: " + e);
        }
    }
}

