/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.common.scheduler;

import ibase.bi.common.scheduler.StarterListener;
import ibase.bi.common.scheduler.StarterMBean;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import java.util.Date;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.timer.TimerNotification;
import org.jboss.util.ServiceMBeanSupport;

public class Starter
extends ServiceMBeanSupport
implements StarterMBean {
    private MBeanServer server;
    private ObjectName timer;
    private Object timeoutTimer;
    private int timeout;
    private int times;

    @Override
    public void init() throws MalformedObjectNameException, InstanceNotFoundException {
        try {
            Set<ObjectInstance> mbeans = this.server.queryMBeans(new ObjectName("DefaultDomain", "service", "timer"), null);
            if (!mbeans.isEmpty()) {
                this.timer = mbeans.iterator().next().getObjectName();
                this.server.addNotificationListener(this.timer, new StarterListener(), (NotificationFilter)new Filter(), null);
            } else {
                BaseLogger.log("3", null, null, "No TimerMBean found.");
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    @Override
    public void start() throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            Object[] objectArray = new Object[6];
            objectArray[0] = "ThisIsMyTimerType";
            objectArray[1] = "I call you with this timer times times";
            objectArray[3] = new Date();
            objectArray[4] = new Long((long)this.timeout * 1000L);
            objectArray[5] = new Long(this.times);
            this.timeoutTimer = this.server.invoke(this.timer, "addNotification", objectArray, new String[]{String.class.getName(), String.class.getName(), "java.lang.Object", "java.util.Date", Long.TYPE.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            this.server.invoke(this.timer, "removeNotifications", new Object[]{"ThisIsMyTimerType"}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    @Override
    public void setTimeout(int seconds) throws Exception {
        try {
            this.timeout = seconds;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getTimeout() throws Exception {
        try {
            return this.timeout;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setRepetitions(int times) throws Exception {
        try {
            this.times = times;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getRepetitions() throws Exception {
        try {
            return this.times;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getName() {
        return "MyTimer";
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        try {
            this.server = server;
            return super.preRegister(server, name);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    class Filter
    implements NotificationFilter {
        Filter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification pNotification) {
            try {
                if (pNotification instanceof TimerNotification) {
                    TimerNotification lTimerNotification = (TimerNotification)pNotification;
                    return lTimerNotification.getNotificationID().equals(Starter.this.timeoutTimer);
                }
                return false;
            }
            catch (Exception e) {
                BIException.setErrorCode(0);
                e.printStackTrace();
                return false;
            }
        }
    }
}

