import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/planview")
public class PlanViewServlet extends HttpServlet{

	private static final long serialVersionUID = 1L;
	List<Employee> empList = new ArrayList<>();
	List<Plan>planList = new ArrayList<>();
	List<Report>feedbackList = new ArrayList<>();
	EmployeeDao empDao;
	protected void doGet(HttpServletRequest request,HttpServletResponse response) {
		
		response.setContentType("application/json");
		 try {
		empDao = new EmployeeDao();
		empList.addAll(empDao.getEmpList());
		feedbackList.addAll(empDao.getYesterdayFeedback());
		//planList.addAll(empDao.getTodysPlan());
		request.setAttribute("empList", empList);
		request.setAttribute("planList", planList);
		request.setAttribute("feedbackList", feedbackList);
		
		
		RequestDispatcher dispatcher = request.getRequestDispatcher("planview.jsp");
	    
		dispatcher.forward(request, response);
		} catch (ServletException | IOException e) {
			e.printStackTrace();
		}
}
}
