/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.ValidateXMLInput;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.E12ChecklistLocal;
import ibase.webitm.ejb.E12ChecklistRemote;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class E12ChecklistEJB
implements E12ChecklistRemote,
E12ChecklistLocal {
    @Override
    public String getChecklistInfo(String objName, String refSer, String trackType, String xtraParams, String transDB) throws ITMException {
        Connection mConn = null;
        Statement pStmt = null;
        String selectQuery = null;
        StringBuffer checkListInfoStr = new StringBuffer("<ROOT>");
        ResultSet rs = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                mConn = mConnDriver.getConnectDB(transDB);
                selectQuery = "SELECT * FROM TRAN_TRACK_ACTS WHERE ACT_CODE IN ( SELECT A.ACT_CODE FROM TRAN_TRACK_SET_DET A  LEFT OUTER JOIN OBJ_TRACK_REQ_DET B  ON A.TRACK_SET = B.TRACK_SET   WHERE B.REF_SER = ? )  AND TRACK_TYPE = ? ";
                BaseLogger.log("3", null, null, "my query:: " + selectQuery);
                pStmt = mConn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, trackType);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    checkListInfoStr.append("<ACT_DETAIL>");
                    checkListInfoStr.append("<ACT_CODE>").append("<![CDATA[").append(rs.getString("ACT_CODE")).append("]]>").append("</ACT_CODE>");
                    checkListInfoStr.append("<DESCR>").append("<![CDATA[").append(rs.getString("DESCR")).append("]]>").append("</DESCR>");
                    checkListInfoStr.append("<ROLE_CODE>").append("<![CDATA[").append(rs.getString("ROLE_CODE")).append("]]>").append("</ROLE_CODE>");
                    checkListInfoStr.append("<TRACK_LEVEL>").append("<![CDATA[").append(rs.getString("TRACK_LEVEL")).append("]]>").append("</TRACK_LEVEL>");
                    checkListInfoStr.append("<TRACK_RESPONSE>").append("<![CDATA[").append(rs.getString("TRACK_RESPONSE")).append("]]>").append("</TRACK_RESPONSE>");
                    checkListInfoStr.append("<TEMPLATE_NAME>").append("<![CDATA[").append(rs.getString("TEMPLATE_NAME")).append("]]>").append("</TEMPLATE_NAME>");
                    checkListInfoStr.append("</ACT_DETAIL>");
                }
                checkListInfoStr.append("</ROOT>");
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :E12ChecklistEJB getChecklistInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConn != null) {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    mConn.close();
                    mConn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :E12ChecklistEJB getChecklistInfo :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "[E12ChecklistEJB]Return Checklist Info :[" + checkListInfoStr + "]");
        return checkListInfoStr.toString();
    }

    @Override
    public String saveChecklistInfo(String objName, String refSer, String trackXMLString, String xtraParams, UserInfoBean userInfo) throws ITMException {
        StringBuffer sqlStringBuffer = new StringBuffer();
        sqlStringBuffer.append(" INSERT INTO TRAN_TRACK_STATUS( ");
        sqlStringBuffer.append(" TRAN_ID, LINE_NO, REF_SER, REF_ID, REF_LINE_NO, TRACK_REQ, TRACK_SET, SEQ_NO, ");
        sqlStringBuffer.append(" ACT_CODE, ROLE_CODE, TRACK_LVL, DAYS_REQUIRED, PLAN_END_DATE, STATUS_FLAG, ");
        sqlStringBuffer.append(" DELAY_DAYS, CHG_USER, CHG_DATE, CHG_TERM, ITEM_CODE, ACTION_RESPONSE ) ");
        sqlStringBuffer.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        String responseStr = null;
        Connection conn = null;
        Statement pStmt = null;
        int lineNo = 1;
        String transDB = "";
        try {
            try {
                E12GenericUtility utility = new E12GenericUtility();
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                DBAccessEJB dbAccess = new DBAccessEJB();
                transDB = userInfo.getTransDB();
                Document dom = utility.parseString(trackXMLString);
                String trackSet = dbAccess.getDBColumnValue(" OBJ_TRACK_REQ_DET ", " TRACK_SET ", " REF_SER = '" + refSer + "' ", transDB);
                String trackReq = dbAccess.getDBColumnValue(" OBJ_TRACK_REQ_DET ", " TRACK_REQ ", " REF_SER = '" + refSer + "' ", transDB);
                String loginCode = utility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
                String chgUser = loginCode != null ? loginCode : "SYSTEM";
                String chgTerm = new E12GenericUtility().getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
                NodeList detailNList = dom.getElementsByTagName("Detail1");
                int len = detailNList.getLength();
                int i = 0;
                while (i < len) {
                    Node detNode = detailNList.item(i);
                    String tranId = utility.getColumnValueFromNode("tran_id", detNode);
                    String actCode = utility.getColumnValueFromNode("act_code", detNode);
                    String roleCode = utility.getColumnValueFromNode("role_code", detNode);
                    String trackLvl = utility.getColumnValueFromNode("track_level", detNode);
                    String trackResponse = utility.getColumnValueFromNode("track_response", detNode);
                    String actionResponse = utility.getColumnValueFromNode("action_response", detNode);
                    BaseLogger.log("3", userInfo, null, "Values [" + loginCode + "][" + chgUser + "][" + chgTerm + "][" + tranId + "][" + actCode + "][" + roleCode + "][" + trackLvl + "][" + actionResponse + "][" + trackResponse + "][" + trackSet + "][" + trackReq + "]");
                    String statusFlag = "";
                    if (!"D".equalsIgnoreCase(trackResponse)) {
                        if ("T".equalsIgnoreCase(trackResponse)) {
                            statusFlag = "true".equalsIgnoreCase(actionResponse) ? "Y" : "N";
                        } else {
                            "S".equalsIgnoreCase(trackResponse);
                        }
                    }
                    if (i == 0) {
                        String lineNoStr = dbAccess.getDBColumnValue(" TRAN_TRACK_STATUS ", " MAX(LINE_NO) AS LINE_NO  ~AS~  LINE_NO ", " TRAN_ID = '" + tranId + "' ", transDB);
                        try {
                            lineNo = Integer.parseInt(this.checkNull(lineNoStr)) + 1;
                            BaseLogger.log("3", userInfo, null, "lineNo Old[" + lineNoStr + "] New[" + lineNo + "]");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    conn = new ConnDriver().getConnectDB(transDB);
                    pStmt = conn.prepareStatement(sqlStringBuffer.toString());
                    pStmt.setString(1, tranId);
                    pStmt.setInt(2, lineNo);
                    pStmt.setString(3, refSer);
                    pStmt.setString(4, tranId);
                    pStmt.setInt(5, 1);
                    pStmt.setString(6, trackReq);
                    pStmt.setString(7, trackSet);
                    pStmt.setInt(8, 1);
                    pStmt.setString(9, actCode);
                    pStmt.setString(10, roleCode);
                    pStmt.setString(11, trackLvl);
                    pStmt.setInt(12, 1);
                    pStmt.setTimestamp(13, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(14, statusFlag);
                    pStmt.setInt(15, 1);
                    pStmt.setString(16, chgUser);
                    pStmt.setTimestamp(17, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(18, chgTerm);
                    pStmt.setString(19, "NA");
                    pStmt.setString(20, actionResponse);
                    int respInt = pStmt.executeUpdate();
                    BaseLogger.log("3", userInfo, null, "executeUpdate [" + respInt + "]");
                    pStmt.close();
                    pStmt = null;
                    ++lineNo;
                    ++i;
                }
                responseStr = "Success";
                dbAccess = null;
            }
            catch (Exception e) {
                responseStr = "Failed : " + e.getMessage();
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :E12ChecklistEJB :saveChecklistInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "\n****responseStr :" + responseStr);
        return responseStr;
    }

    @Override
    public String getTransformXSLData(String objName, String dataXML, String xslFileName) {
        BaseLogger.log("2", null, null, "Starting XML Transformation objName[" + objName + "]xslFileName[" + xslFileName + "]dataXML[" + dataXML + "]");
        String responseStr = "";
        try {
            String xslFilePath = this.getXSLFile(objName, xslFileName);
            File xslFile = new File(xslFilePath);
            if (xslFile.exists()) {
                BaseLogger.log("3", null, null, "TaxTRAN XSL File Exists At :[" + xslFilePath + "]Absolute Path :" + xslFile.getAbsolutePath());
                try {
                    ValidateXMLInput vxi = new ValidateXMLInput();
                    String outputFileName = vxi.validate(xslFilePath, dataXML, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", String.valueOf(objName) + Math.random(), ".html");
                    FileInputStream fis = new FileInputStream(outputFileName);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int i = -1;
                    while ((i = fis.read()) != -1) {
                        baos.write(i);
                    }
                    responseStr = this.checkNull(baos.toString(CommonConstants.ENCODING));
                    baos.close();
                }
                catch (Exception e) {
                    responseStr = "<h1>Data or Application Error : Something goes wrong!</h1>";
                }
            } else {
                BaseLogger.log("3", null, null, " Taxtran XSL File Doesn't Exist At :" + xslFilePath);
                responseStr = "<h3>File not found : " + xslFileName + " at '" + xslFilePath + "' </h3>";
            }
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return responseStr;
    }

    protected String getXSLFile(String objName, String xslFileName) throws ITMException {
        String xslFileNames = xslFileName;
        String xslFilePath = "";
        try {
            if (xslFileName.indexOf(",") != -1) {
                xslFileName = String.valueOf(objName) + ".xsl";
            } else if (!xslFileName.endsWith(".xsl")) {
                xslFileName = String.valueOf(xslFileName) + ".xsl";
            }
            if (CommonConstants.APPLICATION_CONTEXT != null) {
                BaseLogger.log("3", null, null, "In If");
                xslFilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator;
            } else {
                BaseLogger.log("3", null, null, "In ELse");
                xslFilePath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            }
            xslFilePath = String.valueOf(xslFilePath) + "xsl" + File.separator + "checklist" + File.separator;
            File xslFile = new File(String.valueOf(xslFilePath) + xslFileName);
            if (xslFile.exists()) {
                BaseLogger.log("3", null, null, " XSL File Exists At :[" + xslFilePath + "]Absolute Path :" + xslFile.getAbsolutePath());
            } else {
                BaseLogger.log("3", null, null, "  XSL File Doesn't Exist At :" + xslFilePath + "xsl");
                String xslString = this.mergeXslFiles(xslFilePath, xslFileNames);
                byte[] bufferTax = xslString.getBytes();
                int bytesTax = bufferTax.length;
                FileOutputStream fosTax = new FileOutputStream(xslFile);
                fosTax.write(bufferTax, 0, bytesTax);
                fosTax.flush();
                fosTax.close();
                fosTax = null;
            }
            xslFilePath = String.valueOf(xslFilePath) + xslFileName;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: RequestHandlerServlet: getXSLForTax:==>" + e);
            xslFilePath = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        return xslFilePath;
    }

    private String mergeXslFiles(String xslFilePath, String xslFileNames) {
        StringBuffer xslFileBuffer = new StringBuffer();
        String[] xslFiles = this.checkNull(xslFileNames).split(",");
        if (xslFiles != null) {
            String[] stringArray = xslFiles;
            int n = xslFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String xslFileName = stringArray[n2];
                xslFileName = String.valueOf(xslFilePath) + xslFileName + ".xsl";
                File xslFile = new File(xslFileName);
                if (xslFile.exists() && xslFile.isFile()) {
                    try {
                        xslFileBuffer.append(FileUtils.readFileToString((File)xslFile));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return xslFileBuffer.toString();
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

