/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.w3c.dom.Document;

public class BaseLogger {
    public static Logger infoLogger = null;
    public static Logger debugLogger = null;
    public static Logger warnLogger = null;
    public static Logger fatalLogger = null;
    public static Logger errorLogger = null;
    public static String logSeparator = "~";
    public static String JBOSSHOME = "";

    static {
        System.out.println("In Base Logger Static Block..................");
        try {
            String filename = "/IBASEHOME" + File.separator + "ibase.xml";
            File fileObj = new File(filename);
            if (!fileObj.exists()) {
                if (!fileObj.getParentFile().exists()) {
                    fileObj.getParentFile().mkdirs();
                }
                CommonConstants.createDefIBASEHOME(fileObj);
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(filename);
            JBOSSHOME = document.getElementsByTagName("JBOSSHOME").item(0).getFirstChild().getNodeValue();
            System.out.println("In BaseLogger Static Block JBOSSHOME:[" + JBOSSHOME + "]");
        }
        catch (Exception e) {
            System.out.println("Exception:[" + e + "]");
        }
        try {
            infoLogger = Logger.getLogger((String)"BaseLogger");
            infoLogger.setLevel(Level.DEBUG);
            debugLogger = Logger.getLogger((String)"BaseLogger");
            debugLogger.setLevel(Level.DEBUG);
            warnLogger = Logger.getLogger((String)"BaseLogger");
            warnLogger.setLevel(Level.DEBUG);
            fatalLogger = Logger.getLogger((String)"BaseLogger");
            fatalLogger.setLevel(Level.DEBUG);
            errorLogger = Logger.getLogger((String)"BaseLogger");
            errorLogger.setLevel(Level.DEBUG);
            String[] loggerArray = new String[]{"I", "E", "D", "W", "F"};
            int i = 0;
            while (i < loggerArray.length) {
                if (loggerArray[i].equalsIgnoreCase("I")) {
                    BaseLogger.initializeLogger(infoLogger, "infoLogger", "info");
                } else if (loggerArray[i].equalsIgnoreCase("E")) {
                    BaseLogger.initializeLogger(errorLogger, "errorLogger", "error");
                } else if (loggerArray[i].equalsIgnoreCase("W")) {
                    BaseLogger.initializeLogger(warnLogger, "warnLogger", "warn");
                } else if (loggerArray[i].equalsIgnoreCase("F")) {
                    BaseLogger.initializeLogger(fatalLogger, "fatalLogger", "fatal");
                } else if (loggerArray[i].equalsIgnoreCase("D")) {
                    BaseLogger.initializeLogger(debugLogger, "debugLogger", "debug");
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in BaseLogger static block:[" + e.getMessage() + "]");
        }
    }

    public static void initializeLogger(Logger logger, String loggerPropFileName, String loggerOutputFileName) {
        try {
            String propFileDir = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "configuration" + File.separator + loggerPropFileName + ".properties";
            System.out.println("propFileDir:[" + propFileDir + "]");
            File propFile = new File(propFileDir);
            if (propFile.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(propFile));
                System.out.println(String.valueOf(loggerPropFileName) + " properties:[" + properties.toString() + "]");
                String layout = properties.getProperty("layout").trim();
                String appender = properties.getProperty("appender").trim();
                String ConversionPattern = properties.getProperty("ConversionPattern");
                String level = properties.getProperty("level");
                logSeparator = properties.getProperty("logSeparator");
                LevelRangeFilter logFilter = new LevelRangeFilter();
                logFilter.setLevelMin(Level.toLevel((String)level));
                logFilter.setLevelMax(Level.toLevel((String)level));
                logFilter.setAcceptOnMatch(true);
                if (layout.equalsIgnoreCase("HTMLLayout")) {
                    HTMLLayout htmlLayout = new HTMLLayout();
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".html";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)htmlLayout, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)htmlLayout, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)htmlLayout, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                } else if (layout.equalsIgnoreCase("PatternLayout")) {
                    PatternLayout pattern = new PatternLayout(ConversionPattern);
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".log";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)pattern, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)pattern, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)pattern, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                } else if (layout.equalsIgnoreCase("JSONLayout")) {
                    PatternLayout pattern = new PatternLayout(ConversionPattern);
                    String logFilePath = String.valueOf(JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + loggerOutputFileName + ".json";
                    System.out.println("logFilePath:[" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)pattern, logFilePath, true);
                        fileApndr.addFilter((Filter)logFilter);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)pattern, logFilePath, true);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        rFileApndr.addFilter((Filter)logFilter);
                        logger.addAppender((Appender)rFileApndr);
                    } else if (appender.equalsIgnoreCase("DailyRollingFileAppender")) {
                        DailyRollingFileAppender rFileApndr = new DailyRollingFileAppender((Layout)pattern, logFilePath, "'.'yyyy-MM-dd");
                        rFileApndr.addFilter((Filter)logFilter);
                        rFileApndr.getEncoding();
                        logger.addAppender((Appender)rFileApndr);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in initializeLogger :[" + e.getMessage() + "]");
        }
    }

    public static void log(String debugLevel, UserInfoBean userInfo, String componentId, Object msg) {
        debugLevel = "".equals(debugLevel = E12GenericUtility.checkNull(debugLevel)) ? "0" : debugLevel;
        int debugLev = Integer.parseInt(debugLevel);
        String ibaseDebugLevel = E12GenericUtility.checkNull(CommonConstants.DEBUG_LEVEL);
        ibaseDebugLevel = "".equals(ibaseDebugLevel) ? "0" : ibaseDebugLevel;
        int ibaseDebugLev = Integer.parseInt(ibaseDebugLevel);
        String userId = "NA";
        if (userInfo != null) {
            userId = userInfo.getLoginCode();
        }
        String editorId = "NA";
        if (!"".equals(E12GenericUtility.checkNull(componentId))) {
            editorId = componentId;
        }
        if (debugLev <= ibaseDebugLev || ibaseDebugLev == -1) {
            String className = "";
            String methodName = "";
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
            }
            String msgInfo = String.valueOf(userId) + logSeparator + editorId + logSeparator + className + logSeparator + methodName + logSeparator + msg;
            BaseLogger.debug(msgInfo);
            if (ibaseDebugLev == -1) {
                System.out.println(msgInfo);
            }
        }
    }

    public static void info(Object msg) {
        infoLogger.info(msg);
    }

    public static void info(Object msg, String userId) {
        String msginfo = msg + logSeparator + userId;
        infoLogger.info((Object)msginfo);
    }

    public static void info(Object msg, Throwable t) {
        infoLogger.info(msg, t);
    }

    public static void debug(Object msg) {
        debugLogger.debug(msg);
    }

    public static void debug(Object msg, Throwable t) {
        debugLogger.debug(msg, t);
    }

    public static void debug(Object msg, String userId) {
        String debug = msg + logSeparator + userId;
        debugLogger.debug((Object)debug);
    }

    public static void warn(Object msg) {
        warnLogger.warn(msg);
    }

    public static void warn(Object msg, Throwable t) {
        warnLogger.warn(msg, t);
    }

    public static void warn(Object msg, String userId) {
        String warn = msg + logSeparator + userId;
        warnLogger.warn((Object)warn);
    }

    public static void error(Object msg) {
        errorLogger.error(msg);
    }

    public static void error(Object msg, Throwable t) {
        errorLogger.error(msg, t);
    }

    public static void error(Object msg, String userId) {
        String error = msg + logSeparator + userId;
        errorLogger.error((Object)error);
    }

    public static void fatal(Object msg) {
        fatalLogger.fatal(msg);
    }

    public static void fatal(Object msg, Throwable t) {
        fatalLogger.fatal(msg, t);
    }

    public static void fatal(Object msg, String userId) {
        String fatal = msg + logSeparator + userId;
        fatalLogger.fatal((Object)fatal);
    }

    public static Timestamp getCurrentTimeStamp() {
        Timestamp currentTimeStamp = null;
        Date date = new Date();
        long time = date.getTime();
        currentTimeStamp = new Timestamp(time);
        System.out.println("Current Time Stamp:[" + currentTimeStamp + "]");
        return currentTimeStamp;
    }
}

