/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public class RIAWrkflwHandlerServlet
extends HttpServlet {
    UserInfoBean userInfo = null;
    protected InitialContext ctx = null;
    final String XTRA_PARAMS_SEPARATOR = "~~";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession sess = null;
        sess = request.getSession();
        this.userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
        E12GenericUtility genericUtility = new E12GenericUtility();
        BaseLogger.log("2", null, null, "\nsess.getId()............... :" + sess.getId());
        BaseLogger.log("2", null, null, "XXXXXXXXRIAWrkflwHandlerServletXXXXXXXXXXXXXX");
        try {
            if (this.ctx == null) {
                AppConnectParm appConnect = new AppConnectParm();
                this.ctx = new InitialContext(appConnect.getProperty());
            }
            String action = request.getParameter("ACTION");
            BaseLogger.log("3", null, null, "ACTION[" + action + "]");
            if ("GETWORKFLOWDATA".equalsIgnoreCase(action)) {
                String retStr = null;
                String objName = request.getParameter("OBJ_NAME");
                String transDomString = request.getParameter("TRANS_DOM");
                String detailDomStr = request.getParameter("DETAIL_DOM");
                String domId = request.getParameter("DOM_ID");
                String divId = request.getParameter("DIV_ID");
                String eventCode = request.getParameter("EVENT_CODE");
                BaseLogger.log("3", null, null, "GETWORKFLOWDATA :: objName[" + objName + "] \ntransDom[" + transDomString + "] \ndetailDom[" + detailDomStr + "] \ndomId[" + domId + "] \nDIV_ID[" + divId + "] \nEVENT_CODE[" + eventCode + "]");
                String xtraParams = this.getXtraParams(this.userInfo);
                Document tranDom = genericUtility.parseString(transDomString);
                Document detailDom = genericUtility.parseString(detailDomStr);
                retStr = this.executeSystemEvent(objName, eventCode, tranDom, detailDom, xtraParams, domId, this.userInfo);
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                response.setHeader("Cache-Control", "no-cache");
                if (retStr != null && !"null".equals(retStr) && retStr.trim().length() > 0) {
                    response.getWriter().write(retStr);
                } else {
                    response.getWriter().write("Error");
                }
            }
        }
        catch (Exception e) {
            String msg = e.toString();
            if (e != null && e.toString().contains("Posted content")) {
                msg = msg.replace("java.io.IOException:", "");
                BaseLogger.log("0", null, null, "RIAWrkflwHandlerServlet : Exception[" + msg + "]");
                msg = "Exception:" + msg;
            }
            BaseLogger.log("3", null, null, "RIAWrkflwHandlerServlet : Exception[" + msg + "]");
            response.getWriter().write(msg);
        }
        catch (Throwable e) {
            BaseLogger.log("0", null, null, "]::::::::::::::::RIAWrkflwHandlerServlet:::::::::::::::::::::::;;;;;;Stack trace:[");
            BaseLogger.log("0", null, null, e.getStackTrace() + "]");
            BaseLogger.log("0", null, null, ":::::::::::::::::RIAWrkflwHandlerServlet::::::::::::::::::::::;;;;;;Cause:[");
            BaseLogger.log("0", null, null, e.getCause() + "]");
        }
    }

    private String executeSystemEvent(String objName, String eventCode, Document transDomString, Document detailDomString, String xtraParams, String domId, UserInfoBean userInfo) throws ITMException {
        String retStr = "";
        EventManagerEJB eventManager = null;
        String transDB = userInfo.getTransDB();
        BaseLogger.log("2", userInfo, null, "TranDB: " + transDB);
        try {
            try {
                eventManager = new EventManagerEJB();
                eventManager.setUserInfo(userInfo);
                retStr = transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 ? eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId, userInfo) : eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId);
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException :RIAWrkflwHandlerServlet :executeSystemEvent :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :RIAWrkflwHandlerServlet :executeSystemEvent :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (eventManager != null) {
                    eventManager.remove();
                    eventManager = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retStr;
    }

    private String getXtraParams(UserInfoBean userInfoBean) throws Exception {
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfoBean.getLoginCode());
        xtraParamsBuff.append("~~").append("loginEmpCode =" + userInfoBean.getEmpCode());
        xtraParamsBuff.append("~~").append("loginSiteCode =" + userInfoBean.getSiteCode());
        xtraParamsBuff.append("~~").append("entityCode =" + userInfoBean.getEntityCode());
        xtraParamsBuff.append("~~").append("profileId =" + userInfoBean.getProfileId());
        xtraParamsBuff.append("~~").append("userType =" + userInfoBean.getUserType());
        xtraParamsBuff.append("~~").append("runMode = I");
        xtraParamsBuff.append("~~").append("user_lang = " + userInfoBean.getUserLanguage());
        xtraParamsBuff.append("~~").append("user_country = " + userInfoBean.getUserCountry());
        xtraParamsBuff.append("~~").append("charEnc=" + userInfoBean.getCharEnc());
        xtraParamsBuff.append("~~").append("termId = " + userInfoBean.getRemoteHost());
        String chgTerm = userInfoBean.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = userInfoBean.getRemoteHost();
        }
        xtraParamsBuff.append("~~").append("chgTerm=" + chgTerm);
        BaseLogger.log("2", userInfoBean, null, "xtraParamsBuff [" + xtraParamsBuff + "]");
        return xtraParamsBuff.toString();
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

