/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenerateXml
extends ActionHandlerEJB {
    public String actionHandler(String tranID, String xtraParam, String forceFlag) throws RemoteException, ITMException {
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String retVal = "";
        UserInfoBean userInfo = null;
        try {
            String userCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
            userInfo = commonDBAccessEJB.createUserInfo(userCode);
        }
        catch (Exception userCode) {
            // empty catch block
        }
        String csvFilePath = "/wildfly/BankIntegration/UNS-HSBC/From HSBC/UTR/PP Reverse report - UTR number.xlsx - PP Reverse report - UTR number.csv";
        BaseLogger.log((String)"3", null, null, (Object)("Inside csvFilePath [" + csvFilePath + "] "));
        Map<String, String> resultMap = GenerateXml.readCsv(csvFilePath, "Customer Reference Number", "Bank Ref no");
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            System.out.println("Key gsb: " + entry.getKey() + ", Value gsb: " + entry.getValue());
        }
        BaseLogger.log((String)"3", null, null, (Object)"Inside actionHandler.. ");
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler.. tranID[ " + tranID + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler.. xtraParam" + xtraParam));
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler.. forceFlag" + forceFlag));
        String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = 'BCA0000001'", userInfo.getTransDB());
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler test.. payIntArgs[ " + payIntArgs + "]"));
        JsonObject payIntArgsJSON = GenerateXml.parseJsonString(payIntArgs);
        String bankIntegrationFilePath = GenerateXml.getValueFromJson(payIntArgsJSON, "bank_integration_file_path");
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler test.. bankIntegrationFilePath[ " + bankIntegrationFilePath + "]"));
        return retVal;
    }

    private void updatePaymentStatus(String tranID, String transXML, UserInfoBean userInfo) throws Exception {
        Connection connection = null;
        BaseLogger.log((String)"3", null, null, (Object)"Inside updatePaymentStatus.. ");
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext initialContext = new InitialContext(appConnect.getProperty());
            ConnDriver connDriver = new ConnDriver();
            connection = connDriver.getConnectDB(userInfo.getTransDB());
            StringBuffer processDynXmlString = new StringBuffer();
            processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
            processDynXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
            processDynXmlString.append("<objName><![CDATA[payintstatus]]></objName>");
            processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
            processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
            processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
            processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
            processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
            processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
            processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
            processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
            processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
            processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='1'  objName='payintstatus'>");
            processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='TRAN_ID' selected='N' status='N' updateFlag='A'/>");
            processDynXmlString.append(transXML);
            processDynXmlString.append("</Detail1>");
            processDynXmlString.append("</Header0></group0></DocumentRoot>");
            String XmlString = processDynXmlString.toString();
            BaseLogger.log((String)"3", null, null, (Object)(" Xml String... " + XmlString));
            MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
            String reString = masterStateful.processRequest(this.getUserInfo(), XmlString, false, connection);
            BaseLogger.log((String)"3", null, null, (Object)("reString.. " + reString));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    private String getTransXML(String paymentTranID, String refSer, String descr, String remarks, String errorDet) {
        StringBuffer transXML = new StringBuffer();
        try {
            E12GenericUtility e12genericUtility = new E12GenericUtility();
            SimpleDateFormat sdf = new SimpleDateFormat(e12genericUtility.getApplDateFormat());
            String currentDateStr = sdf.format(new Date());
            currentDateStr = e12genericUtility.getValidDateTimeString(currentDateStr, e12genericUtility.getApplDateFormat(), e12genericUtility.getDBDateFormat());
            BaseLogger.log((String)"3", null, null, (Object)("Value of currentDateStr... [" + currentDateStr + "]"));
            transXML.append("<ref_ser><![CDATA[" + refSer + "]]></ref_ser>");
            transXML.append("<ref_id><![CDATA[" + paymentTranID + "]]></ref_id>");
            transXML.append("<status_date><![CDATA[" + GenerateXml.getCurrentDate() + "]]></status_date>");
            transXML.append("<stage_descr><![CDATA[" + descr + "]]></stage_descr>");
            transXML.append("<remarks><![CDATA[" + remarks + "]]></remarks>");
            transXML.append("<error_det><![CDATA[" + errorDet + "]]></error_det>");
        }
        catch (Exception e) {
            e.getMessage();
        }
        return transXML.toString();
    }

    public static String getCurrentDate() {
        BaseLogger.log((String)"3", null, null, (Object)"inside getCurrentDate .. ");
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm:ss");
        BaseLogger.log((String)"3", null, null, (Object)("currentDateTime is .. [" + currentDateTime.format(formatter) + "]"));
        return currentDateTime.format(formatter);
    }

    private static String getElementValueByTagName(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getTextContent();
        }
        return null;
    }

    private static String getElementValue(Element parentElement, String parentTagName, String tagName) {
        NodeList parentNodes = parentElement.getElementsByTagName(parentTagName);
        int i = 0;
        while (i < parentNodes.getLength()) {
            int j = 0;
            Element parent = (Element)parentNodes.item(i);
            NodeList nodeList = parent.getElementsByTagName(tagName);
            if (j < nodeList.getLength()) {
                Element element = (Element)nodeList.item(j);
                return element.getTextContent();
            }
            ++i;
        }
        return null;
    }

    public static String getAcknowledgmentTagValue(String filePath, String tagName, String parentTagName) {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method filePath [" + filePath + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method tagName [" + tagName + "]"));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filePath));
            BaseLogger.log((String)"3", null, null, (Object)("Acknowledgement document:[" + E12GenericUtility.documentToString((Document)document) + "]"));
            if (parentTagName.equalsIgnoreCase("")) {
                result = GenerateXml.getElementValueByTagName(document, tagName);
            } else {
                Element rootElement = document.getDocumentElement();
                System.out.println("Root Element gsb: " + document.getDocumentElement().getTagName());
                result = GenerateXml.getElementValue(rootElement, parentTagName, tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseLogger.log((String)"3", null, null, (Object)("result from getAcknowledgmentTagValue:[" + result + "]"));
        return result;
    }

    public static String generateFormattedTranId(String tranId) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmss");
        String formattedDate = dateFormat.format(currentDate);
        String formattedTranId = String.valueOf(tranId) + formattedDate;
        BaseLogger.log((String)"3", null, null, (Object)(" value of formattedTranId [" + formattedTranId + "]"));
        return formattedTranId;
    }

    public static JsonObject parseJsonString(String jsonString) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        return jsonReader.readObject();
    }

    public static String getValueFromJson(JsonObject jsonObject, String key) {
        if (jsonObject.containsKey((Object)key)) {
            return jsonObject.getString(key);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> readCsv(String csvFilePath, String column1Name, String column2Name) {
        BaseLogger.log((String)"3", null, null, (Object)("Inside readCsv method filePath [" + csvFilePath + "] column1Name [" + column1Name + "] column1Name [" + column2Name + "]"));
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileReader reader = new FileReader(csvFilePath);
                try {
                    try (CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.withHeader(new String[0]));){
                        for (CSVRecord csvRecord : csvParser) {
                            String value1 = csvRecord.get(column1Name);
                            String value2 = csvRecord.get(column2Name);
                            System.out.println("Column gsb:::" + column1Name + ": " + value1);
                            System.out.println("Column gsb:::" + column2Name + ": " + value2);
                            resultMap.put(value1, value2);
                        }
                    }
                    if (reader == null) return resultMap;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return resultMap;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultMap;
    }
}

