/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExecuteQuery {
    public String executeQuery(String conFileName, String query, String paramString) throws Exception {
        Connection connectionObject = null;
        Statement pst = null;
        try {
            try {
                this.executeQuery(conFileName, query, paramString, connectionObject);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception: ExecuteQuery: executeQuery:==>\n" + e.getMessage());
                throw e;
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
                if (connectionObject != null) {
                    connectionObject.close();
                    connectionObject = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception: ExecuteQuery: executeQuery:==>\n" + e.getMessage());
                throw e;
            }
        }
        return "";
    }

    public String executeQuery(String conFileName, String query, String paramString, Connection connectionObject) throws Exception {
        Statement pst = null;
        boolean isLocalConn = false;
        try {
            try {
                BaseLogger.log("3", null, null, "conFileName [" + conFileName + "]");
                if (conFileName != null && conFileName.length() > 0) {
                    if (connectionObject == null) {
                        ConnDriver mConnDriver = new ConnDriver();
                        connectionObject = mConnDriver.getConnectDB(conFileName);
                        isLocalConn = true;
                    }
                    if (query != null && query.length() > 0) {
                        pst = connectionObject.prepareStatement(query);
                        if (paramString != null && paramString.length() > 0) {
                            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                            DocumentBuilder db = dbf.newDocumentBuilder();
                            Document doc = db.parse(new ByteArrayInputStream(paramString.getBytes()));
                            NodeList paramNodeList = doc.getElementsByTagName("parameter");
                            BaseLogger.log("3", null, null, "No. of parametets found " + paramNodeList.getLength());
                            int i = 0;
                            int cnt = 1;
                            while (i < paramNodeList.getLength()) {
                                Node paramDetails = paramNodeList.item(i);
                                if (paramDetails.getAttributes().getNamedItem("datatype") != null) {
                                    String datatype = paramDetails.getAttributes().getNamedItem("datatype").getNodeValue();
                                    BaseLogger.log("3", null, null, "datatype [" + datatype + "]");
                                    if (paramDetails.getFirstChild() != null) {
                                        String value = paramDetails.getFirstChild().getNodeValue();
                                        BaseLogger.log("3", null, null, "Setting value on index[" + cnt + "] - [" + value + "]");
                                        if (datatype.toUpperCase().indexOf("STRING") != -1 || datatype.toUpperCase().indexOf("VARCHAR") != -1 || datatype.toUpperCase().indexOf("CHAR") != -1) {
                                            pst.setString(cnt, value);
                                        } else if (datatype.toUpperCase().indexOf("DATETIME") != -1 || datatype.toUpperCase().indexOf("TIMESTAMP") != -1) {
                                            pst.setTimestamp(cnt, Timestamp.valueOf(value));
                                        } else if (datatype.toUpperCase().indexOf("DATE") != -1) {
                                            pst.setDate(cnt, Date.valueOf(value));
                                        } else if (datatype.toUpperCase().indexOf("DECIMAL") != -1 || datatype.toUpperCase().indexOf("DOUBLE") != -1 || datatype.toUpperCase().indexOf("NUMBER") != -1 || datatype.toUpperCase().indexOf("LONG") != -1) {
                                            pst.setDouble(cnt, Double.valueOf(value));
                                        }
                                        ++cnt;
                                    } else {
                                        BaseLogger.log("3", null, null, "Warning : No DataType Found !!!");
                                    }
                                } else {
                                    BaseLogger.log("3", null, null, "Warning : Datatype Not Found !!!");
                                }
                                ++i;
                            }
                        } else {
                            BaseLogger.log("3", null, null, "Warning : Parameter Not Defined !!!");
                        }
                        int result = pst.executeUpdate();
                        BaseLogger.log("3", null, null, "No. of Rows Updated :" + result);
                        pst.close();
                        pst = null;
                    } else {
                        BaseLogger.log("3", null, null, "Warning : Query is Null !!!");
                    }
                } else {
                    BaseLogger.log("3", null, null, "Warning : Connection File Name is Null !!!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception: ExecuteQuery: executeQuery:==>\n" + e.getMessage());
                throw e;
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
                if (isLocalConn && connectionObject != null) {
                    connectionObject.close();
                    connectionObject = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception: ExecuteQuery: executeQuery:==>\n" + e.getMessage());
                throw e;
            }
        }
        return "";
    }
}

