import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class UserTaskService {
  private serviceUrl = 'http://192.168.0.116:9090/ibase/rest/UserTasksService/addUserTask';
  private pophelpUrl = 'http://192.168.0.116:9090/ibase/rest/PopHelpService/getPophelpData';

  constructor(private http: HttpClient) {}

  addUserTask(refId: string, refSer: string, userIdAssigned: string, taskDescr: string, tokenId: string): Observable<any> {
    const body = new URLSearchParams();
    body.set('REF_ID', refId);
    body.set('REF_SER', refSer);
    body.set('USER_ID__ASSIGNED', userIdAssigned);
    body.set('TASK_DESCR', taskDescr);

    const headers = new HttpHeaders({
      'Content-Type': 'application/x-www-form-urlencoded',
      'token_id': tokenId // Adding the token_id to the headers
    });

    return this.http.post(this.serviceUrl, body.toString(), { headers });
  }

  getPophelpData(fieldName: string, modName: string, tokenId: string): Observable<any> {
    const url = `${this.pophelpUrl}?FIELD_NAME=${fieldName}&MOD_NAME=${modName}`;
    const headers = new HttpHeaders({
      'Content-Type': 'application/x-www-form-urlencoded',
      'token_id': tokenId // Adding the token_id to the headers
    });

    return this.http.get<any>(url, { headers });
  }
}
